<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Luk',
    'actions'                                   => 'Handlinger',
    'edit'                                      => 'Rediger',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Slet',
    'split'                                     => 'Opdel',
    'single_split'                              => 'Opdel',
    'clone'                                     => 'Klon',
    'clone_and_edit'                            => 'Clone and edit',
    'confirm_action'                            => 'Bekræft',
    'last_seven_days'                           => 'Sidste syv dage',
    'last_thirty_days'                          => 'Sidste tredive dage',
    'last_180_days'                             => 'Seneste 180 dage',
    'month_to_date'                             => 'Måned til dato',
    'year_to_date'                              => 'År til dato',
    'YTD'                                       => 'ÅTD',
    'welcome_back'                              => 'Hvad spiller?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Alting',
    'today'                                     => 'i dag',
    'customRange'                               => 'Tilpasset interval',
    'date_range'                                => 'Dato interval',
    'apply'                                     => 'Anvend',
    'select_date'                               => 'Vælg dato..',
    'cancel'                                    => 'Annuller',
    'from'                                      => 'Fra',
    'to'                                        => 'Til',
    'structure'                                 => 'Struktur',
    'help_translating'                          => 'Denne hjælpetekst er endnu ikke tilgængelig på dit sprog. <a href="https://crowdin.com/project/firefly-iii-help">Vil du hjælpe med at oversætte?</a>',
    'showEverything'                            => 'Vis alt',
    'never'                                     => 'Aldrig',
    'no_results_for_empty_search'               => 'Din søgning var tom, så intet blev fundet.',
    'removed_amount'                            => 'Fjernede :amount',
    'added_amount'                              => 'Tilføjede :amount',
    'asset_account_role_help'                   => 'Ekstra indstillinger der opstår på baggrund af dit valg kan sættes senere.',
    'Opening balance'                           => 'Startsaldo',
    'create_new_stuff'                          => 'Opret nye ting',
    'new_withdrawal'                            => 'Ny hævning',
    'create_new_transaction'                    => 'Opret en ny transaktion',
    'sidebar_frontpage_create'                  => 'Opret',
    'new_transaction'                           => 'Ny overførsel',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Se dine aktiver',
    'go_to_budgets'                             => 'Gå til dine budgetter',
    'go_to_withdrawals'                         => 'Gå til dine udbetalinger',
    'clones_journal_x'                          => 'Denne transaktion er en klon af ":description" (#:id)',
    'go_to_categories'                          => 'Gå til dine kategorier',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Se dine udgiftskonti',
    'go_to_revenue_accounts'                    => 'Se dine indkomstkonti',
    'go_to_piggies'                             => 'Gå til dine sparegrise',
    'new_deposit'                               => 'Ny deponering',
    'new_transfer'                              => 'Ny overførsel',
    'new_transfers'                             => 'Ny overførsel',
    'new_asset_account'                         => 'Ny aktivkonto',
    'new_expense_account'                       => 'Ny udgiftskonto',
    'new_revenue_account'                       => 'Ny indkomstkonto',
    'new_liabilities_account'                   => 'Ny passivkonto',
    'new_budget'                                => 'Nyt budget',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'Du er blevet logget ud. Blokerede konti kan ikke bruge denne side. Oprettede du dig med en gyldig e-mailadresse?',
    'flash_success'                             => 'Succes!',
    'flash_info'                                => 'Besked',
    'flash_warning'                             => 'Advarsel!',
    'flash_error'                               => 'Fejl!',
    'flash_danger'                              => 'Fare!',
    'flash_info_multiple'                       => 'Der er en besked|Der er :count beskeder',
    'flash_error_multiple'                      => 'Der er en fejl|Der er :count fejl',
    'net_worth'                                 => 'Nettoformue',
    'help_for_this_page'                        => 'Hjælp til denne side',
    'help_for_this_page_body'                   => 'Du kan finde mere information om denne side <a href="https://docs.firefly-iii.org/">i dokumentationen</a>.',
    'two_factor_welcome'                        => 'Hej!',
    'two_factor_enter_code'                     => 'For at fortsætte, indtast venligst din to-faktor-godkendelseskode. Dit program vil generere den for dig.',
    'two_factor_code_here'                      => 'Indtast koden her',
    'two_factor_title'                          => 'Tofaktorgodkendelse',
    'authenticate'                              => 'Godkend',
    'two_factor_forgot_title'                   => 'Glemt totrinsbekræftelse',
    'two_factor_forgot'                         => 'Jeg har glemt min tofaktor-ting.',
    'two_factor_lost_header'                    => 'Glemt din totrinsbekræftelse?',
    'two_factor_lost_intro'                     => 'Hvis du også har glemt dine backupkoder, så er det sort uheld. Det er ikke noget, du kan fikse fra webinterfacet. Du har to muligheder.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Ellers, send en e-mail til sideejeren, <a href="mailto::site_owner">:site_owner</a> og spørg dem om at nulstille din tofaktorgodkendelse.',
    'mfa_backup_code'                           => 'Du har brugt en backupkode til at logge ind på Firefly III. Den kan ikke bruges igen, så streg den fra din liste.',
    'pref_two_factor_new_backup_codes'          => 'Få nye backupkoder',
    'pref_two_factor_backup_code_count'         => 'Du har :count gyldig backup kode.|Du har :count gyldige backup koder.',
    '2fa_i_have_them'                           => 'Jeg gemte dem!',
    'warning_much_data'                         => ':days dages data kan tage et stykke tid at indlæse.',
    'registered'                                => 'Du er blevet succesfuldt oprettet!',
    'Default asset account'                     => 'Standard aktivkonto',
    'no_budget_pointer'                         => 'Det ser ud til, at du ikke har oprettet budgetter endnu. Du burde oprette nogle på <a href="/budgets">budgetsiden</a>. Budgetter kan hjælpe dig med at holde styr på udgifter.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Opsparingskonto',
    'Credit card'                               => 'Kreditkort',
    'source_accounts'                           => 'Kildekonto|Kildekonti',
    'destination_accounts'                      => 'Destinationskontoen|Destinationskonti',
    'user_id_is'                                => 'Dit brugerid er <strong>:user</strong>',
    'field_supports_markdown'                   => 'Dette felt undersøtter <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Hvis du har brug for mere hjælp til at bruge Firefly III, åbn <a href="https://github.com/firefly-iii/firefly-iii/issues">venligst en sag på Github</a>.',
    'reenable_intro_text'                       => 'Du kan også genaktivere <a href="#" id="reenableGuidance">introduktionsguiden</a>.',
    'intro_boxes_after_refresh'                 => 'Introduktionsboksene vil kunne ses igen, når du genopfrisker siden.',
    'show_all_no_filter'                        => 'Vis alle transaktioner uden at gruppere dem efter dato.',
    'expenses_by_category'                      => 'Udgifter per kategori',
    'expenses_by_budget'                        => 'Udgifter per budget',
    'income_by_category'                        => 'Indkomst per kategori',
    'expenses_by_asset_account'                 => 'Udgifter per aktivkonto',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III kan ikke videresende dig til den korrekte side. Beklager.',
    'sum_of_expenses'                           => 'Sum af udgifter',
    'sum_of_income'                             => 'Sum af indkomst',
    'liabilities'                               => 'Gæld',
    'spent_in_specific_budget'                  => 'Brugt på budget ":budget"',
    'spent_in_specific_double'                  => 'Forbrug på konto ":account"',
    'earned_in_specific_double'                 => 'Optjent på konto ":account"',
    'source_account'                            => 'Kildekonto',
    'source_account_reconciliation'             => 'Du kan ikke redigere kildekontoen på en afstemningstransaktion.',
    'destination_account'                       => 'Destinationskonto',
    'destination_account_reconciliation'        => 'Du kan ikke redigere destinationskontoen på en afstemningstransaktion.',
    'sum_of_expenses_in_budget'                 => 'Total brugt på budget ":budget"',
    'left_in_budget_limit'                      => 'Resterende beløb i henhold til budgettet',
    'current_period'                            => 'Aktuel periode',
    'show_the_current_period_and_overview'      => 'Vis den aktuelle periode og overblik',
    'pref_languages_locale'                     => 'For at et andet sprog end engelsk skal virke rigtigt, skal dit operativsystem være udstyret med den korrekte lokale-information. Hvis denne ikke er til stede, vil valutadata, datoer og beløb muligvis vises forkert.',
    'budget_in_period'                          => 'Alle transaktioner for budget ":name" mellem :start og :end i :currency',
    'chart_budget_in_period'                    => 'Diagram for alle transaktioner for budget ":name" mellem :start og :end i :currency',
    'chart_budget_in_period_only_currency'      => 'Beløbet du budgetterede var i :currency, så dette diagram vil kun vise transaktioner i :currency.',
    'chart_account_in_period'                   => 'Diagram for alle transaktion for konto ":name" (:balance) mellem :start og :end',
    'chart_category_in_period'                  => 'Diagram for alle transaktion i kategori ":name" mellem :start og :end',
    'chart_category_all'                        => 'Diagram for alle transaktion i kategori ":name"',
    'clone_withdrawal'                          => 'Klon denne hævning',
    'clone_deposit'                             => 'Klon denne deponering',
    'clone_transfer'                            => 'Klon denne overførsel',
    'multi_select_no_selection'                 => 'Ingen valgt',
    'multi_select_select_all'                   => 'Vælg alle',
    'multi_select_n_selected'                   => 'valgt',
    'multi_select_all_selected'                 => 'Alt valgt',
    'multi_select_filter_placeholder'           => 'Find..',
    'intro_next_label'                          => 'Næste',
    'intro_prev_label'                          => 'Forrige',
    'intro_skip_label'                          => 'Spring over',
    'intro_done_label'                          => 'Udført',
    'between_dates_breadcrumb'                  => 'Mellem :start og :end',
    'all_journals_without_budget'               => 'Alle transaktion uden et budget',
    'journals_without_budget'                   => 'Transaktioner uden et budget',
    'all_journals_without_category'             => 'Alle transaktion uden en kategori',
    'journals_without_category'                 => 'Transaktioner uden en kategori',
    'all_journals_for_account'                  => 'Alle transaktioner for konto :name',
    'chart_all_journals_for_account'            => 'Diagram af alle transaktioner for konto :name',
    'journals_in_period_for_account'            => 'Alle transaktioner for konto :name imellem :start og :end',
    'journals_in_period_for_account_js'         => 'Alle transaktioner for konto {title} mellem {start} og {end}',
    'transferred'                               => 'Overført',
    'all_withdrawal'                            => 'Alle udgifter',
    'all_transactions'                          => 'Alle transaktioner',
    'title_withdrawal_between'                  => 'Alle udgifter imellem :start og :end',
    'all_deposit'                               => 'Alle indkomster',
    'title_deposit_between'                     => 'Alle indkomster imellem :start og :end',
    'all_transfers'                             => 'Alle overførsler',
    'title_transfers_between'                   => 'Alle overførsler imellem :start og :end',
    'all_transfer'                              => 'Alle overførsler',
    'all_journals_for_tag'                      => 'Alle overførsler for tag ":tag"',
    'title_transfer_between'                    => 'Alle overførsler imellem :start og :end',
    'all_journals_for_category'                 => 'Alle transaktioner for kategori :name',
    'all_journals_for_budget'                   => 'Alle transaktioner for budget :name',
    'chart_all_journals_for_budget'             => 'Diagram over alle transaktioner for budget :name',
    'journals_in_period_for_category'           => 'Alle transaktioner for kategori :name mellem :start og :end',
    'journals_in_period_for_tag'                => 'Alle transaktioner for tag :tag mellem :start og :end',
    'not_available_demo_user'                   => 'Den funktion, du forsøger at få adgang til, er ikke tilgængelig for demobrugere.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Kildekonto "@source_name" tillader kun transaktioner i @source_currency. Destinationskonto "@dest_name" tillader kun transaktioner i @dest_currency. Du skal rigtigt angive det overførte beløb i begge valutaer.',
    'transaction_data'                          => 'Transaktionsdata',
    'invalid_server_configuration'              => 'Ugyldig server konfiguration',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Hurtigskift',
    'sign_in_to_start'                          => 'Log ind for at starte din session',
    'sign_in'                                   => 'Log ind',
    'register_new_account'                      => 'Registrer en ny konto',
    'forgot_my_password'                        => 'Jeg har glemt min adgangskode',
    'problems_with_input'                       => 'Der var nogle problemer med din indtastning.',
    'reset_password'                            => 'Nulstil din adgangskode',
    'button_reset_password'                     => 'Nulstil adgangskode',
    'reset_button'                              => 'Nulstil',
    'want_to_login'                             => 'Jeg ønsker at logge ind',
    'login_page_title'                          => 'Log ind i Firefly III',
    'register_page_title'                       => 'Registrer hos Firefly III',
    'forgot_pw_page_title'                      => 'Glemt din adgangskode til Firefly III',
    'reset_pw_page_title'                       => 'Nulstil din adgangskode til Firefly III',
    'cannot_reset_demo_user'                    => 'Du kan ikke nulstille adgangskoden til demo-brugeren.',
    'no_att_demo_user'                          => 'Demo brugeren kan ikke uploade vedhæftede filer.',
    'button_register'                           => 'Registrér',
    'authorization'                             => 'Autorisation',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Forventede daglige omkostninger',
    'per_period_sum_1W'                         => 'Forventede ugentlige omkostninger',
    'per_period_sum_1M'                         => 'Forventede månedlige omkostninger',
    'per_period_sum_3M'                         => 'Forventede kvartalsvise omkostninger',
    'per_period_sum_6M'                         => 'Forventede halvårlige omkostninger',
    'per_period_sum_1Y'                         => 'Forventede årlige omkostninger',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'forventet total',
    'reconciliation_account_name'               => ':name afstemning (:currency)',
    'saved'                                     => 'Gemt',
    'advanced_options'                          => 'Avancerede indstillinger',
    'advanced_options_explain'                  => 'Nogle sider i Firefly III har avancerede indstillinger der kan tilgås via denne knap. Denne side har ikke noget specielt her, men tjek de andre!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'deaktiveret',
    'no_webhook_messages'                       => 'Der er ingen webhook-beskeder',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Efter oprettelse af transaktion',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Efter opdatering af transaktion',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Efter sletning af transaktion',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaktionsdetaljer',
    'webhook_response_ACCOUNTS'                 => 'Kontodetaljer',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspect',
    'create_new_webhook'                        => 'Opret ny webhook',
    'webhooks_create_breadcrumb'                => 'Opret ny webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Hvilket format webhook skal levere data i.',
    'webhook_active_form_help'                  => 'Webhooken skal være aktiv, ellers vil den ikke blive kaldt.',
    'stored_new_webhook'                        => 'Gemte ny webhook ":title"',
    'delete_webhook'                            => 'Slet webhook',
    'deleted_webhook'                           => 'Slettede webhook ":title"',
    'edit_webhook'                              => 'Rediger webhook ":title"',
    'updated_webhook'                           => 'Opdaterede webhook ":title"',
    'edit_webhook_js'                           => 'Rediger webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook-besked',
    'view_message'                              => 'Vis besked',
    'view_attempts'                             => 'Vis mislykkede forsøg',
    'message_content_title'                     => 'Webhook-beskedindhold',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook-forsøg',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'Der er ingen mislykkede forsøg. Det er en god ting!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Svar',
    'visit_webhook_url'                         => 'Besøg webhook-URL',
    'reset_webhook_secret'                      => 'Nulstil webhook-hemmelighed',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Anmodning om Autorisation',
    'authorization_request_intro'               => '<strong>:client</strong> anmoder om at få adgang til din økonomi. Vil du give <strong>:client</strong> adgang til disse poster?',
    'authorization_request_site'                => 'Du vil blive omdirigeret til <code>:url</code> som derefter vil være i stand til at få adgang til dine Firefly III-data.',
    'authorization_request_invalid'             => 'Denne adgangsanmodning er ugyldig. Følg aldrig dette link igen.',
    'scopes_will_be_able'                       => 'Applikationen vil kunne:',
    'button_authorize'                          => 'Autoriser',
    'none_in_select_list'                       => '(ingen)',
    'no_piggy_bank'                             => '(ingen opsparing)',
    'name_in_currency'                          => ':name i :currency',
    'paid_in_currency'                          => 'Betalt i :currency',
    'unpaid_in_currency'                        => 'Ikke betalt i :currency',
    'is_alpha_warning'                          => 'Du kører en ALPHA version. Vær opmærksom på fejl og mangler.',
    'is_beta_warning'                           => 'Du kører en BETA version. Vær opmærksom på fejl og mangler.',
    'all_destination_accounts'                  => 'Destinationskonti',
    'all_source_accounts'                       => 'Kildekonti',
    'back_to_index'                             => 'Tilbage til indholdsfortegnelsen',
    'cant_logout_guard'                         => 'Firefly III kan ikke logge dig ud.',
    'internal_reference'                        => 'Intern reference',

    // check for updates:
    'update_check_title'                        => 'Søg efter opdateringer',
    'admin_update_check_title'                  => 'Søg automatisk efter opdateringer',
    'admin_update_check_explain'                => 'Firefly III kan tjekke for opdateringer automatisk. Når du aktiverer denne indstilling, vil det kontakte Firefly III-opdateringsserveren for at se, om en ny version af Firefly III er tilgængelig. Når det er, vil du få en meddelelse. Du kan teste denne meddelelse ved hjælp af knappen til højre. Angiv venligst nedenfor, hvis du vil have Firefly III til automatisk at søge efter opdateringer.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Spørg mig senere',
    'updates_do_not_check'                      => 'Søg ikke efter opdateringer',
    'updates_enable_check'                      => 'Aktiver søgning for opdateringer',
    'admin_update_check_now_title'              => 'Søg efter opdateringer nu',
    'admin_update_check_now_explain'            => 'Hvis du trykker på knappen, vil Firefly III tjekke, om din nuværende version er den seneste.',
    'check_for_updates_button'                  => 'Tjek nu!',
    'update_new_version_alert'                  => 'En ny version af Firefly III er tilgængelig. Du bruger :your_version, den nyeste version er :new_version, som blev udgivet den :date.',
    'update_version_beta'                       => 'Denne version er en BETA version. Du kan løbe ind i problemer.',
    'update_version_alpha'                      => 'Denne version er en ALPHA version. Du kan løbe ind i problemer.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Du bruger :version, som er den seneste tilgængelige udgivelse.',
    'update_newer_version_alert'                => 'Du bruger :your_version, som er nyere end den seneste udgivelse, :new_version.',
    'update_check_error'                        => 'Der opstod en fejl under søgning efter opdateringer: :error',
    'unknown_error'                             => 'Ukendt fejl. Beklager.',
    'disabled_but_check'                        => 'Du har deaktiveret automatisk søgning efter opdateringer. Så glem ikke, nu og da, at tjekke for opdateringer. Tak!',
    'admin_update_channel_title'                => 'Opdateringskanal',
    'admin_update_channel_explain'              => 'Firefly III har tre opdaterings "kanaler" som bestemmer, hvor du er i forhold til funktioner, forbedringer og fejl. Brug "beta" kanalen, hvis du er eventyrlig og "alfa" kanalen, hvis du vil leve livet farligt.',
    'update_channel_stable'                     => 'Stabil. Alt bør fungere som forventet.',
    'update_channel_beta'                       => 'Beta. Nye funktioner, men der kan være fejl.',
    'update_channel_alpha'                      => 'Alfa. Meget afprøves, og vi bruger det som fungerer.',

    // search
    'search'                                    => 'Søg',
    'search_query'                              => 'Forespørgsel',
    'search_found_transactions'                 => 'Firefly III fandt:count transaktion på :time sekunder.IFirefly III fandt :count transaktioner på :time sekunder.',
    'search_found_more_transactions'            => 'Firefly III fandt mere end :count transaktioner på :time sekunder.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Disse søgeparametre er ikke gyldige og er blevet ignoreret.',

    // old


    'search_modifier_date_on'                             => 'Transaktionsdato er ":value"',
    'search_modifier_not_date_on'                         => 'Transaktionsdato er ikke ":value"',
    'search_modifier_reconciled'                          => 'Transaktionen er afstemt',
    'search_modifier_not_reconciled'                      => 'Transaktionen er ikke afstemt',
    'search_modifier_id'                                  => 'Transaktions-ID er ":value"',
    'search_modifier_not_id'                              => 'Transaktions-ID er ikke ":value"',
    'search_modifier_date_before'                         => 'Transaktionsdato er før eller den ":value"',
    'search_modifier_date_after'                          => 'Transaktionsdato er efter eller den ":value"',
    'search_modifier_external_id_is'                      => 'Eksternt ID er ":value"',
    'search_modifier_not_external_id_is'                  => 'Eksternt ID er ikke ":value"',
    'search_modifier_no_external_url'                     => 'Transaktionen har ikke noget eksternt URL',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'Transaktionen har ikke noget eksternt URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'Transaktionen skal have et (vilkårligt) eksternt URL',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'Transaktionen skal have et (vilkårligt) eksternt URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Intern reference er ":value"',
    'search_modifier_not_internal_reference_is'           => 'Intern reference er ikke ":value"',
    'search_modifier_description_starts'                  => 'Beskrivelsen starter med ":value"',
    'search_modifier_not_description_starts'              => 'Beskrivelsen starter ikke med ":value"',
    'search_modifier_description_ends'                    => 'Beskrivelsen slutter med ":value"',
    'search_modifier_not_description_ends'                => 'Beskrivelsen slutter ikke med ":value"',
    'search_modifier_description_contains'                => 'Beskrivelsen indeholder ":value"',
    'search_modifier_not_description_contains'            => 'Beskrivelsen indeholder ikke ":value"',
    'search_modifier_description_is'                      => 'Beskrivelsen er præcis ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => 'Udenlandsk transaktions valuta er ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Udenlandsk transaktions valuta er ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'Transaktionen skal have en vedhæftet fil',
    'search_modifier_has_no_category'                     => 'Transaktionen må ikke have nogen kategori',
    'search_modifier_not_has_no_category'                 => 'Transaktionen skal have en (vilkårlig) kategori',
    'search_modifier_not_has_any_category'                => 'Transaktionen må ikke have nogen kategori',
    'search_modifier_has_any_category'                    => 'Transaktionen skal have en (vilkårlig) kategori',
    'search_modifier_has_no_budget'                       => 'Transaktionen må ikke have noget budget',
    'search_modifier_not_has_any_budget'                  => 'Transaktionen må ikke have noget budget',
    'search_modifier_has_any_budget'                      => 'Transaktionen skal have et (vilkårligt) budget',
    'search_modifier_not_has_no_budget'                   => 'Transaktionen skal have et (vilkårligt) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transaktionen må ikke have nogen tags',
    'search_modifier_not_has_any_tag'                     => 'Transaktionen må ikke have nogen tags',
    'search_modifier_not_has_no_tag'                      => 'Transaktionen skal have et (vilkårligt) tag',
    'search_modifier_has_any_tag'                         => 'Transaktionen skal have et (vilkårligt) tag',
    'search_modifier_notes_contains'                      => 'Transaktionsnoterne indeholder ":value"',
    'search_modifier_not_notes_contains'                  => 'Transaktionsnoterne indeholder ikke ":value"',
    'search_modifier_notes_starts'                        => 'Transaktionsnoterne starter med ":value"',
    'search_modifier_not_notes_starts'                    => 'Transaktionsnoterne starter ikke med ":value"',
    'search_modifier_notes_ends'                          => 'Transaktionsnoterne slutter med ":value"',
    'search_modifier_not_notes_ends'                      => 'Transaktionsnoterne slutter ikke med ":value"',
    'search_modifier_notes_is'                            => 'Transaktionsnoterne er præcis ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Transaktionen har ingen noter',
    'search_modifier_not_no_notes'                        => 'Transaktionen skal have noter',
    'search_modifier_any_notes'                           => 'Transaktionen skal have noter',
    'search_modifier_not_any_notes'                       => 'Transaktionen har ingen noter',
    'search_modifier_amount_is'                           => 'Beløbet er præcis :value',
    'search_modifier_not_amount_is'                       => 'Beløbet er ikke :value',
    'search_modifier_amount_less'                         => 'Beløbet er mindre end eller lig med :value',
    'search_modifier_not_amount_more'                     => 'Beløbet er mindre end eller lig med :value',
    'search_modifier_amount_more'                         => 'Beløbet er større end eller lig med :value',
    'search_modifier_not_amount_less'                     => 'Beløbet er større end eller lig med :value',
    'search_modifier_source_account_is'                   => 'Kildekontonavnet er præcis ":value"',
    'search_modifier_not_source_account_is'               => 'Kildekontonavnet er ikke ":value"',
    'search_modifier_source_account_contains'             => 'Kildekontonavnet indeholder ":value"',
    'search_modifier_not_source_account_contains'         => 'Kildekontonavnet indeholder ikke ":value"',
    'search_modifier_source_account_starts'               => 'Kildekontonavnet starter med ":value"',
    'search_modifier_not_source_account_starts'           => 'Kildekontonavnet starter ikke med ":value"',
    'search_modifier_source_account_ends'                 => 'Kildekontonavnet slutter med ":value"',
    'search_modifier_not_source_account_ends'             => 'Kildekontonavnet slutter ikke med ":value"',
    'search_modifier_source_account_id'                   => 'Kildekonto ID er :value',
    'search_modifier_not_source_account_id'               => 'Kildekonto-ID er ikke :value',
    'search_modifier_source_account_nr_is'                => 'Kildekontonummer (IBAN) er ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Kildekontonummer (IBAN) er ikke ":value"',
    'search_modifier_source_account_nr_contains'          => 'Kildekontonummer (IBAN) indeholder ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Kildekontonummer (IBAN) indeholder ikke ":value"',
    'search_modifier_source_account_nr_starts'            => 'Kildekontonummer (IBAN) starter med ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Kildekontonummer (IBAN) starter ikke med ":value"',
    'search_modifier_source_account_nr_ends'              => 'Kildekontonummer (IBAN) slutter med ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Kildekontonummer (IBAN) slutter ikke med ":value"',
    'search_modifier_destination_account_is'              => 'Destinationskontonavnet er præcis ":value"',
    'search_modifier_not_destination_account_is'          => 'Destinationskontonavnet er ikke ":value"',
    'search_modifier_destination_account_contains'        => 'Destinationskontonavnet indeholder ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destinationskontonavnet indeholder ikke ":value"',
    'search_modifier_destination_account_starts'          => 'Destinationskontonavnet starter med ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destinationskontonavnet starter ikke med ":value"',
    'search_modifier_destination_account_ends'            => 'Destinationskontonavnet slutter med ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destinationskontonavnet slutter ikke med ":value"',
    'search_modifier_destination_account_id'              => 'Destinationskonto ID er :value',
    'search_modifier_not_destination_account_id'          => 'Destinationskonto-ID er ikke :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Destinationskontonummer (IBAN) er ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Destinationskontonummer (IBAN) indeholder ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Destinationskontonummer (IBAN) starter med ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Destinationskontonummer (IBAN) slutter med ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Kilde- eller destinationskonto ID er: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Kategori er ":value"',
    'search_modifier_not_category_is'                     => 'Kategori er ikke ":value"',
    'search_modifier_budget_is'                           => 'Budget er ":value"',
    'search_modifier_not_budget_is'                       => 'Budget er ikke ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Transaktionstype er ":value"',
    'search_modifier_not_transaction_type'                => 'Transaktionstype er ikke ":value"',
    'search_modifier_tag_is'                              => 'Tag er ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'Intet tag er ":value"',
    'search_modifier_date_on_year'                        => 'Transaktionen er i år ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaktionen er i måned ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaktionen er på den ":value". i måneden',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Transaktionen er før eller i år ":value"',
    'search_modifier_date_before_month'                   => 'Transaktionen er før eller i måned ":value"',
    'search_modifier_date_before_day'                     => 'Transaktionen er før eller på den ":value". i måneden',
    'search_modifier_date_after_year'                     => 'Transaktionen er i eller efter år ":value"',
    'search_modifier_date_after_month'                    => 'Transaktionen er i eller efter måned ":value"',
    'search_modifier_date_after_day'                      => 'Transaktionen er på eller efter den ":value". i måneden',

    // new
    'search_modifier_tag_is_not'                          => 'Intet tag er ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Begge konti er ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Begge konti indeholder ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Begge konti slutter med ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Begge konti starter med ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Begge konto numre / IBAN er ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Begge konto numre / IBAN indeholder ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Begge konto numre / IBAN slutter med ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Begge konto numre / IBAN starter med ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Kategori indeholder ":value"',
    'search_modifier_not_category_contains'               => 'Kategori indeholder ikke ":value"',
    'search_modifier_category_ends'                       => 'Kategori slutter med ":value"',
    'search_modifier_not_category_ends'                   => 'Kategori slutter ikke med ":value"',
    'search_modifier_category_starts'                     => 'Kategori starter med ":value"',
    'search_modifier_not_category_starts'                 => 'Kategori begynder ikke med ":value"',
    'search_modifier_budget_contains'                     => 'Budget indeholder ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget indeholder ikke ":value"',
    'search_modifier_budget_ends'                         => 'Budget slutter med ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget slutter ikke med ":value"',
    'search_modifier_budget_starts'                       => 'Budget starter med ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget begynder ikke med ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'Eksternt ID indeholder ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'Eksternt ID ender med ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'Eksternt ID starter med ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Intern reference indeholder ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Intern reference slutter med ":value"',
    'search_modifier_internal_reference_starts'           => 'Intern reference starter med ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'Eksternt URL er ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'Eksternt URL indeholder ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'Ekstern URL slutter med ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'Ekstern URL starter med ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaktionen har ingen vedhæftninger',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'Det udenlandske beløb er ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'Det udenlandske beløb er mindre end ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'Det udenlandske beløb er mere end ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaktion rentedato er ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaktionens rentedato er i år ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaktions rentedato er i måned ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaktions rentedato er den ":value". i måneden',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaktions rentedato er før eller i år ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaktionens forfaldsdato er efter eller i år ":value"',
    'search_modifier_due_date_after_month'                => 'Transaktionens forfaldsdato er efter eller i måned ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaktionens forfaldsdato er efter eller på den ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaktionens betalingsdato er i år ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaktionens betalingsdato er i måned ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaktionen er på den ":value". i måneden',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaktionens betalings dato er før eller i år ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaktionens betalings dato er før eller i måned ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaktionens betalings dato er før eller på den ":value" i måneden',
    'search_modifier_payment_date_after_year'             => 'Transaktionens betalings dato er efter eller i år ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaktionens betalings dato er efter eller i måned ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaktionens betalings dato er efter eller på den ":value" i måneden',
    'search_modifier_invoice_date_on_year'                => 'Transaktionens faktura dato er i år ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaktionens faktura dato er i måned ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaktionens fakturadato er den ":value" i måneden',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaktionens faktura dato er før eller i år ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaktionens faktura dato er før eller i måned ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaktionens faktura dato er før eller på den ":value" i måneden',
    'search_modifier_invoice_date_after_year'             => 'Transaktionens faktura dato er efter eller i år ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaktionens faktura dato er efter eller i måned ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaktionens faktura dato er efter eller på den ":value" i måneden',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaktionen blev sidst opdateret i år ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaktionen blev sidst opdateret i måned ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaktionen blev sidst opdateret den ":value" i måneden',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaktionen blev sidst opdateret i eller før år ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaktionen blev sidst opdateret i eller før måned ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaktionen blev sidst opdateret i eller før den ":value" i måneden',
    'search_modifier_updated_at_after_year'               => 'Transaktionen blev sidst opdateret i eller efter år ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaktionen blev sidst opdateret i eller efter måned ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaktionen blev sidst opdateret på eller efter den ":value" i måneden',
    'search_modifier_created_at_on_year'                  => 'Transaktionen blev oprettet i år ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaktionen blev oprettet i måned ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaktionen blev oprettet den ":value" i måneden',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaktionen blev oprettet i eller før år ":value"',
    'search_modifier_created_at_before_month'             => 'Transaktionen blev oprettet i eller før måned ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Opdater regel ":rule" fra søgeforespørgsel',
    'create_rule_from_query'                        => 'Opret ny regel fra søgeforespørgsel',
    'rule_from_search_words'                        => 'Der er problemer med at håndtere forespørgslen ":string". Den foreslåede regel, der passer til din søgeforespørgsel, kan give forskellige resultater. Kontroller venligst omhyggeligt de udløsende hændelser.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Der opstod en fejl under søgningen. Kontroller logfilerne for mere information.',
    'search_box'                                          => 'Søg',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Fejl under søgning',
    'search_searching'                                    => 'Søger...',
    'search_results'                                      => 'Søgeresultater',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'årligt',
    'repeat_freq_half-year'                               => 'hvert halve år',
    'repeat_freq_quarterly'                               => 'kvartalsvis',
    'repeat_freq_monthly'                                 => 'månedligt',
    'repeat_freq_weekly'                                  => 'ugentligt',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => 'ugentligt',
    'quarterly'                                           => 'kvartalsvis',
    'half-year'                                           => 'hvert halve år',
    'yearly'                                              => 'årligt',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Du kan ikke afvikle inaktive regler.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Regler',
    'rule_name'                                           => 'Navn på regel',
    'rule_triggers'                                       => 'Regel udløsere, ved',
    'rule_actions'                                        => 'Reglen vil',
    'new_rule'                                            => 'Ny regel',
    'new_rule_group'                                      => 'Ny regel gruppe',
    'rule_priority_up'                                    => 'Giv reglen mere prioritet',
    'rule_priority_down'                                  => 'Giv reglen mindre prioritet',
    'make_new_rule_group'                                 => 'Opret ny regel gruppe',
    'store_new_rule_group'                                => 'Gem ny regel gruppe',
    'created_new_rule_group'                              => 'Ny regel gruppe ":title" gemt!',
    'updated_rule_group'                                  => 'Regelgruppen ":title" opdateret.',
    'edit_rule_group'                                     => 'Rediger regelgruppe ":title"',
    'duplicate_rule'                                      => 'Dublet regel ":title"',
    'rule_copy_of'                                        => 'Kopi af ":title"',
    'duplicated_rule'                                     => 'Regel ":title" duplikeret som ":newTitle"',
    'delete_rule_group'                                   => 'Slet regelgruppe ":title"',
    'deleted_rule_group'                                  => 'Regelgruppe ":title" slettet',
    'update_rule_group'                                   => 'Opdater regelgruppe',
    'no_rules_in_group'                                   => 'Der er ingen regler i denne gruppe',
    'move_rule_group_up'                                  => 'Flyt regelgruppe op',
    'move_rule_group_down'                                => 'Flyt regelgruppe ned',
    'save_rules_by_moving'                                => 'Gem denne regel ved at flytte den til en anden regelgruppe:|Gem disse regler ved at flytte dem til en anden regelgruppe:',
    'make_new_rule'                                       => 'Lav en ny regel i regelgruppen ":title"',
    'make_new_rule_no_group'                              => 'Lav en ny regel',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Opret en regel baseret på en af dine transaktioner. Udfyld eller indsend nedenstående formular.',
    'rule_is_strict'                                      => 'streng regel',
    'rule_is_not_strict'                                  => 'ikke-streng regel',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'I strenge regler SKAL ALLE udløsere affyre for at handlingen/handlingerne kan udføres. I ikke-strenge regler er én udløser nok til, at handlingen/aktionerne kan udføres.',
    'rule_help_active'                                    => 'Inaktive regler vil aldrig udløses.',
    'stored_new_rule'                                     => 'Gemt ny regel med titlen ":title"',
    'deleted_rule'                                        => 'Slettede reglen med titlen ":title"',
    'store_new_rule'                                      => 'Gem ny regel',
    'updated_rule'                                        => 'Opdateret regel med titlen ":title"',
    'default_rule_group_name'                             => 'Standard regler',
    'default_rule_group_description'                      => 'Alle dine regler som ikke er i en bestemt gruppe.',
    'trigger'                                             => 'Udløser',
    'trigger_value'                                       => 'Udløs på værdi',
    'stop_processing_other_triggers'                      => 'Stop behandling af andre udløsere',
    'add_rule_trigger'                                    => 'Tilføj ny udløser',
    'action'                                              => 'Handling',
    'action_value'                                        => 'Aktionsværdi',
    'stop_executing_other_actions'                        => 'Stop udførelse af øvrige handlinger',
    'add_rule_action'                                     => 'Tilføj en ny handling',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Slet regel ":title"',
    'update_rule'                                         => 'Opdater regel',
    'test_rule_triggers'                                  => 'Se matchende transaktioner',
    'warning_no_matching_transactions'                    => 'Ingen matchende transaktioner fundet.',
    'warning_no_valid_triggers'                           => 'Ingen gyldige udløsere angivet.',
    'apply_rule_selection'                                => 'Anvend regel ":title" på udvalgte transaktioner',
    'apply_rule_selection_intro'                          => 'Regler som ":title" anvendes normalt kun på nye eller opdaterede transaktioner, men du kan bede Firefly III at køre det på et udvalg af dine eksisterende transaktioner. Dette kan være nyttigt, når du har opdateret en regel og du har brug for at ændringerne anvendes på alle dine andre transaktioner.',
    'include_transactions_from_accounts'                  => 'Inkludér transaktioner fra disse konti',
    'include'                                             => 'Inkludér?',
    'applied_rule_selection'                              => '{0} Ingen transaktioner i dit valg blev ændret af regel ":title".[1] En transaktion i dit valg blev ændret af regel ":title". [2,*] :count transaktioner i dit valg blev ændret af regel ":title".',
    'execute'                                             => 'Kør',
    'apply_rule_group_selection'                          => 'Anvend regelgruppe ":title" på et udvalg af dine transaktioner',
    'apply_rule_group_selection_intro'                    => 'Regelgrupper som ":title" anvendes normalt kun på nye eller opdaterede transaktioner, men du kan bede Firefly III at køre alle reglerne i denne gruppe, på et udvalg af dine eksisterende transaktioner. Dette kan være nyttigt når du har opdateret en gruppe af regler, og du har brug for at regelændringerne anvendes på alle dine andre transaktioner.',
    'applied_rule_group_selection'                        => 'Regelgruppe ":title" er blevet anvendt på det udvalgte.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Når en transaktion er oprettet',
    'rule_trigger_update_journal'                         => 'Når en transaktion opdateres',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Brugerhandling er ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Kildekontonavn starter med..',
    'rule_trigger_source_account_starts'                  => 'Kildekontonavn starter med ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Kildekontonavnet slutter med..',
    'rule_trigger_source_account_ends'                    => 'Kildekontonavn slutter med ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Kildekontonavn er..',
    'rule_trigger_source_account_is'                      => 'Kildekontonavn er ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Kildekontonavnet indeholder..',
    'rule_trigger_source_account_contains'                => 'Kildekontonavnet indeholder ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Kildekonto ID er præcis..',
    'rule_trigger_source_account_id'                      => 'Kildekonto ID er præcis :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Destinationskonto ID er præcis..',
    'rule_trigger_destination_account_id'                 => 'Destinationskonto ID er præcis :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Kildekonto er (kontant) konto',
    'rule_trigger_source_is_cash'                         => 'Kildekonto er (kontant) konto',
    'rule_trigger_destination_is_cash_choice'             => 'Destinationskonto er (kontant) konto',
    'rule_trigger_destination_is_cash'                    => 'Destinationskonto er (kontant) konto',
    'rule_trigger_source_account_nr_starts_choice'        => 'Kildekontonummer / IBAN starter med..',
    'rule_trigger_source_account_nr_starts'               => 'Kildekontonummer / IBAN starter med ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Kildekontonummer / IBAN slutter med..',
    'rule_trigger_source_account_nr_ends'                 => 'Kildekontonummer / IBAN slutter med ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Kildekontonummer / IBAN er..',
    'rule_trigger_source_account_nr_is'                   => 'Kildekontonummer / IBAN er ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Kildekontonummer / IBAN indeholder..',
    'rule_trigger_source_account_nr_contains'             => 'Kildekontonummer / IBAN indeholder ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Destinationskontonavnet starter med..',
    'rule_trigger_destination_account_starts'             => 'Destinationskontonavnet starter med ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Destinationskontonavnet slutter med..',
    'rule_trigger_destination_account_ends'               => 'Destinationskontonavnet slutter med ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Destinationskontonavnet er..',
    'rule_trigger_destination_account_is'                 => 'Destinationskontonavnet er ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Destinationskontonavnet indeholder..',
    'rule_trigger_destination_account_contains'           => 'Destinationskontonavnet indeholder ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Destinationskontonummer / IBAN starter med..',
    'rule_trigger_destination_account_nr_starts'          => 'Destinationskontonummer / IBAN starter med ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Destinationskontonummer / IBAN slutter med..',
    'rule_trigger_destination_account_nr_ends'            => 'Destinationskontonummer / IBAN slutter med ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Destinationskontonummer / IBAN er..',
    'rule_trigger_destination_account_nr_is'              => 'Destinationskontonummer / IBAN er ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Destinationskontonummer / IBAN indeholder..',
    'rule_trigger_destination_account_nr_contains'        => 'Destinationskontonummer / IBAN indeholder ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transaktionen er af type..',
    'rule_trigger_transaction_type'                       => 'Transaktionen er af typen ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategorien er..',
    'rule_trigger_category_is'                            => 'Kategori er ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Beskrivelsen starter med..',
    'rule_trigger_description_starts'                     => 'Beskrivelsen starter med ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Beskrivelsen slutter med..',
    'rule_trigger_description_ends'                       => 'Beskrivelsen slutter med ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Beskrivelsen indeholder..',
    'rule_trigger_description_contains'                   => 'Beskrivelsen indeholder ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Beskrivelsen er..',
    'rule_trigger_description_is'                         => 'Beskrivelsen er ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transaktionsdato er før..',
    'rule_trigger_date_before'                            => 'Transaktionsdatoen er før ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transaktionsdatoen er efter..',
    'rule_trigger_date_after'                             => 'Transaktionsdatoen er efter ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budgettet er..',
    'rule_trigger_budget_is'                              => 'Budgettet er ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transaktionsvalutaen er..',
    'rule_trigger_currency_is'                            => 'Transaktionsvalutaen er ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Udenlandsk transaktionsvaluta er..',
    'rule_trigger_foreign_currency_is'                    => 'Udenlansk transaktionsvaluta er ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Har ingen kategori',
    'rule_trigger_has_no_category'                        => 'Transaktionen har ingen kategori',
    'rule_trigger_has_any_category_choice'                => 'Har en (vilkårlig) kategori',
    'rule_trigger_has_any_category'                       => 'Transaktionen har en (nogen) kategori',
    'rule_trigger_has_no_budget_choice'                   => 'Har intet budget',
    'rule_trigger_has_no_budget'                          => 'Transaktionen har intet budget',
    'rule_trigger_has_any_budget_choice'                  => 'Har et (noget) budget',
    'rule_trigger_has_any_budget'                         => 'Transaktionen har et (noget) budget',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Har ingen tag(s)',
    'rule_trigger_has_no_tag'                             => 'Transaktionen har ingen tag(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Har en eller flere (nogen) tags',
    'rule_trigger_has_any_tag'                            => 'Transaktionen har en eller flere (nogen) tags',
    'rule_trigger_any_notes_choice'                       => 'Har (nogen) noter',
    'rule_trigger_any_notes'                              => 'Transaktionen har (nogen) noter',
    'rule_trigger_no_notes_choice'                        => 'Har ingen noter',
    'rule_trigger_no_notes'                               => 'Transaktionen har ingen noter',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaktionsjournal ID er..',
    'rule_trigger_journal_id'                             => 'Transaktionsjournal ID er ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaktion har ikke noget eksternt URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Valuta er ikke ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Fremmed valuta er ikke ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Sæt kategori til ":action_value"',
    'rule_action_clear_category'                 => 'Ryd kategori',
    'rule_action_set_budget'                     => 'Sæt budget til ":action_value"',
    'rule_action_clear_budget'                   => 'Ryd budget',
    'rule_action_add_tag'                        => 'Tilføj tag ":action_value"',
    'rule_action_remove_tag'                     => 'Fjern tag ":action_value"',
    'rule_action_remove_all_tags'                => 'Fjern alle tags',
    'rule_action_set_description'                => 'Angiv beskrivelsen til ":action_value"',
    'rule_action_append_description'             => 'Tilføj beskrivelsen med ":action_value"',
    'rule_action_prepend_description'            => 'Præfiks beskrivelsen med ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Ryd alle kategorier',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Ryd ethvert budget',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Fjern alle tags',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Sæt kildekonto til :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Sæt destinationskonto til :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Tilføj noter med ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Præfiks noter med ":action_value"',
    'rule_action_clear_notes_choice'             => 'Fjern alle noter',
    'rule_action_clear_notes'                    => 'Fjern alle noter',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Sæt noter til ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Konverter transaktionen til et indskud',
    'rule_action_convert_deposit'                => 'Konverter transaktionen til et indskud fra ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Konverter transaktionen til en udbetaling',
    'rule_action_convert_withdrawal'             => 'Konverter transaktionen til en udbetaling til ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Konverter transaktionen til en overførsel',
    'rule_action_convert_transfer'               => 'Konverter transaktionen til en overførsel med ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regel baseret på transaktionen ":description"',
    'new_rule_for_journal_description'          => 'Denne regel er baseret på transaktionen ":description". Den vil matche transaktioner, der er nøjagtigt de samme.',

    // tags
    'store_new_tag'                             => 'Gem nyt tag',
    'update_tag'                                => 'Opdater tag',
    'no_location_set'                           => 'Ingen stedangivelse.',
    'meta_data'                                 => 'Meta data',
    'location'                                  => 'Sted',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Uden dato',
    'result'                                    => 'Resultat',
    'sums_apply_to_range'                       => 'Alle beløb gælder for det valgte interval',
    'mapbox_api_key'                            => 'For at bruge kortet, hent en API-nøgle fra <a href="https://www.mapbox.com/">Mapbox</a>. Åbn <code>.env</code> -filen og indtast denne kode under <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Højreklik eller langt tryk for at angive objektets placering.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Ryd stedangivelse',
    'delete_all_selected_tags'                  => 'Slet alle valgte tags',
    'select_tags_to_delete'                     => 'Glem ikke at vælge nogle tags.',
    'deleted_x_tags'                            => 'Slettede :count tag.|Slettede :count tags.',
    'create_rule_from_transaction'              => 'Opret regel baseret på transaktion',
    'create_recurring_from_transaction'         => 'Opret periodisk transaktion baseret på transaktion',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(lig med sprog)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Startskærmskonti',
    'pref_home_screen_accounts_help'            => 'Hvilke konti skal vises på hjemmesiden?',
    'pref_view_range'                           => 'Vis interval',
    'pref_view_range_help'                      => 'Nogle diagrammer er automatisk grupperet i perioder. Dine budgetter vil også blive grupperet i perioder. Hvilken periode vil du foretrække?',
    'pref_1D'                                   => 'En dag',
    'pref_1W'                                   => 'En uge',
    'pref_1M'                                   => 'En måned',
    'pref_3M'                                   => 'Tre måneder (kvartal)',
    'pref_6M'                                   => 'Seks måneder',
    'pref_1Y'                                   => 'Et år',
    'pref_last365'                              => 'Sidste år',
    'pref_last90'                               => 'Sidste 90 dage',
    'pref_last30'                               => 'Sidste 30 dage',
    'pref_last7'                                => 'Sidste 7 dage',
    'pref_YTD'                                  => 'År til dato',
    'pref_QTD'                                  => 'Kvartal til dato',
    'pref_MTD'                                  => 'Måned til dato',
    'pref_languages'                            => 'Sprog',
    'pref_locale'                               => 'Landekode indstillinger',
    'pref_languages_help'                       => 'Firefly III understøtter flere sprog. Hvilket foretrækker du?',
    'pref_locale_help'                          => 'Firefly III giver dig mulighed for at indstille andre landestandard indstillinger, såsom hvordan valutaer, tal og datoer er formateret. Indstillingerne i denne liste understøttes muligvis ikke af dit system. Firefly III har ikke de korrekte datoindstillinger for hver landestandard; kontakt mig for forbedringer.',
    'pref_locale_no_demo'                       => 'Denne funktion virker ikke for demo-brugeren.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Skatteår indstillinger',
    'pref_custom_fiscal_year_label'             => 'Aktiveret',
    'pref_custom_fiscal_year_help'              => 'For lande, der anvender anden regnskabsårsperiode end 1. januar til 31. december, kan du slå dette til og angive start-/slut- dato for regnskabsåret',
    'pref_fiscal_year_start_label'              => 'Regnskabsårets start dato',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Glem ikke at fjerne kontoen fra din godkendelse app!',
    'pref_two_factor_auth_code'                 => 'Bekræftelseskode',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Nulstil bekræftelseskode',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Hvis du ikke kan scanne QR-koden, er du velkommen til at bruge \'koden\' i stedet: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Gem disse backup koder for adgang, hvis du mister din enhed.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Denne Multifaktor bekræftelseskode er ikke gyldig.',
    'pref_save_settings'                        => 'Gem indstillinger',
    'saved_preferences'                         => 'Indstillinger gemt!',
    'preferences_general'                       => 'Generelt',
    'preferences_frontpage'                     => 'Startskærm',
    'preferences_security'                      => 'Sikkerhed',
    'preferences_layout'                        => 'Layout',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Vis indskud på startskærmen',
    'pref_home_show_deposits_info'              => 'Startskærmen viser allerede dine udgiftskonti. Skal det også vise dine indtægtskonti?',
    'pref_home_do_show_deposits'                => 'Ja, vis dem',
    'successful_count'                          => 'heraf :count lykkedes',
    'list_page_size_title'                      => 'Sidestørrelse',
    'list_page_size_help'                       => 'Enhver vilkårlig liste (konti, transaktioner osv.) viser højst så mange per side.',
    'list_page_size_label'                      => 'Sidestørrelse',
    'between_dates'                             => '(:start og :end)',
    'pref_optional_fields_transaction'          => 'Valgfrie felter for transaktioner',
    'pref_optional_fields_transaction_help'     => 'Som standard er ikke alle felter aktiveret, når du opretter en ny transaktion (undgår rod). Nedenfor kan du aktivere disse felter, hvis du tror, de kunne være nyttige for dig. Selvfølgelig vil ethvert felt, der er deaktiveret, men allerede udfyldt, være synligt uanset konfigurationen.',
    'optional_tj_date_fields'                   => 'Dato felter',
    'optional_tj_other_fields'                  => 'Andre felter',
    'optional_tj_attachment_fields'             => 'Bilagsfelter',
    'pref_optional_tj_interest_date'            => 'Rentedato',
    'pref_optional_tj_book_date'                => 'Bogføringsdato',
    'pref_optional_tj_process_date'             => 'Behandlingsdato',
    'pref_optional_tj_due_date'                 => 'Forfaldsdato',
    'pref_optional_tj_payment_date'             => 'Betalingsdato',
    'pref_optional_tj_invoice_date'             => 'Fakturadato',
    'pref_optional_tj_internal_reference'       => 'Intern reference',
    'pref_optional_tj_notes'                    => 'Bemærkninger',
    'pref_optional_tj_attachments'              => 'Vedhæftninger',
    'pref_optional_tj_external_url'             => 'Eksternt URL',
    'pref_optional_tj_location'                 => 'Placering',
    'pref_optional_tj_links'                    => 'Transaktionslinks',
    'optional_field_meta_dates'                 => 'Datoer',
    'optional_field_meta_business'              => 'Forretning',
    'optional_field_attachments'                => 'Vedhæftninger',
    'optional_field_meta_data'                  => 'Valgfrit metadata',
    'external_url'                              => 'Ekstern URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Alle dine andre sessioner er blevet logget af.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Slet ALLE dine budgetter',
    'delete_all_categories'                     => 'Slet alle dine kategorier',
    'delete_all_tags'                           => 'Slet ALLE dine tags',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Slet ALLE dine "sparegrise"',
    'delete_all_rules'                          => 'Slet ALLE dine regninger',
    'delete_all_recurring'                      => 'Slet ALLE dine periodiske transaktioner',
    'delete_all_object_groups'                  => 'Slet ALLE dine objektgrupper',
    'delete_all_accounts'                       => 'Slet ALLE dine konti',
    'delete_all_asset_accounts'                 => 'Slet ALLE dine aktiv konti',
    'delete_all_expense_accounts'               => 'Slet ALLE dine udgiftskonti',
    'delete_all_revenue_accounts'               => 'Slet ALLE dine indtægtskonti',
    'delete_all_liabilities'                    => 'Slet ALLE dine forpligtelser',
    'delete_all_transactions'                   => 'Slet ALLE dine transaktioner',
    'delete_all_withdrawals'                    => 'Slet ALLE dine udbetalinger',
    'delete_all_deposits'                       => 'Slet ALLE dine indskud',
    'delete_all_transfers'                      => 'Slet ALLE dine overførsler',
    'also_delete_transactions'                  => 'Sletning af konti vil også slette ALLE tilknyttede udbetalinger, indskud og transaktioner!',
    'deleted_all_budgets'                       => 'Alle budgetter er blevet slettet',
    'deleted_all_categories'                    => 'Alle kategorier er blevet slettet',
    'deleted_all_tags'                          => 'Alle tags er blevet slettet',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Alle "sparegrise" er blevet slettet',
    'deleted_all_rules'                         => 'Alle regler og regelgrupper er blevet slettet',
    'deleted_all_object_groups'                 => 'Alle grupper er blevet slettet',
    'deleted_all_accounts'                      => 'Alle konti er blevet slettet',
    'deleted_all_asset_accounts'                => 'Alle aktiv konti er blevet slettet',
    'deleted_all_expense_accounts'              => 'Alle udgiftskonti er blevet slettet',
    'deleted_all_revenue_accounts'              => 'Alle indtægtskonti er slettet',
    'deleted_all_liabilities'                   => 'Alle forpligtelser er blevet slettet',
    'deleted_all_transactions'                  => 'Alle transaktioner er blevet slettet',
    'deleted_all_withdrawals'                   => 'Alle udbetalinger er blevet slettet',
    'deleted_all_deposits'                      => 'Alle indskud er blevet slettet',
    'deleted_all_transfers'                     => 'Alle overførsler er blevet slettet',
    'deleted_all_recurring'                     => 'Alle periodiske transaktioner er blevet slettet',
    'change_your_password'                      => 'Skift din adgangskode',
    'delete_account'                            => 'Slet konto',
    'current_password'                          => 'Aktuel adgangskode',
    'new_password'                              => 'Nyt Password',
    'new_password_again'                        => 'Ny adgangskode (gentag)',
    'delete_your_account'                       => 'Slet din konto',
    'delete_your_account_help'                  => 'Sletning af din konto vil også slette alle konti, transaktioner, <em>alt</em> du måtte have gemt i Firefly III. Det vil være VÆK.',
    'delete_your_account_password'              => 'Indtast din adgangskode for at fortsætte.',
    'password'                                  => 'Adgangskode',
    'are_you_sure'                              => 'Er du sikker? Du kan ikke fortryde dette.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'SLET din konto',
    'invalid_current_password'                  => 'Ugyldig adgangskode!',
    'password_changed'                          => 'Adgangskoden ændret!',
    'should_change'                             => 'Idéen er at ændre din adgangskode.',
    'invalid_password'                          => 'Ugyldig adgangskode!',
    'what_is_pw_security'                       => 'Hvad er "bekræft adgangskodesikkerhed"?',
    'secure_pw_title'                           => 'Sådan vælger du en sikker adgangskode',
    'forgot_password_response'                  => 'Tak. Hvis en konto findes med denne e-mailadresse, vil du finde instruktioner i din indbakke.',
    'secure_pw_history'                         => 'Ikke en uge går, uden at du læser i nyhederne om at et websted lækker sine brugeres kodeord. Hackere og tyve bruger disse adgangskoder til at forsøge at stjæle dine private oplysninger. Den information er værdifuld.',
    'secure_pw_ff'                              => 'Bruger du den samme adgangskode over hele internettet? Hvis et websted lækker din adgangskode, har hackere adgang til alle dine data. Firefly III betror dig om at vælge en stærk og unik adgangskode til at beskytte dine regnskaber.',
    'secure_pw_check_box'                       => 'Firefly III kan kontrollere om den adgangskode du ønsker at bruge er lækket tidligere. Hvis dette er tilfældet, anbefaler Firefly III dig IKKE at anvende denne adgangskode.',
    'secure_pw_working_title'                   => 'Hvordan virker det?',
    'secure_pw_working'                         => 'Ved at afkrydse boksen, vil Firefly III sende de første fem tegn af SHA1-hashen af din adgangskode til <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">hjemmesiden for Troy Hunt</a> for at se, om det er på listen. Dette vil stoppe dig i at bruge usikre adgangskoder, som anbefales i den seneste <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> om dette emne.',
    'secure_pw_should'                          => 'Skal jeg tjekke boksen?',
    'secure_pw_long_password'                   => 'Ja. Kontroller altid, at din adgangskode er sikker.',
    'command_line_token'                        => 'Kommandolinje-token',
    'explain_command_line_token'                => 'Du har brug for dette token for at udføre kommandolinje kommandoer til eksempelvis eksport af data. Uden dene, vil denne følsomme kommandoer ikke virke. Del ikke dit kommandolinje-token. Ingen vil bede dig om dette token, ikke engang mig. Hvis du frygter, at du har mistet dette, eller hvis du er paranoid, kan du regenerere dette token ved hjælp af knappen.',
    'regenerate_command_line_token'             => 'Regenerer kommandolinje-token',
    'token_regenerated'                         => 'En ny kommandolinje-token blev genereret',
    'change_your_email'                         => 'Skift din e-mail adresse',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Indtil du bekræfter din e-mailadresse, kan du ikke logge ind.',
    'login_with_new_email'                      => 'Du kan nu logge ind med din nye e-mail-adresse.',
    'login_with_old_email'                      => 'Du kan nu logge ind med din gamle e-mail-adresse igen.',
    'login_provider_local_only'                 => 'Denne handling er ikke tilgængelig ved godkendelse via ":login_provider".',
    'external_user_mgt_disabled'                => 'Denne handling er ikke tilgængelig, når Firefly III ikke er ansvarlig for brugerhåndtering eller godkendelseshåndtering.',
    'external_auth_disabled'                    => 'Denne handling er ikke tilgængelig, når Firefly III ikke er ansvarlig for autentificering.',
    'delete_local_info_only'                    => "Da Firefly III ikke er ansvarlig for brugerhåndtering eller godkendelseshåndtering, vil denne funktion kun slette lokale Firefly III-oplysninger.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth Klienter',
    'profile_oauth_no_clients'                  => 'Du har ikke oprettet nogen OAuth klienter.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Klienter',
    'profile_oauth_client_id'                   => 'Klient ID',
    'profile_oauth_client_name'                 => 'Navn',
    'profile_oauth_client_secret'               => 'Hemmelighed',
    'profile_oauth_create_new_client'           => 'Opret ny klient',
    'profile_oauth_create_client'               => 'Opret klient',
    'profile_oauth_edit_client'                 => 'Rediger klient',
    'profile_oauth_name_help'                   => 'Noget dine brugere vil genkende og stole på.',
    'profile_oauth_redirect_url'                => 'Omdirigerings-URL',
    'profile_oauth_redirect_url_help'           => 'Din autoriserings callback URL.',
    'profile_authorized_apps'                   => 'Autoriserede programmer',
    'profile_authorized_clients'                => 'Autoriserede klienter',
    'profile_scopes'                            => 'Anvendelsesområde',
    'profile_revoke'                            => 'Tilbagekald',
    'profile_oauth_client_secret_title'         => 'Klient Hemmelighed',
    'profile_oauth_client_secret_expl'          => 'Her er din nye klient hemmelighed. Dette er den eneste tid, den vil blive vist, så mist det ikke! Du kan nu bruge denne hemmelighed til at lave API-anmodninger.',
    'profile_personal_access_tokens'            => 'Personlige Adgangstokens',
    'profile_personal_access_token'             => 'Personligt Adgangstoken',
    'profile_oauth_confidential'                => 'Fortroligt',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Her er dit nye personlige adgangstoken. Dette er den eneste gang det vil blive vist, så mist det ikke! Du kan nu bruge dette token til at foretage API-anmodninger.',
    'profile_no_personal_access_token'          => 'Du har ikke oprettet en personlig adgangstoken.',
    'profile_create_new_token'                  => 'Opret nyt token',
    'profile_create_token'                      => 'Opret token',
    'profile_create'                            => 'Opret',
    'profile_save_changes'                      => 'Gem ændringer',
    'profile_whoops'                            => 'Hovsa!',
    'profile_something_wrong'                   => 'Noget gik galt!',
    'profile_try_again'                         => 'Noget gik galt. Forsøg venligst igen.',
    'amounts'                                   => 'Beløb',
    'multi_account_warning_unknown'             => 'Afhængigt af hvilken type transaktion du opretter kan kilden og/eller destinationskontoen for efterfølgende opsplitninger tilsidesættes, uanset hvad der er defineret i den første opdeling af transaktionen.',
    'multi_account_warning_withdrawal'          => 'Husk, at kildekontoen for efterfølgende opdelinger vil blive overstyret af hvad der er defineret i den første opdeling af tilbagetrækningen.',
    'multi_account_warning_deposit'             => 'Husk, at destinationskontoen for efterfølgende opdelinger vil blive tilsidesat af hvad der er defineret i den første opsplitning af depositummet.',
    'multi_account_warning_transfer'            => 'Husk på, at kilden + destination konto for efterfølgende opdelinger vil blive overstyret af hvad der er defineret i den første opdeling af overførslen.',


    // export data:
    'export_data_title'                         => 'Eksporter data fra Firefly III',
    'export_data_menu'                          => 'Eksporter data',
    'export_data_bc'                            => 'Eksporter data fra Firefly III',
    'export_data_main_title'                    => 'Eksporter data fra Firefly III',
    'export_data_expl'                          => 'Dette link giver dig mulighed for at eksportere alle transaktioner + metadata fra Firefly III. Se hjælp (øverste højre (?)-ikon) for mere information om processen.',
    'export_data_all_transactions'              => 'Eksporter alle transaktioner',
    'export_data_advanced_expl'                 => 'Hvis du har brug for en mere avanceret eller specifik dataeksport, kan du under hjælp læse, hvordan du bruger konsolkommandoen <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Én vedhæftet fil|:count vedhæftede filer',
    'attachments'                               => 'Vedhæftninger',
    'edit_attachment'                           => 'Rediger vedhæftet fil ":name"',
    'update_attachment'                         => 'Opdater vedhæftning',
    'delete_attachment'                         => 'Slet vedhæftet fil ":name"',
    'attachment_deleted'                        => 'Slettede vedhæftning ":name"',
    'liabilities_deleted'                       => 'Slettet gæld ":name"',
    'attachment_updated'                        => 'Opdateret vedhæftning ":name"',
    'upload_max_file_size'                      => 'Maksimal filstørrelse: :size',
    'list_all_attachments'                      => 'Liste over alle vedhæftede filer',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Udgifter',
    'title_withdrawal'                          => 'Udgifter',
    'title_revenue'                             => 'Indtægter / indkomst',
    'title_deposit'                             => 'Indtægter / indkomster',
    'title_transfer'                            => 'Overførsler',
    'title_transfers'                           => 'Overførsler',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Denne transaktion er allerede en udbetaling',
    'convert_is_already_type_Deposit'           => 'Denne transaktion er allerede en indbetaling',
    'convert_is_already_type_Transfer'          => 'Denne transaktion er allerede en overførsel',
    'convert_to_Withdrawal'                     => 'Konverter ":description" til en udbetaling',
    'convert_to_Deposit'                        => 'Konverter ":description" til en indbetaling',
    'convert_to_Transfer'                       => 'Konverter ":description" til en overførsel',
    'convert_options_WithdrawalDeposit'         => 'Konverter en udbetaling til en indbetaling',
    'convert_options_WithdrawalTransfer'        => 'Konverter en udbetaling til en overførsel',
    'convert_options_DepositTransfer'           => 'Konverter et indbetaling til en overførsel',
    'convert_options_DepositWithdrawal'         => 'Konverter et indbetaling til en udbetaling',
    'convert_options_TransferWithdrawal'        => 'Konverter en overførsel til en hævning',
    'convert_options_TransferDeposit'           => 'Konverter en overførsel til en indbetaling',
    'convert_Withdrawal_to_deposit'             => 'Konverter denne hævning til en indbetaling',
    'convert_Withdrawal_to_transfer'            => 'Konverter denne udbetaling til en overførsel',
    'convert_Deposit_to_withdrawal'             => 'Konverter dette indskud til en udbetaling',
    'convert_Deposit_to_transfer'               => 'Konverter dette indskud til en overførsel',
    'convert_Transfer_to_deposit'               => 'Konverter denne overførsel til en indbetaling',
    'convert_Transfer_to_withdrawal'            => 'Konverter denne overførsel til en udbetaling',
    'convert_please_set_revenue_source'         => 'Vælg venligst den indtægtskonto, hvor pengene kommer fra.',
    'convert_please_set_asset_destination'      => 'Vælg venligst den aktivkonto, hvor pengene skal overføres til.',
    'convert_please_set_expense_destination'    => 'Vælg venligst den udgiftskonto, hvor pengene skal flyttes til.',
    'convert_please_set_asset_source'           => 'Vælg venligst aktivkontoen, hvor pengene kommer fra.',
    'convert_expl_w_d'                          => 'Ved konvertering fra en udbetaling til et indskud, vil pengene blive deponeret på den viste destinationskonto, i stedet for at blive trukket tilbage fra den. Ved konvertering fra en udbetaling til et indskud, vil pengene blive deponeret på de viste destinationskonti i stedet for at blive trukket tilbage fra dem.',
    'convert_expl_w_t'                          => 'Ved omregning af en udbetaling til en overførsel pengene vil blive overført væk fra kildekontoen til andre aktiver eller passiver i stedet for at blive brugt på den oprindelige omkostningskonto. Ved omregning af en udbetaling til en overførsel pengene vil blive overført væk fra kildekonti til andre aktiv- eller passivkonti i stedet for at blive brugt på de oprindelige omkostningskonti.',
    'convert_expl_d_w'                          => 'Ved konvertering af en indbetaling til en udbetaling, vil pengene blive trukket tilbage fra den viste kilde konto, i stedet for at blive deponeret i den. Ved konvertering af et depositum til en udbetaling, vil pengene blive trukket tilbage fra de viste kildekonti i stedet for at blive deponeret i dem.',
    'convert_expl_d_t'                          => 'Når du konverterer en indbetaling til en overførsel, pengene vil blive deponeret på den anførte destinationskonto fra en af dine aktiver eller passiver konto. Når du konverterer en indbetaling til en overførsel, pengene vil blive deponeret på de anførte destinationskonti fra et af dine aktiver eller passivkonti.',
    'convert_expl_t_w'                          => 'Når du konverterer en overførsel til en udbetaling, vil pengene blive brugt på den destinationskonto, du angiver her, i stedet for at blive overført væk. Når du konverterer en overførsel til en udbetaling, vil pengene blive brugt på de destinationskonti, du angiver her, i stedet for at blive overført væk.',
    'convert_expl_t_d'                          => 'Når du konverterer en overførsel til et indskud, pengene vil blive deponeret på den destinationskonto, du ser her, i stedet for at blive overført til den. Når du konverterer en overførsel til et indskud, pengene vil blive deponeret på de destinationskonti, du ser her, i stedet for at blive overført til dem.',
    'convert_select_sources'                    => 'For at fuldføre konverteringen, skal du indstille den nye kilde konto nedenfor.● For at fuldføre konverteringen, skal du indstille den nye kilde konti nedenfor.',
    'convert_select_destinations'               => 'For at fuldføre konverteringen, skal du vælge den nye destination konto nedenfor.● For at fuldføre konverteringen, skal du vælge den nye destination konti nedenfor.',
    'converted_to_Withdrawal'                   => 'Transaktionen er blevet konverteret til en udbetaling',
    'converted_to_Deposit'                      => 'Transaktionen er blevet konverteret til et indskud',
    'converted_to_Transfer'                     => 'Transaktionen er blevet konverteret til en overførsel',
    'invalid_convert_selection'                 => 'Den valgte konto er allerede brugt i denne transaktion eller eksisterer ikke.',
    'source_or_dest_invalid'                    => 'Kan ikke finde de korrekte transaktionsdetaljer. Konvertering er ikke muligt.',
    'convert_to_withdrawal'                     => 'Konverter til en udbetaling',
    'convert_to_deposit'                        => 'Konverter til en indbetaling',
    'convert_to_transfer'                       => 'Konvertér til en overførsel',

    // create new stuff:
    'create_new_withdrawal'                     => 'Opret ny udbetaling',
    'create_new_deposit'                        => 'Opret ny indbetaling',
    'create_new_transfer'                       => 'Opret ny overførsel',
    'create_new_asset'                          => 'Opret ny aktivkonto',
    'create_new_liabilities'                    => 'Opret ny passiv',
    'create_new_expense'                        => 'Opret ny omkostningskonto',
    'create_new_revenue'                        => 'Opret ny indtægtskonto',
    'create_new_piggy_bank'                     => 'Opret ny sparegris',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Opret en ny valuta',
    'store_currency'                            => 'Gem ny valuta',
    'update_currency'                           => 'Opdater valuta',
    'new_default_currency'                      => '":name" er nu standard valuta.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Kan ikke slette :name , fordi den stadig er i brug.',
    'cannot_delete_fallback_currency'           => ':name er systemet fallback valuta og kan ikke slettes.',
    'cannot_disable_currency_journals'          => 'Kan ikke deaktivere :name , da transaktionerne stadig bruger den.',
    'cannot_disable_currency_last_left'         => 'Kan ikke deaktivere :name , fordi det er den sidste aktiverede valuta.',
    'cannot_disable_currency_account_meta'      => 'Kan ikke deaktivere :name , fordi den bruges på aktivkonti.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Kan ikke deaktivere :name fordi det bruges i tilbagevendende transaktioner.',
    'cannot_disable_currency_available_budgets' => 'Kan ikke deaktivere :name fordi det bruges i tilgængelige budgetter.',
    'cannot_disable_currency_budget_limits'     => 'Kan ikke deaktivere :name fordi det bruges i budgetgrænser.',
    'cannot_disable_currency_current_default'   => 'Kan ikke deaktivere :name fordi det er systemets standardvaluta.',
    'cannot_disable_currency_system_fallback'   => 'Kan ikke deaktivere :name fordi det er systemets standardvaluta.',
    'disable_EUR_side_effects'                  => 'Euroen er systemets nødnødvaluta. Deaktivering af systemet kan have utilsigtede bivirkninger og kan annullere din garanti.',
    'deleted_currency'                          => 'Valuta :name slettet',
    'created_currency'                          => 'Valuta :name oprettet',
    'could_not_store_currency'                  => 'Kunne ikke gemme den nye valuta.',
    'updated_currency'                          => 'Valuta :name opdateret',
    'ask_site_owner'                            => 'Bed venligst :owner om at tilføje, fjerne eller redigere valutaer.',
    'currencies_intro'                          => 'Firefly III understøtter forskellige valutaer, som du kan indstille og aktivere her.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Gør til standard',
    'default_currency'                          => 'standard',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Deaktiveret',
    'enable_currency'                           => 'Aktiver',
    'disable_currency'                          => 'Deaktivér',
    'currencies_default_disabled'               => 'De fleste af disse valutaer er som standard deaktiveret. For at bruge dem, skal du først aktivere dem.',
    'currency_is_now_enabled'                   => 'Valuta ":name" er blevet aktiveret',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Valuta ":name" er blevet deaktiveret',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Obligatoriske felter',
    'optionalFields'                            => 'Valgfrie felter',
    'options'                                   => 'Indstillinger',

    // budgets:
    'daily_budgets'                             => 'Daglige budgetter',
    'weekly_budgets'                            => 'Ugentlige budgetter',
    'monthly_budgets'                           => 'Månedlige budgetter',
    'quarterly_budgets'                         => 'Kvartalsvise budgetter',
    'half_year_budgets'                         => 'Halvårlige budgetter',
    'yearly_budgets'                            => 'Årlige budgetter',
    'other_budgets'                             => 'Brugerdefinerede tidsbegrænsede budgetter',
    'budget_limit_not_in_range'                 => 'Dette beløb gælder fra :start til :end:',
    'total_available_budget'                    => 'Samlet disponibelt budget (mellem :start og :end)',
    'total_available_budget_in_currency'        => 'Samlet disponibelt budget i :currency',
    'see_below'                                 => 'se nedenfor',
    'create_new_budget'                         => 'Opret et nyt budget',
    'store_new_budget'                          => 'Gem nyt budget',
    'stored_new_budget'                         => 'Gemt nyt budget ":name"',
    'available_between'                         => 'Tilgængelig mellem :start og :end',
    'transactionsWithoutBudget'                 => 'Udgifter uden budget',
    'transactions_no_budget'                    => 'Udgifter uden budget mellem :start og :end',
    'spent_between'                             => 'Allerede brugt mellem :start og :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Angiv disponibelt beløb',
    'update_available_amount'                   => 'Opdater disponibelt beløb',
    'ab_basic_modal_explain'                    => 'Brug denne formular til at angive, hvor meget du forventer at kunne budgettere (i alt, i :currency) i den angivne periode.',
    'createBudget'                              => 'Nyt budget',
    'invalid_currency'                          => 'Dette er en ugyldig valuta',
    'invalid_amount'                            => 'Indtast et beløb',
    'set_ab'                                    => 'Det disponible budgetbeløb er fastsat',
    'updated_ab'                                => 'Det disponible budgetbeløb er blevet opdateret',
    'deleted_ab'                                => 'Det disponible budgetbeløb er blevet slettet',
    'deleted_bl'                                => 'Det budgetterede beløb er blevet fjernet',
    'alt_currency_ab_create'                    => 'Sæt det tilgængelige budget i en anden valuta',
    'bl_create_btn'                             => 'Sæt budget i en anden valuta',
    'inactiveBudgets'                           => 'Inaktive budgetter',
    'without_budget_between'                    => 'Transaktioner uden et budget mellem :start og :end',
    'delete_budget'                             => 'Slet budget ":name"',
    'deleted_budget'                            => 'Slettet budget ":name"',
    'edit_budget'                               => 'Rediger budget ":name"',
    'updated_budget'                            => 'Opdateret budget ":name"',
    'update_amount'                             => 'Opdater beløb',
    'update_budget'                             => 'Opdater budget',
    'update_budget_amount_range'                => 'Opdatering (forventet) disponibelt beløb mellem :start og :end',
    'set_budget_limit_title'                    => 'Sæt budgetteret beløb for budget :budget mellem :start og :end',
    'set_budget_limit'                          => 'Sæt budgetteret beløb',
    'budget_period_navigator'                   => 'Periode navigator',
    'info_on_available_amount'                  => 'Hvad har jeg til rådighed?',
    'available_amount_indication'               => 'Brug disse beløb til at få en angivelse af, hvad dit samlede budget kan være.',
    'suggested'                                 => 'Foreslået',
    'average_between'                           => 'Gennemsnit mellem :start og :end',
    'transferred_in'                            => 'Overført (ind)',
    'transferred_away'                          => 'Overført (ud)',
    'auto_budget_none'                          => 'Ingen auto-budget',
    'auto_budget_reset'                         => 'Angiv et fast beløb for hver periode',
    'auto_budget_rollover'                      => 'Tilføj et beløb hver periode',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Daglig',
    'auto_budget_period_weekly'                 => 'Ugentlig',
    'auto_budget_period_monthly'                => 'Månedlig',
    'auto_budget_period_quarterly'              => 'Kvartalsvis',
    'auto_budget_period_half_year'              => 'Hvert halve år',
    'auto_budget_period_yearly'                 => 'Årlig',
    'auto_budget_help'                          => 'Du kan læse mere om denne funktion i hjælpen. Klik på ikonet øverst til højre (?)',
    'auto_budget_reset_icon'                    => 'Dette budget vil blive fastsat periodisk',
    'auto_budget_rollover_icon'                 => 'Budgettet vil stige med jævne mellemrum',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Fjern budgetteret beløb i :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Ikke forventet denne periode',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Ikke (endnu)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Gentagelser',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Tilsluttede transaktioner',
    'auto_match_on'                             => 'Automatisk matchet af Firefly III',
    'auto_match_off'                            => 'Ikke automatisk matchet af Firefly III',
    'next_expected_match'                       => 'Næste forventede match',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mere',
    'rescan_old'                                => 'Kør regler igen, på alle transaktioner',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Forventet mellem :start og :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'springer over',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inaktiv regel',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Forventede :date',
    'bill_expected_date_js'                     => 'Forventede {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Betalt {date}',
    'bill_repeats_weekly'                       => 'Gentages ugentligt',
    'bill_repeats_monthly'                      => 'Gentages månedligt',
    'bill_repeats_quarterly'                    => 'Gentages kvartalsvis',
    'bill_repeats_half-year'                    => 'Gentages hvert halve år',
    'bill_repeats_yearly'                       => 'Gentages årligt',
    'bill_repeats_weekly_other'                 => 'Gentages hver anden uge',
    'bill_repeats_monthly_other'                => 'Gentages hver anden måned',
    'bill_repeats_quarterly_other'              => 'Gentages hvert andet kvartal',
    'bill_repeats_half-year_other'              => 'Gentages årligt',
    'bill_repeats_yearly_other'                 => 'Gentages hvert andet år',
    'bill_repeats_weekly_skip'                  => 'Gentages hver {skip} uge',
    'bill_repeats_monthly_skip'                 => 'Gentages hver {skip} måned',
    'bill_repeats_quarterly_skip'               => 'Gentages hver {skip} kvartal',
    'bill_repeats_half-year_skip'               => 'Gentages hvert {skip} halve år',
    'bill_repeats_yearly_skip'                  => 'Gentages hvert {skip} år',
    'subscriptions'                             => 'Abonnementer',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'For evigt',
    'extension_date_is'                         => 'Udvidelsesdato er {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Du har :count inaktive (arkiveret) konto, som du kan se på denne separate side.|Du har :count inaktive (arkiveret) konti, som du kan se på denne separate side.',
    'all_accounts_inactive'                     => 'Dette er dine inaktive konti.',
    'active_account_link'                       => 'Dette link går tilbage til dine aktive konti.',
    'account_missing_transaction'               => 'Konto #:id (":name") kan ikke ses direkte, men Firefly mangler omdirigeringsoplysninger.',
    'cc_monthly_payment_date_help'              => 'Vælg et hvilket som helst år og en hvilken som helst måned, det vil blive ignoreret alligevel. Kun dagen i måneden er relevant.',
    'details_for_asset'                         => 'Detaljer for aktivkonto ":name"',
    'details_for_expense'                       => 'Detaljer for udgiftskonto":name"',
    'details_for_revenue'                       => 'Detaljer for indtægtskonto":name"',
    'details_for_cash'                          => 'Detaljer for kontantkonto ":name"',
    'store_new_asset_account'                   => 'Gem ny aktivkonto',
    'store_new_expense_account'                 => 'Gem ny omkostningskonto',
    'store_new_revenue_account'                 => 'Gem ny indtægtskonto',
    'edit_asset_account'                        => 'Rediger aktiv konto ":name"',
    'edit_expense_account'                      => 'Rediger omkostningskonto ":name"',
    'edit_revenue_account'                      => 'Rediger indtægtskonto ":name"',
    'delete_asset_account'                      => 'Slet aktiv konto ":name"',
    'delete_expense_account'                    => 'Slet omkostningskonto ":name"',
    'delete_revenue_account'                    => 'Slet indtægtskonto ":name"',
    'delete_liabilities_account'                => 'Slet passiv ":name"',
    'asset_deleted'                             => 'Kontoen ":name" blev slettet',
    'account_deleted'                           => 'Kontoen ":name" blev slettet',
    'expense_deleted'                           => 'Udgiftskontoen ":name" blev slettet',
    'revenue_deleted'                           => 'Indtægtskontoen ":name" blev slettet',
    'update_asset_account'                      => 'Opdater konto',
    'update_undefined_account'                  => 'Opdater konto',
    'update_liabilities_account'                => 'Opdater ansvarskonto',
    'update_expense_account'                    => 'Opdater udgiftskonto',
    'update_revenue_account'                    => 'Opdater indtægtskonto',
    'make_new_asset_account'                    => 'Opret ny konto',
    'make_new_expense_account'                  => 'Opret ny udgiftskonto',
    'make_new_revenue_account'                  => 'Opret ny indtægtskonto',
    'make_new_liabilities_account'              => 'Opret en ny ansvarskonto',
    'asset_accounts'                            => 'Aktivkonti',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Aktivkonti (inaktiv)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Udgiftskonti',
    'expense_accounts_inactive'                 => 'Udgiftskonti (inaktiv)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Indtægtskonti',
    'revenue_accounts_inactive'                 => 'Indtægtskonti (inaktive)',
    'cash_accounts'                             => 'Kontant konti',
    'Cash account'                              => 'Kontant konto',
    'liabilities_accounts'                      => 'Gæld',
    'liabilities_accounts_inactive'             => 'Gæld (inaktiv)',
    'reconcile_account'                         => 'Afstem konto ":account"',
    'overview_of_reconcile_modal'               => 'Overblik af afstemning',
    'delete_reconciliation'                     => 'Slet afstemning',
    'update_reconciliation'                     => 'Opdater afstemning',
    'amount_cannot_be_zero'                     => 'Beløbet kan ikke være 0',
    'end_of_reconcile_period'                   => 'Slut på afstemningsperiode: :period',
    'start_of_reconcile_period'                 => 'Start på afstemningsperiode: :period',
    'start_balance'                             => 'Start saldo',
    'end_balance'                               => 'Slut saldo',
    'update_balance_dates_instruction'          => 'Afpas beløber og datoer herover med dit kontoudtog og tryk på "Start afstemning"',
    'select_transactions_instruction'           => 'Vælg de transaktioner, der vises på dit kontoudtog.',
    'select_range_and_balance'                  => 'Kontroller først datointerval og beløb. Tryk derefter på "Start afstemning"',
    'date_change_instruction'                   => 'Hvis du ændrer datointervallet nu, vil nuværende fremskridt gå tabt.',
    'update_selection'                          => 'Opdater valgte',
    'store_reconcile'                           => 'Gem afstemning',
    'reconciliation_transaction'                => 'Afstem transaktion',
    'Reconciliation'                            => 'Afstemning',
    'reconciliation'                            => 'Afstemning',
    'reconcile_options'                         => 'Indstillinger for afstemning',
    'reconcile_range'                           => 'Afstemningsinterval',
    'start_reconcile'                           => 'Start afstemning',
    'cash_account_type'                         => 'Kontant',
    'cash'                                      => 'kontant',
    'cant_find_redirect_account'                => 'Firefly III tried to redirect you but couldn\'t. Sorry about that. Back to the index.',
    'account_type'                              => 'Account type',
    'save_transactions_by_moving'               => 'Save this transaction by moving it to another account:|Save these transactions by moving them to another account:',
    'save_transactions_by_moving_js'            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                        => 'New account ":name" stored!',
    'stored_new_account_js'                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                           => 'Opdateret konto ":name"',
    'updated_account_js'                        => 'Opdateret konto "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Credit card options',
    'no_transactions_account'                   => 'There are no transactions (in this period) for asset account ":name".',
    'no_transactions_period'                    => 'Der er ingen transaktioner (i denne periode).',
    'no_data_for_chart'                         => 'Der er ikke nok information (endnu) til at generere dette diagram.',
    'select_at_least_one_account'               => 'Please select at least one asset account',
    'select_at_least_one_category'              => 'Vælg venligst mindst én kategori',
    'select_at_least_one_budget'                => 'Vælg venligst mindst et budget',
    'select_at_least_one_tag'                   => 'Vælg venligst mindst et tag',
    'select_at_least_one_expense'               => 'Vælg venligst mindst én kombination af udgifter/indtægtskonti. Hvis du ikke har nogen (listen er tom) er denne rapport ikke tilgængelig.',
    'account_default_currency'                  => 'Dette vil være den standard valuta, der er tilknyttet denne konto.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Din Firefly III hovedbog holder flere penge end din bank angiver du bør have. Der er flere muligheder. Vælg venligst hvad der skal gøres. Tryk derefter på "Bekræft afstemning".',
    'reconcile_has_less'                        => 'Din Firefly III hovedbog holder færre penge end din bank angiver du bør have. Der er flere muligheder. Vælg venligst hvad der skal gøres. Tryk derefter på "Bekræft afstemning".',
    'reconcile_is_equal'                        => 'Din firefly III hovedbog og dine kontoudtog stemmer. Der er intet at gøre. Tryk på "Bekræft afstemning" for at bekræfte dit input.',
    'create_pos_reconcile_transaction'          => 'Ryd de valgte transaktioner, og opret en korrektion, der tilføjer :amount til denne aktivkonto.',
    'create_neg_reconcile_transaction'          => 'Ryd de valgte transaktioner, og opret en korrektion, der fjerner :amount fra denne aktivkonto.',
    'reconcile_do_nothing'                      => 'Ryd de valgte transaktioner, uden at korrigere.',
    'reconcile_go_back'                         => 'Du kan altid redigere eller slette en korrektion senere.',
    'must_be_asset_account'                     => 'Du kan kun afstemme aktivkonti',
    'reconciliation_stored'                     => 'Afstemning gemt',
    'reconciliation_error'                      => 'På grund af en fejl blev transaktionerne markeret som afstemt, men korrektionen blev ikke gemt: :error.',
    'reconciliation_transaction_title'          => 'Afstemning (:from til :to)',
    'sum_of_reconciliation'                     => 'Sum af korrektionen',
    'reconcile_this_account'                    => 'Afstem denne konto',
    'reconcile'                                 => 'Afstem',
    'show'                                      => 'Vis',
    'confirm_reconciliation'                    => 'Bekræft afstemning',
    'submitted_start_balance'                   => 'Indsendt start saldo',
    'selected_transactions'                     => 'Valgte transaktioner (:count)',
    'already_cleared_transactions'              => 'Already cleared transactions (:count)',
    'submitted_end_balance'                     => 'Indsendt slut saldo',
    'initial_balance_description'               => 'Start saldo for ":account"',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'ukendt',
    'interest_calc_daily'                       => 'Pr. dag',
    'interest_calc_monthly'                     => 'Pr. måned',
    'interest_calc_yearly'                      => 'Pr. år',
    'interest_calc_weekly'                      => 'Pr. uge',
    'interest_calc_half-year'                   => 'Hvert halve år',
    'interest_calc_quarterly'                   => 'Pr. kvartal',
    'initial_balance_account'                   => 'Start saldo for :account',
    'list_options'                              => 'Vis valgmuligheder',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Ny kategori',
    'create_new_category'                       => 'Opret ny kategori',
    'without_category'                          => 'Uden en kategori',
    'update_category'                           => 'Opdater kategori',
    'updated_category'                          => 'Kategori ":name" er blevet opdateret',
    'categories'                                => 'Kategorier',
    'edit_category'                             => 'Rediger kategori ":name"',
    'no_category'                               => '(ingen kategori)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategori',
    'delete_category'                           => 'Slet kategori ":name"',
    'deleted_category'                          => 'Kategori ":name" er blevet slettet',
    'store_category'                            => 'Gem ny kategori',
    'stored_category'                           => 'Stored new category ":name"',
    'without_category_between'                  => 'Without category between :start and :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Opdater udbetaling',
    'update_deposit'                            => 'Opdater indbetaling',
    'update_transaction'                        => 'Opdater transaktion',
    'update_transfer'                           => 'Opdater overførsel',
    'updated_withdrawal'                        => 'Opdateret udbetaling ":description"',
    'updated_deposit'                           => 'Opdateret indbetaling ":description"',
    'updated_transfer'                          => 'Opdateret overførsel ":description"',
    'no_changes_withdrawal'                     => 'Udbetalingen ":description" blev ikke ændret.',
    'no_changes_deposit'                        => 'Indbetalingen ":description" blev ikke ændret.',
    'no_changes_transfer'                       => 'Overførslen ":description" blev ikke ændret.',
    'delete_withdrawal'                         => 'Slet udbetalingen ":description"',
    'delete_deposit'                            => 'Slet indbetalingen ":description"',
    'delete_transfer'                           => 'Slet overførslen ":description"',
    'deleted_withdrawal'                        => 'Successfully deleted withdrawal ":description"',
    'deleted_deposit'                           => 'Successfully deleted deposit ":description"',
    'deleted_transfer'                          => 'Successfully deleted transfer ":description"',
    'deleted_reconciliation'                    => 'Successfully deleted reconciliation transaction ":description"',
    'stored_journal'                            => 'Successfully created new transaction ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Successfully created your new transaction',
    'updated_journal_no_descr'                  => 'Successfully updated your transaction',
    'select_transactions'                       => 'Select transactions',
    'rule_group_select_transactions'            => 'Apply ":title" to transactions',
    'rule_select_transactions'                  => 'Apply ":title" to transactions',
    'stop_selection'                            => 'Stop selecting transactions',
    'reconcile_selected'                        => 'Reconcile',
    'mass_delete_journals'                      => 'Delete a number of transactions',
    'mass_edit_journals'                        => 'Edit a number of transactions',
    'mass_bulk_journals'                        => 'Bulk edit a number of transactions',
    'mass_bulk_journals_explain'                => 'This form allows you to change properties of the transactions listed below in one sweeping update. All the transactions in the table will be updated when you change the parameters you see here.',
    'part_of_split'                             => 'This transaction is part of a split transaction. If you have not selected all the splits, you may end up with changing only half the transaction.',
    'bulk_set_new_values'                       => 'Use the inputs below to set new values. If you leave them empty, they will be made empty for all. Also, note that only withdrawals will be given a budget.',
    'no_bulk_category'                          => 'Don\'t update category',
    'no_bulk_budget'                            => 'Don\'t update budget',
    'no_bulk_tags'                              => 'Don\'t update tag(s)',
    'replace_with_these_tags'                   => 'Replace with these tags',
    'append_these_tags'                         => 'Add these tags',
    'mass_edit'                                 => 'Edit selected individually',
    'bulk_edit'                                 => 'Edit selected in bulk',
    'mass_delete'                               => 'Delete selected',
    'cannot_edit_other_fields'                  => 'You cannot mass-edit other fields than the ones here, because there is no room to show them. Please follow the link and edit them by one-by-one, if you need to edit these fields.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(no budget)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Konto pr. budget',
    'account_per_category'                      => 'Konto pr. kategori',
    'create_new_object'                         => 'Opret',
    'empty'                                     => '(tom)',
    'all_other_budgets'                         => '(alle andre budgetter)',
    'all_other_accounts'                        => '(alle andre konti)',
    'expense_per_source_account'                => 'Udgifter pr. kildekonto',
    'expense_per_destination_account'           => 'Udgifter pr. destination konto',
    'income_per_destination_account'            => 'Income per destination account',
    'spent_in_specific_category'                => 'Spent in category ":category"',
    'earned_in_specific_category'               => 'Earned in category ":category"',
    'spent_in_specific_tag'                     => 'Spent in tag ":tag"',
    'earned_in_specific_tag'                    => 'Earned in tag ":tag"',
    'income_per_source_account'                 => 'Income per source account',
    'average_spending_per_destination'          => 'Average expense per destination account',
    'average_spending_per_source'               => 'Gennemsnitlig udgift pr. kildekonto',
    'average_earning_per_source'                => 'Gennemsnitlig indtjening pr. kildekonto',
    'average_earning_per_destination'           => 'Gennemsnitlig indtjening pr. destinationskonto',
    'account_per_tag'                           => 'Konto pr. tag',
    'tag_report_expenses_listed_once'           => 'Udgifter og indtægter bliver aldrig vist flere gange. Hvis en transaktion har flere tags, bliver den kun vist under et af sine tags. Det ligner måske at denne liste mangler data, men beløbene vil være korrekte.',
    'double_report_expenses_charted_once'       => 'Udgifter og indtægter bliver aldrig vist flere gange. Hvis en transaktion har flere tags, bliver den kun vist under et af sine tags. Det ligner måske at denne graf mangler data, men beløbene vil være korrekte.',
    'tag_report_chart_single_tag'               => 'Denne graf viser ét enkelt tag. Hvis en transaktion har flere tags, vil hvad der bliver vist her måske også fremgå af andre grafer.',
    'tag'                                       => 'Tag',
    'no_budget_squared'                         => '(intet budget)',
    'perm-delete-many'                          => 'Deleting many items in one go can be very disruptive. Please be cautious. You can delete part of a split transaction from this page, so take care.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(ingen kontotype)',
    'opt_group_no_account_type'                 => '(ingen kontotype)',
    'opt_group_defaultAsset'                    => 'Default asset accounts',
    'opt_group_savingAsset'                     => 'Savings accounts',
    'opt_group_sharedAsset'                     => 'Shared asset accounts',
    'opt_group_ccAsset'                         => 'Credit cards',
    'opt_group_cashWalletAsset'                 => 'Cash wallets',
    'opt_group_expense_account'                 => 'Udgiftskonti',
    'opt_group_revenue_account'                 => 'Indtægtskonti',
    'opt_group_l_Loan'                          => 'Ansvar: Lån',
    'opt_group_cash_account'                    => 'Kontant konto',
    'opt_group_l_Debt'                          => 'Ansvar: Gæld',
    'opt_group_l_Mortgage'                      => 'Ansvar: Pant',
    'opt_group_l_Credit card'                   => 'Ansvar: Kreditkort',
    'notes'                                     => 'Noter',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Kunne ikke gemme transaktionen. Kontroller logfilerne.',
    'attachment_not_found'                      => 'Denne vedhæftning kunne ikke findes.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaction #{ID} ("{title}")</a> has been stored.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaction #{ID}</a> has been stored.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                   => 'Welcome to Firefly III!',
    'submit'                                    => 'Submit',
    'submission'                                => 'Submission',
    'submit_yes_really'                         => 'Submit (I know what I\'m doing)',
    'getting_started'                           => 'Kom godt i gang',
    'to_get_started'                            => 'It is good to see you have successfully installed Firefly III. To get started with this tool please enter your bank\'s name and the balance of your main checking account. Do not worry yet if you have multiple accounts. You can add those later. It\'s just that Firefly III needs something to start with.',
    'savings_balance_text'                      => 'Firefly III will automatically create a savings account for you. By default, there will be no money in your savings account, but if you tell Firefly III the balance it will be stored as such.',
    'finish_up_new_user'                        => 'That\'s it! You can continue by pressing <strong>Submit</strong>. You will be taken to the index of Firefly III.',
    'stored_new_accounts_new_user'              => 'Jubii, Dine nye konti er blevet gemt.',
    'set_preferred_language'                    => 'If you prefer to use Firefly III in another language, please indicate so here.',
    'language'                                  => 'Sprog',
    'new_savings_account'                       => ':bank_name opsparingskonto',
    'cash_wallet'                               => 'Kontant tegnebog',
    'currency_not_present'                      => 'If the currency you normally use is not listed do not worry. You can create your own currencies under Options > Currencies.',

    // home page:
    'transaction_table_description'             => 'En tabel med dine transaktioner',
    'opposing_account'                          => 'Modsvarende konto',
    'yourAccounts'                              => 'Dine konti',
    'your_accounts'                             => 'Din kontooversigt',
    'category_overview'                         => 'Kategorioversigt',
    'expense_overview'                          => 'Expense account overview',
    'revenue_overview'                          => 'Revenue account overview',
    'budgetsAndSpending'                        => 'Budgets and spending',
    'budgets_and_spending'                      => 'Budgetter og udgifter',
    'go_to_budget'                              => 'Go to budget "{budget}"',
    'go_to_deposits'                            => 'Go to deposits',
    'go_to_expenses'                            => 'Go to expenses',
    'savings'                                   => 'Savings',
    'newWithdrawal'                             => 'New expense',
    'newDeposit'                                => 'New deposit',
    'newTransfer'                               => 'New transfer',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Per day',
    'left_to_spend_per_day'                     => 'Left to spend per day',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Custom period',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Select a period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Preferences',
    'logout'                                    => 'Logout',
    'logout_other_sessions'                     => 'Logout all other sessions',
    'toggleNavigation'                          => 'Toggle navigation',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Search...',
    'version'                                   => 'Version',
    'dashboard'                                 => 'Dashboard',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Available budget ({currency})',
    'currencies'                                => 'Currencies',
    'activity'                                  => 'Aktivitet',
    'usage'                                     => 'Anvendelse',
    'accounts'                                  => 'Konti',
    'Asset account'                             => 'Asset account',
    'Default account'                           => 'Asset account',
    'Expense account'                           => 'Udgiftskonto',
    'Revenue account'                           => 'Indtægtskonto',
    'Initial balance account'                   => 'Initial balance account',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Gæld',
    'account_type_Loan'                         => 'Lån',
    'account_type_Mortgage'                     => 'Pant',
    'account_type_debt'                         => 'Gæld',
    'account_type_loan'                         => 'Lån',
    'account_type_mortgage'                     => 'Pant',
    'account_type_Credit card'                  => 'Kreditkort',
    'credit_card_type_monthlyFull'              => 'Fuld betaling hver måned',
    'liability_direction_credit'                => 'Jeg skylder denne gæld',
    'liability_direction_debit'                 => 'Jeg skylder denne gæld til en anden',
    'liability_direction_credit_short'          => 'Ejer denne gæld',
    'liability_direction_debit_short'           => 'Ejer denne gæld',
    'liability_direction__short'                => 'Ukendt',
    'liability_direction_null_short'            => 'Ukendt',
    'Liability credit'                          => 'Passiv kredit',
    'budgets'                                   => 'Budgetter',
    'tags'                                      => 'Etiketter',
    'reports'                                   => 'Rapporter',
    'transactions'                              => 'Transaktioner',
    'expenses'                                  => 'Udgifter',
    'income'                                    => 'Indtægter / indkomst',
    'transfers'                                 => 'Overførsler',
    'moneyManagement'                           => 'Pengestyring',
    'money_management'                          => 'Pengestyring',
    'tools'                                     => 'Værktøjer',
    'piggyBanks'                                => 'Sparebøsser',
    'piggy_banks'                               => 'Sparebøsser',
    'amount_x_of_y'                             => '{current} af {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Hævet',
    'opening_balance'                           => 'Startsaldo',
    'deposit'                                   => 'Indbetaling',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Overførsel',
    'Withdrawal'                                => 'Hævet',
    'Deposit'                                   => 'Indbetaling',
    'Transfer'                                  => 'Overførsel',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nej',
    'amount'                                    => 'Beløb',
    'overview'                                  => 'Oversigt',
    'saveOnAccount'                             => 'Gem på konto',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Ukendt',
    'monthly'                                   => 'Monthly',
    'profile'                                   => 'Profile',
    'errors'                                    => 'Errors',
    'debt_start_date'                           => 'Start date of debt',
    'debt_start_amount'                         => 'Start amount of debt',
    'debt_start_amount_help'                    => 'It\'s always best to set this value to a negative amount. Read the help pages (top right (?)-icon) for more information.',
    'interest_period_help'                      => 'This field is purely cosmetic and won\'t be calculated for you. As it turns out banks are very sneaky so Firefly III never gets it right.',
    'store_new_liabilities_account'             => 'Store new liability',
    'edit_liabilities_account'                  => 'Edit liability ":name"',
    'financial_control'                         => 'Financial control',
    'accounting'                                => 'Accounting',
    'automation'                                => 'Automation',
    'others'                                    => 'Others',
    'classification'                            => 'Classification',
    'store_transaction'                         => 'Store transaction',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Default financial report between :start and :end',
    'report_audit'                              => 'Transaction history overview between :start and :end',
    'report_category'                           => 'Category report between :start and :end',
    'report_double'                             => 'Expense/revenue account report between :start and :end',
    'report_budget'                             => 'Budget report between :start and :end',
    'report_tag'                                => 'Tag report between :start and :end',
    'quick_link_reports'                        => 'Quick links',
    'quick_link_examples'                       => 'These are just some example links to get you started. Check out the help pages under the (?)-button for information on all reports and the magic words you can use.',
    'quick_link_default_report'                 => 'Default financial report',
    'quick_link_audit_report'                   => 'Transaction history overview',
    'report_this_month_quick'                   => 'Current month, all accounts',
    'report_last_month_quick'                   => 'Last month, all accounts',
    'report_this_year_quick'                    => 'Current year, all accounts',
    'report_this_fiscal_year_quick'             => 'Current fiscal year, all accounts',
    'report_all_time_quick'                     => 'All-time, all accounts',
    'reports_can_bookmark'                      => 'Remember that reports can be bookmarked.',
    'incomeVsExpenses'                          => 'Income vs. expenses',
    'accountBalances'                           => 'Account balances',
    'balanceStart'                              => 'Balance at start of period',
    'balanceEnd'                                => 'Balance at end of period',
    'splitByAccount'                            => 'Split by account',
    'coveredWithTags'                           => 'Covered with tags',
    'leftInBudget'                              => 'Left in budget',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Sum of sums',
    'noCategory'                                => '(no category)',
    'notCharged'                                => 'Not charged (yet)',
    'inactive'                                  => 'Inactive',
    'active'                                    => 'Active',
    'difference'                                => 'Difference',
    'money_flowing_in'                          => 'In',
    'money_flowing_out'                         => 'Ud',
    'topX'                                      => 'top :number',
    'show_full_list'                            => 'Vis hele listen',
    'show_only_top'                             => 'Vis kun top :number',
    'report_type'                               => 'Rapporttype',
    'report_type_default'                       => 'Standard regnskabsrapport',
    'report_type_audit'                         => 'Overblik over transaktionshistorik (revision)',
    'report_type_category'                      => 'Kategori rapport',
    'report_type_budget'                        => 'Budgetrapport',
    'report_type_tag'                           => 'Tag rapport',
    'report_type_double'                        => 'Regnskabsrapport for udgifter/indtægter',
    'more_info_help'                            => 'Mere information om disse typer af rapporter kan findes på hjælpesiderne. Tryk på (?) ikonet i øverste højre hjørne.',
    'report_included_accounts'                  => 'Inkluderede konti',
    'report_date_range'                         => 'Datointerval',
    'report_preset_ranges'                      => 'Forudindstillet intervaller',
    'shared'                                    => 'Delt',
    'fiscal_year'                               => 'Regnskabsår',
    'income_entry'                              => 'Indtægter fra konto ":name" mellem :start og :end',
    'expense_entry'                             => 'Expenses to account ":name" between :start and :end',
    'category_entry'                            => 'Expenses and income in category ":name" between :start and :end',
    'budget_spent_amount'                       => 'Expenses in budget ":budget" between :start and :end',
    'balance_amount'                            => 'Expenses in budget ":budget" paid from account ":account" between :start and :end',
    'no_audit_activity'                         => 'No activity was recorded on account <a href=":url" title=":account_name">:account_name</a> between :start and :end.',
    'audit_end_balance'                         => 'Account balance of <a href=":url" title=":account_name">:account_name</a> at the end of :end was: :balance',
    'reports_extra_options'                     => 'Ekstra valgmuligheder',
    'report_has_no_extra_options'               => 'Denne rapport har ingen ekstra muligheder',
    'reports_submit'                            => 'Vis rapport',
    'end_after_start_date'                      => 'Slutdato for rapport skal være efter startdato.',
    'select_category'                           => 'Vælg kategori(er)',
    'select_budget'                             => 'Vælg budget(ter).',
    'select_tag'                                => 'Vælg mærke(r).',
    'income_per_category'                       => 'Indkomst pr. kategori',
    'expense_per_category'                      => 'Udgift pr. kategori',
    'expense_per_budget'                        => 'Udgifter pr. budget',
    'income_per_account'                        => 'Indkomst pr. konto',
    'expense_per_account'                       => 'Udgift pr. konto',
    'expense_per_tag'                           => 'Udgift pr. mærke',
    'income_per_tag'                            => 'Indkomst pr. mærke',
    'include_expense_not_in_budget'             => 'Inkluderede udgifter er ikke i det valgte budget(ter)',
    'include_expense_not_in_account'            => 'Included expenses not in the selected account(s)',
    'include_expense_not_in_category'           => 'Included expenses not in the selected category(ies)',
    'include_income_not_in_category'            => 'Included income not in the selected category(ies)',
    'include_income_not_in_account'             => 'Included income not in the selected account(s)',
    'include_income_not_in_tags'                => 'Included income not in the selected tag(s)',
    'include_expense_not_in_tags'               => 'Included expenses not in the selected tag(s)',
    'everything_else'                           => 'Alt andet',
    'income_and_expenses'                       => 'Indtægter og udgifter',
    'spent_average'                             => 'Brugt (gennemsnit)',
    'income_average'                            => 'Indkomst (gennemsnit)',
    'transaction_count'                         => 'Transaktionen tæller',
    'average_spending_per_account'              => 'Gennemsnitlige udgifter pr. konto',
    'average_income_per_account'                => 'Average income per account',
    'total'                                     => 'Total',
    'description'                               => 'Description',
    'sum_of_period'                             => 'Sum of period',
    'average_in_period'                         => 'Average in period',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Default asset account',
    'account_role_sharedAsset'                  => 'Shared asset account',
    'account_role_savingAsset'                  => 'Savings account',
    'account_role_ccAsset'                      => 'Credit card',
    'account_role_cashWalletAsset'              => 'Cash wallet',
    'budget_chart_click'                        => 'Please click on a budget name in the table above to see a chart.',
    'category_chart_click'                      => 'Please click on a category name in the table above to see a chart.',
    'in_out_accounts'                           => 'Earned and spent per combination',
    'in_out_accounts_per_asset'                 => 'Earned and spent (per asset account)',
    'in_out_per_category'                       => 'Earned and spent per category',
    'out_per_budget'                            => 'Spent per budget',
    'select_expense_revenue'                    => 'Select expense/revenue account',
    'multi_currency_report_sum'                 => 'Because this list contains accounts with multiple currencies, the sum(s) you see may not make sense. The report will always fall back to your default currency.',
    'sum_in_default_currency'                   => 'The sum will always be in your default currency.',
    'net_filtered_prefs'                        => 'This chart will never include accounts that have the "Include in net worth"-option unchecked.',


    // charts:
    'chart'                                     => 'Chart',
    'month'                                     => 'Month',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Spent',
    'spent_capped'                              => 'Spent (capped)',
    'spent_in_budget'                           => 'Spent in budget',
    'left_to_spend'                             => 'Left to spend',
    'earned'                                    => 'Earned',
    'overspent'                                 => 'Overspent',
    'left'                                      => 'Left',
    'max-amount'                                => 'Maximum amount',
    'min-amount'                                => 'Minimum amount',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Name',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Date',
    'date_and_time'                             => 'Date and time',
    'time'                                      => 'Time',
    'paid'                                      => 'Paid',
    'unpaid'                                    => 'Ubetalt',
    'day'                                       => 'Dag',
    'budgeted'                                  => 'Budgetteret',
    'period'                                    => 'Periode',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'I alt',
    'summary'                                   => 'Opsummering',
    'average'                                   => 'Gennemsnitlig',
    'balanceFor'                                => 'Saldo for :name',
    'no_tags'                                   => '(ingen mærker)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Tilføj penge til sparegrisen ":name"',
    'piggy_bank'                    => 'Sparegris',
    'new_piggy_bank'                => 'Ny sparegris',
    'store_piggy_bank'              => 'Gem ny sparegris',
    'stored_piggy_bank'             => 'Gem ny sparegris ":name"',
    'account_status'                => 'Status for konto',
    'left_for_piggy_banks'          => 'Left for piggy banks',
    'sum_of_piggy_banks'            => 'Sum of piggy banks',
    'saved_so_far'                  => 'Saved so far',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Left to save',
    'suggested_amount'              => 'Suggested monthly amount to save',
    'add_money_to_piggy_title'      => 'Add money to piggy bank ":name"',
    'remove_money_from_piggy_title' => 'Remove money from piggy bank ":name"',
    'add'                           => 'Tilføj',
    'no_money_for_piggy'            => 'You have no money to put in this piggy bank.',
    'suggested_savings_per_month'   => 'Suggested per month',

    'remove'                    => 'Fjern',
    'max_amount_add'            => 'Det maksimale beløb, du kan tilføje er',
    'max_amount_remove'         => 'Det maksimale beløb, du kan fjerne er',
    'update_piggy_button'       => 'Update piggy bank',
    'update_piggy_title'        => 'Update piggy bank ":name"',
    'updated_piggy_bank'        => 'Updated piggy bank ":name"',
    'details'                   => 'Detaljer',
    'events'                    => 'Begivenheder',
    'target_amount'             => 'Target amount',
    'start_date'                => 'Start dato',
    'no_start_date'             => 'No start date',
    'target_date'               => 'Target date',
    'no_target_date'            => 'No target date',
    'table'                     => 'Tabel',
    'delete_piggy_bank'         => 'Delete piggy bank ":name"',
    'cannot_add_amount_piggy'   => 'Could not add :amount to ":name".',
    'cannot_remove_from_piggy'  => 'Could not remove :amount from ":name".',
    'deleted_piggy_bank'        => 'Deleted piggy bank ":name"',
    'added_amount_to_piggy'     => 'Added :amount to ":name"',
    'removed_amount_from_piggy' => 'Removed :amount from ":name"',
    'piggy_events'              => 'Related piggy banks',

    // tags
    'delete_tag'                => 'Delete tag ":tag"',
    'deleted_tag'               => 'Deleted tag ":tag"',
    'new_tag'                   => 'Make new tag',
    'edit_tag'                  => 'Edit tag ":tag"',
    'updated_tag'               => 'Updated tag ":tag"',
    'created_tag'               => 'Tag ":tag" has been created!',

    'transaction_journal_information'               => 'Transaction information',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta information',
    'transaction_journal_more'                      => 'More information',
    'basic_journal_information'                     => 'Basic transaction information',
    'transaction_journal_extra'                     => 'Extra information',
    'att_part_of_journal'                           => 'Stored under ":journal"',
    'total_amount'                                  => 'Total amount',
    'number_of_decimals'                            => 'Number of decimals',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Administration',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'User administration',
    'list_all_users'                                => 'All users',
    'all_users'                                     => 'All users',
    'instance_configuration'                        => 'Configuration',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Single user mode',
    'setting_single_user_mode_explain'              => 'By default, Firefly III only accepts one (1) registration: you. This is a security measure, preventing others from using your instance unless you allow them to. Future registrations are blocked. When you uncheck this box, others can use your instance as well, assuming they can reach it (when it is connected to the internet).',
    'store_configuration'                           => 'Store configuration',
    'single_user_administration'                    => 'User administration for :email',
    'edit_user'                                     => 'Edit user :email',
    'hidden_fields_preferences'                     => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                         => 'User data',
    'user_information'                              => 'User information',
    'total_size'                                    => 'total size',
    'budget_or_budgets'                             => ':count budget|:count budgets',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_rules rule(s) in :count_groups rule group(s)',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'The configuration has been updated',
    'setting_is_demo_site'                          => 'Demo site',
    'setting_is_demo_site_explain'                  => 'If you check this box, this installation will behave as if it is the demo site, which can have weird side effects.',
    'block_code_bounced'                            => 'Email message(s) bounced',
    'block_code_expired'                            => 'Demo account expired',
    'no_block_code'                                 => 'No reason for block or user not blocked',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'User has not yet confirmed new email address',
    'admin_update_email'                            => 'Contrary to the profile page, the user will NOT be notified their email address has changed!',
    'update_user'                                   => 'Update user',
    'updated_user'                                  => 'User data has been changed.',
    'delete_user'                                   => 'Delete user :email',
    'user_deleted'                                  => 'The user has been deleted',
    'send_test_email'                               => 'Send test email message',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Send message',
    'send_test_triggered'                           => 'Test was triggered. Check your inbox and the log files.',
    'give_admin_careful'                            => 'Users who are given admin rights can take away yours. Be careful.',
    'admin_maintanance_title'                       => 'Maintenance',
    'admin_maintanance_expl'                        => 'Some nifty buttons for Firefly III maintenance',
    'admin_maintenance_clear_cache'                 => 'Clear cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Description of the split transaction',
    'split_transaction_title_help'          => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'split_title_help'                      => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'you_create_transfer'                   => 'You\'re creating a transfer.',
    'you_create_withdrawal'                 => 'You\'re creating a withdrawal.',
    'you_create_deposit'                    => 'You\'re creating a deposit.',

    // links
    'journal_link_configuration'            => 'Transaction links configuration',
    'create_new_link_type'                  => 'Create new link type',
    'store_new_link_type'                   => 'Store new link type',
    'update_link_type'                      => 'Update link type',
    'edit_link_type'                        => 'Edit link type ":name"',
    'updated_link_type'                     => 'Updated link type ":name"',
    'delete_link_type'                      => 'Delete link type ":name"',
    'deleted_link_type'                     => 'Deleted link type ":name"',
    'stored_new_link_type'                  => 'Store new link type ":name"',
    'cannot_edit_link_type'                 => 'Cannot edit link type ":name"',
    'link_type_help_name'                   => 'Ie. "Duplicates"',
    'link_type_help_inward'                 => 'Ie. "duplicates"',
    'link_type_help_outward'                => 'Ie. "is duplicated by"',
    'save_connections_by_moving'            => 'Save the link between these transactions by moving them to another link type:',
    'do_not_save_connection'                => '(do not save connection)',
    'link_transaction'                      => 'Link transaction',
    'link_to_other_transaction'             => 'Link this transaction to another transaction',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'This transaction',
    'transaction'                           => 'Transaction',
    'comments'                              => 'Comments',
    'link_notes'                            => 'Any notes you wish to store with the link.',
    'invalid_link_selection'                => 'Cannot link these transactions',
    'selected_transaction'                  => 'Selected transaction',
    'journals_linked'                       => 'Transactions are linked.',
    'journals_error_linked'                 => 'These transactions are already linked.',
    'journals_link_to_self'                 => 'You cannot link a transaction to itself',
    'journal_links'                         => 'Transaction links',
    'this_withdrawal'                       => 'This withdrawal',
    'this_deposit'                          => 'This deposit',
    'this_transfer'                         => 'This transfer',
    'overview_for_link'                     => 'Overview for link type ":name"',
    'source_transaction'                    => 'Source transaction',
    'link_description'                      => 'Link description',
    'destination_transaction'               => 'Destination transaction',
    'delete_journal_link'                   => 'Delete the link between <a href=":source_link">:source</a> and <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Deleted link',

    // link translations:
    'Paid_name'                             => 'Paid',
    'Refund_name'                           => 'Refund',
    'Reimbursement_name'                    => 'Reimbursement',
    'Related_name'                          => 'Related',
    'relates to_inward'                     => 'relates to',
    'is (partially) refunded by_inward'     => 'is (partially) refunded by',
    'is (partially) paid for by_inward'     => 'is (partially) paid for by',
    'is (partially) reimbursed by_inward'   => 'is (partially) reimbursed by',
    'inward_transaction'                    => 'Inward transaction',
    'outward_transaction'                   => 'Outward transaction',
    'relates to_outward'                    => 'relates to',
    '(partially) refunds_outward'           => '(partially) refunds',
    '(partially) pays for_outward'          => '(partially) pays for',
    '(partially) reimburses_outward'        => '(partially) reimburses',
    'is (partially) refunded by'            => 'is (partially) refunded by',
    'is (partially) paid for by'            => 'is (partially) paid for by',
    'is (partially) reimbursed by'          => 'is (partially) reimbursed by',
    'relates to'                            => 'relates to',
    '(partially) refunds'                   => '(partially) refunds',
    '(partially) pays for'                  => '(partially) pays for',
    '(partially) reimburses'                => '(partially) reimburses',

    // split a transaction:
    'splits'                                => 'Splits',
    'add_another_split'                     => 'Add another split',
    'cannot_edit_opening_balance'           => 'You cannot edit the opening balance of an account.',
    'no_edit_multiple_left'                 => 'You have selected no valid transactions to edit.',
    'breadcrumb_convert_group'              => 'Convert transaction',
    'convert_invalid_source'                => 'Source information is invalid for transaction #%d.',
    'convert_invalid_destination'           => 'Destination information is invalid for transaction #%d.',
    'create_another'                        => 'After storing, return here to create another one.',
    'after_update_create_another'           => 'After updating, return here to continue editing.',
    'store_as_new'                          => 'Store as a new transaction instead of updating.',
    'reset_after'                           => 'Reset form after submission',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(ungrouped)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Let\'s create an asset account!',
    'no_accounts_intro_asset'               => 'You have no asset accounts yet. Asset accounts are your main accounts: your checking account, savings account, shared account or even your credit card.',
    'no_accounts_imperative_asset'          => 'To start using Firefly III you must create at least one asset account. Let\'s do so now:',
    'no_accounts_create_asset'              => 'Create an asset account',
    'no_accounts_title_expense'             => 'Let\'s create an expense account!',
    'no_accounts_intro_expense'             => 'You have no expense accounts yet. Expense accounts are the places where you spend money, such as shops and supermarkets.',
    'no_accounts_imperative_expense'        => 'Expense accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_expense'            => 'Create an expense account',
    'no_accounts_title_revenue'             => 'Let\'s create a revenue account!',
    'no_accounts_intro_revenue'             => 'You have no revenue accounts yet. Revenue accounts are the places where you receive money from, such as your employer.',
    'no_accounts_imperative_revenue'        => 'Revenue accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_revenue'            => 'Create a revenue account',
    'no_accounts_title_liabilities'         => 'Let\'s create a liability!',
    'no_accounts_intro_liabilities'         => 'You have no liabilities yet. Liabilities are the accounts that register your (student) loans and other debts.',
    'no_accounts_imperative_liabilities'    => 'You don\'t have to use this feature, but it can be useful if you want to keep track of these things.',
    'no_accounts_create_liabilities'        => 'Create a liability',
    'no_budgets_title_default'              => 'Let\'s create a budget',
    'no_rules_title_default'                => 'Let\'s create a rule',
    'no_budgets_intro_default'              => 'You have no budgets yet. Budgets are used to organize your expenses into logical groups, which you can give a soft-cap to limit your expenses.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Budgets are the basic tools of financial management. Let\'s create one now:',
    'no_budgets_create_default'             => 'Create a budget',
    'no_rules_create_default'               => 'Create a rule',
    'no_categories_title_default'           => 'Let\'s create a category!',
    'no_categories_intro_default'           => 'You have no categories yet. Categories are used to fine tune your transactions and label them with their designated category.',
    'no_categories_imperative_default'      => 'Categories are created automatically when you create transactions, but you can create one manually too. Let\'s create one now:',
    'no_categories_create_default'          => 'Create a category',
    'no_tags_title_default'                 => 'Let\'s create a tag!',
    'no_tags_intro_default'                 => 'You have no tags yet. Tags are used to fine tune your transactions and label them with specific keywords.',
    'no_tags_imperative_default'            => 'Tags are created automatically when you create transactions, but you can create one manually too. Let\'s create one now:',
    'no_tags_create_default'                => 'Create a tag',
    'no_transactions_title_withdrawal'      => 'Let\'s create an expense!',
    'no_transactions_intro_withdrawal'      => 'You have no expenses yet. You should create expenses to start managing your finances.',
    'no_transactions_imperative_withdrawal' => 'Have you spent some money? Then you should write it down:',
    'no_transactions_create_withdrawal'     => 'Create an expense',
    'no_transactions_title_deposit'         => 'Let\'s create some income!',
    'no_transactions_intro_deposit'         => 'You have no recorded income yet. You should create income entries to start managing your finances.',
    'no_transactions_imperative_deposit'    => 'Have you received some money? Then you should write it down:',
    'no_transactions_create_deposit'        => 'Create a deposit',
    'no_transactions_title_transfers'       => 'Let\'s create a transfer!',
    'no_transactions_intro_transfers'       => 'You have no transfers yet. When you move money between asset accounts, it is recorded as a transfer.',
    'no_transactions_imperative_transfers'  => 'Have you moved some money around? Then you should write it down:',
    'no_transactions_create_transfers'      => 'Create a transfer',
    'no_piggies_title_default'              => 'Let\'s create a piggy bank!',
    'no_piggies_intro_default'              => 'You have no piggy banks yet. You can create piggy banks to divide your savings and keep track of what you\'re saving up for.',
    'no_piggies_imperative_default'         => 'Do you have things you\'re saving money for? Create a piggy bank and keep track:',
    'no_piggies_create_default'             => 'Create a new piggy bank',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Recurring transactions',
    'repeat_until_in_past'                  => 'This recurring transaction stopped repeating on :date.',
    'recurring_calendar_view'               => 'Calendar',
    'no_recurring_title_default'            => 'Let\'s create a recurring transaction!',
    'no_recurring_intro_default'            => 'You have no recurring transactions yet. You can use these to make Firefly III automatically create transactions for you.',
    'no_recurring_imperative_default'       => 'This is a pretty advanced feature but it can be extremely useful. Make sure you read the documentation (?)-icon in the top right corner) before you continue.',
    'no_recurring_create_default'           => 'Create a recurring transaction',
    'make_new_recurring'                    => 'Create a recurring transaction',
    'recurring_daily'                       => 'Every day',
    'recurring_weekly'                      => 'Every week on :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Every month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_monthly_skip'                => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_ndom'                        => 'Every month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Every year on :date',
    'overview_for_recurrence'               => 'Overview for recurring transaction ":title"',
    'warning_duplicates_repetitions'        => 'In rare instances, dates appear twice in this list. This can happen when multiple repetitions collide. Firefly III will always generate one transaction per day.',
    'created_transactions'                  => 'Related transactions',
    'expected_withdrawals'                  => 'Expected withdrawals',
    'expected_deposits'                     => 'Expected deposits',
    'expected_transfers'                    => 'Expected transfers',
    'created_withdrawals'                   => 'Created withdrawals',
    'created_deposits'                      => 'Created deposits',
    'created_transfers'                     => 'Created transfers',
    'recurring_info'                        => 'Recurring transaction :count / :total',
    'created_from_recurrence'               => 'Created from recurring transaction ":title" (#:id)',
    'recurring_never_cron'                  => 'It seems the cron job that is necessary to support recurring transactions has never run. This is of course normal when you have just installed Firefly III, but this should be something to set up as soon as possible. Please check out the help-pages using the (?)-icon in the top right corner of the page.',
    'recurring_cron_long_ago'               => 'It looks like it has been more than 36 hours since the cron job to support recurring transactions has fired for the last time. Are you sure it has been set up correctly? Please check out the help-pages using the (?)-icon in the top right corner of the page.',

    'create_new_recurrence'              => 'Create new recurring transaction',
    'help_first_date'                    => 'Indicate the first expected recurrence. This must be in the future.',
    'help_first_date_no_past'            => 'Indicate the first expected recurrence. Firefly III will not create transactions in the past.',
    'no_currency'                        => '(ingen valuta)',
    'mandatory_for_recurring'            => 'Mandatory recurrence information',
    'mandatory_for_transaction'          => 'Mandatory transaction information',
    'optional_for_recurring'             => 'Optional recurrence information',
    'optional_for_transaction'           => 'Optional transaction information',
    'change_date_other_options'          => 'Change the "first date" to see more options.',
    'mandatory_fields_for_tranaction'    => 'The values here will end up in the transaction(s) being created',
    'click_for_calendar'                 => 'Click here for a calendar that shows you when the transaction would repeat.',
    'repeat_forever'                     => 'Repeat forever',
    'repeat_until_date'                  => 'Repeat until date',
    'repeat_times'                       => 'Repeat a number of times',
    'recurring_skips_one'                => 'Every other',
    'recurring_skips_more'               => 'Skips :count occurrences',
    'store_new_recurrence'               => 'Store recurring transaction',
    'stored_new_recurrence'              => 'Recurring transaction ":title" stored successfully.',
    'edit_recurrence'                    => 'Edit recurring transaction ":title"',
    'recurring_repeats_until'            => 'Repeats until :date',
    'recurring_repeats_forever'          => 'Repeats forever',
    'recurring_repeats_x_times'          => 'Repeats :count time|Repeats :count times',
    'update_recurrence'                  => 'Update recurring transaction',
    'updated_recurrence'                 => 'Updated recurring transaction ":title"',
    'recurrence_is_inactive'             => 'This recurring transaction is not active and will not generate new transactions.',
    'delete_recurring'                   => 'Delete recurring transaction ":title"',
    'new_recurring_transaction'          => 'New recurring transaction',
    'help_weekend'                       => 'What should Firefly III do when the recurring transaction falls on a Saturday or Sunday?',
    'do_nothing'                         => 'Just create the transaction',
    'skip_transaction'                   => 'Skip the occurrence',
    'jump_to_friday'                     => 'Create the transaction on the previous Friday instead',
    'jump_to_monday'                     => 'Create the transaction on the next Monday instead',
    'will_jump_friday'                   => 'Will be created on Friday instead of the weekends.',
    'will_jump_monday'                   => 'Will be created on Monday instead of the weekends.',
    'except_weekends'                    => 'Except weekends',
    'recurrence_deleted'                 => 'Recurring transaction ":title" deleted',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Forbrug (:currency)',
    'box_earned_in_currency'             => 'Earned (:currency)',
    'box_budgeted_in_currency'           => 'Budgetteret (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Left to spend (:currency)',
    'box_net_worth_in_currency'          => 'Net worth (:currency)',
    'box_spend_per_day'                  => 'Left to spend per day: :amount',

    // debug page
    'debug_page'                         => 'Debug page',
    'debug_submit_instructions'          => 'If you are running into problems, you can use the information in this box as debug information. Please copy-and-paste into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. It will generate a beautiful table that can be used to quickly diagnose your problem.',
    'debug_pretty_table'                 => 'If you copy/paste the box below into a GitHub issue it will generate a table. Please do not surround this text with backticks or quotes.',
    'debug_additional_data'              => 'You may also share the content of the box below. You can also copy-and-paste this into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. However, the content of this box may contain private information such as account names, transaction details or email addresses.',

    // object groups
    'object_groups_menu_bar'             => 'Groups',
    'object_groups_page_title'           => 'Groups',
    'object_groups_breadcrumb'           => 'Groups',
    'object_groups_index'                => 'Overview',
    'object_groups'                      => 'Groups',
    'object_groups_empty_explain'        => 'Some things in Firefly III can be divided into groups. Piggy banks for example, feature a "Group" field in the edit and create screens. When you set this field, you can edit the names and the order of the groups on this page. For more information, check out the help-pages in the top right corner, under the (?)-icon.',
    'object_group_title'                 => 'Title',
    'edit_object_group'                  => 'Edit group ":title"',
    'delete_object_group'                => 'Delete group ":title"',
    'update_object_group'                => 'Update group',
    'updated_object_group'               => 'Successfully updated group ":title"',
    'deleted_object_group'               => 'Successfully deleted group ":title"',
    'object_group'                       => 'Group',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Aktiver valutakonvertering',
    'disable_auto_convert'               => 'Deaktivér valutakonvertering',
];
