<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'desat en ":timezone"',
    'displayed_in_tz'                           => 'mostrat en ":timezone"',
    'close'                                     => 'Tancar',
    'actions'                                   => 'Accions',
    'edit'                                      => 'Editar',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'ID al llibre de transaccions',
    'delete'                                    => 'Eliminar',
    'split'                                     => 'Dividir',
    'single_split'                              => 'Divisió',
    'clone'                                     => 'Duplicar',
    'clone_and_edit'                            => 'Clona i edita',
    'confirm_action'                            => 'Confirmar acció',
    'last_seven_days'                           => 'Últims set dies',
    'last_thirty_days'                          => 'Últims trenta dies',
    'last_180_days'                             => 'Últims 180 dies',
    'month_to_date'                             => 'Mes en curs',
    'year_to_date'                              => 'Any en curs',
    'YTD'                                       => 'Any en curs',
    'welcome_back'                              => 'Què està passant?',
    'main_dashboard_page_title'                 => 'Inici',
    'everything'                                => 'Tot',
    'today'                                     => 'avui',
    'customRange'                               => 'Interval personalitzat',
    'date_range'                                => 'Interval de dates',
    'apply'                                     => 'Aplicar',
    'select_date'                               => 'Seleccionar data..',
    'cancel'                                    => 'Cancel·lar',
    'from'                                      => 'De',
    'to'                                        => 'A',
    'structure'                                 => 'Estructura',
    'help_translating'                          => 'Aquest text d\'ajuda encara no està disponible en el teu idioma. <a href="https://crowdin.com/project/firefly-iii-help">Ens ajudaries a traduir-lo?</a>',
    'showEverything'                            => 'Mostrar tot',
    'never'                                     => 'Mai',
    'no_results_for_empty_search'               => 'La cerca era buida, per la qual cosa no s\'ha trobat res.',
    'removed_amount'                            => 'Eliminat :amount',
    'added_amount'                              => 'Afegit :amount',
    'asset_account_role_help'                   => 'Qualsevol opció addicional resultant de la teva elecció, es pot escollir més endavant.',
    'Opening balance'                           => 'Saldo inicial',
    'create_new_stuff'                          => 'Crear coses noves',
    'new_withdrawal'                            => 'Nova retirada',
    'create_new_transaction'                    => 'Crear una transacció nova',
    'sidebar_frontpage_create'                  => 'Crear',
    'new_transaction'                           => 'Nova transacció',
    'no_rules_for_bill'                         => 'La subscripció no té normes associades.',
    'go_to_asset_accounts'                      => 'Veure el teu compte d\'actius',
    'go_to_budgets'                             => 'Anar als teus pressupostos',
    'go_to_withdrawals'                         => 'Anar a les teves retirades',
    'clones_journal_x'                          => 'Aquesta transacció és duplicada de ":description" (#:id)',
    'go_to_categories'                          => 'Anar a les teves categories',
    'go_to_bills'                               => 'Ves a les teves subscripcions',
    'go_to_expense_accounts'                    => 'Veure els teus comptes de despeses',
    'go_to_revenue_accounts'                    => 'Veure els teus comptes de beneficis',
    'go_to_piggies'                             => 'Anar a la teva guardiola',
    'new_deposit'                               => 'Nou dipòsit',
    'new_transfer'                              => 'Nova transferència',
    'new_transfers'                             => 'Nova transferència',
    'new_asset_account'                         => 'Nou compte d\'actiu',
    'new_expense_account'                       => 'Nou compte de despeses',
    'new_revenue_account'                       => 'Nou compte de beneficis',
    'new_liabilities_account'                   => 'Nou deute',
    'new_budget'                                => 'Nou pressupost',
    'new_bill'                                  => 'Nova subscripció',
    'block_account_logout'                      => 'S\'ha tancat la teva sessió. Els comptes bloquejats no poden utilitzar aquest lloc. T\'has registrat amb una adreça de correu vàlida?',
    'flash_success'                             => 'Èxit!',
    'flash_info'                                => 'Missatge',
    'flash_warning'                             => 'Atenció!',
    'flash_error'                               => 'Error!',
    'flash_danger'                              => 'Perill!',
    'flash_info_multiple'                       => 'Hi ha un missatge|Hi ha :count missatges',
    'flash_error_multiple'                      => 'Hi ha un error|Hi ha :count errors',
    'net_worth'                                 => 'Valor net',
    'help_for_this_page'                        => 'Ajuda per aquesta pàgina',
    'help_for_this_page_body'                   => 'Pots trobar més informació sobre aquesta pàgina <a href="https://docs.firefly-iii.org/">a la documentació</a>.',
    'two_factor_welcome'                        => 'Hola!',
    'two_factor_enter_code'                     => 'Per continuar, si us plau, introdueix el teu codi d\'autenticació en dues passes. La teva aplicació el pot generar per tu.',
    'two_factor_code_here'                      => 'Introduir codi aquí',
    'two_factor_title'                          => 'Autenticació en dues passes',
    'authenticate'                              => 'Autentificar',
    'two_factor_forgot_title'                   => 'Autenticació en dues passes perduda',
    'two_factor_forgot'                         => 'He oblidat la meva cosa de dos factors.',
    'two_factor_lost_header'                    => 'Has perdut la teva autenticació en dues passes?',
    'two_factor_lost_intro'                     => 'Si també has perdut els teus codis de seguretat, has tingut mala sort. No hi ha res que puguis fer per arreglar-ho des de la interfície web. Tens dues opcions.',
    'two_factor_lost_fix_self'                  => 'Si tens la teva pròpia instància de Firefly III, llegeix <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working>aquesta entrada a les FAQ</a> per a obtenir instruccions.',
    'two_factor_lost_fix_owner'                 => 'Altrament, envia un correu al propietari del lloc, <a href="mailto::site_owner">:site_owner</a> i demana-li que reiniciï la teva autenticació de dues passes.',
    'mfa_backup_code'                           => 'Has fet servir un codi de seguretat per iniciar sessió a Firefly III. No es pot tornar a utilitzar, així que ratlla\'l de la llista.',
    'pref_two_factor_new_backup_codes'          => 'Obtenir nous codis de seguretat',
    'pref_two_factor_backup_code_count'         => 'Tens :count codi de seguretat vàlid.|Tens :count codis de seguretat vàlids.',
    '2fa_i_have_them'                           => 'Els he guardat!',
    'warning_much_data'                         => ':days dies de dades poden tardar a carregar-se.',
    'registered'                                => 'T\'has registrat satisfactòriament!',
    'Default asset account'                     => 'Compte d\'actius per defecte',
    'no_budget_pointer'                         => 'Sembla que encara no tens cap pressupost. N\'hauries de crear alguns a la pàgina de <a href="budgets">pressuposts</a>. Els pressupostos et poden ajudar a fer el seguiment de les teves despeses.',
    'no_bill_pointer'                           => 'Sembla que encara no tens cap subscripció. N\'hauries de crear alguns a la pàgina de <a href="subscriptions">subscripcions</a>. Les subscripcions et poden ajudar a fer el seguiment de les teves despeses.',
    'Savings account'                           => 'Compte d\'estalvis',
    'Credit card'                               => 'Targeta de crèdit',
    'source_accounts'                           => 'Compte d\'origen|Comptes d\'origen',
    'destination_accounts'                      => 'Compte de destí|Comptes de destí',
    'user_id_is'                                => 'El teu identificador d\'usuari és <strong>:user</strong>',
    'field_supports_markdown'                   => 'Aquest camp suporta <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Si necessites més ajuda per utilitzar Firefly III, si us plau, <a href="https://github.com/firefly-iii/firefly-iii/issues">obre un tiquet a GitHub</a>.',
    'reenable_intro_text'                       => 'També pots tornar a activar <a href="#" id="reenableGuidance">la guia d\'introducció</a>.',
    'intro_boxes_after_refresh'                 => 'Els quadres d\'introducció tornaran a aparèixer quan actualitzis la pàgina.',
    'show_all_no_filter'                        => 'Mostrar totes les transaccions sense agrupar-les per data.',
    'expenses_by_category'                      => 'Despeses per categoria',
    'expenses_by_budget'                        => 'Despeses per pressupost',
    'income_by_category'                        => 'Ingressos per categoria',
    'expenses_by_asset_account'                 => 'Despeses per compte d\'actius',
    'expenses_by_expense_account'               => 'Despeses per compte de destinació',
    'cannot_redirect_to_account'                => 'Firefly III no et pot redirigir a la pàgina correcta. Disculpes.',
    'sum_of_expenses'                           => 'Total de despeses',
    'sum_of_income'                             => 'Total d\'ingressos',
    'liabilities'                               => 'Passius',
    'spent_in_specific_budget'                  => 'Gastat del pressupost ":budget"',
    'spent_in_specific_double'                  => 'Gastat del compte ":account"',
    'earned_in_specific_double'                 => 'Guanyat al compte ":account"',
    'source_account'                            => 'Compte d\'origen',
    'source_account_reconciliation'             => 'No pots editar el compte d\'origen d\'una transacció de consolidació.',
    'destination_account'                       => 'Compte de destí',
    'destination_account_reconciliation'        => 'No pots editar el compte de destí d\'una transacció de reconciliació.',
    'sum_of_expenses_in_budget'                 => 'Total gastat del pressupost ":budget"',
    'left_in_budget_limit'                      => 'Disponible per gastar segons el pressupost',
    'current_period'                            => 'Període actual',
    'show_the_current_period_and_overview'      => 'Mostrar el període actual i la vista general',
    'pref_languages_locale'                     => 'Perquè una llengua diferent de l\'anglès funcioni correctament, el teu sistema operatiu ha de tenir la informació regional correcta. Si no hi és, les dades de monedes, dates i quantitats podrien formatar-se incorrectament.',
    'budget_in_period'                          => 'Totes les transaccions del pressupost ":name" entre :start i :end en :currency',
    'chart_budget_in_period'                    => 'Gràfica de totes les transaccions del pressupost ":name" entre :start i :end en :currency',
    'chart_budget_in_period_only_currency'      => 'La quantitat la vas pressupostar en :currency, així que la gràfica només mostrarà transaccions en :currency.',
    'chart_account_in_period'                   => 'Gràfica de totes les transaccions del compte ":name" (:balance) entre :start i :end',
    'chart_category_in_period'                  => 'Gràfica de totes les transaccions de la categoria ":name" entre :start i :end',
    'chart_category_all'                        => 'Gràfica de totes les transaccions de la categoria ":name"',
    'clone_withdrawal'                          => 'Duplicar aquesta retirada',
    'clone_deposit'                             => 'Duplicar aquest dipòsit',
    'clone_transfer'                            => 'Duplicar aquesta transferència',
    'multi_select_no_selection'                 => 'Res seleccionat',
    'multi_select_select_all'                   => 'Seleccionar-ho tot',
    'multi_select_n_selected'                   => 'seleccionat',
    'multi_select_all_selected'                 => 'Tots seleccionats',
    'multi_select_filter_placeholder'           => 'Buscar..',
    'intro_next_label'                          => 'Següent',
    'intro_prev_label'                          => 'Anterior',
    'intro_skip_label'                          => 'Ometre',
    'intro_done_label'                          => 'Fet',
    'between_dates_breadcrumb'                  => 'Entre :start i :end',
    'all_journals_without_budget'               => 'Totes les transaccions sense pressupost',
    'journals_without_budget'                   => 'Transaccions sense pressupost',
    'all_journals_without_category'             => 'Totes les transaccions sense categoria',
    'journals_without_category'                 => 'Transaccions sense categoria',
    'all_journals_for_account'                  => 'Totes les transaccions del compte :name',
    'chart_all_journals_for_account'            => 'Gràfica de totes les transaccions del compte :name',
    'journals_in_period_for_account'            => 'Totes les transaccions del compte :name entre :start i :end',
    'journals_in_period_for_account_js'         => 'Totes les transaccions del compte {title} entre {start} i {end}',
    'transferred'                               => 'Transferit',
    'all_withdrawal'                            => 'Totes les despeses',
    'all_transactions'                          => 'Totes les transaccions',
    'title_withdrawal_between'                  => 'Totes les despeses entre :start i :end',
    'all_deposit'                               => 'Tots els beneficis',
    'title_deposit_between'                     => 'Tots els beneficis entre :start i :end',
    'all_transfers'                             => 'Totes les transferències',
    'title_transfers_between'                   => 'Totes les transferències entre :start i :end',
    'all_transfer'                              => 'Totes les transferències',
    'all_journals_for_tag'                      => 'Totes les transferències amb l\'etiqueta ":tag"',
    'title_transfer_between'                    => 'Totes les transferències entre :start i :end',
    'all_journals_for_category'                 => 'Totes les transaccions amb categoria :name',
    'all_journals_for_budget'                   => 'Totes les transaccions del pressupost :name',
    'chart_all_journals_for_budget'             => 'Gràfica de totes les transaccions del pressupost :name',
    'journals_in_period_for_category'           => 'Totes les transaccions de la categoria :name entre :start i :end',
    'journals_in_period_for_tag'                => 'Totes les transaccions amb etiqueta :tag entre :start i :end',
    'not_available_demo_user'                   => 'La característica a la qual intentes accedir no es troba disponible pels usuaris de demostració.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'El compte d\'actius d\'origen "@source_name" només accepta transaccions en @source_currency. El compte de destí "@dest_name" només accepta transaccions en @dest_currency. Has d\'indicar la quantitat correcta transferida en ambdues monedes.',
    'transaction_data'                          => 'Dades de transacció',
    'invalid_server_configuration'              => 'Configuració del servidor invàlida',
    'invalid_locale_settings'                   => 'Firefly III no pot formatar quantitats monetàries perquè el teu servidor no té instal·lats alguns paquets necessaris. Hi ha <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instruccions sobre com fer-ho</a>.',
    'quickswitch'                               => 'Canvi ràpid',
    'sign_in_to_start'                          => 'Inicia sessió per començar',
    'sign_in'                                   => 'Iniciar sessió',
    'register_new_account'                      => 'Registrar un nou compte',
    'forgot_my_password'                        => 'He oblidat la meva contrasenya',
    'problems_with_input'                       => 'Hi ha hagut alguns problemes amb els valors introduïts.',
    'reset_password'                            => 'Restablir la teva contrasenya',
    'button_reset_password'                     => 'Restablir contrasenya',
    'reset_button'                              => 'Restablir',
    'want_to_login'                             => 'Vull iniciar sessió',
    'login_page_title'                          => 'Iniciar sessió a Firefly III',
    'register_page_title'                       => 'Registrar-se a Firefly III',
    'forgot_pw_page_title'                      => 'Contrasenya de Firefly III oblidada',
    'reset_pw_page_title'                       => 'Restablir contrasenya de Firefly III',
    'cannot_reset_demo_user'                    => 'No pots restablir la contrasenya de l\'usuari de demo.',
    'no_att_demo_user'                          => 'L\'usuari de demostració no pot pujar fitxers adjunts.',
    'button_register'                           => 'Registrar-se',
    'authorization'                             => 'Autorització',
    'active_bills_only'                         => 'només subscripcions actives',
    'active_bills_only_total'                   => 'totes les subscripcions actives',
    'active_exp_bills_only'                     => 'només subscripcions actives i esperades',
    'active_exp_bills_only_total'               => 'només totes les subscripcions actives',
    'per_period_sum_1D'                         => 'Costos diaris esperats',
    'per_period_sum_1W'                         => 'Costos setmanals esperats',
    'per_period_sum_1M'                         => 'Costos mensuals esperats',
    'per_period_sum_3M'                         => 'Costos trimestrals esperats',
    'per_period_sum_6M'                         => 'Costos semestrals esperats',
    'per_period_sum_1Y'                         => 'Costos anuals esperats',
    'average_per_bill'                          => 'mitjana per subscripció',
    'expected_total'                            => 'total esperat',
    'reconciliation_account_name'               => ':name consolidació (:currency)',
    'saved'                                     => 'Guardat',
    'advanced_options'                          => 'Opcions avançades',
    'advanced_options_explain'                  => 'Algunes pàgines de Firefly III tenen opcions avançades amagades darrere aquest botó. Aquesta pàgina no té res d\'especial, però pots comprovar les altres!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'deshabilitat',
    'no_webhook_messages'                       => 'No hi ha missatges webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Després de crear la transacció',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Després d\'actualitzar la transacció',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Després d\'eliminar la transacció',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Detalls de la transacció',
    'webhook_response_ACCOUNTS'                 => 'Detalls del compte',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspeccionar',
    'create_new_webhook'                        => 'Crear nou webhook',
    'webhooks_create_breadcrumb'                => 'Crear nou webhook',
    'webhook_trigger_form_help'                 => 'Indicar quin esdeveniment activarà el webhook',
    'webhook_response_form_help'                => 'Indicar què ha d\'enviar el webhook a l\'URL.',
    'webhook_delivery_form_help'                => 'En quin format ha d\'entregar les dades el webhook.',
    'webhook_active_form_help'                  => 'El wehook ha d\'estar actiu o no es cridarà.',
    'stored_new_webhook'                        => 'Nou webhook guardat ":title"',
    'delete_webhook'                            => 'Webhook eliminat',
    'deleted_webhook'                           => 'Webhook eliminat ":title"',
    'edit_webhook'                              => 'Editar webhook ":title"',
    'updated_webhook'                           => 'Webhook actualitzat ":title"',
    'edit_webhook_js'                           => 'Editar webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'El webhook ha sigut cridat a la transacció indicada. Per favor, espera a que apareguen els resultats.',
    'webhook_messages'                          => 'Missatge del webhook',
    'view_message'                              => 'Veure el missatge',
    'view_attempts'                             => 'Veure intents fallits',
    'message_content_title'                     => 'Contingut del missatge del webhook',
    'message_content_help'                      => 'Aquest és el contingut del missatge que s\'ha enviat (o s\'ha intentat) utilitzant aquest webhook.',
    'attempt_content_title'                     => 'Intents de webhook',
    'attempt_content_help'                      => 'Aquests han estat tots els intents sense èxit d\'enviar el missatge del webhook a l\'URL configurat. Després de cert temps, Firefly III deixarà de provar-ho.',
    'no_attempts'                               => 'No hi ha hagut intents sense èxit. Això és bon senyal!',
    'webhook_attempt_at'                        => 'Intent de {moment}',
    'logs'                                      => 'Registres',
    'response'                                  => 'Resposta',
    'visit_webhook_url'                         => 'Visitar l\'URL del webhook',
    'reset_webhook_secret'                      => 'Reiniciar el secret del webhook',
    'webhook_stored_link'                       => 'S\'ha desat <a href="webhooks/show/{ID}">el Webook #{ID} ("{title}")</a> correctament.',
    'webhook_updated_link'                      => 'S\'ha actualitzat el <a href="webhooks/show/{ID}">Webook #{ID}</a> ("{title}").',

    // API access
    'authorization_request'                     => 'Firefly III v:version Sol·licitud d\'Autorització',
    'authorization_request_intro'               => 'L\'aplicació "<strong>:client</strong>" està demanant permís per tenir accés a l\'administració de les teves finances. Vols autoritzar a <strong>:client</strong> a accedir a les dades?',
    'authorization_request_site'                => 'Seràs redirigit a <code>:url</code> que podrà accedir a les dades del teu Firefly III.',
    'authorization_request_invalid'             => 'Aquesta sol·licitud d\'accés no és vàlida. Si us plau, no tornis a obrir aquest enllaç.',
    'scopes_will_be_able'                       => 'Aquesta aplicació podrà:',
    'button_authorize'                          => 'Autoritzar',
    'none_in_select_list'                       => '(cap)',
    'no_piggy_bank'                             => '(sense guardiola)',
    'name_in_currency'                          => ':name en :currency',
    'paid_in_currency'                          => 'Pagat en :currency',
    'unpaid_in_currency'                        => 'Pendent de pagament en :currency',
    'is_alpha_warning'                          => 'Estàs executant una versió ALFA. Ves amb compte amb els errors i problemes.',
    'is_beta_warning'                           => 'Estàs executant una versió BETA. Ves amb compte amb els errors i problemes.',
    'all_destination_accounts'                  => 'Comptes de destí',
    'all_source_accounts'                       => 'Comptes d\'origen',
    'back_to_index'                             => 'Tornar a l\'índex',
    'cant_logout_guard'                         => 'Firefly III no pot tancar la sessió.',
    'internal_reference'                        => 'Referència interna',

    // check for updates:
    'update_check_title'                        => 'Buscar actualitzacions',
    'admin_update_check_title'                  => 'Buscar actualitzacions automàticament',
    'admin_update_check_explain'                => 'Firefly III pot buscar actualitzacions automàticament. Quan actives aquesta peferència, contactarà el servidor d\'actualitzacions de Firefly III per comprovar si hi ha una nova versió de Firefly III disponible. Quan hi sigui, se\'t notificarà. Pots provar aquesta notificació utilitzant el botó de la dreta. Si us plau, indica a sota si vols que Firefly III busqui actualitzacions.',
    'check_for_updates_permission'              => 'Firefly III pot buscar actualitzacions, però necessita el teu permís per a fer-ho. Si us plau, ves a <a href=":link">configuració</a> per indicar si vols activar aquesta característica.',
    'updates_ask_me_later'                      => 'Pregunta\'m més endavant',
    'updates_do_not_check'                      => 'No busquis actualitzacions',
    'updates_enable_check'                      => 'Activa el buscador d\'actualitzacions',
    'admin_update_check_now_title'              => 'Busca actualitzacions ara',
    'admin_update_check_now_explain'            => 'Si prems el botó, Firefly III comprovarà si la versió actual és l\'última.',
    'check_for_updates_button'                  => 'Comprovar ara!',
    'update_new_version_alert'                  => 'Hi ha una nova versió de Firefly III disponible. Estàs executant la versió :your_version, i l\'última versió és la :new_version que es va publicar el :date.',
    'update_version_beta'                       => 'Aquesta és una versió BETA. Podries tenir problemes.',
    'update_version_alpha'                      => 'Aquesta és una versió ALFA. Podries tenir problemes.',
    'update_current_dev_older'                  => 'Estàs fent servir la versió de desenvolupament ":version", que és més antiga que l\'última versió disponible :new_version. Per favor, actualitza!',
    'update_current_dev_newer'                  => 'Estàs fent servir la versió de desenvolupament ":version", que és més nova que l\'última versió disponible :new_version.',
    'update_current_version_alert'              => 'Estàs executant :version, que és l\'última versió disponible.',
    'update_newer_version_alert'                => 'Estàs executant :your_version, que és més nova que l\'última versió, :new_version.',
    'update_check_error'                        => 'Ha succeït un error mentre es comprovaven les actualitzacions: :error',
    'unknown_error'                             => 'Error desconegut. Ho sento.',
    'disabled_but_check'                        => 'Has desactivat la cerca d\'actualitzacions. Així que no t\'oblidis de comprovar les actualitzacions tu mateix de tant en tant. Gràcies!',
    'admin_update_channel_title'                => 'Canal d\'actualitzacions',
    'admin_update_channel_explain'              => 'Firefly III té tres "canals" d\'actualització que determinen quant d\'avançat estàs en termes de característiques, millores i errors. Utilitza el canal "beta" si ets un aventurer i "alfa" si t\'agrada viure al límit.',
    'update_channel_stable'                     => 'Estable. Tot hauria de funcionar com s\'espera.',
    'update_channel_beta'                       => 'Beta. Noves característiques, però algunes coses podrien fallar.',
    'update_channel_alpha'                      => 'Alfa. Anem provant coses, i utilitzem el que funcioni.',

    // search
    'search'                                    => 'Cercar',
    'search_query'                              => 'Consulta',
    'search_found_transactions'                 => 'Firefly III ha trobat :count transacció en :time segons.|Firefly III ha trobat :count transaccions en :time segons.',
    'search_found_more_transactions'            => 'Firefly III ha trobat més de :count transaccions en :time segons.',
    'search_for_overview'                       => 'Firefly II està buscant transaccions que compleixin <b>totes</b> les següents condicions:',
    'search_for_query'                          => 'Totes aquestes paraules han d\'estar presents: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Cap d\'aquestes paraules ha d\'estar present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Aquests paràmetres de cerca no són vàlids i s\'han ignorat.',

    // old


    'search_modifier_date_on'                             => 'La data de la transacció és ":value"',
    'search_modifier_not_date_on'                         => 'La data de la transacció no és ":value"',
    'search_modifier_reconciled'                          => 'La transacció s\'ha consolidat',
    'search_modifier_not_reconciled'                      => 'La transacció no s\'ha consolidat',
    'search_modifier_id'                                  => 'L\'ID de la transacció és ":value"',
    'search_modifier_not_id'                              => 'L\'ID de la transacció no és ":value"',
    'search_modifier_date_before'                         => 'La data de la transacció és prèvia a ":value"',
    'search_modifier_date_after'                          => 'La data de la transacció és posterior a ":value"',
    'search_modifier_external_id_is'                      => 'L\'ID externa és ":value"',
    'search_modifier_not_external_id_is'                  => 'L\'ID externa no és ":value"',
    'search_modifier_no_external_url'                     => 'La transacció no té URL extern',
    'search_modifier_no_external_id'                      => 'La transacció no té cap ID extern',
    'search_modifier_not_any_external_url'                => 'La transacció no té URL extern',
    'search_modifier_not_any_external_id'                 => 'La transacció no té cap ID extern',
    'search_modifier_any_external_url'                    => 'La transacció ha de tenir un URL extern (qualsevol)',
    'search_modifier_any_external_id'                     => 'La transacció ha de tenir almenys un ID extern',
    'search_modifier_not_no_external_url'                 => 'La transacció ha de tenir un URL extern (qualsevol)',
    'search_modifier_not_no_external_id'                  => 'La transacció ha de tenir almenys un ID extern',
    'search_modifier_internal_reference_is'               => 'La referència interna és ":value"',
    'search_modifier_not_internal_reference_is'           => 'La referència interna no és ":value"',
    'search_modifier_description_starts'                  => 'La descripció comença amb ":value"',
    'search_modifier_not_description_starts'              => 'La descripció no comença amb ":value"',
    'search_modifier_description_ends'                    => 'La descripció acaba amb ":value"',
    'search_modifier_not_description_ends'                => 'La descripció no acaba amb ":value"',
    'search_modifier_description_contains'                => 'La descripció conté ":value"',
    'search_modifier_not_description_contains'            => 'La descripció no conté ":value"',
    'search_modifier_description_is'                      => 'La descripció és exactament ":value"',
    'search_modifier_not_description_is'                  => 'La descripció no és exactament ":value"',
    'search_modifier_currency_is'                         => 'La moneda (estrangera) de la transacció és ":value"',
    'search_modifier_not_currency_is'                     => 'La moneda (estrangera) de la transacció no és ":value"',
    'search_modifier_foreign_currency_is'                 => 'La moneda estrangera de la transacció és ":value"',
    'search_modifier_not_foreign_currency_is'             => 'La moneda estrangera de la transacció no és ":value"',
    'search_modifier_has_attachments'                     => 'La transacció ha de tenir un fitxer adjunt',
    'search_modifier_has_no_category'                     => 'La transacció no pot tenir categoria',
    'search_modifier_not_has_no_category'                 => 'La transacció ha de tenir categoria (qualsevol)',
    'search_modifier_not_has_any_category'                => 'La transacció no pot tenir categoria',
    'search_modifier_has_any_category'                    => 'La transacció ha de tenir categoria (qualsevol)',
    'search_modifier_has_no_budget'                       => 'La transacció no pot tenir pressupost',
    'search_modifier_not_has_any_budget'                  => 'La transacció no pot tenir pressupost',
    'search_modifier_has_any_budget'                      => 'La transacció ha de tenir pressupost (qualsevol)',
    'search_modifier_not_has_no_budget'                   => 'La transacció ha de tenir pressupost (qualsevol)',
    'search_modifier_has_no_bill'                         => 'La transacció no pot tenir cap subscripció',
    'search_modifier_not_has_no_bill'                     => 'La transacció ha de tenir una subscripció',
    'search_modifier_has_any_bill'                        => 'La transacció ha de tenir una subscripció',
    'search_modifier_not_has_any_bill'                    => 'La transacció no pot tenir cap subscripció',
    'search_modifier_has_no_tag'                          => 'La transacció no pot tenir etiquetes',
    'search_modifier_not_has_any_tag'                     => 'La transacció no pot tenir etiquetes',
    'search_modifier_not_has_no_tag'                      => 'La transacció ha de tenir etiqueta (qualsevol)',
    'search_modifier_has_any_tag'                         => 'La transacció ha de tenir etiqueta (qualsevol)',
    'search_modifier_notes_contains'                      => 'Les notes de la transacció contenen ":value"',
    'search_modifier_not_notes_contains'                  => 'Les notes de la transacció no contenen ":value"',
    'search_modifier_notes_starts'                        => 'Les notes de la transacció comencen per ":value"',
    'search_modifier_not_notes_starts'                    => 'Les notes de la transacció no comencen per ":value"',
    'search_modifier_notes_ends'                          => 'Les notes de la transacció acaben amb ":value"',
    'search_modifier_not_notes_ends'                      => 'Les notes de la transacció no acaben amb ":value"',
    'search_modifier_notes_is'                            => 'Les notes de la transacció són exactament ":value"',
    'search_modifier_not_notes_is'                        => 'Les notes de la transacció no són exactament ":value"',
    'search_modifier_no_notes'                            => 'La transacció no té notes',
    'search_modifier_not_no_notes'                        => 'La transacció ha de tenir notes',
    'search_modifier_any_notes'                           => 'La transacció ha de tenir notes',
    'search_modifier_not_any_notes'                       => 'La transacció no té notes',
    'search_modifier_amount_is'                           => 'La quantitat és exactament :value',
    'search_modifier_not_amount_is'                       => 'La quantitat no és :value',
    'search_modifier_amount_less'                         => 'La quantitat és igual o inferior a :value',
    'search_modifier_not_amount_more'                     => 'La quantitat és igual o inferior a :value',
    'search_modifier_amount_more'                         => 'La quantitat és igual o superior a :value',
    'search_modifier_not_amount_less'                     => 'La quantitat és igual o superior a :value',
    'search_modifier_source_account_is'                   => 'El nom del compte d\'origen és exactament ":value"',
    'search_modifier_not_source_account_is'               => 'El nom del compte d\'origen no és ":value"',
    'search_modifier_source_account_contains'             => 'El nom del compte d\'origen conté ":value"',
    'search_modifier_not_source_account_contains'         => 'El nom del compte d\'origen no conté ":value"',
    'search_modifier_source_account_starts'               => 'El nom del compte d\'origen comença per ":value"',
    'search_modifier_not_source_account_starts'           => 'El nom del compte d\'origen no comença per ":value"',
    'search_modifier_source_account_ends'                 => 'El nom del compte d\'origen acaba amb ":value"',
    'search_modifier_not_source_account_ends'             => 'El nom del compte d\'origen no acaba amb ":value"',
    'search_modifier_source_account_id'                   => 'L\'ID del compte d\'origen és :value',
    'search_modifier_not_source_account_id'               => 'L\'ID del compte d\'origen no és :value',
    'search_modifier_source_account_nr_is'                => 'El número (IBAN) del compte d\'origen és ":value"',
    'search_modifier_not_source_account_nr_is'            => 'El número (IBAN) del compte d\'origen no és ":value"',
    'search_modifier_source_account_nr_contains'          => 'El número (IBAN) del compte d\'origen conté ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'El número (IBAN) del compte d\'origen no conté ":value"',
    'search_modifier_source_account_nr_starts'            => 'El número (IBAN) del compte d\'origen comença per ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'El número (IBAN) del compte d\'origen no comença per ":value"',
    'search_modifier_source_account_nr_ends'              => 'El número (IBAN) del compte d\'origen acaba amb ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'El número (IBAN) del compte d\'origen no acaba amb ":value"',
    'search_modifier_destination_account_is'              => 'El nom del compte de destí és exactament ":value"',
    'search_modifier_not_destination_account_is'          => 'El nom del compte de destí no és ":value"',
    'search_modifier_destination_account_contains'        => 'El nom del compte de destí conté ":value"',
    'search_modifier_not_destination_account_contains'    => 'El nom del compte de destí no conté ":value"',
    'search_modifier_destination_account_starts'          => 'El nom del compte de destí comença per ":value"',
    'search_modifier_not_destination_account_starts'      => 'El nom del compte de destí no comença per ":value"',
    'search_modifier_destination_account_ends'            => 'El nom del compte de destí acaba amb ":value"',
    'search_modifier_not_destination_account_ends'        => 'El nom del compte de destí no acaba amb ":value"',
    'search_modifier_destination_account_id'              => 'L\'ID del compte de destí és :value',
    'search_modifier_not_destination_account_id'          => 'L\'ID del compte de destí no és :value',
    'search_modifier_destination_is_cash'                 => 'El compte de destí és el compte "(efectiu)"',
    'search_modifier_not_destination_is_cash'             => 'El compte de destí no és el compte "(efectiu)"',
    'search_modifier_source_is_cash'                      => 'El compte d\'origen és el compte "(efectiu)"',
    'search_modifier_not_source_is_cash'                  => 'El compte d\'origen no és el compte "(efectiu)"',
    'search_modifier_destination_account_nr_is'           => 'El número (IBAN) del compte de destí és ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'El número (IBAN) del compte de destí és ":value"',
    'search_modifier_destination_account_nr_contains'     => 'El número (IBAN) del compte de destí conté ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'El número (IBAN) del compte de destí no conté ":value"',
    'search_modifier_destination_account_nr_starts'       => 'El número (IBAN) del compte de destí comença per ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'El número (IBAN) del compte de destí no comença per ":value"',
    'search_modifier_destination_account_nr_ends'         => 'El número (IBAN) del compte de destí acaba amb ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'El número (IBAN) del compte de destí no acaba amb ":value"',
    'search_modifier_account_id'                          => 'L\'ID del compte d\'origen o de destí és/són: :value',
    'search_modifier_not_account_id'                      => 'L\'ID del compte d\'origen o de destí no és/són: :value',
    'search_modifier_category_is'                         => 'La categoria és ":value"',
    'search_modifier_not_category_is'                     => 'La categoria no és ":value"',
    'search_modifier_budget_is'                           => 'El pressupost és ":value"',
    'search_modifier_not_budget_is'                       => 'El pressupost no és ":value"',
    'search_modifier_bill_is'                             => 'La subscripció és ":value"',
    'search_modifier_not_bill_is'                         => 'La subscripció no és ":value"',
    'search_modifier_transaction_type'                    => 'El tipus de transacció és ":value"',
    'search_modifier_not_transaction_type'                => 'El tipus de transacció no és ":value"',
    'search_modifier_tag_is'                              => 'L\'etiqueta és ":value"',
    'search_modifier_tag_contains'                        => 'L\'etiqueta conté ":value"',
    'search_modifier_not_tag_contains'                    => 'L\'etiqueta no conté ":value"',
    'search_modifier_tag_ends'                            => 'L\'etiqueta acaba amb ":value"',
    'search_modifier_tag_starts'                          => 'L\'etiqueta comença amb ":value"',
    'search_modifier_not_tag_is'                          => 'Cap etiqueta és ":value"',
    'search_modifier_date_on_year'                        => 'L\'any de la transacció és ":value"',
    'search_modifier_not_date_on_year'                    => 'L\'any de la transacció no és ":value"',
    'search_modifier_date_on_month'                       => 'El mes de la transacció és ":value"',
    'search_modifier_not_date_on_month'                   => 'El mes de la transacció no és ":value"',
    'search_modifier_date_on_day'                         => 'La transacció és el dia ":value" del mes',
    'search_modifier_not_date_on_day'                     => 'La transacció no és el dia ":value" del mes',
    'search_modifier_date_before_year'                    => 'L\'any de la transacció és anterior o igual a ":value"',
    'search_modifier_date_before_month'                   => 'El mes de la transacció és anterior o igual a ":value"',
    'search_modifier_date_before_day'                     => 'El dia del mes de la transacció és anterior o igual a ":value"',
    'search_modifier_date_after_year'                     => 'L\'any de la transacció és igual o posterior a ":value"',
    'search_modifier_date_after_month'                    => 'El mes de la transacció és igual o posterior a ":value"',
    'search_modifier_date_after_day'                      => 'El dia del mes de la transacció és igual o posterior a ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Cap etiqueta és ":value"',
    'search_modifier_not_tag_is_not'                      => 'L\'etiqueta és ":value"',
    'search_modifier_account_is'                          => 'Un dels comptes és ":value"',
    'search_modifier_not_account_is'                      => 'Cap dels comptes és ":value"',
    'search_modifier_account_contains'                    => 'Un dels comptes conté ":value"',
    'search_modifier_not_account_contains'                => 'Cap dels comptes conté ":value"',
    'search_modifier_account_ends'                        => 'Un dels comptes acaba amb ":value"',
    'search_modifier_not_account_ends'                    => 'Cap dels comptes acaba amb ":value"',
    'search_modifier_account_starts'                      => 'Un dels comptes comença per ":value"',
    'search_modifier_not_account_starts'                  => 'Cap dels comptes comença per ":value"',
    'search_modifier_account_nr_is'                       => 'El número / IBAN d\'un dels comptes és ":value"',
    'search_modifier_not_account_nr_is'                   => 'Cap número de compte / IBAN és ":value"',
    'search_modifier_account_nr_contains'                 => 'Qualsevol número de compte / IBAN conté ":value"',
    'search_modifier_not_account_nr_contains'             => 'Cap número de compte / IBAN conté ":value"',
    'search_modifier_account_nr_ends'                     => 'Qualsevol número de compte / IBAN acaba amb ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Cap número de compte / IBAN acaba amb ":value"',
    'search_modifier_account_nr_starts'                   => 'Qualsevol número de compte / IBAN comença per ":value"',
    'search_modifier_not_account_nr_starts'               => 'Cap número de compte / IBAN comença per ":value"',
    'search_modifier_category_contains'                   => 'La categoria conté ":value"',
    'search_modifier_not_category_contains'               => 'La categoria no conté ":value"',
    'search_modifier_category_ends'                       => 'La categoria acaba amb ":value"',
    'search_modifier_not_category_ends'                   => 'La categoria no acaba amb ":value"',
    'search_modifier_category_starts'                     => 'La categoria comença per ":value"',
    'search_modifier_not_category_starts'                 => 'La categoria no comença per ":value"',
    'search_modifier_budget_contains'                     => 'El pressupost conté ":value"',
    'search_modifier_not_budget_contains'                 => 'El pressupost no conté ":value"',
    'search_modifier_budget_ends'                         => 'El pressupost acaba amb ":value"',
    'search_modifier_not_budget_ends'                     => 'El pressupost no acaba amb ":value"',
    'search_modifier_budget_starts'                       => 'El pressupost comença per ":value"',
    'search_modifier_not_budget_starts'                   => 'El pressupost no comença per ":value"',
    'search_modifier_bill_contains'                       => 'La subscripció conté ":value"',
    'search_modifier_not_bill_contains'                   => 'La subscripció no conté ":value"',
    'search_modifier_bill_ends'                           => 'La subscripció acaba amb ":value"',
    'search_modifier_not_bill_ends'                       => 'La subscripció no acaba amb ":value"',
    'search_modifier_bill_starts'                         => 'La subscripció comença amb ":value"',
    'search_modifier_not_bill_starts'                     => 'La subscripció no comença amb ":value"',
    'search_modifier_external_id_contains'                => 'L\'ID externa conté ":value"',
    'search_modifier_not_external_id_contains'            => 'L\'ID externa no conté ":value"',
    'search_modifier_external_id_ends'                    => 'L\'ID externa acaba amb ":value"',
    'search_modifier_not_external_id_ends'                => 'L\'ID externa no acaba amb ":value"',
    'search_modifier_external_id_starts'                  => 'L\'ID externa comença per ":value"',
    'search_modifier_not_external_id_starts'              => 'L\'ID externa no comença per ":value"',
    'search_modifier_internal_reference_contains'         => 'La referència interna conté ":value"',
    'search_modifier_not_internal_reference_contains'     => 'La referència interna no conté ":value"',
    'search_modifier_internal_reference_ends'             => 'La referència interna acaba amb ":value"',
    'search_modifier_internal_reference_starts'           => 'La referència interna comença per ":value"',
    'search_modifier_not_internal_reference_ends'         => 'La referència interna no acaba amb ":value"',
    'search_modifier_not_internal_reference_starts'       => 'La referència interna no comença per ":value"',
    'search_modifier_external_url_is'                     => 'L\'URL extern és ":value"',
    'search_modifier_not_external_url_is'                 => 'L\'URL extern no és ":value"',
    'search_modifier_external_url_contains'               => 'L\'URL extern conté ":value"',
    'search_modifier_not_external_url_contains'           => 'L\'URL extern no conté ":value"',
    'search_modifier_external_url_ends'                   => 'L\'URL extern acaba amb ":value"',
    'search_modifier_not_external_url_ends'               => 'L\'URL extern no acaba amb ":value"',
    'search_modifier_external_url_starts'                 => 'L\'URL extern comença per ":value"',
    'search_modifier_not_external_url_starts'             => 'L\'URL extern no comença per ":value"',
    'search_modifier_has_no_attachments'                  => 'La transacció no té fitxers adjunts',
    'search_modifier_not_has_no_attachments'              => 'La transacció té fitxers adjunts',
    'search_modifier_not_has_attachments'                 => 'La transacció no té fitxers adjunts',
    'search_modifier_account_is_cash'                     => 'Un dels comptes és el compte "(efectiu)".',
    'search_modifier_not_account_is_cash'                 => 'Cap dels comptes és el compte "(efectiu)".',
    'search_modifier_journal_id'                          => 'L\'ID del registre és ":value"',
    'search_modifier_not_journal_id'                      => 'L\'ID del registre no és ":value"',
    'search_modifier_recurrence_id'                       => 'L\'ID de la transacció periòdica és ":value"',
    'search_modifier_not_recurrence_id'                   => 'L\'ID de la transacció periòdica no és ":value"',
    'search_modifier_foreign_amount_is'                   => 'La quantitat en moneda estrangera és ":value"',
    'search_modifier_not_foreign_amount_is'               => 'La quantitat en moneda estrangera no és ":value"',
    'search_modifier_foreign_amount_less'                 => 'La quantitat en moneda estrangera és inferior a ":value"',
    'search_modifier_not_foreign_amount_more'             => 'La quantitat en moneda estrangera és inferior a ":value"',
    'search_modifier_not_foreign_amount_less'             => 'La quantitat en moneda estrangera és superior a ":value"',
    'search_modifier_foreign_amount_more'                 => 'La quantitat en moneda estrangera és superior a ":value"',
    'search_modifier_exists'                              => 'La transacció existeix (qualsevol)',
    'search_modifier_not_exists'                          => 'La transacció no existeix (cap transacció)',

    // date fields
    'search_modifier_interest_date_on'                    => 'La data d\'interès de la transacció és ":value"',
    'search_modifier_not_interest_date_on'                => 'La data d\'interès de la transacció no és ":value"',
    'search_modifier_interest_date_on_year'               => 'La data d\'interès de la transacció és en l\'any ":value"',
    'search_modifier_not_interest_date_on_year'           => 'La data d\'interès de la transacció no és en l\'any ":value"',
    'search_modifier_interest_date_on_month'              => 'La data d\'interès de la transacció és en el mes ":value"',
    'search_modifier_not_interest_date_on_month'          => 'La data d\'interès de la transacció no és en el mes ":value"',
    'search_modifier_interest_date_on_day'                => 'La data d\'interès de la transacció és en el dia ":value" del mes',
    'search_modifier_not_interest_date_on_day'            => 'La data d\'interès de la transacció no és en el dia ":value" del mes',
    'search_modifier_interest_date_before_year'           => 'La data d\'interès de la transacció és prèvia o igual a l\'any ":value"',
    'search_modifier_interest_date_before_month'          => 'La data d\'interès de la transacció és prèvia o igual al mes ":value"',
    'search_modifier_interest_date_before_day'            => 'La data d\'interès de la transacció és prèvia o igual al dia ":value" del mes',
    'search_modifier_interest_date_after_year'            => 'La data d\'interès de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_interest_date_after_month'           => 'La data d\'interès de la transacció és igual o posterior al mes ":value"',
    'search_modifier_interest_date_after_day'             => 'La data d\'interès de la transacció és igual o posterior al dia ":value" del mes',
    'search_modifier_book_date_on_year'                   => 'La data de registre de la transacció és en l\'any ":value"',
    'search_modifier_book_date_on_month'                  => 'La data de registre de la transacció és en el mes ":value"',
    'search_modifier_book_date_on_day'                    => 'La data de registre de la transacció és en el dia ":value" del mes',
    'search_modifier_not_book_date_on_year'               => 'La data de registre de la transacció no és en l\'any ":value"',
    'search_modifier_not_book_date_on_month'              => 'La data de registre de la transacció no és en el mes ":value"',
    'search_modifier_not_book_date_on_day'                => 'La data de registre de la transacció no és en el dia ":value" del mes',
    'search_modifier_book_date_before_year'               => 'La data de registre de la transacció és anterior o igual a l\'any ":value"',
    'search_modifier_book_date_before_month'              => 'La data de registre de la transacció és anterior o igual al mes ":value"',
    'search_modifier_book_date_before_day'                => 'La data de registre de la transacció és anterior o igual al dia ":value" del mes',
    'search_modifier_book_date_after_year'                => 'La data de registre de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_book_date_after_month'               => 'La data de registre de la transacció és igual o posterior al mes ":value"',
    'search_modifier_book_date_after_day'                 => 'La data de registre de la transacció és igual o posterior al dia ":value" del mes',
    'search_modifier_process_date_on_year'                => 'La data de processament de la transacció és en l\'any ":value"',
    'search_modifier_process_date_on_month'               => 'La data de processament de la transacció és en el mes ":value"',
    'search_modifier_process_date_on_day'                 => 'La data de processament de la transacció és en el dia ":value" del mes',
    'search_modifier_not_process_date_on_year'            => 'La data de processament de la transacció no és en l\'any ":value"',
    'search_modifier_not_process_date_on_month'           => 'La data de processament de la transacció no és en el mes ":value"',
    'search_modifier_not_process_date_on_day'             => 'La data de processament de la transacció no és en el dia ":value" del mes',
    'search_modifier_process_date_before_year'            => 'La data de processament de la transacció és anterior o igual a l\'any ":value"',
    'search_modifier_process_date_before_month'           => 'La data de processament de la transacció és anterior o igual al mes ":value"',
    'search_modifier_process_date_before_day'             => 'La data de processament de la transacció és anterior o igual al dia ":value" del mes',
    'search_modifier_process_date_after_year'             => 'La data de processament de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_process_date_after_month'            => 'La data de processament de la transacció és igual o posterior al mes ":value"',
    'search_modifier_process_date_after_day'              => 'La data de processament de la transacció és igual o posterior al dia ":value" del mes',
    'search_modifier_due_date_on_year'                    => 'La data de venciment de la transacció és en l\'any ":value"',
    'search_modifier_due_date_on_month'                   => 'La data de venciment de la transacció és en el mes ":value"',
    'search_modifier_due_date_on_day'                     => 'La data de venciment de la transacció és en el dia ":value" del mes',
    'search_modifier_not_due_date_on_year'                => 'La data de venciment de la transacció no és en l\'any ":value"',
    'search_modifier_not_due_date_on_month'               => 'La data de venciment de la transacció no és en el mes ":value"',
    'search_modifier_not_due_date_on_day'                 => 'La data de venciment de la transacció no és en el dia ":value" del mes',
    'search_modifier_due_date_before_year'                => 'La data de venciment de la transacció és anterior o igual a l\'any ":value"',
    'search_modifier_due_date_before_month'               => 'La data de venciment de la transacció és anterior o igual al mes ":value"',
    'search_modifier_due_date_before_day'                 => 'La data de venciment de la transacció és anterior o igual al dia ":value" del mes',
    'search_modifier_due_date_after_year'                 => 'La data de venciment de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_due_date_after_month'                => 'La data de venciment de la transacció és igual o posterior al mes ":value"',
    'search_modifier_due_date_after_day'                  => 'La data de venciment de la transacció és igual o posterior al dia ":value" del mes',
    'search_modifier_payment_date_on_year'                => 'La data de pagament de la transacció és en l\'any ":value"',
    'search_modifier_payment_date_on_month'               => 'La data de pagament de la transacció és en el mes ":value"',
    'search_modifier_payment_date_on_day'                 => 'La data de pagament de la transacció és en el dia ":value" del mes',
    'search_modifier_not_payment_date_on_year'            => 'La data de pagament de la transacció no és en l\'any ":value"',
    'search_modifier_not_payment_date_on_month'           => 'La data de pagament de la transacció no és en el mes ":value"',
    'search_modifier_not_payment_date_on_day'             => 'La data de pagament de la transacció no és en el dia ":value" del mes',
    'search_modifier_payment_date_before_year'            => 'La data de pagament de la transacció és anterior o igual a l\'any ":value"',
    'search_modifier_payment_date_before_month'           => 'La data de pagament de la transacció és anterior o igual al mes ":value"',
    'search_modifier_payment_date_before_day'             => 'La data de pagament de la transacció és anterior o igual al dia ":value" del mes',
    'search_modifier_payment_date_after_year'             => 'La data de pagament de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_payment_date_after_month'            => 'La data de pagament de la transacció és igual o posterior al mes ":value"',
    'search_modifier_payment_date_after_day'              => 'La data de pagament de la transacció és igual o posterior al dia ":value" del mes',
    'search_modifier_invoice_date_on_year'                => 'La data de factura de la transacció és en l\'any ":value"',
    'search_modifier_invoice_date_on_month'               => 'La data de factura de la transacció és en el mes ":value"',
    'search_modifier_invoice_date_on_day'                 => 'La data de factura de la transacció és en el dia ":value" del mes',
    'search_modifier_not_invoice_date_on_year'            => 'La data de factura de la transacció no és en l\'any ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'La data de factura de la transacció no és en el mes ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'La data de factura de la transacció no és en el dia ":value" del mes',
    'search_modifier_invoice_date_before_year'            => 'La data de factura de la transacció és prèvia o igual a l\'any ":value"',
    'search_modifier_invoice_date_before_month'           => 'La data de factura de la transacció és prèvia o igual al mes ":value"',
    'search_modifier_invoice_date_before_day'             => 'La data de factura de la transacció és prèvia o igual al dia ":value" del mes',
    'search_modifier_invoice_date_after_year'             => 'La data de factura de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_invoice_date_after_month'            => 'La data de factura de la transacció és igual o posterior al mes ":value"',
    'search_modifier_invoice_date_after_day'              => 'La data de factura de la transacció és igual o posterior al dia ":value" del mes',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'La transacció es va actualitzar per últim cop l\'any ":value"',
    'search_modifier_updated_at_on_month'                 => 'La transacció es va actualitzar per últim cop el mes ":value"',
    'search_modifier_updated_at_on_day'                   => 'La transacció es va actualitzar per últim el dia ":value" del mes',
    'search_modifier_not_updated_at_on_year'              => 'La transacció no es va actualitzar per últim cop l\'any ":value"',
    'search_modifier_not_updated_at_on_month'             => 'La transacció no es va actualitzar per últim cop el mes ":value"',
    'search_modifier_not_updated_at_on_day'               => 'La transacció no es va actualitzar per últim el dia ":value" del mes',
    'search_modifier_updated_at_before_year'              => 'L\'última data d\'actualització de la transacció és anterior o igual a l\'any ":value"',
    'search_modifier_updated_at_before_month'             => 'La transacció es va actualitzar per últim cop abans o durant el mes ":value"',
    'search_modifier_updated_at_before_day'               => 'La transacció es va actualitzar per últim cop abans o durant el dia ":value" del mes',
    'search_modifier_updated_at_after_year'               => 'L\'última data d\'actualització de la transacció és igual o posterior a l\'any ":value"',
    'search_modifier_updated_at_after_month'              => 'La transacció es va actualitzar per últim cop durant o després del mes ":value"',
    'search_modifier_updated_at_after_day'                => 'La transacció es va actualitzar per últim cop durant o després del dia ":value" del mes',
    'search_modifier_created_at_on_year'                  => 'La transacció es va crear l\'any ":value"',
    'search_modifier_created_at_on_month'                 => 'La transacció es va crear el mes ":value"',
    'search_modifier_created_at_on_day'                   => 'La transacció es va crear el dia ":value" del mes',
    'search_modifier_not_created_at_on_year'              => 'La transacció no es va crear l\'any ":value"',
    'search_modifier_not_created_at_on_month'             => 'La transacció no es va crear el mes ":value"',
    'search_modifier_not_created_at_on_day'               => 'La transacció no es va crear el dia ":value" del mes',
    'search_modifier_created_at_before_year'              => 'L\'any de creació de la transacció és anterior o igual a ":value"',
    'search_modifier_created_at_before_month'             => 'El mes de creació de la transacció és anterior o igual a ":value"',
    'search_modifier_created_at_before_day'               => 'El dia del mes de creació de la transacció és anterior o igual a ":value"',
    'search_modifier_created_at_after_year'               => 'L\'any de creació de la transacció és igual o posterior a ":value"',
    'search_modifier_created_at_after_month'              => 'El mes de creació de la transacció és igual o posterior a ":value"',
    'search_modifier_created_at_after_day'                => 'El dia del mes de creació de la transacció és igual o posterior a ":value"',
    'search_modifier_interest_date_before'                => 'La data d\'interès de la transacció és anterior o igual a ":value"',
    'search_modifier_interest_date_after'                 => 'La data d\'interès de la transacció és igual o posterior a ":value"',
    'search_modifier_book_date_on'                        => 'La data de registre de la transacció és el ":value"',
    'search_modifier_not_book_date_on'                    => 'La data de registre de la transacció no és el ":value"',
    'search_modifier_book_date_before'                    => 'La data de registre de la transacció és anterior o igual a ":value"',
    'search_modifier_book_date_after'                     => 'La data de registre de la transacció és igual o posterior a ":value"',
    'search_modifier_process_date_on'                     => 'La data de processament de la transacció és el ":value"',
    'search_modifier_not_process_date_on'                 => 'La data de processament de la transacció no és el ":value"',
    'search_modifier_process_date_before'                 => 'La data de processament de la transacció és anterior o igual a ":value"',
    'search_modifier_process_date_after'                  => 'La data de processament de la transacció és igual o posterior a ":value"',
    'search_modifier_due_date_on'                         => 'La data de venciment de la transacció és el ":value"',
    'search_modifier_not_due_date_on'                     => 'La data de venciment de la transacció no és el ":value"',
    'search_modifier_due_date_before'                     => 'La data de venciment de la transacció és anterior o igual a ":value"',
    'search_modifier_due_date_after'                      => 'La data de venciment de la transacció és igual o posterior a ":value"',
    'search_modifier_payment_date_on'                     => 'La data de pagament de la transacció és el ":value"',
    'search_modifier_not_payment_date_on'                 => 'La data de pagament de la transacció no és el ":value"',
    'search_modifier_payment_date_before'                 => 'La data de pagament de la transacció és anterior o igual a ":value"',
    'search_modifier_payment_date_after'                  => 'La data de pagament de la transacció és igual o posterior a ":value"',
    'search_modifier_invoice_date_on'                     => 'La data de facturació de la transacció és el ":value"',
    'search_modifier_not_invoice_date_on'                 => 'La data de facturació de la transacció no és el ":value"',
    'search_modifier_invoice_date_before'                 => 'La data de facturació de la transacció és anterior o igual a ":value"',
    'search_modifier_invoice_date_after'                  => 'La data de facturació de la transacció és igual o posterior a ":value"',
    'search_modifier_created_at_on'                       => 'La transacció es va crear el ":value"',
    'search_modifier_not_created_at_on'                   => 'La transacció no es va crear el ":value"',
    'search_modifier_created_at_before'                   => 'La data de creació de la transacció és anterior o igual a ":value"',
    'search_modifier_created_at_after'                    => 'La data de creació de la transacció és igual o posterior a ":value"',
    'search_modifier_updated_at_on'                       => 'La transacció es va actualitzar el ":value"',
    'search_modifier_not_updated_at_on'                   => 'La transacció no es va actualitzar el ":value"',
    'search_modifier_updated_at_before'                   => 'La data d\'actualització de la transacció és anterior o igual a ":value"',
    'search_modifier_updated_at_after'                    => 'La data d\'actualització de la transacció és igual o posterior a ":value"',

    'search_modifier_attachment_name_is'            => 'El nom de qualsevol adjunt és ":value"',
    'search_modifier_attachment_name_contains'      => 'El nom de qualsevol adjunt conté ":value"',
    'search_modifier_attachment_name_starts'        => 'El nom de qualsevol adjunt comença per ":value"',
    'search_modifier_attachment_name_ends'          => 'El nom de qualsevol adjunt acaba amb ":value"',
    'search_modifier_attachment_notes_are'          => 'Les notes de qualsevol adjunt són ":value"',
    'search_modifier_attachment_notes_contains'     => 'Les notes de qualsevol adjunt contenen ":value"',
    'search_modifier_attachment_notes_starts'       => 'Les notes de qualsevol adjunt comencen per ":value"',
    'search_modifier_attachment_notes_ends'         => 'Les notes de qualsevol adjunt acaben amb ":value"',
    'search_modifier_not_attachment_name_is'        => 'El nom de qualsevol adjunt no és ":value"',
    'search_modifier_not_attachment_name_contains'  => 'El nom de qualsevol adjunt no conté ":value"',
    'search_modifier_not_attachment_name_starts'    => 'El nom de qualsevol adjunt no comença per ":value"',
    'search_modifier_not_attachment_name_ends'      => 'El nom de qualsevol adjunt no acaba amb ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Les notes de qualsevol adjunt no són ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Les notes de qualsevol adjunt no contenen ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Les notes de qualsevol adjunt comencen per ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Les notes de qualsevol adjunt no acaben amb ":value"',
    'search_modifier_sepa_ct_is'                    => 'El SEPA CT és ":value"',
    'update_rule_from_query'                        => 'Actualitzar regla ":rule" de la consulta de la cerca',
    'create_rule_from_query'                        => 'Crear regla nova a partir de la consulta de la cerca',
    'rule_from_search_words'                        => 'El motor de regles ha tingut problemes gestionant ":string". La regla suggerida que s\'ajusti a la consulta de cerca pot donar resultats diferents. Si us plau, verifica els activadors de la regla curosament.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'El balanç del compte de destí és exactament ":value"',
    'search_modifier_not_destination_balance_is'    => 'El balanç del compte de destí NO és exactament ":value"',
    'search_modifier_source_balance_is'             => 'El balanç del compte d\'origen és exactament ":value"',
    'search_modifier_not_source_balance_is'         => 'El balanç del compte d\'origen NO és exactament ":value"',

    'search_modifier_destination_balance_lte'     => 'El balanç del compte de destí és menor o igual a ":value"',
    'search_modifier_not_destination_balance_lte' => 'El balanç del compte de destí és més de ":value"',
    'search_modifier_source_balance_lte'          => 'El balanç del compte d\'origen és menor o igual a ":value"',
    'search_modifier_not_source_balance_lte'      => 'El balanç del compte d\'origen és major a ":value"',

    'search_modifier_destination_balance_lt'     => 'El balanç del compte de destí és menor a ":value"',
    'search_modifier_not_destination_balance_lt' => 'El balanç del compte de destí és major o igual a ":value"',
    'search_modifier_source_balance_lt'          => 'El balanç del compte d\'origen és menor a ":value"',
    'search_modifier_not_source_balance_lt'      => 'El balanç del compte d\'origen és major o igual a ":value"',

    'search_modifier_destination_balance_gte'     => 'El balanç del compte de destí és major o igual a ":value"',
    'search_modifier_not_destination_balance_gte' => 'El balanç del compte de destí és menor a ":value"',
    'search_modifier_source_balance_gte'          => 'El balanç del compte d\'origen és major o igual a ":value"',
    'search_modifier_not_source_balance_gte'      => 'El balanç del compte d\'origen és menor a ":value"',

    'search_modifier_destination_balance_gt'              => 'El balanç del compte de destí és més de ":value"',
    'search_modifier_not_destination_balance_gt'          => 'El balanç del compte de destí és menor o igual a ":value"',
    'search_modifier_source_balance_gt'                   => 'El balanç del compte d\'origen és major a ":value"',
    'search_modifier_not_source_balance_gt'               => 'El balanç del compte d\'origen és menor o igual a ":value"',


    // END
    'general_search_error'                                => 'Ha succeït un error durant la cerca. Si us plau, comprova els fitxers de registre per obtenir més informació.',
    'search_box'                                          => 'Cercar',
    'search_box_intro'                                    => 'Benvingut a la funció de cerca de Firefly III. Introdueix la consulta de cerca al requadre. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Assegura\'t de comprovar l\'arxiu d\'ajuda</a>, ja que el cercador és bastant avançat.',
    'search_error'                                        => 'Error durant la cerca',
    'search_searching'                                    => 'Cercant ...',
    'search_results'                                      => 'Resultats de la cerca',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'anualment',
    'repeat_freq_half-year'                               => 'cada mig any',
    'repeat_freq_quarterly'                               => 'trimestralment',
    'repeat_freq_monthly'                                 => 'mensualment',
    'repeat_freq_weekly'                                  => 'setmanalment',
    'repeat_freq_daily'                                   => 'diàriament',
    'daily'                                               => 'diàriament',
    'weekly'                                              => 'setmanalment',
    'quarterly'                                           => 'trimestralment',
    'half-year'                                           => 'cada mig any',
    'yearly'                                              => 'anualment',

    // rules
    'is_not_rule_trigger'                                 => 'No',
    'cannot_fire_inactive_rules'                          => 'No pots executar regles inactives.',
    'show_triggers'                                       => 'Mostra els activadors',
    'show_actions'                                        => 'Mostra les accions',
    'rules'                                               => 'Regles',
    'rule_name'                                           => 'Nom de la regla',
    'rule_triggers'                                       => 'La regla s\'activa quan',
    'rule_actions'                                        => 'La regla serà',
    'new_rule'                                            => 'Nova regla',
    'new_rule_group'                                      => 'Nou grup de regles',
    'rule_priority_up'                                    => 'Donar més prioritat a la regla',
    'rule_priority_down'                                  => 'Donar menys prioritat a la regla',
    'make_new_rule_group'                                 => 'Crear un nou grup de regles',
    'store_new_rule_group'                                => 'Guardar nou grup de regles',
    'created_new_rule_group'                              => 'Nou grup de regles ":title" guardat!',
    'updated_rule_group'                                  => 'Grup de regles ":title" actualitzat satisfactòriament.',
    'edit_rule_group'                                     => 'Editar grup de regles ":title"',
    'duplicate_rule'                                      => 'Duplicar regla ":title"',
    'rule_copy_of'                                        => 'Còpia de ":title"',
    'duplicated_rule'                                     => 'Regla ":title" duplicada a ":newTitle"',
    'delete_rule_group'                                   => 'Eliminar grup de regles ":title"',
    'deleted_rule_group'                                  => 'Grup de regles ":title" eliminat',
    'update_rule_group'                                   => 'Actualitzar grup de regles',
    'no_rules_in_group'                                   => 'No hi ha regles en aquest grup',
    'move_rule_group_up'                                  => 'Moure grup de regles amunt',
    'move_rule_group_down'                                => 'Moure grup de regles avall',
    'save_rules_by_moving'                                => 'Guardar aquesta regla movent-la a un altre grup de regles:|Guardar aquestes regles movent-les a un altre grup de regles:',
    'make_new_rule'                                       => 'Crea una nova regla al grup de regles ":title"',
    'make_new_rule_no_group'                              => 'Crea una nova regla',
    'instructions_rule_from_bill'                         => 'Per tal de fer coincidir les transaccions a la teva nova factura ":name", FIrefly III pot crear una regla que comprovi automàticament totes les transaccions que guardis. Si us plau, verifica els detalls a sota i guarda la regla perque Firefly III faci coincidir automàticament les transaccions a la teva nova subscripció.',
    'instructions_rule_from_journal'                      => 'Crea una regla basada en una de les teves transaccions. Complementa o envia el següent formulari.',
    'rule_is_strict'                                      => 'regla estricta',
    'rule_is_not_strict'                                  => 'regla no estricta',
    'rule_help_stop_processing'                           => 'Quan marques aquesta casella, les regles futures d\'aquest grup no seran executades quan s\'executi aquesta regla.',
    'rule_help_strict'                                    => 'En les regles estrictes TOTS els activadors s\'han d\'activar per tal que la/les acció/ns s\'executin. En les regles no estrictes, QUALSEVOL activador és suficient per executar la/les acció/ns.',
    'rule_help_active'                                    => 'Les regles inactives no s\'activaran mai.',
    'stored_new_rule'                                     => 'S\'ha guardat una nova regla amb títol ":title"',
    'deleted_rule'                                        => 'S\'ha eliminat la regla amb títol ":title"',
    'store_new_rule'                                      => 'Guardar nova regla',
    'updated_rule'                                        => 'S\'ha actualitzat la regla amb títol ":title"',
    'default_rule_group_name'                             => 'Regles per defecte',
    'default_rule_group_description'                      => 'Totes les regles sense grup específic.',
    'trigger'                                             => 'Activador',
    'trigger_value'                                       => 'Activador en el valor',
    'stop_processing_other_triggers'                      => 'Aturar el processament d\'altres activadors',
    'add_rule_trigger'                                    => 'Afegir nou activador',
    'action'                                              => 'Acció',
    'action_value'                                        => 'Valor de l\'acció',
    'stop_executing_other_actions'                        => 'Aturar l\'execució d\'altres accions',
    'add_rule_action'                                     => 'Afegir nova acció',
    'edit_rule'                                           => 'Editar regla #:nr ":title"',
    'delete_rule'                                         => 'Eliminar regla ":title"',
    'update_rule'                                         => 'Actualitzar regla',
    'test_rule_triggers'                                  => 'Mostrar transaccions coincidents',
    'warning_no_matching_transactions'                    => 'No s\'han trobat transaccions coincidents.',
    'warning_no_valid_triggers'                           => 'No s\'han proporcionat activadors vàlids.',
    'apply_rule_selection'                                => 'Aplicar la regla ":title" a una selecció de transaccions',
    'apply_rule_selection_intro'                          => 'Les regles com ":title" normalment només s\'apliquen a transaccions noves o actualitzades, però li pots indicar a Firefly III que l\'executi en una selecció de transaccions existents. Això pot ser útil quan has actualitzat una regla i necessites que els canvis s\'apliquin a totes les teves transaccions.',
    'include_transactions_from_accounts'                  => 'Incloure transaccions d\'aquests comptes',
    'include'                                             => 'Incloure?',
    'applied_rule_selection'                              => '{0} Cap transacció de la teva selecció s\'ha canviat per la regla ":title".|[1] Una transacció de la teva selecció s\'ha canviat per la regla ":title".|[2,*] :count transaccions de la teva selecció s\'han canviat per la regla ":title".',
    'execute'                                             => 'Executar',
    'apply_rule_group_selection'                          => 'Aplicar el grup de regles ":title" a una selecció de transaccions',
    'apply_rule_group_selection_intro'                    => 'Els grups de regles com ":title" normalment només s\'aliquen a transaccions noves o actualitzades, però li pots indicar a Firefly III que executi totes les regles d\'aquest grup a una selecció de transaccions existents. Això pot ser útil quan has actualitzat un grup de regles i necessites que els canvis s\'apliquin a totes les teves transaccions.',
    'applied_rule_group_selection'                        => 'El grup de regles ":title" s\'ha aplicat a la teva selecció.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Quan es crea una transacció',
    'rule_trigger_update_journal'                         => 'Quan s\'actualitza una transacció',
    'rule_trigger_manual'                                 => 'Només quan l\'activi un usuari',
    'rule_trigger_user_action'                            => 'L\'acció de l\'usuari és ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'El nom del compte d\'origen comença per..',
    'rule_trigger_source_account_starts'                  => 'El nom del compte d\'origen comença per ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'El nom del compte d\'origen acaba amb..',
    'rule_trigger_source_account_ends'                    => 'El nom del compte d\'origen acaba amb ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'El nom del compte d\'origen és..',
    'rule_trigger_source_account_is'                      => 'El nom del compte d\'origen és ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'El nom del compte d\'origen conté..',
    'rule_trigger_source_account_contains'                => 'El nom del compte d\'origen conté ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'L\'ID d\'un dels comptes és exactament..',
    'rule_trigger_account_id'                             => 'L\'ID d\'un dels comptes és exactament :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'L\'ID del compte d\'origen és exactament..',
    'rule_trigger_source_account_id'                      => 'L\'ID del compte d\'origen és exactament :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'L\'ID del compte de destí és exactament..',
    'rule_trigger_destination_account_id'                 => 'L\'ID del compte de destí és exactament :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Un dels comptes és d\'efectiu',
    'rule_trigger_account_is_cash'                        => 'Un dels comptes és d\'efectiu',
    'rule_trigger_source_is_cash_choice'                  => 'El compte d\'origen és el compte (efectiu)',
    'rule_trigger_source_is_cash'                         => 'El compte d\'origen és el compte (efectiu)',
    'rule_trigger_destination_is_cash_choice'             => 'El compte de destí és el compte (efectiu)',
    'rule_trigger_destination_is_cash'                    => 'El compte de destí és el compte (efectiu)',
    'rule_trigger_source_account_nr_starts_choice'        => 'El número / IBAN del compte d\'origen comença per..',
    'rule_trigger_source_account_nr_starts'               => 'El número / IBAN del compte d\'origen comença per ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'El número / IBAN del compte d\'origen acaba amb..',
    'rule_trigger_source_account_nr_ends'                 => 'El número / IBAN del compte d\'origen acaba amb ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'El número / IBAN del compte d\'origen és..',
    'rule_trigger_source_account_nr_is'                   => 'El número / IBAN del compte d\'origen és ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'El número / IBAN del compte d\'origen conté..',
    'rule_trigger_source_account_nr_contains'             => 'El número / IBAN del compte d\'origen conté ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'El nom del compte de destí comença per..',
    'rule_trigger_destination_account_starts'             => 'El nom del compte de destí comença per ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'El nom del compte de destí acaba amb..',
    'rule_trigger_destination_account_ends'               => 'El nom del compte de destí acaba amb ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'El nom del compte de destí és..',
    'rule_trigger_destination_account_is'                 => 'El nom del compte de destí és ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'El nom del compte de destí conté..',
    'rule_trigger_destination_account_contains'           => 'El nom del compte de destí conté ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'El número / IBAN del compte de destí comença per..',
    'rule_trigger_destination_account_nr_starts'          => 'El número / IBAN del compte de destí comença per ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'El número / IBAN del compte de destí acaba amb..',
    'rule_trigger_destination_account_nr_ends'            => 'El número / IBAN del compte de destí acaba amb ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'El número / IBAN del compte de destí és..',
    'rule_trigger_destination_account_nr_is'              => 'El número / IBAN del compte de destí és ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'El número / IBAN del compte de destí conté..',
    'rule_trigger_destination_account_nr_contains'        => 'El número / IBAN del compte de destí conté ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'La transacció és del tipus..',
    'rule_trigger_transaction_type'                       => 'La transacció és del tipus ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'La categoria és..',
    'rule_trigger_category_is'                            => 'La categoria és ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'La quantitat és menor o igual a ..',
    'rule_trigger_amount_less'                            => 'La quantitat és menor o igual a :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'La quantitat és..',
    'rule_trigger_amount_is'                              => 'La quantitat és :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'La quantitat és major o igual a..',
    'rule_trigger_amount_more'                            => 'La quantitat és major o igual a :trigger_value',
    'rule_trigger_description_starts_choice'              => 'La descripció comença per..',
    'rule_trigger_description_starts'                     => 'La descripció comença per ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'La descripció acaba amb..',
    'rule_trigger_description_ends'                       => 'La descripció acaba amb ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'La descripció conté..',
    'rule_trigger_description_contains'                   => 'La descripció conté ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'La descripció és..',
    'rule_trigger_description_is'                         => 'La descripció és ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'La data de la transacció és..',
    'rule_trigger_date_on'                                => 'La data de la transacció és ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'La data de la transacció és anterior a..',
    'rule_trigger_date_before'                            => 'La data de la transacció és anterior a ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'La data de la transacció és posterior a..',
    'rule_trigger_date_after'                             => 'La data de la transacció és posterior a ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'La transacció es va fer el..',
    'rule_trigger_created_at_on'                          => 'La transacció es va fer el ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'La transacció es va editar per últim cop el..',
    'rule_trigger_updated_at_on'                          => 'La transacció es va editar per últim cop el ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'El pressupost és..',
    'rule_trigger_budget_is'                              => 'El pressupost és ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Qualsevol etiqueta és..',
    'rule_trigger_tag_is'                                 => 'Qualsevol etiqueta és ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Qualsevol etiqueta conté..',
    'rule_trigger_tag_contains'                           => 'Qualsevol etiqueta conté ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Qualsevol etiqueta acaba amb..',
    'rule_trigger_tag_ends'                               => 'Qualsevol etiqueta acaba amb ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Qualsevol etiqueta comença amb..',
    'rule_trigger_tag_starts'                             => 'Qualsevol etiqueta comença amb ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'La moneda de la transacció és..',
    'rule_trigger_currency_is'                            => 'La moneda de la transacció és ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'La moneda estrangera de la transacció és..',
    'rule_trigger_foreign_currency_is'                    => 'La moneda estrangera de la transacció és ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Té qualsevol adjunt',
    'rule_trigger_has_attachments'                        => 'Té qualsevol adjunt(s)',
    'rule_trigger_has_no_category_choice'                 => 'No té categoria',
    'rule_trigger_has_no_category'                        => 'La transacció no té categoria',
    'rule_trigger_has_any_category_choice'                => 'Té categoria (qualsevol)',
    'rule_trigger_has_any_category'                       => 'La transacció té almenys una categoria (qualsevol)',
    'rule_trigger_has_no_budget_choice'                   => 'No té pressupost',
    'rule_trigger_has_no_budget'                          => 'La transacció no té pressupost',
    'rule_trigger_has_any_budget_choice'                  => 'Té un pressupost (qualsevol)',
    'rule_trigger_has_any_budget'                         => 'La transacció té almenys un pressupost (qualsevol)',
    'rule_trigger_has_no_bill_choice'                     => 'No té cap subscripció',
    'rule_trigger_has_no_bill'                            => 'La transacció no té cap subscripció',
    'rule_trigger_has_any_bill_choice'                    => 'Té una subscripció',
    'rule_trigger_has_any_bill'                           => 'No transacció té una subscripció',
    'rule_trigger_has_no_tag_choice'                      => 'No té etiqueta(es)',
    'rule_trigger_has_no_tag'                             => 'La transacció no té etiqueta(es)',
    'rule_trigger_has_any_tag_choice'                     => 'Té una o més etiquetes (qualsevol)',
    'rule_trigger_has_any_tag'                            => 'La transacció té una o més etiquetes (qualsevol)',
    'rule_trigger_any_notes_choice'                       => 'Té notes (qualsevol)',
    'rule_trigger_any_notes'                              => 'La transacció té notes (qualsevol)',
    'rule_trigger_no_notes_choice'                        => 'No té notes',
    'rule_trigger_no_notes'                               => 'La transacció no té notes',
    'rule_trigger_notes_is_choice'                        => 'Les notes són..',
    'rule_trigger_notes_is'                               => 'Les notes són ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Les notes contenen..',
    'rule_trigger_notes_contains'                         => 'Les notes contenen ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Les notes comencen per..',
    'rule_trigger_notes_starts'                           => 'Les notes comencen per ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Les notes acaben amb..',
    'rule_trigger_notes_ends'                             => 'Les notes acaben amb ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'La subscrició és..',
    'rule_trigger_bill_is'                                => 'La subscripció és ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'L\'ID externa és..',
    'rule_trigger_external_id_is'                         => 'L\'ID externa és ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'La referència interna és..',
    'rule_trigger_internal_reference_is'                  => 'La referència interna és ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'L\'ID del llibre de transaccions és..',
    'rule_trigger_journal_id'                             => 'L\'ID del llibre de transaccions és ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'La transació té (cap) URL externa',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'La transació té (cap) ID extern',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'La transacció no té URL extern',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'La transacció no té cap ID extern',
    'rule_trigger_id_choice'                              => 'L\'ID de la transacció és..',
    'rule_trigger_id'                                     => 'L\'ID de la transacció és ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'El SEPA CT és..',
    'rule_trigger_sepa_ct_is'                             => 'El SEPA CT és ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'L\'acció d\'usuari és ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Cap etiqueta és..',
    'rule_trigger_tag_is_not'                             => 'Cap etiqueta és ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Un dels comptes és exactament..',
    'rule_trigger_account_is'                             => 'Un dels comptes és exactament ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Un dels comptes conté..',
    'rule_trigger_account_contains'                       => 'Un dels comptes conté ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Un dels comptes acaba amb..',
    'rule_trigger_account_ends'                           => 'Un dels comptes acaba amb ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Un dels comptes comença per..',
    'rule_trigger_account_starts'                         => 'Un dels comptes comença per ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'El número / IBAN d\'un dels comptes és..',
    'rule_trigger_account_nr_is'                          => 'El número / IBAN d\'un dels comptes és ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'El número / IBAN d\'un dels comptes conté..',
    'rule_trigger_account_nr_contains'                    => 'El número / IBAN d\'un dels comptes conté ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'El número / IBAN d\'un dels comptes acaba amb..',
    'rule_trigger_account_nr_ends'                        => 'El número / IBAN d\'un dels comptes acaba amb ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'El número / IBAN d\'un dels comptes comença per..',
    'rule_trigger_account_nr_starts'                      => 'El número / IBAN d\'un dels comptes comença per ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'La categoria conté..',
    'rule_trigger_category_contains'                      => 'La categoria conté ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'La categoria acaba amb..',
    'rule_trigger_category_ends'                          => 'La categoria acaba amb ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'La categoria comença per..',
    'rule_trigger_category_starts'                        => 'La categoria comença per ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'El pressupost conté..',
    'rule_trigger_budget_contains'                        => 'El pressupost conté ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'El pressupost acaba amb..',
    'rule_trigger_budget_ends'                            => 'El pressupost acaba amb ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'El pressupost comença per..',
    'rule_trigger_budget_starts'                          => 'El pressupost comença per ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'La subscripció conté..',
    'rule_trigger_bill_contains'                          => 'La subscripció conté ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'La subscripció acaba amb..',
    'rule_trigger_bill_ends'                              => 'La subscripció acaba amb ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'La subscripció comença amb..',
    'rule_trigger_bill_starts'                            => 'La subscripció comença amb ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'L\'ID externa conté..',
    'rule_trigger_external_id_contains'                   => 'L\'ID externa conté ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'L\'ID externa acaba amb..',
    'rule_trigger_external_id_ends'                       => 'L\'ID externa acaba amb ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'L\'ID externa comença per..',
    'rule_trigger_external_id_starts'                     => 'L\'ID externa comença per ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'La referència interna conté..',
    'rule_trigger_internal_reference_contains'            => 'La referència interna conté ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'La referència interna acaba amb..',
    'rule_trigger_internal_reference_ends'                => 'La referència interna acaba amb ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'La referència interna comença per..',
    'rule_trigger_internal_reference_starts'              => 'La referència interna comença per ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'L\'URL extern és..',
    'rule_trigger_external_url_is'                        => 'L\'URL extern és ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'L\'URL extern conté..',
    'rule_trigger_external_url_contains'                  => 'L\'URL extern conté ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'L\'URL extern acaba amb..',
    'rule_trigger_external_url_ends'                      => 'L\'URL extern acaba amb ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'L\'URL extern comença per..',
    'rule_trigger_external_url_starts'                    => 'L\'URL extern comença per ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'No té adjunts',
    'rule_trigger_has_no_attachments'                     => 'La transacció no té fitxers adjunts',
    'rule_trigger_recurrence_id_choice'                   => 'L\'ID de la transacció periòdica és..',
    'rule_trigger_recurrence_id'                          => 'L\'ID de la transacció periòdica és ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'La data d\'interès és..',
    'rule_trigger_interest_date_on'                       => 'La data d\'interès és ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'La data d\'interès és anterior a..',
    'rule_trigger_interest_date_before'                   => 'La data d\'interès és anterior a ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'La data d\'interès és posterior a..',
    'rule_trigger_interest_date_after'                    => 'La data d\'interès és posterior a ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'La data de reserva és..',
    'rule_trigger_book_date_on'                           => 'La data de reserva és ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'La data de reserva és anterior a..',
    'rule_trigger_book_date_before'                       => 'La data de reserva és anterior a ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'La data de reserva és posterior a..',
    'rule_trigger_book_date_after'                        => 'La data de reserva és posterior a ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'La data de processament és..',
    'rule_trigger_process_date_on'                        => 'La data de processament és ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'La data de processament és anterior a..',
    'rule_trigger_process_date_before'                    => 'La data de processament és anterior a ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'La data de processament és posterior a..',
    'rule_trigger_process_date_after'                     => 'La data de processament és posterior a ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'La data de venciment és..',
    'rule_trigger_due_date_on'                            => 'La data de venciment és ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'La data de venciment és anterior a..',
    'rule_trigger_due_date_before'                        => 'La data de venciment és anterior a ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'La data de venciment és posterior a..',
    'rule_trigger_due_date_after'                         => 'La data de venciment és posterior a ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'La data de pagament és..',
    'rule_trigger_payment_date_on'                        => 'La data de pagament és ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'La data de pagament és anterior a..',
    'rule_trigger_payment_date_before'                    => 'La data de pagament és anterior a ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'La data de pagament és posterior a..',
    'rule_trigger_payment_date_after'                     => 'La data de pagament és posterior a ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'La data de facturació és..',
    'rule_trigger_invoice_date_on'                        => 'La data de facturació és ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'La data de facturació és anterior a..',
    'rule_trigger_invoice_date_before'                    => 'La data de facturació és anterior a ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'La data de facturació és posterior a..',
    'rule_trigger_invoice_date_after'                     => 'La data de facturació és posterior a ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'La transacció es va crear abans de..',
    'rule_trigger_created_at_before'                      => 'La transacció es va crear abans de ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'La transacció es va crear després de..',
    'rule_trigger_created_at_after'                       => 'La transacció es va crear després de ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'La transacció es va actualitzar per últim cop abans de..',
    'rule_trigger_updated_at_before'                      => 'La transacció es va actualitzar per últim cop abans de ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'La transacció es va actualitzar per últim cop després de..',
    'rule_trigger_updated_at_after'                       => 'La transacció es va actualitzar per últim cop després de ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'La quantitat en moneda estrangera és exactament..',
    'rule_trigger_foreign_amount_is'                      => 'La quantitat en moneda estrangera és exactament ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'La quantitat en moneda estrangera és inferior a..',
    'rule_trigger_foreign_amount_less'                    => 'La quantitat en moneda estrangera és inferior a ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'La quantitat en moneda estrangera és superior a..',
    'rule_trigger_foreign_amount_more'                    => 'La quantitat en moneda estrangera és superior a ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'El nom de qualsevol adjunt és..',
    'rule_trigger_attachment_name_is'                     => 'El nom de qualsevol adjunt és ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'El nom de qualsevol adjunt conté..',
    'rule_trigger_attachment_name_contains'               => 'El nom de qualsevol adjunt conté ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'El nom de qualsevol adjunt comença per..',
    'rule_trigger_attachment_name_starts'                 => 'El nom de qualsevol adjunt comença per ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'El nom de qualsevol adjunt acaba amb..',
    'rule_trigger_attachment_name_ends'                   => 'El nom de qualsevol adjunt acaba amb ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Les notes de qualsevol adjunt són..',
    'rule_trigger_attachment_notes_are'                   => 'Les notes de qualsevol adjunt són ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Les notes de qualsevol adjunt contenen..',
    'rule_trigger_attachment_notes_contains'              => 'Les notes de qualsevol adjunt contenen ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Les notes de qualsevol adjunt comencen per..',
    'rule_trigger_attachment_notes_starts'                => 'Les notes de qualsevol adjunt comencen per ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Les notes de qualsevol adjunt acaben amb..',
    'rule_trigger_attachment_notes_ends'                  => 'Les notes de qualsevol adjunt acaben amb ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'La transacció s\'ha consolidat',
    'rule_trigger_reconciled'                             => 'La transacció s\'ha consolidat',
    'rule_trigger_exists_choice'                          => 'Qualsevol transacció coincideix(!)',
    'rule_trigger_exists'                                 => 'Qualsevol transacció coincideix',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'L\'ID del compte no és ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'L\'ID del compte d\'origen no és ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'L\'ID del compte de destí no és ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'El tipus de transacció no és ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'L\'etiqueta no és ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'L\'etiqueta és ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'La descripció no és ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'La descripció no acaba amb ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'La descripció no comença per ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Les notes no són ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Les notes no contenen ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Les notes no acaben amb ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Les notes no comencen per ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'El compte d\'origen no és ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'El compte d\'origen no conté ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'El compte d\'origen no acaba amb ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'El compte d\'origen no comença per ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'El número / IBAN del compte d\'origen no és ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'El número / IBAN del compte d\'origen no conté ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'El número / IBAN del compte d\'origen no acaba amb ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'El número / IBAN del compte d\'origen no comença per ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'El compte de destí no és ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'El compte de destí no conté ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'El compte de destí no acaba amb ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'El compte de destí no comença per ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'El número / IBAN del compte de destí no és ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'El número / IBAN del compte de destí no conté ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'El número / IBAN del compte de destí no acaba amb ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'El número / IBAN del compte de destí no comença per ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Cap dels comptes és ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Cap dels comptes conté ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Cap dels comptes acaba amb ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Cap dels comptes comença per ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Cap número de compte / IBAN és ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Cap número de compte / IBAN conté ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Cap número de compte / IBAN acaba amb ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Cap número de compte / IBAN comença per ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'La categoria no és ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'La categoria no conté ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'La categoria no acaba en ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'La categoria no comença per ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'El pressupost no és ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'El pressupost no conté ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'El pressupost no acaba en ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'El pressupost no comença amb ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'La subscripció no és ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'La subscripció no conté ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'La subscripció no acaba amb ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'La subscripció no acaba amb ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'L\'ID externa no és ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'L\'ID externa no conté ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'L\'ID externa no acaba amb ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'L\'ID externa no comença per ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'La referència interna no és ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'La referència interna no conté ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'La referència interna no acaba amb ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'La referència interna no comença per ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'L\'URL extern no és ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'L\'URL extern no conté ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'L\'URL extern no acaba amb ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'L\'URL extern no comença per ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'La moneda no és ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'La moneda estrangera no és ":trigger_value"',
    'rule_trigger_not_id'                                 => 'L\'ID de la transacció no és ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'L\'ID del llibre de transaccions no és ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'L\'ID periòdica no és ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'La data no és ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'La data no és anterior a ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'La data no és posterior a ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'La data d\'interès no és ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'La data d\'interès no és anterior a ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'La data d\'interès no és posterior a ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'La data de reserva no és ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'La data de reserva no és anterior a ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'La data de reserva no és posterior a ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'La data de processament no és ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'La data de processament no és anterior a ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'La data de processament no és posterior a ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'La data de venciment no és ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'La data de venciment no és anterior a ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'La data de venciment no és posterior a ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'La data de pagament no és ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'La data de pagament no és anterior a ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'La data de pagament no és posterior a ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'La data de facturació no és ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'La data de facturació no és anterior a ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'La data de facturació no és posterior a ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'La transacció no es va crear el ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'La transacció no es va crear abans de ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'La transacció no es va crear després de ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'La transacció no es va actualitzar el ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'La transacció no es va actualitzar abans de ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'La transacció no es va actualitzar després de ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'La quantitat de la transacció no és ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'La quantitat de la transacció és superior a ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'La quantitat de la transacció és inferior a ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'La quantitat en moneda estrangera no és ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'La quantitat en moneda estrangera és superior a ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'La quantitat en moneda estrangera és inferior a ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Cap adjunt té per nom ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Cap nom d\'adjunt conté ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Cap nom d\'adjunt comença per ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Cap nom d\'adjunt acaba amb ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Cap nota d\'adjunt és ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Cap nota d\'adjunt conté ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Cap nota d\'adjunt comença per ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Cap nota d\'adjunt acaba amb ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'La transacció no s\'ha consolidat',
    'rule_trigger_not_exists'                             => 'La transacció no existeix',
    'rule_trigger_not_has_attachments'                    => 'La transacció no té fitxers adjunts',
    'rule_trigger_not_has_any_category'                   => 'La transacció no té categoria',
    'rule_trigger_not_has_any_budget'                     => 'La transacció no té pressupost',
    'rule_trigger_not_has_any_bill'                       => 'La transacció no té cap subscripció',
    'rule_trigger_not_has_any_tag'                        => 'La transacció no té etiquetes',
    'rule_trigger_not_any_notes'                          => 'La transacció no té notes',
    'rule_trigger_not_any_external_url'                   => 'La transacció no té URL extern',
    'rule_trigger_not_has_no_attachments'                 => 'La transacció té almenys un fitxer adjunt (qualsevol)',
    'rule_trigger_not_has_no_category'                    => 'La transacció té almenys una categoria (qualsevol)',
    'rule_trigger_not_has_no_budget'                      => 'La transacció té almenys un pressupost (qualsevol)',
    'rule_trigger_not_has_no_bill'                        => 'La transacció té una subscripció',
    'rule_trigger_not_has_no_tag'                         => 'La transacció té almenys una etiqueta (qualsevol)',
    'rule_trigger_not_no_notes'                           => 'La transacció té almenys una nota',
    'rule_trigger_not_no_external_url'                    => 'La transacció té un URL extern',
    'rule_trigger_not_source_is_cash'                     => 'El compte d\'origen no és un compte d\'efectiu',
    'rule_trigger_not_destination_is_cash'                => 'El compte de destí no és un compte d\'efectiu',
    'rule_trigger_not_account_is_cash'                    => 'Cap dels comptes és un compte d\'efectiu',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'El balanç del compte de destí és major a..',
    'rule_trigger_destination_balance_gte_choice'         => 'El balanç del compte de destí és major o igual a..',
    'rule_trigger_destination_balance_is_choice'          => 'El balanç del compte de destí és exactament..',
    'rule_trigger_destination_balance_lt_choice'          => 'El balanç del compte de destí és menor a..',
    'rule_trigger_destination_balance_lte_choice'         => 'El balanç del compte de destí és menor o igual a..',

    'rule_trigger_source_balance_gt_choice'  => 'El balanç del compte d\'origen és major a..',
    'rule_trigger_source_balance_gte_choice' => 'El balanç del compte d\'origen és major o igual a..',
    'rule_trigger_source_balance_is_choice'  => 'El balanç del compte d\'origen és exactament..',
    'rule_trigger_source_balance_lt_choice'  => 'El balanç del compte d\'origen és menor a..',
    'rule_trigger_source_balance_lte_choice' => 'El balanç del compte d\'origen és menor o igual a..',

    'rule_trigger_destination_balance_gt'  => 'El balanç del compte de destí és major a :trigger_value',
    'rule_trigger_destination_balance_gte' => 'El balanç del compte de destí és major o igual a :trigger_value',
    'rule_trigger_destination_balance_is'  => 'El balanç del compte de destí és exactament :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'El balanç del compte de destí és menor a :trigger_value',
    'rule_trigger_destination_balance_lte' => 'El balanç del compte de destí és menor o igual a :trigger_value',

    'rule_trigger_source_balance_gt'           => 'El balanç del compte d\'origen és major a :trigger_value',
    'rule_trigger_source_balance_gte'          => 'El balanç del compte d\'origen és major o igual a :trigger_value',
    'rule_trigger_source_balance_is'           => 'El balanç del compte d\'origen és exactament :trigger_value',
    'rule_trigger_source_balance_lt'           => 'El balanç del compte d\'origen és menor a :trigger_value',
    'rule_trigger_source_balance_lte'          => 'El balanç del compte d\'origen és menor o igual a :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'El balanç del compte de destí és menor o igual a :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'El balanç del compte de destí és menor a :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'El balanç del compte de destí no és :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'El balanç del compte de destí és major o igual a :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'El balanç del compte de destí és major a :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'El balanç del compte d\'origen és menor o igual a :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'El balanç del compte d\'origen és menor a :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'El balanç del compte d\'origen no és :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'El balanç del compte d\'origen és major o igual a :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'El balanç del compte d\'origen és major a :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'ELIMINAR transacció(!)',
    'rule_action_delete_transaction'             => 'ELIMINAR transacció(!)',
    'rule_action_set_category'                   => 'Estableix categoria a ":action_value"',
    'rule_action_clear_category'                 => 'Esborrar categoria',
    'rule_action_set_budget'                     => 'Establir pressupost a ":action_value"',
    'rule_action_clear_budget'                   => 'Esborrar pressupost',
    'rule_action_add_tag'                        => 'Afegir etiqueta ":action_value"',
    'rule_action_remove_tag'                     => 'Eliminar etiqueta ":action_value"',
    'rule_action_remove_all_tags'                => 'Eliminar totes les etiquetes',
    'rule_action_set_description'                => 'Establir descripció com ":action_value"',
    'rule_action_append_description'             => 'Afegir ":action_value" a la descripció',
    'rule_action_prepend_description'            => 'Preposa ":action_value" a la descripció',
    'rule_action_set_category_choice'            => 'Establir categoria a ..',
    'rule_action_clear_category_choice'          => 'Esborrar qualsevol categoria',
    'rule_action_set_budget_choice'              => 'Establir pressupost a ..',
    'rule_action_clear_budget_choice'            => 'Esborrar qualsevol pressupost',
    'rule_action_add_tag_choice'                 => 'Afegir etiqueta ..',
    'rule_action_remove_tag_choice'              => 'Eliminar etiqueta ..',
    'rule_action_remove_all_tags_choice'         => 'Eliminar totes les etiquetes',
    'rule_action_set_description_choice'         => 'Estableix la descripció a ..',
    'rule_action_update_piggy_choice'            => 'Afegir/eliminar la quantitat de la transacció a/de la guardiola ..',
    'rule_action_update_piggy'                   => 'Afegir/eliminar la quantitat de la transacció a/de la guardiola ":action_value"',
    'rule_action_append_description_choice'      => 'Afegir a la descripció ..',
    'rule_action_prepend_description_choice'     => 'Preposar a la descripció ..',
    'rule_action_set_source_account_choice'      => 'Establir el compte d\'origen a ..',
    'rule_action_set_source_account'             => 'Establir el compte d\'origen a :action_value',
    'rule_action_set_destination_account_choice' => 'Establir el compte de destí a ..',
    'rule_action_set_destination_account'        => 'Establir el compte de destí a :action_value',
    'rule_action_append_notes_choice'            => 'Afegir a les notes ..',
    'rule_action_append_notes'                   => 'Afegir ":action_value" a les notes',
    'rule_action_prepend_notes_choice'           => 'Preposar a les notes ..',
    'rule_action_prepend_notes'                  => 'Preposa ":action_value" a les notes',
    'rule_action_clear_notes_choice'             => 'Eliminar qualsevol nota',
    'rule_action_clear_notes'                    => 'Eliminar qualsevol nota',
    'rule_action_set_notes_choice'               => 'Establir les notes a ..',
    'rule_action_link_to_bill_choice'            => 'Enllaça a una subscripció ..',
    'rule_action_link_to_bill'                   => 'Enllaça a la subscripció ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Canvia els comptes font i destí (només transferències!)',
    'rule_action_switch_accounts'                => 'Canvia font i destí',
    'rule_action_set_notes'                      => 'Establir notes a ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Convertir la transacció a un dipòsit',
    'rule_action_convert_deposit'                => 'Convertir la transacció a un dipòsit de ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Convertir la transacció en una retirada',
    'rule_action_convert_withdrawal'             => 'Convertir la transacció en una retirada a ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Convertir la transacció en una transferència',
    'rule_action_convert_transfer'               => 'Convertir la transacció en una transferència a ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Afegir la descripció a les notes de la transacció',
    'rule_action_append_notes_to_descr_choice'   => 'Afegir les notes de la transacció a la descripció',
    'rule_action_move_descr_to_notes_choice'     => 'Substituir les notes de la transacció actual amb la descripció',
    'rule_action_move_notes_to_descr_choice'     => 'Substituir la descripció actual amb les notes de la transacció',
    'rule_action_append_descr_to_notes'          => 'Afegir la descripció a les notes',
    'rule_action_append_notes_to_descr'          => 'Afegir notes a la descripció',
    'rule_action_move_descr_to_notes'            => 'Substituir les notes per la descripció',
    'rule_action_move_notes_to_descr'            => 'Substituir la descripció per les notes',
    'rule_action_set_amount_choice'              => 'Estableix quantitat a ..',
    'rule_action_set_amount'                     => 'Estableix quantitat a ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Establir el compte destí a (efectiu)',
    'rule_action_set_source_to_cash_choice'      => 'Establir el compte font a (efectiu)',
    'rulegroup_for_bills_title'                  => 'Grup de regles per a subscripcions',
    'rulegroup_for_bills_description'            => 'Un grup de regles especial per totes les regles que involucren subscripcions.',
    'rule_for_bill_title'                        => 'Regla autogenerada per la subscripció ":name"',
    'rule_for_bill_description'                  => 'Aquesta regla s\'ha autogenerat per intentar trobar la coincidència amb la subscripció ":name".',
    'create_rule_for_bill'                       => 'Crear una regla nova per la subscripció ":name"',
    'create_rule_for_bill_txt'                   => 'Acabes de crear una nova subscripció anomenada ":name", felicitats! Firefly III pot fer correspondre màgicament noves retirades a aquesta subscripció. Per exemple, quan paguis el lloguer, la subscripció "lloguer" s\'enllaçarà a la despesa. D\'aquesta manera, Firefly III pot mostrar amb precisió quines subscripcions han vençut i quines no. Per a fer això, s\'ha de crear una nova regla. Firefly III ha omplert alguns valors per tu. Si us plau, comprova que són correctes. Si els valors són correctes, Firefly III enllaçarà automàticament la retirada a la subscripció correcta. Si us plau, comprova els activadors per veure si són correctes, i afegeix-ne si són incorrectes.',
    'new_rule_for_bill_title'                    => 'Regla per a la subscripció ":name"',
    'new_rule_for_bill_description'              => 'Aquesta regla marca les transaccions per la subscripció ":name".',

    'new_rule_for_journal_title'                => 'Regla basada en la transacció ":description"',
    'new_rule_for_journal_description'          => 'Aquesta regla està basada en la transacció ":description". Farà coincidència amb les transaccions que siguin exactament iguals.',

    // tags
    'store_new_tag'                             => 'Guardar nova etiqueta',
    'update_tag'                                => 'Actualitzar etiqueta',
    'no_location_set'                           => 'Ubicació no establerta.',
    'meta_data'                                 => 'Meta dades',
    'location'                                  => 'Ubicació',
    'location_first_split'                      => 'La ubicació d\'aquesta transacció pot ser establerta a la primera divisió de la transacció.',
    'without_date'                              => 'Sense data',
    'result'                                    => 'Resultat',
    'sums_apply_to_range'                       => 'Totes les sumes s\'apliquen al rang seleccionat',
    'mapbox_api_key'                            => 'Per fer servir el mapa, aconsegueix una clau API de <a href="https://www.mapbox.com/">Mapbox</a>. Obre el fitxer <code>.env</code> i introdueix-hi el codi després de <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Botó dret o premi de forma prolongada per definir la ubicació de l\'objecte.',
    'click_tap_location'                        => 'Fes clic o toca el mapa per afegir una ubicació',
    'clear_location'                            => 'Netejar ubicació',
    'delete_all_selected_tags'                  => 'Eliminar totes les etiquetes seleccionades',
    'select_tags_to_delete'                     => 'No t\'oblidis de seleccionar alguna etiqueta.',
    'deleted_x_tags'                            => ':count etiqueta eliminada.|:count etiquetes eliminades.',
    'create_rule_from_transaction'              => 'Crear regla basada en la transacció',
    'create_recurring_from_transaction'         => 'Crear transacció periòdica basada en la transacció',

    // preferences
    'test_notifications_buttons'                => 'Per a provar la teva configuració, fes servir els botons de sota. Per favor, tingues en compte que els botons no tenen control de brossa.',
    'dark_mode_option_browser'                  => 'Deixa que el navegador decideixi',
    'dark_mode_option_light'                    => 'Sempre Clar',
    'dark_mode_option_dark'                     => 'Sempre fosc',
    'equal_to_language'                         => '(igual a l\'idioma)',
    'dark_mode_preference'                      => 'Mode fosc',
    'dark_mode_preference_help'                 => 'Digues quan vols que Firefly III faci servir el tema fosc.',
    'pref_home_screen_accounts'                 => 'Comptes a la pantalla d\'inici',
    'pref_home_screen_accounts_help'            => 'Quins comptes s\'han de mostrar a la pàgina d\'inici?',
    'pref_view_range'                           => 'Interval de visió',
    'pref_view_range_help'                      => 'Algunes gràfiques s\'agrupen automàticament en períodes. Els teus pressuposts també s\'agruparan en períodes. Quin període prefereixes?',
    'pref_1D'                                   => 'Un dia',
    'pref_1W'                                   => 'Una setmana',
    'pref_1M'                                   => 'Un mes',
    'pref_3M'                                   => 'Tres mesos (trimestre)',
    'pref_6M'                                   => 'Sis mesos',
    'pref_1Y'                                   => 'Un any',
    'pref_last365'                              => 'L\'any passat',
    'pref_last90'                               => 'Últims 90 dies',
    'pref_last30'                               => 'Últims 30 dies',
    'pref_last7'                                => 'Últims 7 dies',
    'pref_YTD'                                  => 'Any en curs',
    'pref_QTD'                                  => 'Trimestre en curs',
    'pref_MTD'                                  => 'Mes en curs',
    'pref_languages'                            => 'Idiomes',
    'pref_locale'                               => 'Preferències d\'idioma',
    'pref_languages_help'                       => 'Firefly III suporta diversos idiomes. Quin prefereixes?',
    'pref_locale_help'                          => 'Firefly III et permet configurar altres paràmetres locals, com el format de les monedes, números i dates. Algunes entrades de la llista podrien no estar suportades pel teu sistema. Firefly III no té els paràmetres correctes per les dates en tots els idiomes; contacta amb mi per obtenir millores.',
    'pref_locale_no_demo'                       => 'Aquesta característica no funciona per l\'usuari de demostració.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Preferències de l\'any fiscal',
    'pref_custom_fiscal_year_label'             => 'Activat',
    'pref_custom_fiscal_year_help'              => 'Pels països que fan servir anys fiscals diferents de l\'1 de gener al 31 de desembre, pots canviar-ho especificant els dies d\'inici / final de l\'any fiscal',
    'pref_fiscal_year_start_label'              => 'Data d\'inici de l\'any fiscal',
    'pref_two_factor_auth'                      => 'Autenticació multifactor',
    'pref_two_factor_auth_help'                 => 'Quan actives la verificació multifactor (també coneguda com a autenticació en dues passes), afegeixes una capa addicional de seguretat al teu compte. Inicies sessió amb una cosa que coneixes (la teva contrasenya) i una cosa que tens (un codi de verificació). Els codis de verificació es generen amb una aplicació al teu telèfon, com per exemple Authy o Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Activar l\'autenticació multifactor',
    'pref_two_factor_auth_disabled'             => 'S\'ha eliminat i desactivat el codi de verificació multi-factor',
    'pref_two_factor_auth_remove_it'            => 'No t\'oblidis d\'eliminar el compte de la teva aplicació d\'autenticació!',
    'pref_two_factor_auth_code'                 => 'Verificar el codi',
    'pref_two_factor_auth_code_help'            => 'Escaneja el codi QR amb una aplicació del teu telèfon com ara Authy o Google Authenticator i introdueix el codi generat. El codi QR canvia cada vegada que visites aquesta pàgina. Assegura\'t d\'utilitzar el més recent.',
    'pref_two_factor_auth_reset_code'           => 'Reiniciar codi de verificació',
    'pref_two_factor_auth_disable_2fa'          => 'Desactivar AMF',
    '2fa_use_secret_instead'                    => 'Si no pots escanejar el codi QR, pots fer servir el codi secret en comptes: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Guarda aquests codis de seguretat per poder accedir en el cas que perdis el teu dispositiu.',
    '2fa_already_enabled'                       => 'La verificació multifactor ja està habilitada.',
    'wrong_mfa_code'                            => 'Aquest codi MFA no és vàlid.',
    'pref_save_settings'                        => 'Guardar preferències',
    'saved_preferences'                         => 'Preferències guardades!',
    'preferences_general'                       => 'General',
    'preferences_frontpage'                     => 'Pantalla d\'inici',
    'preferences_security'                      => 'Seguretat',
    'preferences_layout'                        => 'Disseny',
    'preferences_notifications'                 => 'Notificacions',
    'pref_home_show_deposits'                   => 'Mostrar dipòsits a la pantalla d\'inici',
    'pref_home_show_deposits_info'              => 'La pantalla d\'inici ja mostra els teus comptes de despeses. Ha de mostrar també els teus comptes de beneficis?',
    'pref_home_do_show_deposits'                => 'Sí, mostra\'ls',
    'successful_count'                          => 'dels quals :count satisfactoris',
    'list_page_size_title'                      => 'Mida de pàgina',
    'list_page_size_help'                       => 'Qualsevol llista de coses (comptes, transaccions, etc) mostra com a màxim aquesta quantitat per pàgina.',
    'list_page_size_label'                      => 'Mida de pàgina',
    'between_dates'                             => '(:start i :end)',
    'pref_optional_fields_transaction'          => 'Camps opcionals per transaccions',
    'pref_optional_fields_transaction_help'     => 'Per defecte no tots els camps són actius quan es crea una nova transacció (pel desordre). A continuació, pots activar aquests camps si creus que et seran útils. Per descomptat, qualsevol camp que es desactivi, però que ja s\'hagi omplert, serà visible tot i aquesta preferència.',
    'optional_tj_date_fields'                   => 'Camps de data',
    'optional_tj_other_fields'                  => 'Altres camps',
    'optional_tj_attachment_fields'             => 'Camps d\'adjunts',
    'pref_optional_tj_interest_date'            => 'Data d\'interès',
    'pref_optional_tj_book_date'                => 'Data de registre',
    'pref_optional_tj_process_date'             => 'Data de processament',
    'pref_optional_tj_due_date'                 => 'Data de venciment',
    'pref_optional_tj_payment_date'             => 'Data de pagament',
    'pref_optional_tj_invoice_date'             => 'Data de facturació',
    'pref_optional_tj_internal_reference'       => 'Referència interna',
    'pref_optional_tj_notes'                    => 'Notes',
    'pref_optional_tj_attachments'              => 'Adjunts',
    'pref_optional_tj_external_url'             => 'URL extern',
    'pref_optional_tj_location'                 => 'Ubicació',
    'pref_optional_tj_links'                    => 'Enllaços de transacció',
    'optional_field_meta_dates'                 => 'Dates',
    'optional_field_meta_business'              => 'Negocis',
    'optional_field_attachments'                => 'Adjunts',
    'optional_field_meta_data'                  => 'Metadades opcionals',
    'external_url'                              => 'URL extern',
    'pref_notification_login_failure'           => 'Error d\'inici de sessió',
    'pref_notification_bill_reminder'           => 'Recordatori de venciment de subscripcions',
    'pref_notification_new_access_token'        => 'Avisar quan es creï un nou identificador d\'accés API',
    'pref_notification_transaction_creation'    => 'Avisar quan una transacció es creï automàticament',
    'pref_notification_user_login'              => 'Avisar quan s\'iniciï sessió des d\'una nova ubicació',
    'pref_notification_rule_action_failures'    => 'Alerta quan les accions de la regla no es poden executar (no per email)',
    'pref_notification_new_password'            => 'La teva contrasenya ha canviat',
    'pref_notification_enabled_mfa'             => 'L\'autenticació multifactor està habilitada',
    'pref_notification_disabled_mfa'            => 'L\'autenticació multifactor està deshabilitada',
    'pref_notification_few_left_mfa'            => 'Tens pocs codis de seguretat restants',
    'pref_notification_no_left_mfa'             => 'No et queden codis de seguretat',
    'pref_notification_many_failed_mfa'         => 'La comprovació d\'autenticació multifactor continua fallant',
    'pref_notification_new_backup_codes'        => 'S\'han generat nous codis de recuperació',
    'pref_notifications'                        => 'Notificacions',
    'pref_notifications_help'                   => 'Indica si aquestes són notificacions que vols rebre. Algunes notificacions podrien contenir informació financera sensible.',
    'pref_notifications_settings'               => 'Configuració de notificacions',
    'pref_notifications_settings_help'          => 'Feu servir aquesta configuració per configurar els canals de notificació. Tingueu en compte que les notificacions s\'enviaran a TOTS els canals. PRIMER, deseu la configuració.',
    'slack_url_label'                           => 'URL del webhook entrant de Slack',
    'discord_url_label'                         => 'Enllaç del webhook de Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Tipus de canvi',
    'header_exchange_rates'                     => 'Tipus de canvi',
    'exchange_rates_intro'                      => 'Firefly III permet descarregar i utilitzar tipus de canvi. Més informació sobre això a la <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">documentació</a>.',
    'exchange_rates_from_to'                    => 'Entre {from} i {to} (i a la inversa)',
    'header_exchange_rates_rates'               => 'Tipus de canvi',
    'exchange_rates_intro_rates'                => 'Firefly III utilitza els tipus de canvi següents. L\'invers es calcula automàticament quan no es proporciona. Si no existeix cap tipus de canvi per a la data de la transacció, Firefly III tornarà enrere en el temps per trobar-ne un. Si no n\'hi ha cap, s\'utilitzarà el tipus "1".',
    'header_exchange_rates_table'               => 'Taula amb els tipus de canvi',
    'help_rate_form'                            => 'El dia d\'avui, quants {to} obtindràs amb un {from}?',
    'save_new_rate'                             => 'Desa nou tipus',
    'add_new_rate'                              => 'Afegeix un nou tipus de canvi',
    'not_enough_currencies'                     => 'No hi ha prou monedes',
    'not_enough_currencies_enabled'             => 'Si tens només una divisa habilitada, no cal afegir tipus de canvi.',

    // Financial administrations
    'administration_index'                      => 'Administració financera',
    'administrations_breadcrumb'                => 'Administracions financeres',
    'administrations_page_title'                => 'Administracions financeres',
    'administrations_index_menu'                => 'Administracions financeres',
    'administrations_page_sub_title'            => 'Vista general',
    'create_administration'                     => 'Crea una nova administració',
    'administration_owner'                      => 'Propietari de l\'administració: {{email}}',
    'administration_you'                        => 'El teu rol: {{role}}',
    'other_users_in_admin'                      => 'Altres usuaris a aquesta administració',
    'administrations_create_breadcrumb'         => 'Crea una nova administració financera',
    'administrations_page_create_sub_title'     => 'Crea una nova administració financera',
    'basic_administration_information'          => 'Informació de l\'administració bàsica',
    'new_administration_created'                => 'S\'ha creat una nova administració financera "{{title}}"',
    'edit_administration_breadcrumb'            => 'Edita l\'administració financera ":title"',
    'administrations_page_edit_sub_title'       => 'Edita l\'administració financera ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edita l\'administració financera "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'L\'administració ":title" s\'ha actualitzat',
    'flash_administration_created'              => 'L\'administració ":title" s\'ha creat',
    'flash_administration_deleted'              => 'L\'administració ":title" s\'ha eliminat',

    // roles
    'administration_role_owner'                 => 'Propietari',
    'administration_role_ro'                    => 'Només de lectura',
    'administration_role_mng_trx'               => 'Gestionar transaccions',
    'administration_role_mng_meta'              => 'Gestionar classificació i meta-dades',
    'administration_role_mng_budgets'           => 'Gestionar pressupostos',
    'administration_role_mng_piggies'           => 'Administra guardioles',
    'administration_role_mng_subscriptions'     => 'Gestionar subscripcions',
    'administration_role_mng_rules'             => 'Gestionar regles',
    'administration_role_mng_recurring'         => 'Gestionar transaccions recurrents',
    'administration_role_mng_webhooks'          => 'Gestionar Webhooks',
    'administration_role_mng_currencies'        => 'Gestionar divises',
    'administration_role_view_reports'          => 'Veure informes',
    'administration_role_full'                  => 'Accés total',

    // mfa
    'enable_mfa'                                => 'Activar l\'autenticació multifactor',
    'mfa_index_title'                           => 'Autenticació multifactor',
    'mfa_index_intro'                           => 'Firefly III admet l\'autenticació multifactor (MFA). Podeu habilitar l\'MFA per al vostre compte per afegir una capa addicional de seguretat. Es poden utilitzar aplicacions com Authy, Google Authenticator i FreeOTP per generar els codis que necessiteu per iniciar la sessió. Firefly III no admet claus de seguretat, però podeu utilitzar una clau de seguretat com a dispositiu d\'emmagatzematge per al vostre secret MFA.',
    'mfa_index_enabled'                         => 'L\'autenticació multifactor està habilitada per al vostre compte.',
    'mfa_index_disabled'                        => 'L\'autenticació multifactor no està habilitada per al vostre compte.',
    'mfa_index_owner'                           => 'El propietari d\'aquesta instància sempre podrà desactivar l\'autenticació multifactor per al vostre compte.',
    'current_password_confirm_mfa'              => 'Introduïu la vostra contrasenya actual',
    'mfa_warning_code_changes'                  => 'És possible que rebeu un quadre de diàleg MFA després d\'introduir la contrasenya i un codi MFA. En aquest cas, espereu que l\'aplicació generi un nou codi MFA i no recicleu el que acabeu d\'utilitzar.',
    'mfa_already_disabled'                      => 'L\'autenticació multifactor no està habilitada, per tant no la podeu desactivar.',
    'disable_mfa_page'                          => 'Desactivar l\'autenticació multifactor',
    'disable_mfa_intro'                         => 'Podeu desactivar l\'autenticació multifactor. Per fer-ho, introduïu la vostra contrasenya i un codi d\'autenticació multifactor. Si voleu desactivar l\'autenticació multifactor perquè heu perdut l\'accés al generador de codi, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">consulteu la documentació</a>.',
    'pref_disable_mfa'                          => 'Desactivar l\'autenticació multifactor',
    'mfa_not_enabled'                           => 'L\'autenticació multifactor no està habilitada.',
    'mfa_backup_codes_intro'                    => 'Firefly III pot generar codis de còpia de seguretat. Aquests codis es poden utilitzar per iniciar la sessió quan no es pot utilitzar el generador de codis. Podeu generar un conjunt nou de codis en qualsevol moment. Si genereu un conjunt nou, el conjunt antic serà invalidat.',
    'mfa_backup_codes_quick'                    => 'Si surts molt ràpidament de la pàgina de configuració de l\'autenticació multifactor, és possible que l\'aplicació encara no hagi generat un codi nou. Tingues en compte que els codis MFA només es poden utilitzar una vegada. Assegura\'t d\'utilitzar un codi diferent de l\'anterior.',
    'mfa_backup_codes_title'                    => 'Codis de recuperació de l\'autenticació multifactor',
    'mfa_backup_codes_post_title'               => 'Codis de recuperació de l\'autenticació multifactor',

    // profile:
    'manage_mfa_settings'                       => 'Gestiona la configuració de l\'autenticació multifactor',
    'purge_data_title'                          => 'Purgar dades de Firefly III',
    'purge_data_expl'                           => '"Purgar" vol dir "eliminar allò que ja s\'ha eliminat". En circumstàncies normals, Firefly III no eliminar res permanentment. Només ho oculta. El següent botó elimina tots els registres prèviament "eliminats" PER SEMPRE.',
    'delete_stuff_header'                       => 'Eliminar i purgar dades',
    'purge_all_data'                            => 'Purgar tots els registres eliminats',
    'purge_data'                                => 'Purgar dades',
    'purged_all_records'                        => 'Tots els registres eliminats s\'han purgat.',
    'delete_data_title'                         => 'Eliminar dades de Firefly III',
    'permanent_delete_stuff'                    => 'Pots eliminar coses de Firefly III. Utilitzar els següents botons vol dir que els elements s\'eliminaran de la vista i s\'amagaran. No hi ha botó per desfer-ho, però els elements romandran a la base de dades, d\'on els podràs recuperar si és necessari.',
    'other_sessions_logged_out'                 => 'Totes les altres sessions s\'han desconnectat.',
    'delete_unused_accounts'                    => 'Eliminar els comptes no usats netejarà les llistes d\'autocompletat.',
    'delete_all_unused_accounts'                => 'Eliminar comptes no usats',
    'deleted_all_unused_accounts'               => 'Tots els comptes no usats s\'han eliminat',
    'delete_all_budgets'                        => 'Eliminar TOTS els pressupostos',
    'delete_all_categories'                     => 'Eliminar TOTES les categories',
    'delete_all_tags'                           => 'Eliminar TOTES les etiquetes',
    'delete_all_bills'                          => 'Suprimeix TOTES les teves subscripcions',
    'delete_all_piggy_banks'                    => 'Eliminar TOTES les guardioles',
    'delete_all_rules'                          => 'Eliminar TOTES les regles',
    'delete_all_recurring'                      => 'Eliminar TOTES les transaccions recurrents',
    'delete_all_object_groups'                  => 'Eliminar TOTS els grups d\'objectes',
    'delete_all_accounts'                       => 'Eliminar TOTS els comptes',
    'delete_all_asset_accounts'                 => 'Eliminar TOTS els comptes d\'actius',
    'delete_all_expense_accounts'               => 'Eliminar TOTS els comptes de despeses',
    'delete_all_revenue_accounts'               => 'Eliminar TOTS els comptes de beneficis',
    'delete_all_liabilities'                    => 'Eliminar TOTS els passius',
    'delete_all_transactions'                   => 'Eliminar TOTES les transaccions',
    'delete_all_withdrawals'                    => 'Eliminar TOTES les retirades',
    'delete_all_deposits'                       => 'Eliminar TOTS els dipòsits',
    'delete_all_transfers'                      => 'Eliminar TOTES les transferències',
    'also_delete_transactions'                  => 'Eliminar els comptes també eliminarà TOTES les retirades, dipòsits i transferències associats!',
    'deleted_all_budgets'                       => 'Tots els pressuposts han estat esborrats',
    'deleted_all_categories'                    => 'Totes les categories han estat esborrades',
    'deleted_all_tags'                          => 'Totes les etiquetes han estat esborrades',
    'deleted_all_bills'                         => 'S\'han suprimit totes les subscripcions',
    'deleted_all_piggy_banks'                   => 'Totes les guardioles han estat esborrades',
    'deleted_all_rules'                         => 'Totes les regles i grups de regles han estat esborrats',
    'deleted_all_object_groups'                 => 'Tots els grups han estat esborrats',
    'deleted_all_accounts'                      => 'Tots els comptes han estat esborrats',
    'deleted_all_asset_accounts'                => 'Tots els comptes d\'actius han estat eliminats',
    'deleted_all_expense_accounts'              => 'Tots els comptes de despeses han estat eliminats',
    'deleted_all_revenue_accounts'              => 'Tots els comptes de beneficis han estat eliminats',
    'deleted_all_liabilities'                   => 'Tots els passius han estat eliminats',
    'deleted_all_transactions'                  => 'Totes les transaccions han estat eliminades',
    'deleted_all_withdrawals'                   => 'Totes les retirades han estat eliminades',
    'deleted_all_deposits'                      => 'Tots els dipòsits han estat eliminats',
    'deleted_all_transfers'                     => 'Totes les transferències han estat eliminades',
    'deleted_all_recurring'                     => 'Totes les transaccions periòdiques han estat eliminades',
    'change_your_password'                      => 'Canvia la contrasenya',
    'delete_account'                            => 'Eliminar compte',
    'current_password'                          => 'Contrasenya actual',
    'new_password'                              => 'Nova contrasenya',
    'new_password_again'                        => 'Nova contrasenya (de nou)',
    'delete_your_account'                       => 'Eliminar el teu compte',
    'delete_your_account_help'                  => 'Eliminar el teu compte també eliminarà qualsevol compte, transacció, <em>qualsevol</em> cosa que hagis guardat a Firefly III. Se n\'haurà ANAT.',
    'delete_your_account_password'              => 'Introdueix la contrasenya per continuar.',
    'password'                                  => 'Contrasenya',
    'are_you_sure'                              => 'Estàs segur? Això no es pot desfer.',
    'are_you_sure_confirm'                      => 'N\'esteu segurs?',
    'delete_account_button'                     => 'ELIMINAR el teu compte',
    'invalid_current_password'                  => 'Contrasenya actual invàlida!',
    'password_changed'                          => 'Contrasenya canviada!',
    'should_change'                             => 'La idea és canviar la teva contrasenya.',
    'invalid_password'                          => 'Contrasenya invàlida!',
    'what_is_pw_security'                       => 'Què és "verificar seguretat de la contrasenya"?',
    'secure_pw_title'                           => 'Com escollir una contrasenya segura',
    'forgot_password_response'                  => 'Gràcies. Si existeix un compte amb aquesta adreça de correu electrònic, trobaràs les instruccions a la teva safata d\'entrada.',
    'secure_pw_history'                         => 'Cada setmana pots llegir a les notícies sobre llocs web que perden les contrasenyes dels seus usuaris. Els hackers i lladres fan servir aquestes contrasenyes per provar de robar la teva informació privada. Aquesta informació és valuosa.',
    'secure_pw_ff'                              => 'Fas servir la mateixa contrasenya per tot internet? Si un lloc web perd la teva contrasenya, els hackers tindran accés a totes les teves dades. Firefly III depèn que triïs una contrasenya forta i única per protegir els teus registres financers.',
    'secure_pw_check_box'                       => 'Per ajudar-te en això, Firefly III pot comprovar si la contrasenya que vols fer servir s\'ha robat anteriorment. Si aquest és el cas, Firefly III et recomanarà NO utilitzar aquesta contrasenya.',
    'secure_pw_working_title'                   => 'Com funciona?',
    'secure_pw_working'                         => 'Seleccionant la casella, Firefly III enviarà els cinc primers caràcters del HASH SHA1 de la teva contrasenya a <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">la pàgina web de Troy Hunt</a> per comprovar si es troba a la seva llista. Això impedirà que facis servir contrasenyes insegures tal com es recomana en lúltima <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">Publicació Especial del NIST</a> sobre aquest tema.',
    'secure_pw_should'                          => 'Hauria de seleccionar la casella?',
    'secure_pw_long_password'                   => 'Sí. Verifica sempre que la contrasenya és segura.',
    'command_line_token'                        => 'Token de línia d\'ordres',
    'explain_command_line_token'                => 'Necessites aquest token per executar opcions de línia d\'ordres, com exportar dades. Sense ell, aquesta ordre sensitiva no funcionarà. No comparteixis aquest token de línia d\'ordres. Ningú et demanarà per aquest token, ni tan sols jo. Si et preocupa haver-lo perdut, o estàs paranoic, regenera el token amb aquest botó.',
    'regenerate_command_line_token'             => 'Regenerar token de la línia d\'ordres',
    'token_regenerated'                         => 'S\'ha generat un nou token de línia d\'ordres',
    'change_your_email'                         => 'Canviar adreça de correu electrònic',
    'email_verification'                        => 'S\'enviarà un missatge de correu electrònic a la vostra adreça de correu electrònic antiga I nova. Per motius de seguretat, no podreu iniciar la sessió fins que no verifiqueu la vostra adreça de correu electrònic nova. Si no esteu segurs de si la vostra instal·lació de Firefly III pot enviar correus electrònics, no utilitzeu aquesta funció. Si sou administrador, podeu provar-ho a la <a href="settings">configuració</a>.',
    'email_changed_logout'                      => 'Fins que no verifiquis l\'adreça de correu, no pots iniciar sessió.',
    'login_with_new_email'                      => 'Ja pots iniciar sessió amb la teva nova adreça de correu.',
    'login_with_old_email'                      => 'Ja pots tornar a iniciar sessió amb la teva adreça de correu anterior.',
    'login_provider_local_only'                 => 'Aquesta acció no està disponible quan t\'identifiques a través de ":login_provider".',
    'external_user_mgt_disabled'                => 'Aquesta acció no està disponible quan Firefly III no és responsable de la gestió d\'usuaris o de la seva identificació.',
    'external_auth_disabled'                    => 'Aquesta acció no està disponible quan Firefly III no és responsable de la gestió de la identificació.',
    'delete_local_info_only'                    => "Ja que Firefly III no és responsable de la gestió d'usuaris o de la seva identificació, aquesta funció només eliminarà informació local de Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clients OAuth',
    'profile_oauth_no_clients'                  => 'No has creat cap client OAuth.',
    'profile_oauth_clients_external_auth'       => 'Si estàs fent servir un proveïdor extern d\'autentificació com Authelia, els Clients OAuth no funcionaran. Sols pots fer servir Tokens d\'Accés Personal.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'ID de Client',
    'profile_oauth_client_name'                 => 'Nom',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Crear client nou',
    'profile_oauth_create_client'               => 'Crear client',
    'profile_oauth_edit_client'                 => 'Editar client',
    'profile_oauth_name_help'                   => 'Alguna cosa que els teus usuaris reconeixeran i hi confiaran.',
    'profile_oauth_redirect_url'                => 'URL de redirecció',
    'profile_oauth_redirect_url_help'           => 'L\'URL de crida de retorn de la teva aplicació.',
    'profile_authorized_apps'                   => 'Aplicacions autoritzades',
    'profile_authorized_clients'                => 'Clients autoritzats',
    'profile_scopes'                            => 'Àmbits',
    'profile_revoke'                            => 'Revocar',
    'profile_oauth_client_secret_title'         => 'Secret del client',
    'profile_oauth_client_secret_expl'          => 'Aquest és el teu nou secret de client. És l\'únic cop que es mostrarà, així que no el perdis! Ara ja pots utilitzar aquest secret per fer crides a l\'API.',
    'profile_personal_access_tokens'            => 'Testimoni d\'accés personal',
    'profile_personal_access_token'             => 'Testimoni d\'accés personal',
    'profile_oauth_confidential'                => 'Confidencial',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Aquest és el teu nou testimoni d\'accés personal. És l\'únic cop que es mostrarà, així que no el perdis! Ara ja pots utilitzar aquest testimoni per fer crides a l\'API.',
    'profile_no_personal_access_token'          => 'No has creat cap testimoni d\'accés personal.',
    'profile_create_new_token'                  => 'Crear nou testimoni',
    'profile_create_token'                      => 'Crear testimoni',
    'profile_create'                            => 'Crear',
    'profile_save_changes'                      => 'Desar els canvis',
    'profile_whoops'                            => 'Vaja!',
    'profile_something_wrong'                   => 'Alguna cosa ha sortit malament!',
    'profile_try_again'                         => 'Alguna cosa ha anat malament. Si us plau, prova de nou.',
    'amounts'                                   => 'Quantitats',
    'multi_account_warning_unknown'             => 'Depenent del tipus de transacció que creïs, el compte d\'origen i/o el de destí de divisions posteriors pot ser anul·lada pel que es defineix en la primera divisió de la transacció.',
    'multi_account_warning_withdrawal'          => 'Tingues en compte que el compte d\'origen de divisions posteriors serà anul·lat pel que es troba definit a la primera divisió de la retirada.',
    'multi_account_warning_deposit'             => 'Tingues en compte que el compte de destí de divisions posteriors serà anul·lat pel que es troba definit a la primera divisió del dipòsit.',
    'multi_account_warning_transfer'            => 'Tingues en compte que el compte d\'origen + destí de divisions posteriors serà anul·lat pel que es troba definit a la primera divisió de la transferència.',


    // export data:
    'export_data_title'                         => 'Exportar dades de Firefly III',
    'export_data_menu'                          => 'Exportar dades',
    'export_data_bc'                            => 'Exportar dades de Firefly III',
    'export_data_main_title'                    => 'Exportar dades de Firefly III',
    'export_data_expl'                          => 'Aquest enllaç et permet exportar totes les transaccions + metadades de Firefly III. Si us plau, consulta l\'ajuda (icona (?) superior dreta) per més informació sobre el procés.',
    'export_data_all_transactions'              => 'Exportar totes les transaccions',
    'export_data_advanced_expl'                 => 'Si necessites una exportació més avançada o específica, llegeix l\'ajuda sobre com fer servir les ordres de consola <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Un adjunt::count adjunts',
    'attachments'                               => 'Adjunts',
    'edit_attachment'                           => 'Editar adjunt ":name"',
    'update_attachment'                         => 'Actualitzar adjunt',
    'delete_attachment'                         => 'Eliminar adjunt ":name"',
    'attachment_deleted'                        => 'Adjunt ":name" eliminat',
    'liabilities_deleted'                       => 'Passiu ":name" eliminat',
    'attachment_updated'                        => 'Adjunt ":name" actualitzat',
    'upload_max_file_size'                      => 'Mida màxima del fitxer: :size',
    'list_all_attachments'                      => 'Llistat de tots els adjunts',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Com que aquesta transacció està reconciliada, no podreu actualitzar els comptes ni l\'import o imports tret que elimineu el senyalador de reconciliació.',
    'is_reconciled'                             => 'Està reconciliat',
    'title_expenses'                            => 'Despeses',
    'title_withdrawal'                          => 'Despeses',
    'title_revenue'                             => 'Ingressos / salari',
    'title_deposit'                             => 'Ingressos / salari',
    'title_transfer'                            => 'Transferències',
    'title_transfers'                           => 'Transferències',
    'submission_options'                        => 'Opcions de tramesa',
    'apply_rules_checkbox'                      => 'Aplicar regles',
    'fire_webhooks_checkbox'                    => 'Disparar webhooks',
    'select_source_account'                     => 'Per favor, selecciona o escriu un nom de compte d\'origen vàlid',
    'select_dest_account'                       => 'Per favor, selecciona o escriu un nom de compte de destí vàlid',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Aquesta transacció ja és una retirada',
    'convert_is_already_type_Deposit'           => 'Aquesta transacció ja és un dipòsit',
    'convert_is_already_type_Transfer'          => 'Aquesta transacció ja és una transferència',
    'convert_to_Withdrawal'                     => 'Convertir ":description" en una retirada',
    'convert_to_Deposit'                        => 'Convertir ":description" en un dipòsit',
    'convert_to_Transfer'                       => 'Convertir ":description" en una transferència',
    'convert_options_WithdrawalDeposit'         => 'Convertir retirada en un dipòsit',
    'convert_options_WithdrawalTransfer'        => 'Convertir retirada en una transferència',
    'convert_options_DepositTransfer'           => 'Convertir dipòsit en una transferència',
    'convert_options_DepositWithdrawal'         => 'Convertir dipòsit en una retirada',
    'convert_options_TransferWithdrawal'        => 'Convertir transferència en una retirada',
    'convert_options_TransferDeposit'           => 'Convertir transferència en un dipòsit',
    'convert_Withdrawal_to_deposit'             => 'Convertir aquesta retirada en un dipòsit',
    'convert_Withdrawal_to_transfer'            => 'Convertir aquesta retirada en una transferència',
    'convert_Deposit_to_withdrawal'             => 'Convertir aquest dipòsit en una retirada',
    'convert_Deposit_to_transfer'               => 'Convertir aquest dipòsit en una transferència',
    'convert_Transfer_to_deposit'               => 'Convertir aquesta transferència en un dipòsit',
    'convert_Transfer_to_withdrawal'            => 'Convertir aquesta transferència en una retirada',
    'convert_please_set_revenue_source'         => 'Si us plau, escull el compte de beneficis d\'on vindran els diners.',
    'convert_please_set_asset_destination'      => 'Si us plau, escull el compte d\'actius a on aniran els diners.',
    'convert_please_set_expense_destination'    => 'Si us plau, escull el compte de despeses a on aniran els diners.',
    'convert_please_set_asset_source'           => 'Si us plau, escull el compte d\'actius d\'on vindran els diners.',
    'convert_expl_w_d'                          => 'Quan es converteix d\'una retirada a un dipòsit, els diners es dipositaran en el compte de destí mostrat, en comptes de ser-ne retirats.|Quan es converteix d\'una retirada a un dipòsit, els diners es dipositaran en els comptes de destí mostrats, en comptes de ser-ne retirats.',
    'convert_expl_w_t'                          => 'Quan es converteix d\'una retirada a una transferència, els diners es transferiran del compte d\'origen a un altre compte d\'actius o passius en comptes de ser gastats del compte de despeses original.|Quan es converteix d\'una retirada a una transferència, els diners es transferiran dels comptes d\'origen a uns altres comptes d\'actius o passius en comptes de ser gastats del compte de despeses original.',
    'convert_expl_d_w'                          => 'Quan es converteix d\'un dipòsit a una retirada, els diners es retiraran del compte d\'origen mostrat, en comptes de ser-hi dipositats.|Quan es converteix d\'un dipòsit a una retirada, els diners es retiraran dels comptes d\'origen mostrats, en comptes de ser-hi dipositats.',
    'convert_expl_d_t'                          => 'Quan es converteix d\'un dipòsit a una transferència, els diners es dipositaran al compte de destí llistat des de qualsevol dels comptes d\'actius o passius.|Quan es converteix d\'un dipòsit a una transferència, els diners es dipositaran als comptes de destí llistats des de qualsevol dels comptes d\'actius o passius.',
    'convert_expl_t_w'                          => 'Quan es converteix una transferència en una retirada, els diners es gastaran al compte de destí que indiquis aquí, en comptes de ser transferits.|Quan es converteix una transferència en una retirada, els diners es gastaran als comptes de destí que indiquis aquí, en comptes de ser transferits.',
    'convert_expl_t_d'                          => 'Quan es converteix una transferència en un dipòsit, els diners es dipositaran al compte de destí que veus aquí, en comptes de ser-hi transferits.|Quan es converteix una transferència en un dipòsit, els diners es dipositaran als comptes de destí que veus aquí, en comptes de ser-hi transferits.',
    'convert_select_sources'                    => 'Per completar la conversió, si us plau, estableix un nou compte d\'origen a sota.|Per completar la conversió, si us plau, estableix els nous comptes d\'origen a sota.',
    'convert_select_destinations'               => 'Per completar la conversió, si us plau, selecciona un no compte de destí a sota.|Per completar la conversió, si us plau, selecciona els nous comptes de destí a sota.',
    'converted_to_Withdrawal'                   => 'La transacció s\'ha convertit a retirada',
    'converted_to_Deposit'                      => 'La transacció s\'ha convertit a dipòsit',
    'converted_to_Transfer'                     => 'La transacció s\'ha convertit a transferència',
    'invalid_convert_selection'                 => 'El compte que has seleccionat ja s\'està utilitzant o no existeix.',
    'source_or_dest_invalid'                    => 'No es poden trobar els detalls correctes de la transacció. La conversió no és possible.',
    'convert_to_withdrawal'                     => 'Convertir a retirada',
    'convert_to_deposit'                        => 'Convertir a dipòsit',
    'convert_to_transfer'                       => 'Convertir a transferència',

    // create new stuff:
    'create_new_withdrawal'                     => 'Crear una nova retirada',
    'create_new_deposit'                        => 'Crea un nou dipòsit',
    'create_new_transfer'                       => 'Crear nova transferència',
    'create_new_asset'                          => 'Crear un nou compte d\'actius',
    'create_new_liabilities'                    => 'Crear nou passiu',
    'create_new_expense'                        => 'Crear un nou compte de despeses',
    'create_new_revenue'                        => 'Crear un nou compte de beneficis',
    'create_new_piggy_bank'                     => 'Crea una guardiola nova',
    'create_new_bill'                           => 'Crea una nova subscripció',
    'create_new_subscription'                   => 'Crea una nova subscripció',
    'create_new_rule'                           => 'Crea una nova regla',

    // currencies:
    'create_currency'                           => 'Crear una nova moneda',
    'store_currency'                            => 'Guardar nova moneda',
    'update_currency'                           => 'Actualitza la moneda',
    'new_default_currency'                      => '":name" està ara a la moneda per defecte.',
    'default_currency_failed'                   => 'No s\'ha pogut establir ":name" com a la moneda per defecte. Per favor, revisa els registres.',
    'cannot_delete_currency'                    => 'No es pot eliminar :name perquè encara s\'utilitza.',
    'cannot_delete_fallback_currency'           => ':name és la moneda alternativa del sistema i no es pot eliminar.',
    'cannot_disable_currency_journals'          => 'No es pot deshabilitar :name perquè les transaccions encara la fan servir.',
    'cannot_disable_currency_last_left'         => 'No es pot deshabilitar :name perquè és l\'única moneda activa.',
    'cannot_disable_currency_account_meta'      => 'No es pot deshabilitar :name perquè s\'utilitza en comptes d\'actius.',
    'cannot_disable_currency_bills'             => 'No es pot deshabilitar :name perquè s\'utilitza en subscripcions.',
    'cannot_disable_currency_recurring'         => 'No es pot deshabilitar :name perquè s\'utilitza en transaccions periòdiques.',
    'cannot_disable_currency_available_budgets' => 'No es pot deshabilitar :name perquè s\'utilitza en pressupostos disponibles.',
    'cannot_disable_currency_budget_limits'     => 'No es pot deshabilitar :name perquè s\'utilitza en límits de pressupostos.',
    'cannot_disable_currency_current_default'   => 'No es pot deshabilitar :name perquè és la moneda per defecte actual.',
    'cannot_disable_currency_system_fallback'   => 'No es pot deshabilitar :name perquè és la moneda per defecte del sistema.',
    'disable_EUR_side_effects'                  => 'L\'Euro és la moneda alternativa d\'emergència del sistema. Deshabilitar-la pot tenir efectes secundaris i podria anul·lar la garantia.',
    'deleted_currency'                          => 'Moneda :name eliminada',
    'created_currency'                          => 'Moneda :name creada',
    'could_not_store_currency'                  => 'No s\'ha pogut guardar la nova moneda.',
    'updated_currency'                          => 'Moneda :name actualitzada',
    'ask_site_owner'                            => 'Si us plau, pregunta a :owner per afegir, eliminar o editar monedes.',
    'currencies_intro'                          => 'Firefly III admet diverses monedes que pots establir i habilitar aquí.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Establir per defecte',
    'default_currency'                          => 'per defecte',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Deshabilitat',
    'enable_currency'                           => 'Habilitar',
    'disable_currency'                          => 'Deshabilitar',
    'currencies_default_disabled'               => 'La majoria d\'aquestes monedes estan deshabilitades per defecte. Per utilitzar-les, les has d\'habilitar primer.',
    'currency_is_now_enabled'                   => 'La moneda ":name" s\'ha habilitat',
    'could_not_enable_currency'                 => 'No s\'ha pogut habilitar la moneda ":name". Per favor, revisa els registres.',
    'currency_is_now_disabled'                  => 'La moneda ":name" s\'ha deshabilitat',
    'could_not_disable_currency'                => 'No s\'ha pogut deshabilitar la moneda ":name". Pot ser encara està en ús?',

    // forms:
    'mandatoryFields'                           => 'Camps obligatoris',
    'optionalFields'                            => 'Camps opcionals',
    'options'                                   => 'Opcions',

    // budgets:
    'daily_budgets'                             => 'Pressuposts diaris',
    'weekly_budgets'                            => 'Pressuposts setmanals',
    'monthly_budgets'                           => 'Pressuposts mensuals',
    'quarterly_budgets'                         => 'Pressuposts trimestrals',
    'half_year_budgets'                         => 'Pressuposts semestrals',
    'yearly_budgets'                            => 'Pressuposts anuals',
    'other_budgets'                             => 'Pressuposts de temps personalitzat',
    'budget_limit_not_in_range'                 => 'Aquesta quantitat s\'aplica des de :start fins a :end:',
    'total_available_budget'                    => 'Pressupost total disponible (entre :start i :end)',
    'total_available_budget_in_currency'        => 'Pressupost total disponible en :currency',
    'see_below'                                 => 'veure a sota',
    'create_new_budget'                         => 'Crea un nou pressuport',
    'store_new_budget'                          => 'Desa el pressuport nou',
    'stored_new_budget'                         => 'S\'ha desat el nou pressupost ":name"',
    'available_between'                         => 'Disponible entre :start i :end',
    'transactionsWithoutBudget'                 => 'Despeses sense pressupost',
    'transactions_no_budget'                    => 'Despeses sense pressupost entre :start i :end',
    'spent_between'                             => 'Ja t\'has gastat entre :start i :end',
    'spent_between_left'                        => 'Has gastat :spent entre :start i :end, deixant :left restants.',
    'set_available_amount'                      => 'Establir quantitat disponible',
    'update_available_amount'                   => 'Actualitzar quantitat disponible',
    'ab_basic_modal_explain'                    => 'Utilitza aquest formulari per a indicar el pressupost que esperes tindre (en total, en :currency) en el període indicat.',
    'createBudget'                              => 'Nou pressupost',
    'invalid_currency'                          => 'Moneda invàlida',
    'invalid_amount'                            => 'Per favor, introdueix una quantitat',
    'set_ab'                                    => 'El pressupost disponible establert',
    'updated_ab'                                => 'La quantitat disponible al pressupost s\'ha actualitzat',
    'deleted_ab'                                => 'La quantitat disponible al pressupost s\'ha eliminat',
    'deleted_bl'                                => 'La quantitat pressupostada s\'ha eliminat',
    'alt_currency_ab_create'                    => 'Veure el pressupost disponible en una altra moneda',
    'bl_create_btn'                             => 'Establir pressupost en una altra moneda',
    'inactiveBudgets'                           => 'Pressupostos inactius',
    'without_budget_between'                    => 'Transaccions sense un pressupost entre :start i :end',
    'delete_budget'                             => 'Eliminar pressupost ":name"',
    'deleted_budget'                            => 'Eliminat el pressupost ":name"',
    'edit_budget'                               => 'Editar pressupost ":name"',
    'updated_budget'                            => 'Actualitzat el pressupost ":name"',
    'update_amount'                             => 'Actualitzar quantitat',
    'update_budget'                             => 'Actualitzar pressupost',
    'update_budget_amount_range'                => 'Actualitza la quantitat (esperada) disponible entre :start i :end',
    'set_budget_limit_title'                    => 'Estableix la quantitat pressupostada per al pressupost :budget entre :start i :end',
    'set_budget_limit'                          => 'Establir quantitat pressupostada',
    'budget_period_navigator'                   => 'Navegador de períodes',
    'info_on_available_amount'                  => 'Què tinc disponible?',
    'available_amount_indication'               => 'Utilitza aquestes quantitats per a tindre una aproximació de quin és el teu pressupost disponible.',
    'suggested'                                 => 'Suggerit',
    'average_between'                           => 'Mitjana entre :start i :end',
    'transferred_in'                            => 'Transferit (cap a dins)',
    'transferred_away'                          => 'Transferit (cap a fora)',
    'auto_budget_none'                          => 'Cap auto-pressupost',
    'auto_budget_reset'                         => 'Estableix una quantitat fixa cada període',
    'auto_budget_rollover'                      => 'Afegeix una quantitat cada periode',
    'auto_budget_adjusted'                      => 'Afegeix una quantitat cada període i corregeix per a sobredespeses',
    'auto_budget_period_daily'                  => 'Diàriament',
    'auto_budget_period_weekly'                 => 'Setmanalment',
    'auto_budget_period_monthly'                => 'Mensualment',
    'auto_budget_period_quarterly'              => 'Trimestralment',
    'auto_budget_period_half_year'              => 'Cada mig any',
    'auto_budget_period_yearly'                 => 'Anualment',
    'auto_budget_help'                          => 'Pots llegir més sobre aquesta funció en l\'ajuda. Fes clic a la icona superior dreta (?).',
    'auto_budget_reset_icon'                    => 'El pressupost s\'establirà periòdicament',
    'auto_budget_rollover_icon'                 => 'La quantitat pressupostada s\'incrementarà periòdicament',
    'auto_budget_adjusted_icon'                 => 'La quantitat del pressupost augmentarà periòdicament i es corregirà per a sobredespeses',
    'remove_budgeted_amount'                    => 'S\'ha eliminat la quantitat pressupostada en :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Feu servir el camp d\'omissió per crear intervals bimensuals (omissió = 1) o altres intervals personalitzats.',
    'subscription'                              => 'Subscripció',
    'not_expected_period'                       => 'No s\'espera aquest periode',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'No (encara)',
    'visit_bill'                                => 'Visita la subscripció ":name" a Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'La subscripció coincideix amb les transaccions entre :low i :high.',
    'running_again_loss'                        => 'Les transaccions prèviament vinculades a aquesta subscripció poden perdre la connexió si (ja no) coincideixen amb la(es) regla(es).',
    'bill_related_rules'                        => 'Normes relacionades a aquesta subscripció',
    'repeats'                                   => 'Repeticions',
    'bill_end_date_help'                        => 'Camp opcional. S\'espera que la subscripció finalitzi en aquesta data.',
    'bill_extension_date_help'                  => 'Camp opcional. La subscripcióha de ser estesa (o cancel·lada) aquest dia o abans.',
    'bill_end_index_line'                       => 'Aquesta subscripció finalitza el: data',
    'bill_extension_index_line'                 => 'La subscripció ha de ser cancel·lada o estesa el :date',
    'connected_journals'                        => 'Transaccions connectades',
    'auto_match_on'                             => 'Quadrades automàticament per Firefly III',
    'auto_match_off'                            => 'No quadrades automàticament per Firefly III',
    'next_expected_match'                       => 'Pròxima coincidència esperada',
    'delete_bill'                               => 'Eliminar subscripció ":name"',
    'deleted_bill'                              => 'Subscripció eliminada ":name"',
    'edit_bill'                                 => 'Edita la subscripció ":name"',
    'more'                                      => 'Més',
    'rescan_old'                                => 'Executa les normes altra vegada, en totes les transaccions',
    'update_bill'                               => 'Actualitzar la subscripció',
    'updated_bill'                              => 'Subscripció ":name" actualitzada',
    'store_new_bill'                            => 'Desa la nova subscripció',
    'stored_new_bill'                           => 'Subscripció ":name" creada',
    'cannot_scan_inactive_bill'                 => 'Les subscripcions inactives no poden ser escanejades.',
    'rescanned_bill'                            => 'S\'ha escanejat tot altra vegada, i s\'ha enllaçat :count transacció a la subscripció.|S\'ha escanejat tot altra vegada, i s\'han enllaçat :count transaccions a la subscripció.',
    'average_bill_amount_year'                  => 'Quantitat de subscripcions mitjana (:year)',
    'average_bill_amount_overall'               => 'Quantitat de subscripcions mitjana (total)',
    'bill_is_active'                            => 'La subscripció està activa',
    'bill_expected_between'                     => 'S\'espera entre :start i :end',
    'bill_will_automatch'                       => 'La subscripció s\'enllaçarà automàticament a les transaccions que encaixen',
    'skips_over'                                => 'es salta',
    'bill_store_error'                          => 'Ha hagut un error inesperat al desar la teua nova subscripció. Per favor, comprova els registres',
    'list_inactive_rule'                        => 'regla inactiva',
    'bill_edit_rules'                           => 'Firefly III intentarà editar la norma relacionada amb aquesta subscripció. Tot i això, si has editat aquesta norma pel teu compte, Firefly III no canviarà res.|Firefly III intentarà editar les :count normes relacionades amb aquesta subscripció. Tot i això, si les has editat pel teu compte, Firefly III no canviarà res.',
    'bill_expected_date'                        => 'S\'espera :date',
    'bill_expected_date_js'                     => 'S\'espera {date}',
    'expected_amount'                           => 'Quantitat (esperada)',
    'bill_paid_on'                              => 'Pagat el {date}',
    'bill_repeats_weekly'                       => 'Es repeteix setmanalment',
    'bill_repeats_monthly'                      => 'Es repeteix mensualment',
    'bill_repeats_quarterly'                    => 'Es repeteix cada trimestre',
    'bill_repeats_half-year'                    => 'Es repeteix cada mig any',
    'bill_repeats_yearly'                       => 'Es repeteix anualment',
    'bill_repeats_weekly_other'                 => 'Es repeteix cada dos setmanes',
    'bill_repeats_monthly_other'                => 'Es repeteix cada dos mesos',
    'bill_repeats_quarterly_other'              => 'Es repeteix cada dos trimestres',
    'bill_repeats_half-year_other'              => 'Es repeteix anualment',
    'bill_repeats_yearly_other'                 => 'Es repeteix cada dos anys',
    'bill_repeats_weekly_skip'                  => 'Es repeteix cada {skip} setmanes',
    'bill_repeats_monthly_skip'                 => 'Es repeteix cada {skip} mesos',
    'bill_repeats_quarterly_skip'               => 'Es repeteix cada {skip} trimestres',
    'bill_repeats_half-year_skip'               => 'Es repeteix cada {skip} mitjos anys',
    'bill_repeats_yearly_skip'                  => 'Es repeteix cada {skip} anys',
    'subscriptions'                             => 'Subscripcions',
    'go_to_subscriptions'                       => 'Ves a les teves subscripcions',
    'forever'                                   => 'Per a sempre',
    'extension_date_is'                         => 'La data d\'extensió és {date}',

    // accounts:
    'account_locked_currency'                   => 'La moneda d\'aquest compte ha de seguir sent :name sempre que les guardioles hi estiguin vinculades.',
    'i_am_owed_amount'                          => 'Se\'m deu la quantitat',
    'i_owe_amount'                              => 'Jo dec la quantitat',
    'inactive_account_link'                     => 'Tens :count compte inactiu (arxivat), que pots veure en aquesta pàgina.|Tens :count comptes inactius (arxivats), els pots veure en aquesta pàgina.',
    'all_accounts_inactive'                     => 'Aquests són els teus comptes inactius.',
    'active_account_link'                       => 'Aquest enllaç et retorna als teus comptes actius.',
    'account_missing_transaction'               => 'El compte #:id (":name") no es pot visualitzar directament ja que Firefly no té alguna informació de redirecció.',
    'cc_monthly_payment_date_help'              => 'Selecciona qualsevol any o mes, i serà ignorat. Només el dia és rellevant.',
    'details_for_asset'                         => 'Detalls per al compte d\'actius ":name"',
    'details_for_expense'                       => 'Detalls per al compte de despeses ":name"',
    'details_for_revenue'                       => 'Detalls per al compte de beneficis ":name"',
    'details_for_cash'                          => 'Detalls per al compte d\'efectiu ":name"',
    'store_new_asset_account'                   => 'Desa el nou compte d\'actius',
    'store_new_expense_account'                 => 'Desa el nou compte de despeses',
    'store_new_revenue_account'                 => 'Desa el nou compte de beneficis',
    'edit_asset_account'                        => 'Edita el compte d\'actius ":name"',
    'edit_expense_account'                      => 'Edita el compte de despeses ":name"',
    'edit_revenue_account'                      => 'Edita el compte de beneficis ":name"',
    'delete_asset_account'                      => 'Elimina el compte d\'actius ":name"',
    'delete_expense_account'                    => 'Elimina el compte de despeses ":name"',
    'delete_revenue_account'                    => 'Elimina el compte de beneficis ":name"',
    'delete_liabilities_account'                => 'Elimina el passiu ":name"',
    'asset_deleted'                             => 'S\'ha eliminat el compte d\'actius ":name" satisfactòriament',
    'account_deleted'                           => 'S\'ha eliminat el compte ":name" satisfactòriament',
    'expense_deleted'                           => 'S\'ha eliminat el compte de despeses ":name" satisfactòriament',
    'revenue_deleted'                           => 'S\'ha eliminat el compte de beneficis ":name" satisfactòriament',
    'update_asset_account'                      => 'Actualitza el compte d\'actius',
    'update_undefined_account'                  => 'Actualitza el compte',
    'update_liabilities_account'                => 'Actualitza el passiu',
    'update_expense_account'                    => 'Actualitza el compte de despeses',
    'update_revenue_account'                    => 'Actualitza el compte de beneficis',
    'make_new_asset_account'                    => 'Crea un nou compte d\'actius',
    'make_new_expense_account'                  => 'Crea un nou compte de despeses',
    'make_new_revenue_account'                  => 'Crea un nou compte de beneficis',
    'make_new_liabilities_account'              => 'Crea un nou passiu',
    'asset_accounts'                            => 'Comptes d\'actius',
    'undefined_accounts'                        => 'Comptes',
    'asset_accounts_inactive'                   => 'Comptes d\'actius (inactius)',
    'expense_account'                           => 'Compte de despeses',
    'expense_accounts'                          => 'Comptes de despeses',
    'expense_accounts_inactive'                 => 'Comptes de despeses (inactius)',
    'revenue_account'                           => 'Compte d\'ingressos',
    'revenue_accounts'                          => 'Comptes d\'ingressos',
    'revenue_accounts_inactive'                 => 'Comptes d\'ingressos (inactius)',
    'cash_accounts'                             => 'Comptes d\'efectiu',
    'Cash account'                              => 'Compte d\'efectiu',
    'liabilities_accounts'                      => 'Passius',
    'liabilities_accounts_inactive'             => 'Passius (inactiu)',
    'reconcile_account'                         => 'Consolida el compte ":account"',
    'overview_of_reconcile_modal'               => 'Visió general de consolidació',
    'delete_reconciliation'                     => 'Elimina la consolidació',
    'update_reconciliation'                     => 'Actualitza la consolidació',
    'amount_cannot_be_zero'                     => 'La quantitat no pot ser zero',
    'end_of_reconcile_period'                   => 'Final del període de consolidació :period',
    'start_of_reconcile_period'                 => 'Inici del període de consolidació :period',
    'start_balance'                             => 'Saldo inicial',
    'end_balance'                               => 'Saldo final',
    'update_balance_dates_instruction'          => 'Encaixa les quantitats i dates de dalt amb el teu extracte bancari, i prem "Comença a consolidar"',
    'select_transactions_instruction'           => 'Selecciona les transaccions que apareixen en el teu extracte bancari.',
    'select_range_and_balance'                  => 'Primer, verifica el rang de dates i saldo. Després prem "Comença a consolidar"',
    'date_change_instruction'                   => 'Si canvies el rang de dates ara, es perdrà el progrés.',
    'update_selection'                          => 'Actualitza la selecció',
    'store_reconcile'                           => 'Desa la consolidació',
    'reconciliation_transaction'                => 'Consolida la transacció',
    'Reconciliation'                            => 'Consolidació',
    'reconciliation'                            => 'Consolidació',
    'reconcile_options'                         => 'Opcions de consolidació',
    'reconcile_range'                           => 'Rang de consolidació',
    'start_reconcile'                           => 'Comença a consolidar',
    'cash_account_type'                         => 'Efectiu',
    'cash'                                      => 'efectiu',
    'cant_find_redirect_account'                => 'Firefly III ha intentat redireccionar-te però no ha pogut. Disculpa les molèsties. Torna a l\'índex.',
    'account_type'                              => 'Tipus de compte',
    'save_transactions_by_moving'               => 'Desa aquesta transacció movent-la a un altre compte:|Desa aquestes transaccions movent-les a un altre compte:',
    'save_transactions_by_moving_js'            => 'Sense transaccions.|Desa aquesta transacció movent-la a un altre compte. |Desa aquestes transaccions movent-les a un altre compte.',
    'stored_new_account'                        => 'S\'ha desat el compte nou ":name"!',
    'stored_new_account_js'                     => 'S\'ha desat el compte nou "<a href="accounts/show/{ID}">{name}</a>"!',
    'updated_account'                           => 'S\'ha actualitzat el compte ":name"',
    'updated_account_js'                        => 'S\'ha actualitzat el compte "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opcions de la targeta de crèdit',
    'no_transactions_account'                   => 'No hi ha cap transacció (en aquest període) per al compte d\'actius ":name".',
    'no_transactions_period'                    => 'No hi ha transaccions (en aquest període).',
    'no_data_for_chart'                         => 'No hi ha prou informació (encara) per a generar aquest gràfic.',
    'select_at_least_one_account'               => 'Per favor, selecciona almenys un compte d\'actius',
    'select_at_least_one_category'              => 'Per favor, selecciona almenys una categoria',
    'select_at_least_one_budget'                => 'Per favor, selecciona almenys un pressupost',
    'select_at_least_one_tag'                   => 'Per favor, selecciona almenys una etiqueta',
    'select_at_least_one_expense'               => 'Per favor, selecciona almenys una combinació de comptes de despeses/beneficis. Aquest informe no està disponible si no en tens cap (la llista està buida).',
    'account_default_currency'                  => 'Aquesta serà la nova moneda associada amb aquest compte.',
    'piggy_default_currency'                    => 'Les guardioles només poden estalviar diners en una sola moneda.',
    'piggy_account_currency_match'              => 'Només s\'acceptaran els comptes que utilitzin la moneda seleccionada anteriorment.',
    'reconcile_has_more'                        => 'La compatibilitat a Firefly III diu que tens més diners del que diu el teu banc. Tens diverses opcions. Per favor, tria què fer, i després prem a "Confirmar consolidació".',
    'reconcile_has_less'                        => 'La compatibilitat a Firefly III diu que tens menys diners del que diu el teu banc. Tens diverses opcions. Per favor, tria què fer, i després prem a "Confirmar consolidació".',
    'reconcile_is_equal'                        => 'La compatibilitat a Firefly III coincideix amb el que diu el teu banc. No cal fer res més. Per favor, prem a "Confirmar consolidació" per a confirmar l\'entrada.',
    'create_pos_reconcile_transaction'          => 'Buida les transaccions seleccionades, i crea una correcció afegint :amount a aquest compte d\'actius.',
    'create_neg_reconcile_transaction'          => 'Buida les transaccions seleccionades, i crea una correció eliminant :amount d\'aquest compte d\'actius.',
    'reconcile_do_nothing'                      => 'Buida les transaccions seleccionades, però no corregir res.',
    'reconcile_go_back'                         => 'Sempre pots editar o eliminar una correció més tard.',
    'must_be_asset_account'                     => 'Sols pots consolidar comptes d\'actius',
    'reconciliation_stored'                     => 'Consolidació desada',
    'reconciliation_error'                      => 'A causa d\'un error les transaccions han sigut marcades com a consolidades, però la correcció no s\'ha desat: :error.',
    'reconciliation_transaction_title'          => 'Consolidació (:from to :to)',
    'sum_of_reconciliation'                     => 'Suma de la consolidació',
    'reconcile_this_account'                    => 'Consolida aquest compte',
    'reconcile'                                 => 'Consolidar',
    'show'                                      => 'Mostra',
    'confirm_reconciliation'                    => 'Confirma la consolidació',
    'submitted_start_balance'                   => 'Enviat el balanç inicial',
    'selected_transactions'                     => 'Transaccions seleccionades (:count)',
    'already_cleared_transactions'              => 'Transaccions ja comprovades (:count)',
    'submitted_end_balance'                     => 'Enviat el balanç final',
    'initial_balance_description'               => 'Balanç inicial per a ":account"',
    'liability_credit_description'              => 'Crèdit de passius per a ":account"',
    'interest_calc_'                            => 'desconegut',
    'interest_calc_daily'                       => 'Per dia',
    'interest_calc_monthly'                     => 'Per mes',
    'interest_calc_yearly'                      => 'Per any',
    'interest_calc_weekly'                      => 'Per setmana',
    'interest_calc_half-year'                   => 'Cada mig any',
    'interest_calc_quarterly'                   => 'Per trimestre',
    'initial_balance_account'                   => 'Compte de balanç inicial de :account',
    'list_options'                              => 'Llista opcions',
    'account_column_opt_drag_and_drop'          => 'Arrossega i deixa anar',
    'account_column_opt_active'                 => 'Actiu',
    'account_column_opt_name'                   => 'Nom',
    'account_column_opt_type'                   => 'Tipus',
    'account_column_opt_liability_type'         => 'Tipus de passiu',
    'account_column_opt_liability_direction'    => 'Direcció del passiu',
    'account_column_opt_liability_interest'     => 'Interés del passiu',
    'account_column_opt_number'                 => 'Número de compte',
    'account_column_opt_current_balance'        => 'Balanç actual',
    'account_column_opt_amount_due'             => 'Import pendent',
    'account_column_opt_last_activity'          => 'Darrera activitat',
    'account_column_opt_balance_difference'     => 'Diferència de saldo',
    'account_column_opt_menu'                   => 'Menú',

    // categories:
    'new_category'                              => 'Nova categoria',
    'create_new_category'                       => 'Crear una nova categoria',
    'without_category'                          => 'Sense cap categoria',
    'update_category'                           => 'Actualitza la categoria',
    'updated_category'                          => 'Actualitzar la categoria ":name"',
    'categories'                                => 'Categories',
    'edit_category'                             => 'Editar la categoria ":name"',
    'no_category'                               => '(cap categoria)',
    'unknown_category_plain'                    => 'Sense categoria',
    'category'                                  => 'Categoria',
    'delete_category'                           => 'Eliminar categoria ":name"',
    'deleted_category'                          => 'S\'ha eliminat la categoria ":name"',
    'store_category'                            => 'Desa la nova categoria',
    'stored_category'                           => 'S\'ha desat la nova categoria ":name"',
    'without_category_between'                  => 'Sense categoria entre :start i :end',


    // transactions:
    'wait_loading_transaction'                  => 'Per favor, espera que carregui el formulari',
    'wait_loading_data'                         => 'Per favor, espera que carregui la teva informació...',
    'wait_attachments'                          => 'Per favor, espera que els adjunts es carreguin.',
    'errors_upload'                             => 'La pujada ha fallat. Per favor comprova la consola del teu navegador per a l\'error.',
    'amount_foreign_if'                         => 'Quantitat en la moneda estrangera, si aplica',
    'amount_destination_account'                => 'Quantitat en la moneda del compte de destí',
    'edit_transaction_title'                    => 'Editar transacció ":description"',
    'unreconcile'                               => 'Desfés la reconciliació',
    'update_withdrawal'                         => 'Actualitzar retirada',
    'update_deposit'                            => 'Actualitzar ingrés',
    'update_transaction'                        => 'Actualitzar transacció',
    'update_transfer'                           => 'Actualitzar transferència',
    'updated_withdrawal'                        => 'S\'ha actualitzat la retirada ":description"',
    'updated_deposit'                           => 'S\'ha actualitzat l\'ingrés ":description"',
    'updated_transfer'                          => 'S\'ha actualitzat la transferència ":description"',
    'no_changes_withdrawal'                     => 'La retirada ":description" no s\'ha canviat.',
    'no_changes_deposit'                        => 'L\'ingrès ":description" no s\'ha canviat.',
    'no_changes_transfer'                       => 'La transferència ":description" no s\'ha canviat.',
    'delete_withdrawal'                         => 'Elimina la retirada ":description"',
    'delete_deposit'                            => 'Elimina l\'ingrès ":description"',
    'delete_transfer'                           => 'Elimina la transferència ":description"',
    'deleted_withdrawal'                        => 'S\'ha eliminat la retirada ":description" satisfactòriament',
    'deleted_deposit'                           => 'S\'ha eliminat l\'ingrès ":description" satisfactòriament',
    'deleted_transfer'                          => 'S\'ha eliminat la transferència ":description" satisfactòriament',
    'deleted_reconciliation'                    => 'S\'ha eliminat la transacció de consolidació ":description" satisfactòriament',
    'stored_journal'                            => 'S\'ha creat la retirada ":description" satisfactòriament',
    'stored_journal_js'                         => 'S\'ha creat la transacció "{{description}}" correctament',
    'stored_journal_no_descr'                   => 'S\'ha creat la teua nova transacció satisfactòriament',
    'updated_journal_no_descr'                  => 'S\'ha actualitzat la teua transacció satisfactòriament',
    'select_transactions'                       => 'Selecciona transaccions',
    'rule_group_select_transactions'            => 'Aplica ":title" a totes les transaccions',
    'rule_select_transactions'                  => 'Aplica ":title" a totes les transaccions',
    'stop_selection'                            => 'Para de seleccionar transaccions',
    'reconcile_selected'                        => 'Consolidar',
    'mass_delete_journals'                      => 'Elimina un nombre de transaccions',
    'mass_edit_journals'                        => 'Edita un nombre de transaccions',
    'mass_bulk_journals'                        => 'Edita en grup un nombre de transaccions',
    'mass_bulk_journals_explain'                => 'Aquest formulari et permet canviar propietats de les transaccions següents en una mateixa actualització. Totes les transaccions de la taula seran actualitzades quan canvies els paràmetres mostrats ací.',
    'part_of_split'                             => 'Aquesta transacció forma part d\'una transacció dividida. Si no has seleccionat totes les divisions, pot ser que modifiques només algunes transaccions.',
    'bulk_set_new_values'                       => 'Utilitza les entrades següents per a establir nous valors. Si les deixes en blanc, es desaran en blanc per a tots. Tingues en compte que només les retirades seran assignades a un pressupost.',
    'no_bulk_category'                          => 'No actualitzes la categoria',
    'no_bulk_budget'                            => 'No actualitzes el pressupost',
    'no_bulk_tags'                              => 'No actualitzes la/les etiquetes',
    'replace_with_these_tags'                   => 'Reemplaça amb les següents etiquetes',
    'append_these_tags'                         => 'Afegeix aquestes etiquetes',
    'mass_edit'                                 => 'Edita la selecció individualment',
    'bulk_edit'                                 => 'Edita la selecció en grup',
    'mass_delete'                               => 'Elimina la selecció',
    'cannot_edit_other_fields'                  => 'No pots editar altres camps diferents als llistats, perquè no hi ha espai per a mostrar-los. Per favor, segueix l\'enllaç i edita-les una per una, si vols editar aquests camps.',
    'cannot_change_amount_reconciled'           => 'No podeu canviar l\'import ni el(s) compte(s) de les transaccions reconciliades.',
    'no_budget'                                 => '(cap pressupost)',
    'no_bill'                                   => '(cap subscripció)',
    'account_per_budget'                        => 'Compte per pressupost',
    'account_per_category'                      => 'Compte per categoria',
    'create_new_object'                         => 'Crear',
    'empty'                                     => '(buit)',
    'all_other_budgets'                         => '(tots els pressupostos)',
    'all_other_accounts'                        => '(tots els comptes)',
    'expense_per_source_account'                => 'Despeses per compte d\'origen',
    'expense_per_destination_account'           => 'Despeses per compte de destinació',
    'income_per_destination_account'            => 'Ingressos per compte de destinació',
    'spent_in_specific_category'                => 'Gastat a la categoria ":category"',
    'earned_in_specific_category'               => 'Guanyat a la categoria ":category"',
    'spent_in_specific_tag'                     => 'Gastat a l\'etiqueta ":tag"',
    'earned_in_specific_tag'                    => 'Guanyat a l\'etiqueta ":tag"',
    'income_per_source_account'                 => 'Ingressos per compte d\'origen',
    'average_spending_per_destination'          => 'Despeses mitjanes per compte de destí',
    'average_spending_per_source'               => 'Despeses mitjanes per compte d\'origen',
    'average_earning_per_source'                => 'Benefici mitjà per compte d\'origen',
    'average_earning_per_destination'           => 'Benefici mitjà per compte de destí',
    'account_per_tag'                           => 'Compte per etiqueta',
    'tag_report_expenses_listed_once'           => 'Les despeses i ingressos mai es mostren dues vegades. Si una transacció té varies etiquetes, pot ser sols es mostre en una d\'elles. Pot semblar que falten dades a aquesta llista, però les quantitats seran correctes.',
    'double_report_expenses_charted_once'       => 'Les despeses i ingressos mai es llisten dues vegades. Si una transacció té varies etiquetes, pot ser sols es mostre en una d\'elles. Pot semblar que falten dades a aquesta gràfica, però les quantitats seran correctes.',
    'tag_report_chart_single_tag'               => 'Aquesta gràfica s\'aplica a una única etiqueta. Si una transacció en té diverses, el que veuràs ací pot estar reflectit a les gràfiques d\'altres etiquetes també.',
    'tag'                                       => 'Etiqueta',
    'no_budget_squared'                         => '(cap pressupost)',
    'perm-delete-many'                          => 'Eliminar molts elements a la vegada pot causar problemes. Per favor, ves amb cura. Pots eliminar una part d\'una transacció dividida des d\'aquesta pàgina, així que ves amb compte.',
    'mass_deleted_transactions_success'         => 'S\'ha eliminat :count transacció.|S\'han eliminat :count transaccions.',
    'mass_edited_transactions_success'          => 'S\'ha actualitzat :count transacció.|S\'han actualitzat :count transaccions.',
    'opt_group_'                                => '(cap tipus de compte)',
    'opt_group_no_account_type'                 => '(cap tipus de compte)',
    'opt_group_defaultAsset'                    => 'Comptes d\'actius per defecte',
    'opt_group_savingAsset'                     => 'Comptes d\'estalvis',
    'opt_group_sharedAsset'                     => 'Comptes d\'actius per defecte',
    'opt_group_ccAsset'                         => 'Targetes de crèdit',
    'opt_group_cashWalletAsset'                 => 'Carteres d\'efectiu',
    'opt_group_expense_account'                 => 'Comptes de despeses',
    'opt_group_revenue_account'                 => 'Comptes d\'ingressos',
    'opt_group_l_Loan'                          => 'Passiu: prèstec',
    'opt_group_cash_account'                    => 'Compte d\'efectiu',
    'opt_group_l_Debt'                          => 'Passiu: Deute',
    'opt_group_l_Mortgage'                      => 'Passiu: Hipoteca',
    'opt_group_l_Credit card'                   => 'Passiu: Targeta de crèdit',
    'notes'                                     => 'Notes',
    'view_notes'                                => 'Veure notes',
    'set_budget_limit_notes'                    => 'Veure les notes per a aquest import pressupostat',
    'edit_bl_notes'                             => 'Editar notes',
    'update_bl_notes'                           => 'Actualitzar notes',
    'unknown_journal_error'                     => 'No s\'ha pogut desar la transacció. Per favor, revisa els arxius de registre.',
    'attachment_not_found'                      => 'No s\'ha trobat aquest adjunt.',
    'journal_link_bill'                         => 'Aquesta transacció està enllaçada a la subscripció <a href=":route">:name</a>. Per a eliminar la connexió, desmarca la casella. Utilitza regles per a connectar-la a una altra subscripció.',
    'transaction_stored_link'                   => 'La <a href="transactions/show/{ID}">Transacció #{ID} ("{title}")</a> s\'ha desat.',
    'transaction_new_stored_link'               => 'La <a href="transactions/show/{ID}">Transacció #{ID}</a> s\'ha desat.',
    'transaction_updated_link'                  => 'La <a href="transactions/show/{ID}">transacció#{ID}</a> ("{title}") s\'ha actualitzat.',
    'transaction_updated_no_changes'            => 'La <a href="transactions/show/{ID}">Transacció #{ID}</a> ("{title}") no ha sigut modificada.',
    'first_split_decides'                       => 'La primera divisió determina el valor d\'aquest camp',
    'first_split_overrules_source'              => 'La primera divisió pot sobreescriure el compte d\'origen',
    'first_split_overrules_destination'         => 'La primera divisió pot sobreescriure el compte de destinació',
    'spent_x_of_y'                              => 'Gastat {amount} de {total}',

    // new user:
    'welcome'                                   => 'Benvingut a Firefly III!',
    'submit'                                    => 'Enviar',
    'submission'                                => 'Enviament',
    'submit_yes_really'                         => 'Envia (sé el que estic fent)',
    'getting_started'                           => 'Començant',
    'to_get_started'                            => 'Ens alegrem de veure que has instal·lat Firefly III. Per a començar amb aquesta eine, per favor, introdueix el nom del teu banc, i el saldo del teu compte principal. No et preocupes si tens diversos comptes, els pots afegir més tard. Firefly III necessita alguna cosa amb la que començar.',
    'savings_balance_text'                      => 'Firefly III crearà un compte d\'estalvis automàticament per a tu. Per defecte no hi hauran diners en aquest compte, però si li ho ordenes, Firefly III desarà el saldo d\'aquest compte com a tal.',
    'finish_up_new_user'                        => 'Ja està! Per a continuar prem <strong>Envia</strong>. Seràs redirigit a la pàgina d\'inici de Firefly III.',
    'stored_new_accounts_new_user'              => 'Visca! S\'han desat els teus nous comptes.',
    'set_preferred_language'                    => 'Si prefereixes fer servir Firefly III en un altre idioma, ho pots canviar ací.',
    'language'                                  => 'Idioma',
    'new_savings_account'                       => 'Compte d\'estalvis de :bank_name',
    'cash_wallet'                               => 'Cartera d\'efectiu',
    'currency_not_present'                      => 'Si la moneda que fas servir normalment no ix a la llista, no et preocupes, pots crear la teua pròpia en Opcions > Monedes.',

    // home page:
    'transaction_table_description'             => 'Una taula amb les teues transaccions',
    'opposing_account'                          => 'Compte oposat',
    'yourAccounts'                              => 'Els teus comptes',
    'your_accounts'                             => 'Visió general del teu compte',
    'category_overview'                         => 'Visió general de Categoria',
    'expense_overview'                          => 'Visió general del compte de despeses',
    'revenue_overview'                          => 'Visió general del compte d\'ingressos',
    'budgetsAndSpending'                        => 'Pressupostos i despeses',
    'budgets_and_spending'                      => 'Pressupostos i despeses',
    'go_to_budget'                              => 'Ves al pressupost "{budget}"',
    'go_to_deposits'                            => 'Ves a ingressos',
    'go_to_expenses'                            => 'Ves a despeses',
    'savings'                                   => 'Estalvis',
    'newWithdrawal'                             => 'Nova despesa',
    'newDeposit'                                => 'Nou dipòsit',
    'newTransfer'                               => 'Nova transferència',
    'bills_to_pay'                              => 'Subscripcions a pagar',
    'per_day'                                   => 'Per dia',
    'left_to_spend_per_day'                     => 'Resta per a gastar per dia',
    'bills_paid'                                => 'Subscripcions pagades',
    'custom_period'                             => 'Període personalitzat',
    'reset_to_current'                          => 'Reinicia al període actual',
    'select_period'                             => 'Seleccionar període',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Moneda',
    'preferences'                               => 'Configuració',
    'logout'                                    => 'Tanca la sessió',
    'logout_other_sessions'                     => 'Tanca les altres sessions',
    'toggleNavigation'                          => 'Alternar navegació',
    'toggle_dropdown'                           => 'Commutar desplegable',
    'searchPlaceholder'                         => 'Cerca...',
    'version'                                   => 'Versió',
    'dashboard'                                 => 'Panell de control',
    'income_and_expense'                        => 'Ingressos i despeses',
    'all_money'                                 => 'Tots els teus diners',
    'unknown_source_plain'                      => 'Compte font desconegut',
    'unknown_dest_plain'                        => 'Compte de destí desconegut',
    'unknown_any_plain'                         => 'Compte desconegut',
    'unknown_budget_plain'                      => 'Cap pressupost',
    'available_budget'                          => 'Pressupost disponible ({currency})',
    'currencies'                                => 'Monedes',
    'activity'                                  => 'Activitat (exercici)',
    'usage'                                     => 'Ús',
    'accounts'                                  => 'Comptes',
    'Asset account'                             => 'Compte d\'actius',
    'Default account'                           => 'Compte d\'actius',
    'Expense account'                           => 'Compte de despeses',
    'Revenue account'                           => 'Compte de beneficis',
    'Initial balance account'                   => 'Compte de balanç inicial',
    'account_type_Asset account'                => 'Compte d\'actius',
    'account_type_Expense account'              => 'Compte de despeses',
    'account_type_Revenue account'              => 'Compte d\'ingressos',
    'account_type_Debt'                         => 'Deute',
    'account_type_Loan'                         => 'Crèdit',
    'account_type_Mortgage'                     => 'Hipoteca',
    'account_type_debt'                         => 'Deute',
    'account_type_loan'                         => 'Crèdit',
    'account_type_mortgage'                     => 'Hipoteca',
    'account_type_Credit card'                  => 'Targeta de crèdit',
    'credit_card_type_monthlyFull'              => 'Pagament complet tots els mesos',
    'liability_direction_credit'                => 'Se\'m deu aquest deute',
    'liability_direction_debit'                 => 'Dec aquest deute a una altra persona',
    'liability_direction_credit_short'          => 'Se\'m deu',
    'liability_direction_debit_short'           => 'Ho dec',
    'liability_direction__short'                => 'Desconegut',
    'liability_direction_null_short'            => 'Desconegut',
    'Liability credit'                          => 'Crèdit de passius',
    'budgets'                                   => 'Pressupostos',
    'tags'                                      => 'Etiquetes',
    'reports'                                   => 'Informes',
    'transactions'                              => 'Transaccions',
    'expenses'                                  => 'Despeses',
    'income'                                    => 'Beneficis / ingressos',
    'transfers'                                 => 'Transferències',
    'moneyManagement'                           => 'Gestió dels diners',
    'money_management'                          => 'Gestió dels diners',
    'tools'                                     => 'Eines',
    'piggyBanks'                                => 'Guardioles',
    'piggy_banks'                               => 'Guardioles',
    'amount_x_of_y'                             => '{current} de {total}',
    'bills'                                     => 'Subscripcions',
    'withdrawal'                                => 'Retirada',
    'opening_balance'                           => 'Saldo inicial',
    'deposit'                                   => 'Ingrés',
    'account'                                   => 'Compte',
    'transfer'                                  => 'Transferència',
    'Withdrawal'                                => 'Retirada',
    'Deposit'                                   => 'Ingrés',
    'Transfer'                                  => 'Transferència',
    'bill'                                      => 'Subscripció',
    'yes'                                       => 'Sí',
    'no'                                        => 'No',
    'amount'                                    => 'Import',
    'overview'                                  => 'Visió general',
    'saveOnAccount'                             => 'Desa al compte',
    'saveOnAccounts'                            => 'Desa al(s) compte(s)',
    'unknown'                                   => 'Desconegut',
    'monthly'                                   => 'Mensualment',
    'profile'                                   => 'Perfil',
    'errors'                                    => 'Errors',
    'debt_start_date'                           => 'Data d\'inici del deute',
    'debt_start_amount'                         => 'Quantitat d\'inici del deute',
    'debt_start_amount_help'                    => 'Sempre és millor establir aquest valor a una quantitat negativa. Revisa les pàgines d\'ajuda (la icona (?) de dalt a la dreta) per a més informació.',
    'interest_period_help'                      => 'Aquest camp és simplement cosmètic, i no serà calculat. Resulta que els banc són bastant exquisits, i Firefly III mai obté els valors correctament.',
    'store_new_liabilities_account'             => 'Desa el nou passiu',
    'edit_liabilities_account'                  => 'Edita el passiu ":name"',
    'financial_control'                         => 'Control financer',
    'accounting'                                => 'Comptes',
    'automation'                                => 'Automatització',
    'others'                                    => 'Altres',
    'classification'                            => 'Classificació',
    'store_transaction'                         => 'Desar transacció',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Informe financer per defecte entre :start i :end',
    'report_audit'                              => 'Visió general de l\'historial de transaccions entre :start i :end',
    'report_category'                           => 'Informe de categories entre :start i :end',
    'report_double'                             => 'Informe de comptes de despeses/beneficis entre :start i :end',
    'report_budget'                             => 'Informe de pressupost entre :start i :end',
    'report_tag'                                => 'Informe d\'etiquetes entre :start i :end',
    'quick_link_reports'                        => 'Enllaços ràpids',
    'quick_link_examples'                       => 'Aquests són alguns enllaços d\'exemple per a ajudar-te a començar. Llegeix les pàgines d\'ajuda en la icona (?) per a informació sobre tots els informes i les paraules màgiques que pots fer servir.',
    'quick_link_default_report'                 => 'Informe financer per defecte',
    'quick_link_audit_report'                   => 'Visió general de l\'historial de transaccions',
    'report_this_month_quick'                   => 'Mes actual, tots els comptes',
    'report_last_month_quick'                   => 'Últim mes, tots els comptes',
    'report_this_year_quick'                    => 'Any actual, tots els comptes',
    'report_this_fiscal_year_quick'             => 'Any fiscal actual, tots els comptes',
    'report_all_time_quick'                     => 'Des de sempre, tots els comptes',
    'reports_can_bookmark'                      => 'Recorda que els informes poden ser marcats.',
    'incomeVsExpenses'                          => 'Ingressos vs. despeses',
    'accountBalances'                           => 'Saldo del compte',
    'balanceStart'                              => 'Saldo a l\'inici del període',
    'balanceEnd'                                => 'Saldo al final del període',
    'splitByAccount'                            => 'Divideix per compte',
    'coveredWithTags'                           => 'Cobert per etiquetes',
    'leftInBudget'                              => 'Restant al pressupost',
    'left_in_debt'                              => 'Import pendent',
    'sumOfSums'                                 => 'Suma de sumes',
    'noCategory'                                => '(cap categoria)',
    'notCharged'                                => 'No cobrat (encara)',
    'inactive'                                  => 'Inactiu',
    'active'                                    => 'Actiu',
    'difference'                                => 'Diferència',
    'money_flowing_in'                          => 'Entrant',
    'money_flowing_out'                         => 'Eixint',
    'topX'                                      => ':number primers',
    'show_full_list'                            => 'Mostra la llista sencera',
    'show_only_top'                             => 'Mostra sols els millors :number',
    'report_type'                               => 'Tipus d\'informe',
    'report_type_default'                       => 'Informe financer per defecte',
    'report_type_audit'                         => 'Visió general de l\'historial de transaccions (auditoria)',
    'report_type_category'                      => 'Informe de categoria',
    'report_type_budget'                        => 'Informe de pressupost',
    'report_type_tag'                           => 'Informe d\'etiqueta',
    'report_type_double'                        => 'Informe del compte de despeses/guanys',
    'more_info_help'                            => 'Pots trobar més informació sobre aquests tipus d\'informe a les pàgines d\'ajuda. Prem la icona (?) a la part superior dreta.',
    'report_included_accounts'                  => 'Comptes inclosos',
    'report_date_range'                         => 'Interval de dates',
    'report_preset_ranges'                      => 'Intervals predefinits',
    'shared'                                    => 'Compartit',
    'fiscal_year'                               => 'Any fiscal',
    'income_entry'                              => 'Els ingressos del compte ":name" entre el :start i :end',
    'expense_entry'                             => 'Les despeses al compte ":name" entre el :start i :end',
    'category_entry'                            => 'Despeses i ingressos de la categoria ":name" entre el :start i :end',
    'budget_spent_amount'                       => 'Despeses al pressupost ":budget" entre :start i :end',
    'balance_amount'                            => 'Despeses al pressupost ":budget" pagats des del compte ":account" entre el :start i :end',
    'no_audit_activity'                         => 'No s\'ha desat cap activitat al compte <a href=":url" title=":account_name">:account_name</a> entre el :start i :end.',
    'audit_end_balance'                         => 'Saldo del compte <a href=":url" title=":account_name">:account_name</a> al final de :end va ser :balance',
    'reports_extra_options'                     => 'Opcions extra',
    'report_has_no_extra_options'               => 'Aquest informe no té més opcions',
    'reports_submit'                            => 'Veure informe',
    'end_after_start_date'                      => 'La data final de l\'informe ha de ser després de la d\'inici.',
    'select_category'                           => 'Escull categories',
    'select_budget'                             => 'Escull pressupostos.',
    'select_tag'                                => 'Escull etiquetes.',
    'income_per_category'                       => 'Ingressos per categoria',
    'expense_per_category'                      => 'Despeses per categoria',
    'expense_per_budget'                        => 'Gastat per pressupost',
    'income_per_account'                        => 'Ingressos per compte',
    'expense_per_account'                       => 'Despeses per compte',
    'expense_per_tag'                           => 'Depeses per compte',
    'income_per_tag'                            => 'Ingressos per compte',
    'include_expense_not_in_budget'             => 'Les despeses incloses no hi són al pressupost(os) seleccionats',
    'include_expense_not_in_account'            => 'Les despeses seleccionades no estan als comptes seleccionats',
    'include_expense_not_in_category'           => 'Les depeses incloses no estan a les categories seleccionades',
    'include_income_not_in_category'            => 'Els ingressos seleccionats no estan a les categories seleccionades',
    'include_income_not_in_account'             => 'Els ingressos seleccionats no estan a les categories seleccionades',
    'include_income_not_in_tags'                => 'Els ingressos seleccionats no estan a les etiquetes seleccionades',
    'include_expense_not_in_tags'               => 'Les despeses seleccionades no estan a les etiquetes seleccionades',
    'everything_else'                           => 'Tota la resta',
    'income_and_expenses'                       => 'Ingressos i despeses',
    'spent_average'                             => 'Gastat (mitjana)',
    'income_average'                            => 'Ingressat (mitjana)',
    'transaction_count'                         => 'Nombre de transaccions',
    'average_spending_per_account'              => 'Despesa mitjana per compte',
    'average_income_per_account'                => 'Ingrés mitjà per compte',
    'total'                                     => 'Total',
    'description'                               => 'Descripció',
    'sum_of_period'                             => 'Suma del període',
    'average_in_period'                         => 'Mitjana al període',
    'no_account_role'                           => '(sense rol)',
    'account_role_defaultAsset'                 => 'Compte d\'actius per defecte',
    'account_role_sharedAsset'                  => 'Compte d\'actius compartit',
    'account_role_savingAsset'                  => 'Compte d\'estalvis',
    'account_role_ccAsset'                      => 'Targeta de crèdit',
    'account_role_cashWalletAsset'              => 'Cartera d\'efectiu',
    'budget_chart_click'                        => 'Per favor, fes clic al nom del pressupost a la taula superior per a veure una gràfica.',
    'category_chart_click'                      => 'Per favor, fes clic al nom de la categoria a la taula superior per a veure una gràfica.',
    'in_out_accounts'                           => 'Guanyat i gastat per combinació',
    'in_out_accounts_per_asset'                 => 'Guanyat i gastat (per compte d\'actius)',
    'in_out_per_category'                       => 'Guanyat i gastat per categoria',
    'out_per_budget'                            => 'Gastat per pressupost',
    'select_expense_revenue'                    => 'Selecciona el compte de despeses/beneficis',
    'multi_currency_report_sum'                 => 'Com que aquesta llista conté comptes amb monedes diferents, la/les sumes poden no tenir sentit. El report sempre es mostrarà en la moneda per defecte.',
    'sum_in_default_currency'                   => 'La suma sempre estarà en la teua moneda per defecte.',
    'net_filtered_prefs'                        => 'Aquesta gràfica mai inclourà comptes que tenen la casella "Inclou al valor net" desmarcada.',


    // charts:
    'chart'                                     => 'Gràfica',
    'month'                                     => 'Mes',
    'budget'                                    => 'Pressupost',
    'spent'                                     => 'Gastat',
    'spent_capped'                              => 'Gastat (capat)',
    'spent_in_budget'                           => 'Gastat al pressupost',
    'left_to_spend'                             => 'Queda per gastar',
    'earned'                                    => 'Guanyat',
    'overspent'                                 => 'Gastat de més',
    'left'                                      => 'Queda',
    'max-amount'                                => 'Import màxim',
    'min-amount'                                => 'Import mínim',
    'journal-amount'                            => 'Entrada de subscripció actual',
    'name'                                      => 'Nom',
    'expires_at'                                => 'Caduca a les',
    'date'                                      => 'Data',
    'date_and_time'                             => 'Hora i data',
    'time'                                      => 'Hora',
    'paid'                                      => 'Pagat',
    'unpaid'                                    => 'Pendent de pagament',
    'day'                                       => 'Dia',
    'budgeted'                                  => 'Pressupostat',
    'period'                                    => 'Període',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Entrades + Sortides aquest període',
    'sum'                                       => 'Suma',
    'summary'                                   => 'Resum',
    'average'                                   => 'Mitjana',
    'balanceFor'                                => 'Saldo per a :name',
    'no_tags'                                   => '(cap etiqueta)',
    'nothing_found'                             => '(no s\'ha trobat res)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Configuració de pàgina',
    'visible_columns'               => 'Columnes visibles',
    'accounts_to_show'              => 'Comptes a mostrar',
    'active_accounts_only'          => 'Només comptes actius',
    'in_active_accounts_only'       => 'Només comptes inactius',
    'show_all_accounts'             => 'Mostra tots els comptes',
    'group_accounts'                => 'Agrupa comptes',

    // piggy banks:
    'event_history'                 => 'Historial d\'esdeveniments',
    'add_money_to_piggy'            => 'Afegeix diners a la guardiola ":name"',
    'piggy_bank'                    => 'Guardiola',
    'new_piggy_bank'                => 'Guardiola nova',
    'store_piggy_bank'              => 'Desa una nova guardiola',
    'stored_piggy_bank'             => 'Desa la nova guardiola ":name"',
    'account_status'                => 'Estat del compte',
    'left_for_piggy_banks'          => 'Queda per a les guardioles',
    'sum_of_piggy_banks'            => 'Suma de les guardioles',
    'saved_so_far'                  => 'Estalviat fins ara',
    'saved_so_far_total'            => 'Estalviat fins ara en total',
    'reset_history'                 => 'restablir historial',
    'reset_history_confirm'         => 'Esteu segur que voleu restablir l\'historial d\'aquesta guardiola? Això farà que el gràfic torni a coincidir amb l\'import de la guardiola.',
    'piggy_history_reset'           => 'L\'historial de la guardiola s\'ha reiniciat',
    'left_to_save'                  => 'Queda per estalviar',
    'suggested_amount'              => 'Quantitat mensual suggerida per estalviar',
    'add_money_to_piggy_title'      => 'Afegeix diners a la guardiola ":name"',
    'remove_money_from_piggy_title' => 'Retira diners de la guardiola ":name"',
    'add'                           => 'Afegeix',
    'no_money_for_piggy'            => 'No tens diners per a posar en aquesta guardiola.',
    'suggested_savings_per_month'   => 'Suggerit al mes',

    'remove'                    => 'Suprimeix',
    'max_amount_add'            => 'L\'import màxim que pots afegir és',
    'max_amount_remove'         => 'L\'import màxim que pots eliminar és',
    'update_piggy_button'       => 'Actualitza la guardiola',
    'update_piggy_title'        => 'Actualitza la guardiola ":name"',
    'updated_piggy_bank'        => 'S\'ha actualitzat la guardiola ":name"',
    'details'                   => 'Detalls',
    'events'                    => 'Esdeveniments',
    'target_amount'             => 'Quantitat objectiu',
    'start_date'                => 'Data d\'inici',
    'no_start_date'             => 'Cap data d\'inici',
    'target_date'               => 'Data objectiu',
    'no_target_date'            => 'Cap data objectiu',
    'table'                     => 'Taula',
    'delete_piggy_bank'         => 'Elimina la guardiola ":name"',
    'cannot_add_amount_piggy'   => 'No s\'ha pogut afegir :amount a ":name".',
    'cannot_remove_from_piggy'  => 'No s\'ha pogut eliminar :amount de ":name".',
    'deleted_piggy_bank'        => 'S\'ha eliminat la guardiola ":name"',
    'added_amount_to_piggy'     => 'S\'ha afegit :amount a ":name"',
    'removed_amount_from_piggy' => 'S\'ha eliminat :amount de ":name"',
    'piggy_events'              => 'Guardioles relacionades',

    // tags
    'delete_tag'                => 'Elimina l\'etiqueta ":tag"',
    'deleted_tag'               => 'S\'ha eliminat l\'etiqueta ":tag"',
    'new_tag'                   => 'Crea una etiqueta',
    'edit_tag'                  => 'Edita l\'etiqueta ":tag"',
    'updated_tag'               => 'S\'ha actualitzat l\'etiqueta ":tag"',
    'created_tag'               => 'L\'etiqueta ":tag" ha sigut creada!',

    'transaction_journal_information'               => 'Informació de la transacció',
    'transaction_journal_amount'                    => 'Informació de la quantitat',
    'transaction_journal_meta'                      => 'Metainformació',
    'transaction_journal_more'                      => 'Més informació',
    'basic_journal_information'                     => 'Informació de transacció bàsica',
    'transaction_journal_extra'                     => 'Informació addicional',
    'att_part_of_journal'                           => 'Desada en ":journal"',
    'total_amount'                                  => 'Import total',
    'number_of_decimals'                            => 'Nombre de decimals',


    // administration
    'invite_is_already_redeemed'                    => 'La invitació a ":address" ja ha sigut gastada.',
    'invite_is_deleted'                             => 'La invitació a ":address" ha sigut eliminada.',
    'invite_new_user_title'                         => 'Invitar nou usuari',
    'invite_new_user_text'                          => 'Com a administrador, podeu convidar usuaris a registrar-se a la vostra instal·lació de Firefly III. Mitjançant l\'enllaç directe que podeu compartir amb ells, podran registrar un compte. L\'usuari convidat i el seu enllaç d\'invitació apareixeran a la taula següent. Podeu compartir l\'enllaç d\'invitació amb ells.',
    'invited_user_mail'                             => 'Correu electrònic',
    'invite_user'                                   => 'Convida l\'usuari',
    'user_is_invited'                               => 'El correu electrònic ":address" s\'ha convidat a Firefly III',
    'administration'                                => 'Administració',
    'system_settings'                               => 'Configuració del sistema',
    'code_already_used'                             => 'El code d\'invitació ja s\'ha gastat',
    'user_administration'                           => 'Administració d\'usuaris',
    'list_all_users'                                => 'Tots els usuaris',
    'all_users'                                     => 'Tots els usuaris',
    'instance_configuration'                        => 'Configuració',
    'firefly_instance_configuration'                => 'Configuració de Firefly III',
    'setting_single_user_mode'                      => 'Mode d\'un sol usuari',
    'setting_single_user_mode_explain'              => 'Per defecte, Firefly III sols accepta (1) registre: tu. Aquesta és una mesura de seguretat, que prevent que qualsevol altra persona accedeixa a la instància sense el teu permís. Els registres futurs es bloquejaran. Si desmarques aquesta casella, altres persones podran fer ús de la instància, sempre i quant tingues accés (quan està connectada a Internet).',
    'store_configuration'                           => 'Desa la configuració',
    'single_user_administration'                    => 'Administració d\'usuari per a :email',
    'edit_user'                                     => 'Edita l\'usuari :email',
    'hidden_fields_preferences'                     => 'Pots habilitar més opcions de transacció a la <a href="preferences">configuració</a>.',
    'user_data_information'                         => 'Dades d\'usuari',
    'user_information'                              => 'Informació d\'usuari',
    'total_size'                                    => 'mida total',
    'budget_or_budgets'                             => ':count pressupost|:count pressuposts',
    'budgets_with_limits'                           => ':count pressupost amb quantitat configurada|:count pressupostos amb quantitat configurada',
    'nr_of_rules_in_total_groups'                   => ':count_rules regla/regles en :count_groups grup/grups',
    'tag_or_tags'                                   => ':count etiqueta|:count etiquetes',
    'configuration_updated'                         => 'La configuració s\'ha actualitzat',
    'setting_is_demo_site'                          => 'Lloc de prova',
    'setting_is_demo_site_explain'                  => 'Si marques aquesta casella, la instal·lacció es comportarà com el lloc de prova. Açò pot tindre efectes adversos.',
    'block_code_bounced'                            => 'Correus electrònics retornats',
    'block_code_expired'                            => 'El compte de prova ha expirat',
    'no_block_code'                                 => 'No hi ha cap motiu per a bloquejar, o l\'usuari no està bloquejat',
    'demo_user_export'                              => 'La demo no pot exportar dades',
    'block_code_email_changed'                      => 'L\'usuari encara no ha confirmat la seua direcció de correu electrònic',
    'admin_update_email'                            => 'A diferència de la pàgina de perfil, l\'usuari NO serà notificat si es canvia la seva adreça electrònica!',
    'update_user'                                   => 'Actualitza l\'usuari',
    'updated_user'                                  => 'Les dades de l\'usuari s\'han actualitzat.',
    'delete_user'                                   => 'Eliminar l\'usuari :email',
    'user_deleted'                                  => 'S\'ha eliminat l\'usuari',
    'send_test_email'                               => 'Envia un correu de prova',
    'send_test_email_text'                          => 'Per veure si la vostra instal·lació pot enviar una notificació, premeu aquest botó. Aquí no veureu cap error (si n\'hi ha), <strong>els fitxers de registre reflectiran qualsevol error</strong>. Podeu prémer aquest botó tantes vegades com vulgueu. No hi ha control de correu brossa. El missatge s\'enviarà a <code>:email</code> i hauria d\'arribar en breu.',
    'send_message'                                  => 'Enviar missatge',
    'send_test_triggered'                           => 'La prova s\'ha enviat. Comprova la teua safata d\'entrada, i els arxius de registre.',
    'give_admin_careful'                            => 'Els usuaris que tinguin el permís d\'administrador poden fer-se amb el teu compte. Ves amb cura.',
    'admin_maintanance_title'                       => 'Manteniment',
    'admin_maintanance_expl'                        => 'Alguns botons per al manteniment de Firefly III',
    'admin_maintenance_clear_cache'                 => 'Esborra la memòria cau',
    'owner_notifications'                           => 'Notificacions d\'administració',
    'owner_notifications_expl'                      => 'L\'administrador pot activar o desactivar les notificacions següents. S\'enviaran per TOTS els canals configurats. Alguns canals estan configurats a les variables d\'entorn, d\'altres es poden definir aquí.',
    'channel_settings'                              => 'Configuració dels canals de notificació',
    'notification_test_failed'                      => 'La prova de notificació per al canal ":channel" ha fallat. Els registres tindran més detalls.',
    'notification_test_executed'                    => 'S\'ha executat la prova de notificació per al canal ":channel". Consulteu els registres per obtenir més informació.',
    'settings_notifications'                        => 'Configuració de les notificacions',
    'title_owner_notifications'                     => 'Notificacions de propietari',
    'owner_notification_check_user_new_reg'         => 'L\'usuari rep un missatge de benvinguda després del registre',
    'owner_notification_check_admin_new_reg'        => 'L\'administrador/administradors rep una notificació de nou registre',
    'owner_notification_check_new_version'          => 'Nova versió disponible',
    'owner_notification_check_invite_created'       => 'Un usuari ha estat convidat a Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Una invitació ha sigut bescanviada',
    'owner_notification_check_unknown_user_attempt' => 'Un usuari desconegut intenta iniciar sessió',
    'all_invited_users'                             => 'Tots els usuaris convidats',
    'save_notification_settings'                    => 'Desa la configuració',
    'notification_settings'                         => 'Configuració de les notificacions',
    'notification_settings_saved'                   => 'La configuració de notificacions s\'ha desat',
    'available_channels_title'                      => 'Canals disponibles',
    'available_channels_expl'                       => 'Aquests canals estan disponibles per enviar notificacions. Per provar la configuració, utilitzeu els botons següents. Tingueu en compte que els botons no tenen control de correu brossa.',
    'notification_channel_name_email'               => 'Correu electrònic',
    'slack_discord_double'                          => 'El canal de notificacions de Slack també pot enviar notificacions a Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'no disponible',
    'configure_channel_in_env'                      => 'necessita variables d\'entorn',
    'test_notification_channel_name_email'          => 'Correu electrònic de prova',
    'test_notification_channel_name_slack'          => 'Prova de Slack',
    'test_notification_channel_name_ntfy'           => 'Prova de Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Prova de Pushover',
    'test_notification_channel_name_gotify'         => 'Prova de Gotify',
    'test_notification_channel_name_pushbullet'     => 'Prova de Pushbullet',

    'split_transaction_title'               => 'Descripció de la transacció dividida',
    'split_transaction_title_help'          => 'Si crees una transacció dividida, ha d\'haver una descripció global per a totes les divisions de la transacció.',
    'split_title_help'                      => 'Si crees una transacció dividida, ha d\'haver una descripció global per a totes les divisions de la transacció.',
    'you_create_transfer'                   => 'Estàs creant una transferència.',
    'you_create_withdrawal'                 => 'Estàs creant una retirada.',
    'you_create_deposit'                    => 'Estàs creant un ingrés.',

    // links
    'journal_link_configuration'            => 'Configuració dels enllaços de la transacció',
    'create_new_link_type'                  => 'Crea un nou tipus d\'enllaç',
    'store_new_link_type'                   => 'Desa el nou tipus d\'enllaç',
    'update_link_type'                      => 'Actualitza el tipus d\'enllaç',
    'edit_link_type'                        => 'Edita el tipus d\'enllaç ":name"',
    'updated_link_type'                     => 'S\'ha actualitzat el tipus d\'enllaç ":name"',
    'delete_link_type'                      => 'Elimina el tipus d\'enllaç ":name"',
    'deleted_link_type'                     => 'S\'ha eliminat el tipus d\'enllaç ":name"',
    'stored_new_link_type'                  => 'Desa el nou tipus d\'enllaç ":name"',
    'cannot_edit_link_type'                 => 'No s\'ha pogut editar el tipus d\'enllaç ":name"',
    'link_type_help_name'                   => 'Ie. "Duplicats"',
    'link_type_help_inward'                 => 'Ie. "duplicats"',
    'link_type_help_outward'                => 'Ie. "està duplicat per"',
    'save_connections_by_moving'            => 'Desa l\'enllaç entre aquestes transaccions movent-les a un altre tipus d\'enllaç:',
    'do_not_save_connection'                => '(no deses la connexió)',
    'link_transaction'                      => 'Enllaça la transacció',
    'link_to_other_transaction'             => 'Enllaça aquesta transacció a una altra',
    'select_transaction_to_link'            => 'Seleccioneu una transacció per vincular-la. Actualment, els enllaços no s\'utilitzen a Firefly III (a part de mostrar-se), però tinc previst canviar-ho en el futur. Utilitzeu el quadre de cerca per seleccionar una transacció per títol o per ID. Si voleu afegir tipus d\'enllaç personalitzats, consulteu la configuració.',
    'this_transaction'                      => 'Aquesta transacció',
    'transaction'                           => 'Transacció',
    'comments'                              => 'Comentaris',
    'link_notes'                            => 'Qualsevol nota que vulgues desar amb l\'enllaç.',
    'invalid_link_selection'                => 'No s\'han pogut enllaçar les transaccions',
    'selected_transaction'                  => 'Transacció selecionada',
    'journals_linked'                       => 'Les transaccions estan enllaçades.',
    'journals_error_linked'                 => 'Aquestes transaccions ja estan enllaçades.',
    'journals_link_to_self'                 => 'No pots enllaçar una transacció a ella mateixa',
    'journal_links'                         => 'Enllaços de transacció',
    'this_withdrawal'                       => 'Aquesta retirada',
    'this_deposit'                          => 'Aquest ingrés',
    'this_transfer'                         => 'Aquesta transferència',
    'overview_for_link'                     => 'Visió general per al tipus d\'enllaç ":name"',
    'source_transaction'                    => 'Transacció d\'origen',
    'link_description'                      => 'Descripció de l\'enllaç',
    'destination_transaction'               => 'Transacció de destinació',
    'delete_journal_link'                   => 'Elimina l\'enllaç entre <a href=":source_link">:source</a> i <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Enllaç eliminat',

    // link translations:
    'Paid_name'                             => 'Pagat',
    'Refund_name'                           => 'Reemborsar',
    'Reimbursement_name'                    => 'Reemborsament',
    'Related_name'                          => 'Relacionat',
    'relates to_inward'                     => 'fa referència a',
    'is (partially) refunded by_inward'     => 'està (parcialment) reemborsada per',
    'is (partially) paid for by_inward'     => 'està (parcialment) pagada per',
    'is (partially) reimbursed by_inward'   => 'està (parcialment) reemborsada per',
    'inward_transaction'                    => 'Transacció entrant',
    'outward_transaction'                   => 'Transacció eixint',
    'relates to_outward'                    => 'fa referència a',
    '(partially) refunds_outward'           => 'reemborsa (parcialment)',
    '(partially) pays for_outward'          => 'paga per (parcialment)',
    '(partially) reimburses_outward'        => 'reemborsa (parcialment)',
    'is (partially) refunded by'            => 'està (parcialment) reemborsada per',
    'is (partially) paid for by'            => 'està (parcialment) pagada per',
    'is (partially) reimbursed by'          => 'està (parcialment) reemborsada per',
    'relates to'                            => 'fa referència a',
    '(partially) refunds'                   => 'reemborsa (parcialment)',
    '(partially) pays for'                  => 'paga per (parcialment)',
    '(partially) reimburses'                => 'reemborsa (parcialment)',

    // split a transaction:
    'splits'                                => 'Divisió',
    'add_another_split'                     => 'Afegeix una nova divisió',
    'cannot_edit_opening_balance'           => 'No pots editar el balanç d\'obertura d\'un compte.',
    'no_edit_multiple_left'                 => 'No has seleccionat cap transacció per a editar.',
    'breadcrumb_convert_group'              => 'Converteix la transacció',
    'convert_invalid_source'                => 'La informació d\'origen és invàlida per a la transacció #%d.',
    'convert_invalid_destination'           => 'La informació de destinació és invàlida per a la transacció #%d.',
    'create_another'                        => 'Després de guardar, torna ací per crear-ne un altre.',
    'after_update_create_another'           => 'Després d\'actualitzar, torna ací per a seguir editant.',
    'store_as_new'                          => 'Desa com a una nova transacció, en comptes d\'actualitzar.',
    'reset_after'                           => 'Reiniciar el formulari després d\'enviar',
    'errors_submission'                     => 'Hi ha hagut un error amb el teu enviament. Per favor, revisa els errors de sota.',
    'errors_submission_v2'                  => 'Hi ha hagut un error amb el teu enviament. Per favor, comprova els següents errors: {{errorMessage}}',
    'transaction_expand_split'              => 'Expandeix la divisió',
    'transaction_remove_split'              => 'Eliminar partició',
    'transaction_collapse_split'            => 'Contrau la divisió',

    // object groups
    'default_group_title_name'              => '(no agrupades)',
    'default_group_title_name_plain'        => 'no agrupades',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Anem a crear un compte d\'actius!',
    'no_accounts_intro_asset'               => 'No tens cap compte d\'actius encara. Els comptes d\'actius són els teus comptes principals: comptes d\'ingressos, d\'estalvis, compartits, o inclús la teua targeta de crèdit.',
    'no_accounts_imperative_asset'          => 'Per a començar a gastar Firefly III has de crear com a mínim un compte d\'actius. Som-hi!',
    'no_accounts_create_asset'              => 'Crea un nou compte d\'actius',
    'no_accounts_title_expense'             => 'Anem a crear un compte de despeses!',
    'no_accounts_intro_expense'             => 'No tens cap compte de despeses encara. Els comptes de despeses són els llocs on gastes diners, com tendes o supermercats.',
    'no_accounts_imperative_expense'        => 'Els comptes de despeses es creen automàticament quan crees transaccions, no obstant, els pots crear manualment també, si vols. Anem a crear-ne un ara:',
    'no_accounts_create_expense'            => 'Crea un compte de despeses',
    'no_accounts_title_revenue'             => 'Anem a crear un compte d\'ingressos!',
    'no_accounts_intro_revenue'             => 'No tens cap compte d\'ingressos encara. Els comptes d\'ingressos són els llocs dels quals reps diners, com el teu cap, o empresa, per exemple.',
    'no_accounts_imperative_revenue'        => 'Els comptes d\'ingressos es creen automàticament quan crees transaccions, no obstant, els pots crear manualment també, si vols. Anem a crear-ne un ara:',
    'no_accounts_create_revenue'            => 'Crea un nou compte de beneficis',
    'no_accounts_title_liabilities'         => 'Anem a crear un passiu!',
    'no_accounts_intro_liabilities'         => 'Encara no tens cap passiu. Els passius són els comptes en els quals registres els teus deutes i préstecs.',
    'no_accounts_imperative_liabilities'    => 'No cal que faces servir aquesta funció, però pot ser útil per a tindre un registre d\'aquestes coses.',
    'no_accounts_create_liabilities'        => 'Crea un nou passiu',
    'no_budgets_title_default'              => 'Anem a crear un pressupost',
    'no_rules_title_default'                => 'Anem a crear una regla',
    'no_budgets_intro_default'              => 'No tens cap pressupost encara. Els pressupostos es fan servir per a organitzar les teves despeses en grups lògics, als quals els pots posar un límit per a limitar les teves despeses.',
    'no_rules_intro_default'                => 'No tens cap regla encara. Les regles són automatitzacions potents que poden administrar transaccions per a tu.',
    'no_rules_imperative_default'           => 'Les regles són molt útils quan estàs administrant transaccions. Creem-ne una:',
    'no_budgets_imperative_default'         => 'Els pressupostos són les eines bàsiques d\'administració financera. Creem-ne una:',
    'no_budgets_create_default'             => 'Crea un pressuport',
    'no_rules_create_default'               => 'Crea una regla',
    'no_categories_title_default'           => 'Anem a crear una categoria!',
    'no_categories_intro_default'           => 'No tens cap categoria encara. Les categories es fan servir per a ajustar les teues transaccions, i etiquetar-les amb la corresponent categoria.',
    'no_categories_imperative_default'      => 'Les categories es creen automàticament quan crees transaccions, però en pots crear una manualment. Anem a fer-ho:',
    'no_categories_create_default'          => 'Crea una categoria',
    'no_tags_title_default'                 => 'Anem a crear una etiqueta!',
    'no_tags_intro_default'                 => 'No tens cap etiqueta encara. Les etiquetes es fan servir per a ajustar les teves transaccions, i etiquetar-les amb paraules claus específiques.',
    'no_tags_imperative_default'            => 'Les etiquetes es creen automàticament quan crees transaccions, però les pots crear manualment també. Anem a fer-ho:',
    'no_tags_create_default'                => 'Crea una etiqueta',
    'no_transactions_title_withdrawal'      => 'Creem una despesa!',
    'no_transactions_intro_withdrawal'      => 'No tens cap despesa encara. Hauries de crear despeses per a començar a administrar les teves finances.',
    'no_transactions_imperative_withdrawal' => 'Has gastat diners? Doncs hauries d\'anotar-ho:',
    'no_transactions_create_withdrawal'     => 'Crea una despesa',
    'no_transactions_title_deposit'         => 'Anem a crear un ingrés!',
    'no_transactions_intro_deposit'         => 'No tens cap ingrés registrat encara. Hauries de crear algun per a començar a administrar les teves finances.',
    'no_transactions_imperative_deposit'    => 'Has rebut diners? Hauries d\'anotar-ho:',
    'no_transactions_create_deposit'        => 'Crea un ingrés',
    'no_transactions_title_transfers'       => 'Anem a crear una transferència!',
    'no_transactions_intro_transfers'       => 'No tens cap transferència encara. Quan mogues diners entre comptes, es desarà com una transferència.',
    'no_transactions_imperative_transfers'  => 'Has mogut diners? Ho hauries d\'anotar:',
    'no_transactions_create_transfers'      => 'Crea una transferència',
    'no_piggies_title_default'              => 'Anem a crear una guardiola!',
    'no_piggies_intro_default'              => 'No tens cap guardiola encara. Pots crear guardioles per a dividir els teus estalvis, i saber per a què estàs estalviant.',
    'no_piggies_imperative_default'         => 'Estàs guardant diners per a alguna cosa? Crea una guardiola, i segueix el procés:',
    'no_piggies_create_default'             => 'Crea una nova guardiola',
    'no_bills_title_default'                => 'Creem una subscripció!',
    'no_bills_intro_default'                => 'Encara no tens cap subscripció. Pots crear subscripcions per fer un seguiment de les despeses habituals, com ara el lloguer o l\'assegurança.',
    'no_bills_imperative_default'           => 'Tens subscripcions regulars? Crea una subscripció i fes un seguiment dels teus pagaments:',
    'no_bills_create_default'               => 'Crea una subscripció',

    // recurring transactions
    'recurrence_max_count'                  => 'Aquestes transaccions recurrents es crearan com a màxim :max time(s), i ja s\'han creat :count time(s).',
    'create_right_now'                      => 'Crea ara mateix',
    'no_new_transaction_in_recurrence'      => 'No s\'ha creat cap transacció. Pot ser ja s\'havia executat per a aquesta data?',
    'recurrences'                           => 'Transaccions recurrents',
    'repeat_until_in_past'                  => 'Aquesta transacció recurrent es va parar d\'executar el :date.',
    'recurring_calendar_view'               => 'Calendari',
    'no_recurring_title_default'            => 'Anem a crear una transacció recurrent!',
    'no_recurring_intro_default'            => 'No tens cap transacció recurrent. Fes servir aquesta funció per a que Firefly III cree transaccions automàticament per a tu.',
    'no_recurring_imperative_default'       => 'És una funció bastant avançada, però que et pot ser molt útil. Assegura\'t de llegir la documentació, a la icona (?) de dalt a la dreta, abans de continuar.',
    'no_recurring_create_default'           => 'Crea una transacció recurrent',
    'make_new_recurring'                    => 'Crea una transacció recurrent',
    'recurring_daily'                       => 'Cada dia',
    'recurring_weekly'                      => 'Cada dia els :weekday',
    'recurring_weekly_skip'                 => 'Cada :skip(a) setmana els :weekday',
    'recurring_monthly'                     => 'Cada mes al dia :dayOfMonth',
    'recurring_monthly_skip'                => 'Cada mes :skip el dia :dayOfMonth',
    'recurring_ndom'                        => 'Cada mes els :weekday dia :dayOfMonth',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Cada any els :date',
    'overview_for_recurrence'               => 'Visió general per a la transacció recurrent ":title"',
    'warning_duplicates_repetitions'        => 'En algun cas extrany, pot ser que les dates apareguen dobles a la llista. Pot passar quan varies repeticions coincideixen. Firefly III sempre generarà una transacció al dia.',
    'created_transactions'                  => 'Transaccions relacionades',
    'expected_withdrawals'                  => 'Retirades esperades',
    'expected_deposits'                     => 'Ingressos esperats',
    'expected_transfers'                    => 'Transferències esperades',
    'created_withdrawals'                   => 'Retirades creades',
    'created_deposits'                      => 'Ingressos creats',
    'created_transfers'                     => 'Transferències creades',
    'recurring_info'                        => 'Transacció recurrent :count / :total',
    'created_from_recurrence'               => 'Creat de la transacció recurrent ":title" (#:id)',
    'recurring_never_cron'                  => 'Sembla que el treball cron que és necessari per a les transaccions recurrents no s\'ha executat mai. Açò és normal si acabes d\'instal·lar Firefly III, però hauria d\'executar-se el més prompte possible. Revisa les pàgines d\'ajuda fent servir la icona (?) a la part superior dreta de la pàgina.',
    'recurring_cron_long_ago'               => 'Sembla que fa més de 36 hores que s\'ha executat el treball cron per última vegada. Segur que està ben configurat? Per favor, revisa les pàgines d\'ajuda fent servir la icona (?) de dalt a la dreta.',

    'create_new_recurrence'              => 'Crea una nova transacció recurrent',
    'help_first_date'                    => 'Indica la primera recurrència esperada. Ha de ser en el futur.',
    'help_first_date_no_past'            => 'Indica la primera recurrència esperada. Firefly III no crearà transaccions en el passat.',
    'no_currency'                        => '(sense moneda)',
    'mandatory_for_recurring'            => 'Informació de recurrència requerida',
    'mandatory_for_transaction'          => 'Informació de transacció requerida',
    'optional_for_recurring'             => 'Informació de recurrència opcional',
    'optional_for_transaction'           => 'Informació de transacció opcional',
    'change_date_other_options'          => 'Canvia la "primera data" per a veure més opcions.',
    'mandatory_fields_for_tranaction'    => 'Els valors ací acabaran sent les transaccions que es creen',
    'click_for_calendar'                 => 'Fes clic ací per a veure un calendari que mostra quan la transacció es repetirà.',
    'repeat_forever'                     => 'Repeteix per a sempre',
    'repeat_until_date'                  => 'Repeteix fins a',
    'repeat_times'                       => 'Repeteix un nombre de vegades',
    'recurring_skips_one'                => 'Cada',
    'recurring_skips_more'               => 'Salta :count repeticions',
    'store_new_recurrence'               => 'Desa la transacció recurrent',
    'stored_new_recurrence'              => 'La transacció recurrent ":title" s\'ha desat correctament.',
    'edit_recurrence'                    => 'Edita la transacció recurrent ":title"',
    'recurring_repeats_until'            => 'Es repeteix fins a :date',
    'recurring_repeats_forever'          => 'Es repeteix per a sempre',
    'recurring_repeats_x_times'          => 'Es repeteix :count vegada|Es repeteix :count vegades',
    'update_recurrence'                  => 'Actualitza la transacció recurrent',
    'updated_recurrence'                 => 'S\'ha actualitzat la transacció recurrent ":title"',
    'recurrence_is_inactive'             => 'Aquesta transacció recurrent no està activa i no generarà noves transaccions.',
    'delete_recurring'                   => 'Elimina la transacció recurrent ":title"',
    'new_recurring_transaction'          => 'Nova transacció recurrent',
    'help_weekend'                       => 'Què hauria de fer Firefly III quan la transacció cau dissabte o diumenge?',
    'do_nothing'                         => 'Simplement crea la transacció',
    'skip_transaction'                   => 'Salta la ocurrència',
    'jump_to_friday'                     => 'Crea la transacció el divendres anterior',
    'jump_to_monday'                     => 'Crea la transacció el següent dilluns',
    'will_jump_friday'                   => 'Serà creada divendres en comptes de al cap de setmana.',
    'will_jump_monday'                   => 'Serà creada dilluns en comptes de al cap de setmana.',
    'except_weekends'                    => 'Excepte els caps de setmana',
    'recurrence_deleted'                 => 'S\'ha eliminat la transacció recurrent ":title"',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Gastat (:currency)',
    'box_earned_in_currency'             => 'Guanyat (:currency)',
    'box_budgeted_in_currency'           => 'Pressupostat (:currency)',
    'box_bill_paid_in_currency'          => 'Subscripcions pagades (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscripcions no pagades (:currency)',
    'box_left_to_spend_in_currency'      => 'Queda per gastar (:currency)',
    'box_net_worth_in_currency'          => 'Valor net (:currency)',
    'box_spend_per_day'                  => 'Queda per gastar al dia: :amount',

    // debug page
    'debug_page'                         => 'Pàgina de debug',
    'debug_submit_instructions'          => 'Si tens cpa problema, pots gastar la informació d\'aquesta pàgina com a informació de debug. Per favor, copia i enganxa en una <a href="https://github.com/firefly-iii/firefly-iii/issues">issue de Github</a> existent o una nova. Generarà una taula que serà útil per a poder diagnosticar el teu problema ràpidament.',
    'debug_pretty_table'                 => 'Si copies i enganxes aquesta capsa en una issue de GitHub generarà una taula. Per favor, no rodeges aquest text amb asteriscs o apòstrofs.',
    'debug_additional_data'              => 'També pots compartir els continguts de la caixa. Pots copiar i enganxar-los en una <a href="https://github.com/firefly-iii/firefly-iii/issues">issue de GitHub</a> nova, o una ja existent. No obstant, el contingut de la capsa pot tenir informació privada, com nom de comptes, detalls de transaccions o direccions de correu electrònic.',

    // object groups
    'object_groups_menu_bar'             => 'Grups',
    'object_groups_page_title'           => 'Grups',
    'object_groups_breadcrumb'           => 'Grups',
    'object_groups_index'                => 'Visió general',
    'object_groups'                      => 'Grups',
    'object_groups_empty_explain'        => 'Algunes coses a Firefly III pot ser dividida en grups. Les guardioles, per exemple, tenen una funció de grup en la pàgina de creació i edició. Quan estableixen aquest camp, pots editar els noms, i ordenar els grups en aquesta pàgina. Per a més informació, llegeix les pàgines d\'ajuda en la icona (?) de dalt a la dreta.',
    'object_group_title'                 => 'Títol',
    'edit_object_group'                  => 'Edita el grup ":title"',
    'delete_object_group'                => 'Elimina el grup ":title"',
    'update_object_group'                => 'Actualiza el grup',
    'updated_object_group'               => 'S\'ha actualitzat el grup ":title" satisfactòriament',
    'deleted_object_group'               => 'S\'ha eliminat el grup ":title" satisfactòriament',
    'object_group'                       => 'Grup',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audita les entrades de registre',
    'ale_action_log_add'                 => 'S\'ha afegit :amount a la guardiola ":name"',
    'ale_action_log_remove'              => 'S\'ha eliminat :amount de la guardiola ":name"',
    'ale_action_clear_budget'            => 'Eliminat del pressupost',
    'ale_action_update_group_title'      => 'S\'ha actualitzat el títol del grup de transaccions',
    'ale_action_update_date'             => 'S\'ha actualitzat la data de transacció',
    'ale_action_update_order'            => 'S\'ha actualitzat l\'ordre de transaccions',
    'ale_action_clear_category'          => 'Eliminat de la categoria',
    'ale_action_clear_notes'             => 'Notes eliminades',
    'ale_action_clear_tag'               => 'Etiqueta buidada',
    'ale_action_clear_all_tags'          => 'Buidades totes les etiquetes',
    'ale_action_set_bill'                => 'Enllaçada a la subscripció',
    'ale_action_switch_accounts'         => 'S\'han canviat els comptes font i de destinació',
    'ale_action_set_budget'              => 'Establir pressupost',
    'ale_action_set_category'            => 'Establir categoria',
    'ale_action_set_source'              => 'Establir compte d\'origen',
    'ale_action_set_destination'         => 'Establir compte de destinació',
    'ale_action_update_transaction_type' => 'Tipus de transacció canviat',
    'ale_action_update_notes'            => 'Notes canviades',
    'ale_action_update_description'      => 'Descripció canviada',
    'ale_action_add_to_piggy'            => 'Guardiola',
    'ale_action_remove_from_piggy'       => 'Guardiola',
    'ale_action_add_tag'                 => 'Etiqueta afegida',
    'ale_action_update_amount'           => 'Quantitat actualitzada',

    // dashboard
    'enable_auto_convert'                => 'Habilita la conversió de moneda',
    'disable_auto_convert'               => 'Deshabilita la conversió de moneda',
];
