<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => '은행명',
    'bank_balance'                 => '잔고',
    'current_balance'              => '현재 잔고',
    'savings_balance'              => '저축 잔액',
    'credit_card_limit'            => '신용카드 한도',
    'automatch'                    => '자동으로 일치',
    'skip'                         => '건너뛰기',
    'enabled'                      => '활성화',
    'name'                         => '이름',
    'active'                       => '활성',
    'amount_min'                   => '최소 금액',
    'amount_max'                   => '최대 금액',
    'match'                        => '일치',
    'strict'                       => '엄격 모드',
    'repeat_freq'                  => '반복',
    'object_group'                 => '그룹',
    'location'                     => '위치',
    'update_channel'               => '업데이트 채널',
    'currency_id'                  => '통화',
    'transaction_currency_id'      => '통화',
    'auto_budget_currency_id'      => '통화',
    'external_ip'                  => '서버 외부 IP',
    'attachments'                  => '첨부 파일',
    'BIC'                          => '은행식별코드(BIC)',
    'verify_password'              => '비밀번호 보안 확인',
    'source_account'               => '자산',
    'destination_account'          => '대상 자산',
    'asset_destination_account'    => '대상 자산',
    'include_net_worth'            => '순자산에 포함',
    'asset_source_account'         => '자산',
    'journal_description'          => '상세정보',
    'note'                         => '노트',
    'currency'                     => '통화',
    'account_id'                   => '자산 계좌',
    'budget_id'                    => '예산',
    'bill_id'                      => '구독',
    'opening_balance'              => '초기 잔고',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => '가상 잔고',



    'targetamount'                 => '목표 금액',
    'target_amount'                => '목표 금액',
    'account_role'                 => '계좌 역할',
    'opening_balance_date'         => '개설일',
    'cc_type'                      => '신용카드 결재 계획',
    'cc_monthly_payment_date'      => '신용카드 월 납부일',
    'piggy_bank_id'                => '저금통',
    'returnHere'                   => '여기로 돌아옴',
    'returnHereExplanation'        => '저장후 이 페이지로 돌아와 다른 것을 만듭니다.',
    'returnHereUpdateExplanation'  => '업데이트 후 여기로 돌아옵니다.',
    'description'                  => '설명',
    'expense_account'              => '지출 계좌',
    'revenue_account'              => '수익 계좌',
    'decimal_places'               => '소수 자릿수',
    'destination_amount'           => '금액 (대상)',
    'new_email_address'            => '새로운 이메일 주소',
    'verification'                 => '인증',
    'api_key'                      => 'API 키',
    'remember_me'                  => '기억하기',
    'liability_type_id'            => '부채 유형',
    'liability_type'               => '부채 유형',
    'interest'                     => '이자',
    'interest_period'              => '이자 기간',
    'extension_date'               => '연장일',
    'type'                         => '유형',
    'convert_Withdrawal'           => '출금 전환',
    'convert_Deposit'              => '입금 전환',
    'convert_Transfer'             => '이체 전환',
    'amount'                       => '금액',
    'foreign_amount'               => '외화 금액',
    'date'                         => '날짜',
    'interest_date'                => '이자 날짜',
    'book_date'                    => '예약일',
    'process_date'                 => '처리일',
    'category'                     => '카테고리',
    'tags'                         => '태그',
    'deletePermanently'            => '영구 삭제',
    'cancel'                       => '취소',
    'targetdate'                   => '목표일',
    'target_date'                  => '목표일',
    'startdate'                    => '시작일',
    'start_date'                   => '시작일',
    'tag'                          => '태그',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => '아래',
    'symbol'                       => '심볼',
    'code'                         => '코드',
    'iban'                         => 'IBAN',
    'account_number'               => '계좌 번호',
    'creditCardNumber'             => '카드 번호',
    'has_headers'                  => '헤더',
    'date_format'                  => '날짜 형식',
    'attachments[]'                => '첨부 파일',
    'title'                        => '제목',
    'notes'                        => '메모',
    'filename'                     => '파일명',
    'mime'                         => 'Mime 형식',
    'size'                         => '크기',
    'trigger'                      => '트리거',
    'stop_processing'              => '처리 중단',
    'end_date'                     => '종료일',
    'enddate'                      => '종료 날짜',
    'move_rules_before_delete'     => '규칙 그룹',
    'start'                        => '범위의 시작',
    'end'                          => '범위의 끝',
    'delete_account'               => '":name" 계좌 삭제',
    'delete_webhook'               => '":title" 웹훅 삭제',
    'delete_bill'                  => '":name" 구독 삭제',
    'delete_budget'                => '":name" 예산 삭제',
    'delete_category'              => '":name" 카테고리 삭제',
    'delete_currency'              => '":name" 통화 삭제',
    'delete_journal'               => '설명이 ":description"인 거래 삭제',
    'delete_attachment'            => '":name" 첨부파일 삭제',
    'delete_rule'                  => '":title" 규칙 삭제',
    'delete_rule_group'            => '":title" 규칙 그룹 삭제',
    'delete_link_type'             => '":name" 링크 유형 삭제',
    'delete_user'                  => '":email" 사용자 삭제',
    'delete_recurring'             => '":title" 반복 거래 삭제',
    'user_areYouSure'              => '":email" 사용자를 삭제하면 사용자의 모든 정보가 사라지며 이것은 취소할 수 없습니다. 자신을 삭제하면 이 Firefly III 인스턴스에 접근할 수 없게됩니다.',
    'attachment_areYouSure'        => '":name" 첨부파일을 삭제하시겠습니까?',
    'account_areYouSure'           => '":name" 계좌를 삭제하시겠습니까?',
    'account_areYouSure_js'        => '"{name}" 계좌를 삭제하시겠습니까?',
    'bill_areYouSure'              => '":name" 구독을 삭제하시겠습니까?',
    'rule_areYouSure'              => '":title" 규칙을 삭제하시겠습니까?',
    'object_group_areYouSure'      => '":title" 그룹을 삭제하시겠습니까?',
    'ruleGroup_areYouSure'         => '":title" 규칙 그룹을 삭제하시겠습니까?',
    'budget_areYouSure'            => '":name" 예산을 삭제하시겠습니까?',
    'webhook_areYouSure'           => '":title" 웹훅을 삭제하시겠습니까?',
    'category_areYouSure'          => '":name" 카테고리를 삭제하시겠습니까?',
    'recurring_areYouSure'         => '":title" 반복 거래를 삭제하시겠습니까?',
    'currency_areYouSure'          => '":name" 통화를 삭제하시겠습니까?',
    'piggyBank_areYouSure'         => '":name" 저금통을 삭제하시겠습니까?',
    'journal_areYouSure'           => '":description"으로 설명된 거래를 정말 삭제하시겠습니까?',
    'mass_journal_are_you_sure'    => '이 거래를 정말로 삭제할까요?',



    'tag_areYouSure'               => '":tag" 태그를 정말 삭제하시겠습니까?',
    'journal_link_areYouSure'      => '<a href=":source_link">:source</a>와 <a href=":destination_link">:destination</a> 사이의 링크를 정말로 삭제하시겠습니까?',
    'linkType_areYouSure'          => '":name" (":inward" / ":outward")인 링크 유형을 정말로 삭제하시겠습니까?',
    'permDeleteWarning'            => 'Firefly III에서 삭제한 항목은 다시 되돌릴 수 없습니다.',
    'mass_make_selection'          => '체크박스을 해제하여 항목이 삭제되지 않도록 할 수 있습니다.',
    'delete_all_permanently'       => '선택한 항목을 영구적으로 삭제',
    'update_all_journals'          => '이 거래 업데이트',
    'also_delete_transactions'     => '이 계좌에 연결된 거래 내역이 함께 삭제됩니다.|이 계좌에 연결된 :count개의 거래 내역이 삭제됩니다.',
    'also_delete_transactions_js'  => '거래 내역이 존재하지 않습니다|이 계좌에 연결된 거래 내역이 함께 삭제됩니다.|이 계좌에 연결된 {count} 개의 거래 내역이 삭제됩니다.',
    'also_delete_connections'      => '이 링크 유형과 연결된 유일한 거래의 연결이 끊어집니다.|이 링크 유형과 연결된 모든 :count개의 거래의 연결이 끊어집니다.',
    'also_delete_rules'            => '이 규칙 그룹에 연결된 유일한 규칙이 삭제됩니다.|이 규칙 그룹에 연결된 모든 :count개의 규칙이 삭제됩니다.',
    'also_delete_piggyBanks'       => '이 계좌에 연결된 저금통이 함께 삭제됩니다.|이 계좌에 연결된 :count 개의 저금통이 삭제됩니다.',
    'also_delete_piggyBanks_js'    => '저금통이 존재하지 않습니다|이 계좌에 연결된 저금통이 함께 삭제됩니다.|이 계좌에 연결된 {count} 개의 저금통이 삭제됩니다.',
    'not_delete_piggy_banks'       => '이 그룹에 연결된 저금통은 삭제되지 않습니다|이 그룹에 연결된 :count개의 저금통은 삭제되지 않습니다.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => '이 예산에 연결된 유일한 거래는 삭제되지 않습니다.|이 예산에 연결된 모든 :count개의 거래는 삭제되지 않습니다.',
    'category_keep_transactions'   => '이 카테고리에 연결된 유일한 거래는 삭제되지 않습니다.|이 카테고리에 연결된 모든 :count개의 거래는 삭제되지 않습니다.',
    'recurring_keep_transactions'  => '이 반복 거래에 의해 생성된 유일한 거래는 삭제되지 않습니다.|이 반복 거래에 의해 생성된 모든 :count개의 거래는 삭제되지 않습니다.',
    'tag_keep_transactions'        => '이 태그에 연결된 유일한 거래는 삭제되지 않습니다.|이 태그에 연결된 모든 :count개의 거래는 삭제되지 않습니다.',
    'check_for_updates'            => '업데이트 확인',
    'liability_direction'          => '부채 입출금',
    'delete_object_group'          => '":title" 그룹 삭제',
    'email'                        => '이메일 주소',
    'password'                     => '비밀번호',
    'password_confirmation'        => '비밀번호 (확인)',
    'blocked'                      => '차단되었나요?',
    'blocked_code'                 => '차단 이유',
    'login_name'                   => '로그인',
    'is_owner'                     => '관리자인가요?',
    'url'                          => 'URL',
    'bill_end_date'                => '종료 날짜',

    // import
    'apply_rules'                  => '규칙 적용',
    'artist'                       => '아티스트',
    'album'                        => '앨범',
    'song'                         => '노래',

    // admin
    'domain'                       => '도메인',
    'single_user_mode'             => '사용자 등록 비활성화',
    'is_demo_site'                 => '데모사이트입니다.',

    // import
    'configuration_file'           => '설정 파일',
    'csv_comma'                    => '쉼표 (,)',
    'csv_semicolon'                => '세미콜론 (;)',
    'csv_tab'                      => '탭 (보이지 않음)',
    'csv_delimiter'                => 'CSV 필드 구분기호',
    'client_id'                    => '클라이언트 ID',
    'app_id'                       => '앱 ID',
    'secret'                       => '시크릿',
    'public_key'                   => '공개 키',
    'country_code'                 => '국가 코드',
    'provider_code'                => '은행 또는 데이터제공자',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => '포트',
    'fints_bank_code'              => '은행 코드',
    'fints_username'               => '사용자명',
    'fints_password'               => 'PIN / 비밀번호',
    'fints_account'                => 'FinTS 계좌',
    'local_account'                => 'Firefly III 계정',



    'from_date'                    => '시작 날짜',
    'to_date'                      => '종료 날짜',
    'due_date'                     => '기한',
    'payment_date'                 => '결제일',
    'invoice_date'                 => '청구서 날짜',
    'internal_reference'           => '내부 참조',
    'inward'                       => '내부 설명',
    'outward'                      => '외부 설명',
    'rule_group_id'                => '규칙 그룹',
    'transaction_description'      => '거래 상세내역',
    'first_date'                   => '최초 일자',
    'transaction_type'             => '거래 유형',
    'repeat_until'                 => '반복 기한',
    'recurring_description'        => '반복 거래 설명',
    'repetition_type'              => '반복 유형',
    'foreign_currency_id'          => '외화',
    'repetition_end'               => '반복 종료',
    'repetitions'                  => '반복',
    'calendar'                     => '달력',
    'weekend'                      => '주말',
    'client_secret'                => '클라이언트 시크릿',
    'withdrawal_destination_id'    => '대상 자산',
    'deposit_source_id'            => '자산',
    'expected_on'                  => '예상 일자',
    'paid'                         => '지불됨',
    'auto_budget_type'             => '자동 예산',
    'auto_budget_amount'           => '자동 예산 금액',
    'auto_budget_period'           => '자동 예산 기간',
    'collected'                    => '획득함',
    'submitted'                    => '제출됨',
    'key'                          => '키',
    'value'                        => '기록 내용',
    'webhook_delivery'             => '전달',
    'webhook_response'             => '응답',
    'webhook_trigger'              => '트리거',
    'pushover_app_token'           => 'Pushover 앱 토큰',
    'pushover_user_token'          => 'Pushover 유저 토큰',
    'ntfy_server'                  => 'Ntfy 서버',
    'ntfy_topic'                   => 'Ntfy 토픽',
    'ntfy_auth'                    => 'Ntfy 인증 활성',
    'ntfy_user'                    => 'Ntfy 계정',
    'ntfy_pass'                    => 'Ntfy 암호',
];
