<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org.
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

use FireflyIII\Enums\AccountTypeEnum;
use FireflyIII\Enums\TransactionTypeEnum;
use FireflyIII\Models\Account;
use FireflyIII\Models\Bill;
use FireflyIII\Models\Budget;
use FireflyIII\Models\Category;
use FireflyIII\Models\PiggyBank;
use FireflyIII\Models\Recurrence;
use FireflyIII\Models\Tag;
use FireflyIII\Models\Transaction;
use FireflyIII\Models\TransactionJournal;
use FireflyIII\TransactionRules\Actions\AddTag;
use FireflyIII\TransactionRules\Actions\ClearBudget;
use FireflyIII\TransactionRules\Actions\ClearCategory;
use FireflyIII\TransactionRules\Actions\ClearNotes;
use FireflyIII\TransactionRules\Actions\ConvertToDeposit;
use FireflyIII\TransactionRules\Actions\ConvertToTransfer;
use FireflyIII\TransactionRules\Actions\ConvertToWithdrawal;
use FireflyIII\TransactionRules\Actions\DeleteTransaction;
use FireflyIII\TransactionRules\Actions\LinkToBill;
use FireflyIII\TransactionRules\Actions\RemoveAllTags;
use FireflyIII\TransactionRules\Actions\RemoveTag;
use FireflyIII\TransactionRules\Actions\SetAmount;
use FireflyIII\TransactionRules\Actions\SetBudget;
use FireflyIII\TransactionRules\Actions\SetCategory;
use FireflyIII\TransactionRules\Actions\SetDescription;
use FireflyIII\TransactionRules\Actions\SetDestinationAccount;
use FireflyIII\TransactionRules\Actions\SetDestinationToCashAccount;
use FireflyIII\TransactionRules\Actions\SetNotes;
use FireflyIII\TransactionRules\Actions\SetSourceAccount;
use FireflyIII\TransactionRules\Actions\SetSourceToCashAccount;
use FireflyIII\TransactionRules\Actions\SwitchAccounts;
use FireflyIII\TransactionRules\Actions\UpdatePiggyBank;

/*
 * DO NOT EDIT THIS FILE. IT IS AUTO GENERATED.
 *
 * ANY OPTIONS IN THIS FILE YOU CAN SAFELY EDIT CAN BE FOUND IN THE USER INTERFACE OF FIREFLY III.
 */

return [
    // default values for certain things:
    'configuration'                => [
        'single_user_mode' => true,
        'is_demo_site'     => false,
    ],
    // some feature flags:
    'feature_flags'                => [
        'export'                 => true,
        'telemetry'              => false,
        'webhooks'               => true,
        'handle_debts'           => true,
        'expression_engine'      => true,
        'running_balance_column' => env('USE_RUNNING_BALANCE', false),
        // see cer.php for exchange rates feature flag.
    ],
    'version'                      => '6.4.2',
    'build_time'                   => 1759824590,
    'api_version'                  => '2.1.0', // field is no longer used.
    'db_version'                   => 28, // field is no longer used.

    // generic settings
    'maxUploadSize'                => 1073741824, // 1 GB
    'send_error_message'           => env('SEND_ERROR_MESSAGE', true),
    'site_owner'                   => env('SITE_OWNER', ''),

    // tokens and keys
    'fixer_api_key'                => env('FIXER_API_KEY', ''),
    'ipinfo_token'                 => env('IPINFO_TOKEN', ''),
    'static_cron_token'            => envNonEmpty('STATIC_CRON_TOKEN'),

    // flags
    'enable_external_map'          => env('ENABLE_EXTERNAL_MAP', false),
    'disable_frame_header'         => env('DISABLE_FRAME_HEADER', false),
    'disable_csp_header'           => env('DISABLE_CSP_HEADER', false),
    'allow_webhooks'               => env('ALLOW_WEBHOOKS', false),

    // flags
    'send_report_journals'         => envNonEmpty('SEND_REPORT_JOURNALS', true),

    // info for demo site
    'demo_username'                => env('DEMO_USERNAME', ''),
    'demo_password'                => env('DEMO_PASSWORD', ''),
    'tracker_site_id'              => env('TRACKER_SITE_ID', ''),
    'tracker_url'                  => env('TRACKER_URL', ''),

    // authentication settings
    'authentication_guard'         => envNonEmpty('AUTHENTICATION_GUARD', 'web'),
    'custom_logout_url'            => envNonEmpty('CUSTOM_LOGOUT_URL', ''),

    // static config (cannot be changed by user)
    'update_endpoint'              => 'https://version.firefly-iii.org/index.json',
    'update_minimum_age'           => 7,


    // enabled languages
    'languages'                    => [
        // currently enabled languages
        // 'af_ZA' => ['name_locale' => 'Afrikaans', 'name_english' => 'Afrikaans'],
        'ar_SA' => ['name_locale' => 'العربية', 'name_english' => 'Arabic'],
        'bg_BG' => ['name_locale' => 'Български', 'name_english' => 'Bulgarian'],
        'cs_CZ' => ['name_locale' => 'Czech', 'name_english' => 'Czech'],
        'da_DK' => ['name_locale' => 'Danish', 'name_english' => 'Danish'],
        'de_DE' => ['name_locale' => 'Deutsch', 'name_english' => 'German'],
        'el_GR' => ['name_locale' => 'Ελληνικά', 'name_english' => 'Greek'],
        'en_GB' => ['name_locale' => 'English (GB)', 'name_english' => 'English (GB)'],
        'en_US' => ['name_locale' => 'English (US)', 'name_english' => 'English (US)'],
        'es_ES' => ['name_locale' => 'Español', 'name_english' => 'Spanish'],
        'ca_ES' => ['name_locale' => 'Català (Espanya)', 'name_english' => 'Catalan (Spain)'],
        //        'et_EE' => ['name_locale' => 'Estonian', 'name_english' => 'Estonian'],
        'fa_IR' => ['name_locale' => 'فارسی', 'name_english' => 'Persian'],
        'fi_FI' => ['name_locale' => 'Suomi', 'name_english' => 'Finnish'],
        'fr_FR' => ['name_locale' => 'Français', 'name_english' => 'French'],
        //        'he_IL' => ['name_locale' => 'Hebrew', 'name_english' => 'Hebrew'],
        'hu_HU' => ['name_locale' => 'Hungarian', 'name_english' => 'Hungarian'],
        'id_ID' => ['name_locale' => 'Bahasa Indonesia', 'name_english' => 'Indonesian'],
        //        'is_IS' => ['name_locale' => 'Icelandic', 'name_english' => 'Icelandic'],
        'it_IT' => ['name_locale' => 'Italiano', 'name_english' => 'Italian'],
        'ja_JP' => ['name_locale' => 'Japanese', 'name_english' => 'Japanese'],
        'ko_KR' => ['name_locale' => 'Korean', 'name_english' => 'Korean'],
        //        'lt_LT' => ['name_locale' => 'Lietuvių', 'name_english' => 'Lithuanian'],

        'nb_NO' => ['name_locale' => 'Norsk Bokmål', 'name_english' => 'Norwegian Bokmål'],
        'nn_NO' => ['name_locale' => 'Norsk Nynorsk', 'name_english' => 'Norwegian Nynorsk'],
        'nl_NL' => ['name_locale' => 'Nederlands', 'name_english' => 'Dutch'],
        'pl_PL' => ['name_locale' => 'Polski', 'name_english' => 'Polish'],
        'pt_BR' => ['name_locale' => 'Português do Brasil', 'name_english' => 'Portuguese (Brazil)'],
        'pt_PT' => ['name_locale' => 'Português', 'name_english' => 'Portuguese'],
        'ro_RO' => ['name_locale' => 'Română', 'name_english' => 'Romanian'],
        'ru_RU' => ['name_locale' => 'Русский', 'name_english' => 'Russian'],
        //        'si_LK' => ['name_locale' => 'සිංහල', 'name_english' => 'Sinhala (Sri Lanka)'],
        'sk_SK' => ['name_locale' => 'Slovenčina', 'name_english' => 'Slovak'],
        'sl_SI' => ['name_locale' => 'Slovenian', 'name_english' => 'Slovenian'],
        // //        'sr_CS' => ['name_locale' => 'Serbian (Latin)', 'name_english' => 'Serbian (Latin)'],
        'sv_SE' => ['name_locale' => 'Svenska', 'name_english' => 'Swedish'],
        //        // 'tlh_AA' => ['name_locale' => 'tlhIngan Hol', 'name_english' => 'Klingon'],
        'tr_TR' => ['name_locale' => 'Türkçe', 'name_english' => 'Turkish'],
        'uk_UA' => ['name_locale' => 'Українська', 'name_english' => 'Ukrainian'],
        'vi_VN' => ['name_locale' => 'Tiếng Việt', 'name_english' => 'Vietnamese'],
        'zh_TW' => ['name_locale' => 'Chinese Traditional', 'name_english' => 'Chinese Traditional'],
        'zh_CN' => ['name_locale' => 'Chinese Simplified', 'name_english' => 'Chinese Simplified'],
    ],

    // web configuration:
    'trusted_proxies'              => env('TRUSTED_PROXIES', ''),

    // map configuration
    'default_location'             => [
        'longitude'  => env('MAP_DEFAULT_LONG', '5.916667'),
        'latitude'   => env('MAP_DEFAULT_LAT', '51.983333'),
        'zoom_level' => env('MAP_DEFAULT_ZOOM', '6'),
    ],

    // administration specific preferences
    'admin_specific_prefs'         => [],

    // default user-related values
    'darkMode'                     => 'browser',
    'list_length'                  => 10, // to be removed if v1 is cancelled.
    'default_preferences'          => [
        'frontpageAccounts'  => [],
        'listPageSize'       => 50,
        'currencyPreference' => 'EUR',
        'language'           => 'en_US',
        'locale'             => 'equal',
        'convertToPrimary'   => false,
    ],
    'default_currency'             => 'EUR',
    'default_language'             => envNonEmpty('DEFAULT_LANGUAGE', 'en_US'),
    'default_locale'               => envNonEmpty('DEFAULT_LOCALE', 'equal'),

    // account types that may have or set a currency
    'valid_currency_account_types' => [
        AccountTypeEnum::ASSET->value,
        AccountTypeEnum::LOAN->value,
        AccountTypeEnum::DEBT->value,
        AccountTypeEnum::MORTGAGE->value,
        AccountTypeEnum::CASH->value,
        AccountTypeEnum::INITIAL_BALANCE->value,
        AccountTypeEnum::LIABILITY_CREDIT->value,
        AccountTypeEnum::RECONCILIATION->value,
    ],

    // "value must be in this list" values
    'valid_attachment_models'      => [
        Account::class,
        Bill::class,
        Budget::class,
        Category::class,
        PiggyBank::class,
        Tag::class,
        Transaction::class,
        TransactionJournal::class,
        Recurrence::class,
    ],
    'available_dark_modes'         => ['light', 'dark', 'browser'],
    'bill_reminder_periods'        => [90, 30, 14, 7, 0],
    'valid_view_ranges'            => ['1D', '1W', '1M', '3M', '6M', '1Y'],
    'valid_url_protocols'          => envNonEmpty('VALID_URL_PROTOCOLS', 'http,https,ftp,ftps,mailto'),
    'allowedMimes'                 => [
        // plain files
        'text/plain',
        'text/html',

        // images
        'image/jpeg',
        'image/svg+xml',
        'image/png',
        'image/heic',
        'image/heic-sequence',
        'image/webp',
        'image/gif',
        'image/tiff',
        'image/bmp',
        'image/x-icon',
        'image/vnd.microsoft.icon',


        // PDF
        'application/pdf',

        // Generic upload
        'application/octet-stream',

        // MS word
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
        // MS excel
        'application/vnd.ms-excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
        // MS powerpoint
        'application/vnd.ms-powerpoint',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'application/vnd.openxmlformats-officedocument.presentationml.template',
        'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
        // iWork
        'application/x-iwork-pages-sffpages',
        // open office
        'application/vnd.sun.xml.writer',
        'application/vnd.sun.xml.writer.template',
        'application/vnd.sun.xml.writer.global',
        'application/vnd.stardivision.writer',
        'application/vnd.stardivision.writer-global',
        'application/vnd.sun.xml.calc',
        'application/vnd.sun.xml.calc.template',
        'application/vnd.stardivision.calc',
        'application/vnd.sun.xml.impress',
        'application/vnd.sun.xml.impress.template',
        'application/vnd.stardivision.impress',
        'application/vnd.sun.xml.draw',
        'application/vnd.sun.xml.draw.template',
        'application/vnd.stardivision.draw',
        'application/vnd.sun.xml.math',
        'application/vnd.stardivision.math',
        'application/vnd.oasis.opendocument.text',
        'application/vnd.oasis.opendocument.text-template',
        'application/vnd.oasis.opendocument.text-web',
        'application/vnd.oasis.opendocument.text-master',
        'application/vnd.oasis.opendocument.graphics',
        'application/vnd.oasis.opendocument.graphics-template',
        'application/vnd.oasis.opendocument.presentation',
        'application/vnd.oasis.opendocument.presentation-template',
        'application/vnd.oasis.opendocument.spreadsheet',
        'application/vnd.oasis.opendocument.spreadsheet-template',
        'application/vnd.oasis.opendocument.chart',
        'application/vnd.oasis.opendocument.formula',
        'application/vnd.oasis.opendocument.database',
        'application/vnd.oasis.opendocument.image',

        // EML
        'message/rfc822',

        // JSON
        'application/json',
    ],
    'accountRoles'                 => ['defaultAsset', 'sharedAsset', 'savingAsset', 'ccAsset', 'cashWalletAsset'],
    'valid_liabilities'            => [AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
    'ccTypes'                      => ['monthlyFull' => 'Full payment every month'],
    'credit_card_types'            => ['monthlyFull'],

    // "period must be in this list" values
    'bill_periods'                 => ['daily', 'weekly', 'monthly', 'quarterly', 'half-year', 'yearly'],
    'interest_periods'             => ['weekly', 'monthly', 'quarterly', 'half-year', 'yearly'],

    // settings to translate X to Y
    'range_to_repeat_freq'         => [
        '1D'     => 'weekly',
        '1W'     => 'weekly',
        '1M'     => 'monthly',
        '3M'     => 'quarterly',
        '6M'     => 'half-year',
        '1Y'     => 'yearly',
        'custom' => 'custom',
    ],
    'subTitlesByIdentifier'        => [
        'asset'       => 'Asset accounts',
        'expense'     => 'Expense accounts',
        'revenue'     => 'Revenue accounts',
        'cash'        => 'Cash accounts',
        'liabilities' => 'Liabilities',
        'liability'   => 'Liabilities',
    ],
    'subIconsByIdentifier'         => [
        'asset'                             => 'fa-money',
        AccountTypeEnum::ASSET->value       => 'fa-money',
        AccountTypeEnum::DEFAULT->value     => 'fa-money',
        AccountTypeEnum::CASH->value        => 'fa-money',
        'expense'                           => 'fa-shopping-cart',
        AccountTypeEnum::EXPENSE->value     => 'fa-shopping-cart',
        AccountTypeEnum::BENEFICIARY->value => 'fa-shopping-cart',
        'revenue'                           => 'fa-download',
        AccountTypeEnum::REVENUE->value     => 'fa-download',
        'import'                            => 'fa-download',
        AccountTypeEnum::IMPORT->value      => 'fa-download',
        'liabilities'                       => 'fa-ticket',
    ],
    'accountTypesByIdentifier'     => [
        'asset'       => [AccountTypeEnum::DEFAULT->value, AccountTypeEnum::ASSET->value],
        'expense'     => [AccountTypeEnum::EXPENSE->value, AccountTypeEnum::BENEFICIARY->value],
        'revenue'     => [AccountTypeEnum::REVENUE->value],
        'import'      => [AccountTypeEnum::IMPORT->value],
        'liabilities' => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::CREDITCARD->value, AccountTypeEnum::MORTGAGE->value],
    ],
    'accountTypeByIdentifier'      => [
        'asset'       => [AccountTypeEnum::ASSET->value],
        'expense'     => [AccountTypeEnum::EXPENSE->value],
        'revenue'     => [AccountTypeEnum::REVENUE->value],
        'opening'     => [AccountTypeEnum::INITIAL_BALANCE->value],
        'initial'     => [AccountTypeEnum::INITIAL_BALANCE->value],
        'import'      => [AccountTypeEnum::IMPORT->value],
        'reconcile'   => [AccountTypeEnum::RECONCILIATION->value],
        'loan'        => [AccountTypeEnum::LOAN->value],
        'debt'        => [AccountTypeEnum::DEBT->value],
        'mortgage'    => [AccountTypeEnum::MORTGAGE->value],
        'liabilities' => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value, AccountTypeEnum::CREDITCARD->value],
        'liability'   => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value, AccountTypeEnum::CREDITCARD->value],
    ],
    'shortNamesByFullName'         => [
        AccountTypeEnum::DEFAULT->value         => 'asset',
        AccountTypeEnum::ASSET->value           => 'asset',
        AccountTypeEnum::IMPORT->value          => 'import',
        AccountTypeEnum::EXPENSE->value         => 'expense',
        AccountTypeEnum::BENEFICIARY->value     => 'expense',
        AccountTypeEnum::REVENUE->value         => 'revenue',
        AccountTypeEnum::CASH->value            => 'cash',
        AccountTypeEnum::INITIAL_BALANCE->value => 'initial-balance',
        AccountTypeEnum::RECONCILIATION->value  => 'reconciliation',
        AccountTypeEnum::CREDITCARD->value      => 'liabilities',
        AccountTypeEnum::LOAN->value            => 'liabilities',
        AccountTypeEnum::DEBT->value            => 'liabilities',
        AccountTypeEnum::MORTGAGE->value        => 'liabilities',
    ],
    'shortLiabilityNameByFullName' => [
        AccountTypeEnum::CREDITCARD->value => 'creditcard',
        AccountTypeEnum::LOAN->value       => AccountTypeEnum::LOAN->value,
        AccountTypeEnum::DEBT->value       => AccountTypeEnum::DEBT->value,
        AccountTypeEnum::MORTGAGE->value   => AccountTypeEnum::MORTGAGE->value,
    ],
    'transactionTypesByType'       => [
        'expenses'   => ['Withdrawal'],
        'withdrawal' => ['Withdrawal'],
        'revenue'    => ['Deposit'],
        'deposit'    => ['Deposit'],
        'transfer'   => ['Transfer'],
        'transfers'  => ['Transfer'],
    ],
    'transactionTypesToShort'      => [
        'Withdrawal'      => 'withdrawal',
        'Deposit'         => 'deposit',
        'Transfer'        => 'transfer',
        'Opening balance' => 'opening-balance',
        'Reconciliation'  => 'reconciliation',
    ],
    'transactionIconsByType'       => [
        'expenses'   => 'fa-long-arrow-left',
        'withdrawal' => 'fa-long-arrow-left',
        'revenue'    => 'fa-long-arrow-right',
        'deposit'    => 'fa-long-arrow-right',
        'transfer'   => 'fa-exchange',
        'transfers'  => 'fa-exchange',
    ],


    'rule-actions'                 => [
        'set_category'            => SetCategory::class,
        'clear_category'          => ClearCategory::class,
        'set_budget'              => SetBudget::class,
        'clear_budget'            => ClearBudget::class,
        'add_tag'                 => AddTag::class,
        'remove_tag'              => RemoveTag::class,
        'remove_all_tags'         => RemoveAllTags::class,
        'set_description'         => SetDescription::class,
        // 'append_description'      => AppendDescription::class,
        // 'prepend_description'     => PrependDescription::class,
        'set_source_account'      => SetSourceAccount::class,
        'set_destination_account' => SetDestinationAccount::class,
        'set_notes'               => SetNotes::class,
        //        'append_notes'            => AppendNotes::class,
        //        'prepend_notes'           => PrependNotes::class,
        'clear_notes'             => ClearNotes::class,
        'link_to_bill'            => LinkToBill::class,
        'convert_withdrawal'      => ConvertToWithdrawal::class,
        'convert_deposit'         => ConvertToDeposit::class,
        'convert_transfer'        => ConvertToTransfer::class,
        'switch_accounts'         => SwitchAccounts::class,
        'update_piggy'            => UpdatePiggyBank::class,
        'delete_transaction'      => DeleteTransaction::class,
        //        'append_descr_to_notes'   => AppendDescriptionToNotes::class,
        //        'append_notes_to_descr'   => AppendNotesToDescription::class,
        //        'move_descr_to_notes'     => MoveDescriptionToNotes::class,
        //        'move_notes_to_descr'     => MoveNotesToDescription::class,
        'set_source_to_cash'      => SetSourceToCashAccount::class,
        'set_destination_to_cash' => SetDestinationToCashAccount::class,
        'set_amount'              => SetAmount::class,
        // 'set_foreign_amount' => SetForeignAmount::class,
        // 'set_foreign_currency' => SetForeignCurrency::class,
    ],
    'context-rule-actions'         => [
        'set_category',
        'set_budget',
        'add_tag',
        'remove_tag',
        'set_description',
        'append_description',
        'prepend_description',
        'set_source_account',
        'set_destination_account',
        'set_notes',
        'append_notes',
        'prepend_notes',
        'link_to_bill',
        //        'convert_withdrawal',
        //        'convert_deposit',
        'convert_transfer',
    ],

    'test-triggers'                => [
        'limit' => 10,
        'range' => 200,
    ],

    // expected source types for each transaction type, in order of preference.
    'expected_source_types'        => [
        'source'      => [
            TransactionTypeEnum::WITHDRAWAL->value       => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            TransactionTypeEnum::DEPOSIT->value          => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value, AccountTypeEnum::REVENUE->value, AccountTypeEnum::CASH->value],
            TransactionTypeEnum::TRANSFER->value         => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            TransactionTypeEnum::OPENING_BALANCE->value  => [
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::MORTGAGE->value,
            ],
            TransactionTypeEnum::RECONCILIATION->value   => [AccountTypeEnum::RECONCILIATION->value, AccountTypeEnum::ASSET->value],
            TransactionTypeEnum::LIABILITY_CREDIT->value => [AccountTypeEnum::LIABILITY_CREDIT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            // in case no transaction type is known yet, it could be anything.
            'none'                                       => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::REVENUE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::MORTGAGE->value,
            ],
        ],
        'destination' => [
            TransactionTypeEnum::WITHDRAWAL->value       => [
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::CASH->value,
            ],
            TransactionTypeEnum::DEPOSIT->value          => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            TransactionTypeEnum::TRANSFER->value         => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            TransactionTypeEnum::OPENING_BALANCE->value  => [
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::MORTGAGE->value,
            ],
            TransactionTypeEnum::RECONCILIATION->value   => [AccountTypeEnum::RECONCILIATION->value, AccountTypeEnum::ASSET->value],
            TransactionTypeEnum::LIABILITY_CREDIT->value => [AccountTypeEnum::LIABILITY_CREDIT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
        ],
    ],
    'allowed_opposing_types'       => [
        'source'      => [
            AccountTypeEnum::ASSET->value            => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::CASH->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::RECONCILIATION->value,
                AccountTypeEnum::MORTGAGE->value,
            ],
            AccountTypeEnum::CASH->value             => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::DEBT->value             => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::EXPENSE->value          => [], // is not allowed as a source.
            AccountTypeEnum::INITIAL_BALANCE->value  => [AccountTypeEnum::ASSET->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::LOAN->value             => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::MORTGAGE->value         => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::EXPENSE->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::RECONCILIATION->value   => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::REVENUE->value          => [AccountTypeEnum::ASSET->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::LIABILITY_CREDIT->value => [AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
        ],
        'destination' => [
            AccountTypeEnum::ASSET->value            => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::CASH->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::RECONCILIATION->value,
                AccountTypeEnum::REVENUE->value,
            ],
            AccountTypeEnum::CASH->value             => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::DEBT->value             => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::REVENUE->value,
            ],
            AccountTypeEnum::EXPENSE->value          => [AccountTypeEnum::ASSET->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::INITIAL_BALANCE->value  => [AccountTypeEnum::ASSET->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::LOAN->value             => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::REVENUE->value,
            ],
            AccountTypeEnum::MORTGAGE->value         => [
                AccountTypeEnum::ASSET->value,
                AccountTypeEnum::DEBT->value,
                AccountTypeEnum::INITIAL_BALANCE->value,
                AccountTypeEnum::LOAN->value,
                AccountTypeEnum::MORTGAGE->value,
                AccountTypeEnum::REVENUE->value,
            ],
            AccountTypeEnum::RECONCILIATION->value   => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::REVENUE->value          => [], // is not allowed as a destination
            AccountTypeEnum::LIABILITY_CREDIT->value => [], // is not allowed as a destination
        ],
    ],
    // depending on the account type, return the allowed transaction types:
    'allowed_transaction_types'    => [
        'source'      => [
            AccountTypeEnum::ASSET->value            => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
                TransactionTypeEnum::RECONCILIATION->value,
            ],
            AccountTypeEnum::EXPENSE->value          => [], // is not allowed as a source.
            AccountTypeEnum::REVENUE->value          => [TransactionTypeEnum::DEPOSIT->value],
            AccountTypeEnum::LOAN->value             => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
                TransactionTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::DEBT->value             => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
                TransactionTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::MORTGAGE->value         => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
                TransactionTypeEnum::LIABILITY_CREDIT->value,
            ],
            AccountTypeEnum::INITIAL_BALANCE->value  => [TransactionTypeEnum::OPENING_BALANCE->value],
            AccountTypeEnum::RECONCILIATION->value   => [TransactionTypeEnum::RECONCILIATION->value],
            AccountTypeEnum::LIABILITY_CREDIT->value => [TransactionTypeEnum::LIABILITY_CREDIT->value],
        ],
        'destination' => [
            AccountTypeEnum::ASSET->value            => [
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
                TransactionTypeEnum::RECONCILIATION->value,
            ],
            AccountTypeEnum::EXPENSE->value          => [TransactionTypeEnum::WITHDRAWAL->value],
            AccountTypeEnum::REVENUE->value          => [], // is not allowed as destination.
            AccountTypeEnum::LOAN->value             => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
            ],
            AccountTypeEnum::DEBT->value             => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
            ],
            AccountTypeEnum::MORTGAGE->value         => [
                TransactionTypeEnum::WITHDRAWAL->value,
                TransactionTypeEnum::DEPOSIT->value,
                TransactionTypeEnum::TRANSFER->value,
                TransactionTypeEnum::OPENING_BALANCE->value,
            ],
            AccountTypeEnum::INITIAL_BALANCE->value  => [TransactionTypeEnum::OPENING_BALANCE->value],
            AccountTypeEnum::RECONCILIATION->value   => [TransactionTypeEnum::RECONCILIATION->value],
            AccountTypeEnum::LIABILITY_CREDIT->value => [], // is not allowed as a destination
        ],
    ],

    // having the source + dest will tell you the transaction type.
    'account_to_transaction'       => [
        AccountTypeEnum::ASSET->value            => [
            AccountTypeEnum::ASSET->value           => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::CASH->value            => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::DEBT->value            => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::EXPENSE->value         => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::INITIAL_BALANCE->value => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::LOAN->value            => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::MORTGAGE->value        => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::RECONCILIATION->value  => TransactionTypeEnum::RECONCILIATION->value,
        ],
        AccountTypeEnum::CASH->value             => [
            AccountTypeEnum::ASSET->value    => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::LOAN->value     => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::DEBT->value     => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::MORTGAGE->value => TransactionTypeEnum::DEPOSIT->value,
        ],
        AccountTypeEnum::DEBT->value             => [
            AccountTypeEnum::ASSET->value           => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::DEBT->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::EXPENSE->value         => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::INITIAL_BALANCE->value => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::LOAN->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::MORTGAGE->value        => TransactionTypeEnum::TRANSFER->value,
        ],
        AccountTypeEnum::INITIAL_BALANCE->value  => [
            AccountTypeEnum::ASSET->value    => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::DEBT->value     => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::LOAN->value     => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::MORTGAGE->value => TransactionTypeEnum::OPENING_BALANCE->value,
        ],
        AccountTypeEnum::LOAN->value             => [
            AccountTypeEnum::ASSET->value           => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::DEBT->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::EXPENSE->value         => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::INITIAL_BALANCE->value => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::LOAN->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::MORTGAGE->value        => TransactionTypeEnum::TRANSFER->value,
        ],
        AccountTypeEnum::MORTGAGE->value         => [
            AccountTypeEnum::ASSET->value           => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::DEBT->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::EXPENSE->value         => TransactionTypeEnum::WITHDRAWAL->value,
            AccountTypeEnum::INITIAL_BALANCE->value => TransactionTypeEnum::OPENING_BALANCE->value,
            AccountTypeEnum::LOAN->value            => TransactionTypeEnum::TRANSFER->value,
            AccountTypeEnum::MORTGAGE->value        => TransactionTypeEnum::TRANSFER->value,
        ],
        AccountTypeEnum::RECONCILIATION->value   => [
            AccountTypeEnum::ASSET->value => TransactionTypeEnum::RECONCILIATION->value,
        ],
        AccountTypeEnum::REVENUE->value          => [
            AccountTypeEnum::ASSET->value    => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::DEBT->value     => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::LOAN->value     => TransactionTypeEnum::DEPOSIT->value,
            AccountTypeEnum::MORTGAGE->value => TransactionTypeEnum::DEPOSIT->value,
        ],
        AccountTypeEnum::LIABILITY_CREDIT->value => [
            AccountTypeEnum::DEBT->value     => TransactionTypeEnum::LIABILITY_CREDIT->value,
            AccountTypeEnum::LOAN->value     => TransactionTypeEnum::LIABILITY_CREDIT->value,
            AccountTypeEnum::MORTGAGE->value => TransactionTypeEnum::LIABILITY_CREDIT->value,
        ],
        // AccountTypeEnum::EXPENSE->value unlisted because it cant be a source
    ],

    // allowed source -> destination accounts.
    'source_dests'                 => [
        TransactionTypeEnum::WITHDRAWAL->value       => [
            AccountTypeEnum::ASSET->value    => [AccountTypeEnum::EXPENSE->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value, AccountTypeEnum::CASH->value],
            AccountTypeEnum::LOAN->value     => [AccountTypeEnum::EXPENSE->value, AccountTypeEnum::CASH->value],
            AccountTypeEnum::DEBT->value     => [AccountTypeEnum::EXPENSE->value, AccountTypeEnum::CASH->value],
            AccountTypeEnum::MORTGAGE->value => [AccountTypeEnum::EXPENSE->value, AccountTypeEnum::CASH->value],
        ],
        TransactionTypeEnum::DEPOSIT->value          => [
            AccountTypeEnum::REVENUE->value  => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::CASH->value     => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::LOAN->value     => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::DEBT->value     => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::MORTGAGE->value => [AccountTypeEnum::ASSET->value],
        ],
        TransactionTypeEnum::TRANSFER->value         => [
            AccountTypeEnum::ASSET->value    => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::LOAN->value     => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::DEBT->value     => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
            AccountTypeEnum::MORTGAGE->value => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
        ],
        TransactionTypeEnum::OPENING_BALANCE->value  => [
            AccountTypeEnum::ASSET->value           => [AccountTypeEnum::INITIAL_BALANCE->value],
            AccountTypeEnum::LOAN->value            => [AccountTypeEnum::INITIAL_BALANCE->value],
            AccountTypeEnum::DEBT->value            => [AccountTypeEnum::INITIAL_BALANCE->value],
            AccountTypeEnum::MORTGAGE->value        => [AccountTypeEnum::INITIAL_BALANCE->value],
            AccountTypeEnum::INITIAL_BALANCE->value => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
        ],
        TransactionTypeEnum::RECONCILIATION->value   => [
            AccountTypeEnum::RECONCILIATION->value => [AccountTypeEnum::ASSET->value],
            AccountTypeEnum::ASSET->value          => [AccountTypeEnum::RECONCILIATION->value],
        ],
        TransactionTypeEnum::LIABILITY_CREDIT->value => [
            AccountTypeEnum::LOAN->value             => [AccountTypeEnum::LIABILITY_CREDIT->value],
            AccountTypeEnum::DEBT->value             => [AccountTypeEnum::LIABILITY_CREDIT->value],
            AccountTypeEnum::MORTGAGE->value         => [AccountTypeEnum::LIABILITY_CREDIT->value],
            AccountTypeEnum::LIABILITY_CREDIT->value => [AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
        ],
    ],
    // if you add fields to this array, don't forget to update the export routine (ExportDataGenerator).
    'journal_meta_fields'          => [
        // sepa
        'sepa_cc',
        'sepa_ct_op',
        'sepa_ct_id',
        'sepa_db',
        'sepa_country',
        'sepa_ep',
        'sepa_ci',
        'sepa_batch_id',
        'external_url',

        // dates
        'interest_date',
        'book_date',
        'process_date',
        'due_date',
        'payment_date',
        'invoice_date',

        // others
        'recurrence_id',
        'internal_reference',
        'bunq_payment_id',
        'import_hash',
        'import_hash_v2',
        'external_id',
        'original_source',

        // recurring transactions
        'recurrence_total',
        'recurrence_count',
        'recurrence_date',
    ],
    'webhooks'                     => [
        'max_attempts' => env('WEBHOOK_MAX_ATTEMPTS', 3),
    ],
    'can_have_virtual_amounts'     => [AccountTypeEnum::ASSET->value],
    'can_have_opening_balance'     => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
    'dynamic_creation_allowed'     => [
        AccountTypeEnum::EXPENSE->value,
        AccountTypeEnum::REVENUE->value,
        AccountTypeEnum::INITIAL_BALANCE->value,
        AccountTypeEnum::RECONCILIATION->value,
        AccountTypeEnum::LIABILITY_CREDIT->value,
    ],
    'valid_asset_fields'           => ['account_role', 'account_number', 'currency_id', 'BIC', 'include_net_worth'],
    'valid_cc_fields'              => ['account_role', 'cc_monthly_payment_date', 'cc_type', 'account_number', 'currency_id', 'BIC', 'include_net_worth'],
    'valid_account_fields'         => ['account_number', 'currency_id', 'BIC', 'interest', 'interest_period', 'include_net_worth', 'liability_direction'],

    // dynamic date ranges are as follows:
    'dynamic_date_ranges'          => ['last7', 'last30', 'last90', 'last365', 'MTD', 'QTD', 'YTD'],

    'allowed_sort_parameters'      => [
        'Account' => ['id', 'order', 'name', 'iban', 'active', 'account_type_id',
            'current_balance',
            'pc_current_balance',
            'opening_balance',
            'pc_opening_balance',
            'virtual_balance',
            'pc_virtual_balance',
            'debt_amount',
            'pc_debt_amount',
            'balance_difference',
            'pc_balance_difference',
        ],
    ],
    'allowed_db_sort_parameters'   => [
        'Account' => ['id', 'order', 'name', 'iban', 'active', 'account_type_id'],
    ],


    // preselected account lists possibilities:
    'preselected_accounts'         => ['all', 'assets', 'liabilities'],

    // allowed to store a piggy bank in:
    'piggy_bank_account_types'     => [AccountTypeEnum::ASSET->value, AccountTypeEnum::LOAN->value, AccountTypeEnum::DEBT->value, AccountTypeEnum::MORTGAGE->value],
];
