<?php

/**
 * CurrencyServiceProvider.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
declare(strict_types=1);

namespace FireflyIII\Providers;

use FireflyIII\Repositories\Currency\CurrencyRepository;
use FireflyIII\Repositories\Currency\CurrencyRepository as GroupCurrencyRepository;
use FireflyIII\Repositories\Currency\CurrencyRepositoryInterface as GroupCurrencyRepositoryInterface;
use FireflyIII\Repositories\ExchangeRate\ExchangeRateRepository;
use FireflyIII\Repositories\ExchangeRate\ExchangeRateRepositoryInterface;
use Illuminate\Foundation\Application;
use Illuminate\Support\ServiceProvider;
use Override;

/**
 * Class CurrencyServiceProvider.
 */
class CurrencyServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot(): void {}

    /**
     * Register the application services.
     */
    #[Override]
    public function register(): void
    {
        $this->app->bind(
            static function (Application $app): GroupCurrencyRepositoryInterface {
                /** @var CurrencyRepository $repository */
                $repository = app(CurrencyRepository::class);
                // phpstan does not get the reference to auth
                if ($app->auth->check()) { // @phpstan-ignore-line
                    $repository->setUser(auth()->user());
                }

                return $repository;
            }
        );
        $this->app->bind(
            static function (Application $app): GroupCurrencyRepositoryInterface {
                /** @var GroupCurrencyRepository $repository */
                $repository = app(GroupCurrencyRepository::class);
                // phpstan does not get the reference to auth
                if ($app->auth->check()) { // @phpstan-ignore-line
                    $repository->setUser(auth()->user());
                }

                return $repository;
            }
        );

        $this->app->bind(
            static function (Application $app): ExchangeRateRepositoryInterface {
                /** @var ExchangeRateRepository $repository */
                $repository = app(ExchangeRateRepository::class);
                // phpstan does not get the reference to auth
                if ($app->auth->check()) { // @phpstan-ignore-line
                    $repository->setUserGroup(auth()->user()->userGroup);
                }

                return $repository;
            }
        );

    }
}
