# Drupal文件上传导致跨站脚本执行（CVE-2019-6341）

Drupal是一个使用PHP编写的免费开源的Web内容管理框架。

在Drupal 7.x < 7.65, Drupal 8.x < 8.5.14 和 8.6.x < 8.6.13 中，由于文件模块或子系统中对文件上传处理不当，导致攻击者可以上传一个没有扩展名的文件，该文件表面上是一个图片，但实际包含了嵌入JavaScript的HTML代码。当其他用户访问该文件的链接时，XSS代码将被执行。

参考链接：

- <https://www.drupal.org/sa-core-2019-004>
- <https://www.zerodayinitiative.com/blog/2019/4/11/a-series-of-unfortunate-images-drupal-1-click-to-rce-exploit-chain-detailed>
- <https://paper.seebug.org/897/>

## 环境搭建

执行如下命令启动一个存在漏洞的Drupal 8.5.0服务器：

```
docker compose up -d
```

环境启动后，访问`http://your-ip:8080/`将会看到Drupal的安装页面。按照默认配置完成安装步骤。由于环境中没有MySQL，可以选择SQLite作为数据库。

## 漏洞复现

该漏洞利用了Drupal文件模块中的一个缺陷，允许上传特制的文件。该文件表面上是一个图片，但实际包含了嵌入JavaScript的HTML代码。当其他用户访问该文件的链接时，XSS代码将被执行。

Drupal默认将上传的图片存储在`/sites/default/files/pictures/<YYYY-MM>/`目录下，并保留其原始文件名。

要利用此漏洞，使用来自[thezdi/PoC](https://github.com/thezdi/PoC/tree/master/Drupal)的PoC脚本创建并上传恶意GIF文件。执行以下命令，其中第一个参数是目标IP，第二个参数是目标端口：

```
php cve-2019-6341-exp.php 192.168.11.1 8080
```

![1](1.png)

上传成功后，访问图片位置即可触发XSS漏洞：

![2](2.png)

注意：

1. Chrome和Firefox浏览器内置了XSS过滤器，建议使用Edge或IE浏览器进行测试。
2. 上传的图片名称末尾带有"_0"是由于Drupal的规则机制。详细信息请参见[Drupal 1-click to RCE分析](https://paper.seebug.org/897/)
3. 该漏洞与[CVE-2019-6339](../CVE-2019-6339/README.md)形成漏洞利用链，管理员只需点击一个恶意链接即可导致远程代码执行
