# OpenSMTPD Remote Code Execution Vulnerability (CVE-2020-7247)

[中文版本(Chinese version)](README.zh-cn.md)

OpenSMTPD is an smtp service program for unix operating systems (BSD, MacOS, GNU/Linux), following the RFC 5321 SMTP protocol. OpenSMTPD was originally developed for the OpenBSD operating system and is part of the OpenBSD project. Due to its open source properties, Distributed to other unix platforms. According to the ISC license, the software is free for everyone to use and reuse.

`CVE-2020-7247` is caused by OpenSMTPD's lax verification of the sender/recipient in the process of implementing RFC 5321.

On January 29, 2020, OpenSMTPD group officially submitted a fix for the `CVE-2020-7247` in the GitHub repository. After the repair, the corresponding version is `OpenSMTPD 6.6.2p1`.

**Reference：**

- https://www.qualys.com/2020/01/28/cve-2020-7247/lpe-rce-opensmtpd.txt
- https://www.exploit-db.com/exploits/47984
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-7247
- https://www.anquanke.com/post/id/197689

## Start Vulnerability Application

Start a vulnerable OpenSMTPD through following command:

```
docker compose up -d
```

After SMTPD server is started, connect to the 8825 port and get the result (`44dadcc5a6eb` is the container ID):

```
$ nc <your-ip> 8825 -v
220 44dadcc5a6eb ESMTP OpenSMTPD
```

## Vulnerability Reproduce

Use [Exploit-DB](https://www.exploit-db.com/exploits/47984) to gain a reverse shell:

```
python3 poc.py your-ip 8825 <command> 
```

![image](https://github.com/CatAndCoffee/vulhub/blob/CVE-2020-7247/OpenSMTPD/CVE-2020-7247/image-20210415233036042.png)
