# Apache HTTPD 换行符解析漏洞（CVE-2017-15715）

[English](README.md)

Apache HTTPD 是一个广泛使用的 HTTP 服务器，可以通过 mod_php 模块来运行 PHP 网页。在其 2.4.0 到 2.4.29 版本中存在一个解析漏洞，当文件名以 `1.php\x0A` 结尾时，该文件会被按照 PHP 文件进行解析，这使得攻击者可以绕过服务器的一些安全策略。

参考链接：

- <https://httpd.apache.org/security/vulnerabilities_24.html>
- <https://security.elarlang.eu/cve-2017-15715-apache-http-server-filesmatch-bypass-with-a-trailing-newline-at-the-end-of-the-file-name.html>

## 环境搭建

执行如下命令来编译并启动漏洞环境：

```
docker compose build
docker compose up -d
```

环境启动后，Apache 将运行在 `http://your-ip:8080`。

## 漏洞复现

首先，尝试上传一个名为 `1.php` 的文件，可以看到上传被安全检查拦截：

![上传被安全检查拦截](1.png)

但是，如果我们在文件名 `1.php` 后面添加一个 `\x0A`（注意：必须是单独的 `\x0A`，而不是 `\x0D\x0A`），上传就会成功：

![使用换行符成功上传](2.png)

当访问上传的文件 `/1.php%0a` 时，虽然该文件没有正确的 PHP 扩展名，但它会被成功解析为 PHP 文件。这证实了解析漏洞的存在：

![成功执行 PHP 代码](3.png)
