# Electron Remote Code Execution Vulnerability（CVE-2018-1000006）

[中文版本(Chinese version)](README.zh-cn.md)

Electron is an open source library developed by GitHub for building cross-platform desktop applications with HTML, CSS, and JavaScript. Electron accomplishes this by combining Chromium and Node.js into a single runtime and apps can be packaged for Mac, Windows, and Linux.

On Windows, if an application developed by Electron registers a Protocol Handler (allowing the user to call the application in the browser), a parameter injection vulnerability may occur and eventually cause remote code vulnerability on the user side.

Reference link:[Electron < v1.8.2-beta.4 远程命令执行漏洞—【CVE-2018-1000006】](https://xianzhi.aliyun.com/forum/topic/1990)

## Setup

Execute the following commands to compile an vulnerability application:

```
docker compose run -e ARCH=64 --rm electron
```

Because the software needs to run on the Windows platform, it is necessary to set the value of the ARCH to the number of bits of the platform: 32 or 64.

After the compilation completed, execute the following command to run the web service:

```
docker compose run --rm -p 8080:80 web
```

Now, access`http://your-ip:8080/`You can see the POC page.

## Exploit

First, on the POC page, click on the first link and download the compiled software `vulhub-app.tar.gz`. After the download is complete, extract it and run it once:

![](1.png)

This time the Protocol Handler will be registered.

Then, go back to the POC page and click on the second link. The target software and calculator will pop up:

![](2.png)

> If fails, it may be browser's reason. After testing, the new Chrome browser will call vulhub-app when it clicks on the POC, but it will not execute calc.exe.
