# Django < 2.0.8 Open Redirect in CommonMiddleware (CVE-2018-14574)

[中文版本(Chinese version)](README.zh-cn.md)

Django is a high-level Python web framework that encourages rapid development and clean, pragmatic design.

Django versions before 2.0.8 and 1.11.15 contain an open redirect vulnerability in CommonMiddleware when both `django.middleware.common.CommonMiddleware` and the `APPEND_SLASH` setting are enabled. If the project has a URL pattern that accepts any path ending in a slash, a maliciously crafted URL could lead to a redirect to an arbitrary external site, enabling phishing and other attacks.

References:

- <https://www.djangoproject.com/weblog/2018/aug/01/security-releases/>
- <https://nvd.nist.gov/vuln/detail/CVE-2018-14574>

## Environment Setup

Execute the following command to start a vulnerable Django 2.0.7 server:

```
docker compose build
docker compose up -d
```

After the server is started, you can access the Django home page at `http://your-ip:8000`.

## Vulnerability Reproduction

Visit the following URL to trigger the open redirect vulnerability:

```
http://your-ip:8000//www.example.com
```

The server will redirect you to `//www.example.com/`, which the browser interprets as an absolute URL, effectively redirecting to an external site:

![](1.png)

This vulnerability can be exploited by attackers to redirect users to malicious websites, potentially leading to phishing attacks or other security issues.
