/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.eventregistry.api.EventDefinitionQuery;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventDefinitionQueryProperty;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.flowable.eventregistry.rest.service.api.repository.EventDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Definitions"}, description="Manage Event Definitions", authorizations={@Authorization(value="basicAuth")})
public class EventDefinitionCollectionResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List of event definitions", tags={"Event Definitions"}, nickname="listEventDefinitions")
    @ApiImplicitParams(value={@ApiImplicitParam(name="version", dataType="integer", value="Only return event definitions with the given version.", paramType="query"), @ApiImplicitParam(name="name", dataType="string", value="Only return event definitions with the given name.", paramType="query"), @ApiImplicitParam(name="nameLike", dataType="string", value="Only return event definitions with a name like the given name.", paramType="query"), @ApiImplicitParam(name="nameLikeIgnoreCase", dataType="string", value="Only return event definitions with a name like the given name (case-insensitive).", paramType="query"), @ApiImplicitParam(name="key", dataType="string", value="Only return event definitions with the given key.", paramType="query"), @ApiImplicitParam(name="keyLike", dataType="string", value="Only return event definitions with a name like the given key.", paramType="query"), @ApiImplicitParam(name="keyLikeIgnoreCase", dataType="string", value="Only return event definitions with a name like the given key (case-insensitive).", paramType="query"), @ApiImplicitParam(name="resourceName", dataType="string", value="Only return event definitions with the given resource name.", paramType="query"), @ApiImplicitParam(name="resourceNameLike", dataType="string", value="Only return event definitions with a name like the given resource name.", paramType="query"), @ApiImplicitParam(name="category", dataType="string", value="Only return event definitions with the given category.", paramType="query"), @ApiImplicitParam(name="categoryLike", dataType="string", value="Only return event definitions with a category like the given name.", paramType="query"), @ApiImplicitParam(name="categoryNotEquals", dataType="string", value="Only return event definitions which do not have the given category.", paramType="query"), @ApiImplicitParam(name="deploymentId", dataType="string", value="Only return event definitions which are part of a deployment with the given deployment id.", paramType="query"), @ApiImplicitParam(name="parentDeploymentId", dataType="string", value="Only return event definitions which are part of a deployment with the given parent deployment id.", paramType="query"), @ApiImplicitParam(name="latest", dataType="boolean", value="Only return the latest event definition versions. Can only be used together with key and keyLike parameters, using any other parameter will result in a 400-response.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="name,id,key,category,deploymentId,version", paramType="query"), @ApiImplicitParam(name="order", dataType="string", value="The sort order, either 'asc' or 'desc'. Defaults to 'asc'.", paramType="query"), @ApiImplicitParam(name="start", dataType="integer", value="Index of the first row to fetch. Defaults to 0.", paramType="query"), @ApiImplicitParam(name="size", dataType="integer", value="Number of rows to fetch, starting from start. Defaults to 10.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the event definitions are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format or that latest is used with other parameters other than key and keyLike. The status-message contains additional information.")})
    @GetMapping(value={"/event-registry-repository/event-definitions"}, produces={"application/json"})
    public DataResponse<EventDefinitionResponse> getEventDefinitions(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        EventDefinitionQuery eventDefinitionQuery = this.repositoryService.createEventDefinitionQuery();
        if (allRequestParams.containsKey("category")) {
            eventDefinitionQuery.eventCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            eventDefinitionQuery.eventCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            eventDefinitionQuery.eventCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("key")) {
            eventDefinitionQuery.eventDefinitionKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("keyLike")) {
            eventDefinitionQuery.eventDefinitionKeyLike(allRequestParams.get("keyLike"));
        }
        if (allRequestParams.containsKey("keyLikeIgnoreCase")) {
            eventDefinitionQuery.eventDefinitionKeyLikeIgnoreCase(allRequestParams.get("keyLikeIgnoreCase"));
        }
        if (allRequestParams.containsKey("name")) {
            eventDefinitionQuery.eventDefinitionName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            eventDefinitionQuery.eventDefinitionNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("nameLikeIgnoreCase")) {
            eventDefinitionQuery.eventDefinitionNameLikeIgnoreCase(allRequestParams.get("nameLikeIgnoreCase"));
        }
        if (allRequestParams.containsKey("resourceName")) {
            eventDefinitionQuery.eventDefinitionResourceName(allRequestParams.get("resourceName"));
        }
        if (allRequestParams.containsKey("resourceNameLike")) {
            eventDefinitionQuery.eventDefinitionResourceNameLike(allRequestParams.get("resourceNameLike"));
        }
        if (allRequestParams.containsKey("version")) {
            eventDefinitionQuery.eventVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("latest") && Boolean.parseBoolean(allRequestParams.get("latest"))) {
            eventDefinitionQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            eventDefinitionQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("parentDeploymentId")) {
            eventDefinitionQuery.parentDeploymentId(allRequestParams.get("parentDeploymentId"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            eventDefinitionQuery.tenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            eventDefinitionQuery.tenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessEventDefinitionsWithQuery(eventDefinitionQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)eventDefinitionQuery, (String)"name", properties, this.restResponseFactory::createEventDefinitionResponseList);
    }

    static {
        properties.put("id", (QueryProperty)EventDefinitionQueryProperty.ID);
        properties.put("key", (QueryProperty)EventDefinitionQueryProperty.KEY);
        properties.put("category", (QueryProperty)EventDefinitionQueryProperty.CATEGORY);
        properties.put("name", (QueryProperty)EventDefinitionQueryProperty.NAME);
        properties.put("deploymentId", (QueryProperty)EventDefinitionQueryProperty.DEPLOYMENT_ID);
        properties.put("tenantId", (QueryProperty)EventDefinitionQueryProperty.TENANT_ID);
    }
}

