/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDeploymentResource {
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    protected EventDeployment getEventDeployment(String deploymentId) {
        EventDeployment deployment = (EventDeployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", EventDeployment.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        return deployment;
    }
}

