/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOParameterUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOParameterUtil.class);

    public static void processInParameters(List<IOParameter> inParameters, VariableContainer sourceContainer, VariableContainer targetContainer, ExpressionManager expressionManager) {
        IOParameterUtil.processParameters(inParameters, sourceContainer, (arg_0, arg_1) -> ((VariableContainer)targetContainer).setVariable(arg_0, arg_1), (arg_0, arg_1) -> ((VariableContainer)targetContainer).setTransientVariable(arg_0, arg_1), expressionManager, "In");
    }

    public static void processInParameters(List<IOParameter> inParameters, VariableContainer sourceContainer, Map<String, Object> targetContainer, ExpressionManager expressionManager) {
        IOParameterUtil.processParameters(inParameters, sourceContainer, targetContainer::put, targetContainer::put, expressionManager, "In");
    }

    public static void processOutParameters(List<IOParameter> outParameters, VariableContainer sourceContainer, VariableContainer targetContainer, ExpressionManager expressionManager) {
        IOParameterUtil.processParameters(outParameters, sourceContainer, (arg_0, arg_1) -> ((VariableContainer)targetContainer).setVariable(arg_0, arg_1), (arg_0, arg_1) -> ((VariableContainer)targetContainer).setTransientVariable(arg_0, arg_1), expressionManager, "Out");
    }

    protected static void processParameters(List<IOParameter> parameters, VariableContainer sourceContainer, BiConsumer<String, Object> targetVariableConsumer, BiConsumer<String, Object> targetTransientVariableConsumer, ExpressionManager expressionManager, String parameterType) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (IOParameter parameter : parameters) {
            Object value;
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(parameter.getSourceExpression().trim());
                value = expression.getValue(sourceContainer);
            } else {
                value = sourceContainer.getVariable(parameter.getSource());
            }
            if (value != null && value instanceof JsonNode) {
                value = ((JsonNode)value).deepCopy();
            }
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTargetExpression())) {
                Expression expression = expressionManager.createExpression(parameter.getTargetExpression());
                Object variableNameValue = expression.getValue(sourceContainer);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("{} parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)parameterType, (Object)parameter.getTargetExpression());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                variableName = parameter.getTarget();
            }
            if (parameter.isTransient()) {
                targetTransientVariableConsumer.accept(variableName, value);
                continue;
            }
            targetVariableConsumer.accept(variableName, value);
        }
    }
}

