/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.test.CmmnDeployment;
import org.flowable.cmmn.engine.test.CmmnDeploymentId;
import org.flowable.cmmn.engine.test.impl.CmmnTestHelper;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableCmmnExtension
implements AfterTestExecutionCallback,
AfterEachCallback,
BeforeEachCallback,
ParameterResolver {
    protected static final String ANNOTATION_DEPLOYMENT_ID_KEY = "deploymentIdFromDeploymentAnnotation";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        CmmnEngine cmmnEngine = this.getCmmnEngine(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CmmnDeployment.class).ifPresent(deployment -> {
            String deploymentId = CmmnTestHelper.annotationDeploymentSetUp(cmmnEngine, context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            this.getStore(context).put((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), (Object)deploymentId);
        });
    }

    public void afterTestExecution(ExtensionContext context) {
        CmmnEngine cmmnEngine = this.getCmmnEngine(context);
        cmmnEngine.getCmmnEngineConfiguration().getClock().reset();
        Authentication.setAuthenticatedUserId(null);
        String deploymentIdFromAnnotation = (String)this.getStore(context).remove((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        if (deploymentIdFromAnnotation != null) {
            CmmnTestHelper.annotationDeploymentTearDown(cmmnEngine, deploymentIdFromAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
        }
    }

    public void afterEach(ExtensionContext context) {
        CmmnEngine cmmnEngine = this.getCmmnEngine(context);
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> EnsureCleanDbUtils.assertAndEnsureCleanDb((String)context.getDisplayName(), (Logger)this.logger, (AbstractEngineConfiguration)cmmnEngine.getCmmnEngineConfiguration(), (EnsureCleanDb)ensureCleanDb, (boolean)context.getExecutionException().isEmpty(), (Command)cmmnEngine.getCmmnEngineConfiguration().getSchemaManagementCmd()));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return CmmnEngine.class.equals(parameterType) || parameterContext.isAnnotated(CmmnDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(CmmnDeploymentId.class)) {
            return this.getStore(extensionContext).get((Object)(extensionContext.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        }
        return this.getCmmnEngine(extensionContext);
    }

    protected abstract CmmnEngine getCmmnEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

