/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.scripting;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.task.api.Task;

public class CmmnVariableScopeResolver
implements Resolver {
    protected static final String CASE_INSTANCE_KEY = "caseInstance";
    protected static final String PLAN_ITEM_INSTANCE_KEY = "planItemInstance";
    protected static final String TASK_KEY = "task";
    protected static final Map<String, Function<CmmnEngineConfiguration, ?>> SERVICE_RESOLVERS = Map.of("engineConfiguration", Function.identity(), "cmmnEngineConfiguration", Function.identity(), "runtimeService", CmmnEngineConfiguration::getCmmnRuntimeService, "cmmnRuntimeService", CmmnEngineConfiguration::getCmmnRuntimeService, "historyService", CmmnEngineConfiguration::getCmmnHistoryService, "cmmnHistoryService", CmmnEngineConfiguration::getCmmnHistoryService, "managementService", CmmnEngineConfiguration::getCmmnManagementService, "cmmnManagementService", CmmnEngineConfiguration::getCmmnManagementService, "taskService", CmmnEngineConfiguration::getCmmnTaskService, "cmmnTaskService", CmmnEngineConfiguration::getCmmnTaskService);
    protected static final Set<String> KEYS = Set.of("caseInstance", "planItemInstance", "task");
    protected CmmnEngineConfiguration engineConfiguration;
    protected VariableContainer scopeContainer;
    protected VariableContainer inputVariableContainer;

    public CmmnVariableScopeResolver(CmmnEngineConfiguration engineConfiguration, VariableContainer scopeContainer, VariableContainer inputVariableContainer) {
        if (scopeContainer == null) {
            throw new FlowableIllegalArgumentException("scopeContainer cannot be null");
        }
        this.scopeContainer = scopeContainer;
        this.inputVariableContainer = inputVariableContainer;
        this.engineConfiguration = engineConfiguration;
    }

    public boolean containsKey(Object key) {
        return this.inputVariableContainer.hasVariable((String)key) || KEYS.contains(key) || SERVICE_RESOLVERS.containsKey(key) && this.engineConfiguration.isServicesEnabledInScripting();
    }

    public Object get(Object key) {
        if (SERVICE_RESOLVERS.containsKey((String)key)) {
            if (this.engineConfiguration.isServicesEnabledInScripting()) {
                return SERVICE_RESOLVERS.get(key).apply(this.engineConfiguration);
            }
            throw new FlowableException("The service '" + String.valueOf(key) + "' is not available in the current context. Please enable services in scripting.");
        }
        if (CASE_INSTANCE_KEY.equals(key)) {
            Task task;
            if (this.scopeContainer instanceof CaseInstance) {
                return this.scopeContainer;
            }
            if (this.scopeContainer instanceof PlanItemInstance) {
                PlanItemInstance planItemInstance = (PlanItemInstance)this.scopeContainer;
                if (StringUtils.isNotEmpty((CharSequence)planItemInstance.getCaseInstanceId())) {
                    return CommandContextUtil.getCaseInstanceEntityManager().findById(planItemInstance.getCaseInstanceId());
                }
            } else if (this.scopeContainer instanceof Task && StringUtils.isNotEmpty((CharSequence)(task = (Task)this.scopeContainer).getScopeId()) && "cmmn".equals(task.getScopeType())) {
                return CommandContextUtil.getCaseInstanceEntityManager().findById(task.getScopeId());
            }
            throw new FlowableException("Unsupported variableContainer for key 'caseInstance': " + this.scopeContainer.getClass().getName());
        }
        if (PLAN_ITEM_INSTANCE_KEY.equals(key)) {
            Task task;
            if (this.scopeContainer instanceof PlanItemInstance) {
                return this.scopeContainer;
            }
            if (this.scopeContainer instanceof Task && StringUtils.isNotEmpty((CharSequence)(task = (Task)this.scopeContainer).getSubScopeId()) && "cmmn".equals(task.getScopeType())) {
                return CommandContextUtil.getPlanItemInstanceEntityManager().findById(task.getSubScopeId());
            }
            throw new FlowableException("Unsupported variableContainer for key 'planItemInstance': " + this.scopeContainer.getClass().getName());
        }
        if (TASK_KEY.equals(key)) {
            if (this.scopeContainer instanceof Task) {
                return this.scopeContainer;
            }
            if (this.scopeContainer instanceof PlanItemInstance) {
                PlanItemInstance planItemInstance = (PlanItemInstance)this.scopeContainer;
                return CommandContextUtil.getTaskService().findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
            }
            throw new FlowableException("Unsupported variableContainer for key 'task': " + this.scopeContainer.getClass().getName());
        }
        return this.inputVariableContainer.getVariable((String)key);
    }
}

