/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentConstants;
import org.flowable.cmmn.engine.impl.migration.HistoricCaseInstanceMigrationDocumentBuilderImpl;
import org.flowable.common.engine.api.FlowableException;

public class HistoricCaseInstanceMigrationDocumentConverter
implements CaseInstanceMigrationDocumentConstants {
    protected static ObjectMapper objectMapper = new ObjectMapper();

    public static JsonNode convertToJson(HistoricCaseInstanceMigrationDocument historicCaseInstanceMigrationDocument) {
        ObjectNode documentNode = objectMapper.createObjectNode();
        if (historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionId() != null) {
            documentNode.put("toCaseDefinitionId", historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionId());
        }
        if (historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionKey() != null) {
            documentNode.put("toCaseDefinitionKey", historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionKey());
        }
        if (historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion() != null) {
            documentNode.put("toCaseDefinitionVersion", historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion());
        }
        if (historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId() != null) {
            documentNode.put("toCaseDefinitionTenantId", historicCaseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId());
        }
        return documentNode;
    }

    public static String convertToJsonString(HistoricCaseInstanceMigrationDocument historicCaseInstanceMigrationDocument) {
        JsonNode jsonNode = HistoricCaseInstanceMigrationDocumentConverter.convertToJson(historicCaseInstanceMigrationDocument);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        try {
            return objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            return jsonNode.toString();
        }
    }

    public static HistoricCaseInstanceMigrationDocument convertFromJson(String jsonCaseInstanceMigrationDocument) {
        try {
            JsonNode rootNode = objectMapper.readTree(jsonCaseInstanceMigrationDocument);
            HistoricCaseInstanceMigrationDocumentBuilderImpl documentBuilder = new HistoricCaseInstanceMigrationDocumentBuilderImpl();
            documentBuilder.setCaseDefinitionToMigrateTo(HistoricCaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionId", rootNode));
            String caseDefinitionKey = HistoricCaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionKey", rootNode);
            Integer caseDefinitionVersion = HistoricCaseInstanceMigrationDocumentConverter.getJsonPropertyAsInteger("toCaseDefinitionVersion", rootNode);
            documentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
            documentBuilder.setTenantId(HistoricCaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionTenantId", rootNode));
            return documentBuilder.build();
        }
        catch (IOException e) {
            throw new FlowableException("Error parsing Historic Case Instance Migration Document", (Throwable)e);
        }
    }

    protected static String getJsonProperty(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asText();
        }
        return null;
    }

    protected static Integer getJsonPropertyAsInteger(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asInt();
        }
        return null;
    }
}

