/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.Objects;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;

public class ScriptTypeTaskListener
implements TaskListener {
    private static final long serialVersionUID = -8915149072830499057L;
    protected Expression script;
    protected Expression language;
    protected Expression resultVariable;

    public ScriptTypeTaskListener() {
    }

    public ScriptTypeTaskListener(Expression language, Expression script) {
        this.script = script;
        this.language = language;
    }

    public void notify(DelegateTask delegateTask) {
        String resultVariable;
        this.validateParameters();
        ScriptingEngines scriptingEngines = CommandContextUtil.getCmmnEngineConfiguration().getScriptingEngines();
        String language = Objects.toString(this.language.getValue((VariableContainer)delegateTask), null);
        if (language == null) {
            throw new FlowableIllegalStateException("'language' evaluated to null for taskListener of type 'script'");
        }
        String script = Objects.toString(this.script.getValue((VariableContainer)delegateTask), null);
        if (script == null) {
            throw new FlowableIllegalStateException("Script content is null or evaluated to null for taskListener of type 'script'");
        }
        ScriptEngineRequest.Builder request = ScriptEngineRequest.builder().script(script).language(language).scopeContainer((VariableContainer)delegateTask).traceEnhancer(trace -> trace.addTraceTag("type", "taskListener"));
        Object result = scriptingEngines.evaluate(request.build()).getResult();
        if (this.resultVariable != null && (resultVariable = Objects.toString(this.resultVariable.getValue((VariableContainer)delegateTask), null)) != null) {
            delegateTask.setVariable(resultVariable, result);
        }
    }

    protected void validateParameters() {
        if (this.script == null) {
            throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("The field 'language' should be set on the TaskListener");
        }
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }

    public Expression getResultVariable() {
        return this.resultVariable;
    }
}

