/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.VariableEventListener;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class SetAsyncVariablesJobHandler
implements JobHandler {
    public static final String TYPE = "cmmn-set-async-variables";
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public SetAsyncVariablesJobHandler(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        VariableService variableService = this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List jobVariables = null;
        PlanItemInstanceEntity planItemInstanceEntity = null;
        CaseInstanceEntity caseInstanceEntity = null;
        String caseDefinitionId = null;
        String caseInstanceId = null;
        if (StringUtils.isNotEmpty((CharSequence)job.getSubScopeId())) {
            planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId());
            jobVariables = variableService.findVariableInstanceBySubScopeIdAndScopeType(job.getSubScopeId(), "cmmnAsyncVariables");
            caseDefinitionId = planItemInstanceEntity.getCaseDefinitionId();
            caseInstanceId = planItemInstanceEntity.getCaseInstanceId();
        } else {
            caseInstanceEntity = (CaseInstanceEntity)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(job.getScopeId());
            jobVariables = variableService.findVariableInstanceByScopeIdAndScopeType(job.getScopeId(), "cmmnAsyncVariables");
            caseDefinitionId = caseInstanceEntity.getCaseDefinitionId();
            caseInstanceId = caseInstanceEntity.getId();
        }
        if (!jobVariables.isEmpty()) {
            HashSet<String> variableNames = new HashSet<String>();
            for (VariableInstanceEntity jobVariable : jobVariables) {
                variableNames.add(jobVariable.getName());
                if (caseInstanceEntity != null) {
                    caseInstanceEntity.setVariable(jobVariable.getName(), jobVariable.getValue());
                } else {
                    planItemInstanceEntity.setVariableLocal(jobVariable.getName(), jobVariable.getValue());
                }
                variableService.deleteVariableInstance(jobVariable);
            }
            if (planItemInstanceEntity != null && planItemInstanceEntity instanceof CountingPlanItemInstanceEntity) {
                ((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).setVariableCount(((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).getVariableCount() - jobVariables.size());
            }
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
            if (planItemInstanceEntity == null) {
                CmmnDeploymentManager deploymentManager = this.cmmnEngineConfiguration.getDeploymentManager();
                CaseDefinition caseDefinition = deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId);
                boolean evaluateVariableEventListener = false;
                if (caseDefinition != null) {
                    CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
                    for (Case caze : cmmnModel.getCases()) {
                        List variableEventListeners = caze.findPlanItemDefinitionsOfType(VariableEventListener.class);
                        for (VariableEventListener variableEventListener : variableEventListeners) {
                            if (!variableNames.contains(variableEventListener.getVariableName())) continue;
                            evaluateVariableEventListener = true;
                            break;
                        }
                        if (!evaluateVariableEventListener) continue;
                        break;
                    }
                }
                if (evaluateVariableEventListener) {
                    agenda.planEvaluateVariableEventListenersOperation(caseInstanceId);
                }
            }
            agenda.planEvaluateCriteriaOperation(caseInstanceId);
        }
    }
}

