/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncActivatePlanItemInstanceJobHandler
implements JobHandler {
    public static final String TYPE = "cmmn-async-activate-plan-item-instance";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        PlanItemInstanceEntity planItemInstanceEntity;
        if (variableScope instanceof PlanItemInstanceEntity) {
            planItemInstanceEntity = (PlanItemInstanceEntity)variableScope;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Executing async job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskExecuteAsyncJob", job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
        } else {
            throw new FlowableException("Invalid usage of cmmn-async-activate-plan-item-instance job handler, variable scope is of type " + String.valueOf(variableScope.getClass()));
        }
        CommandContextUtil.getAgenda(commandContext).planActivatePlanItemInstanceOperation(planItemInstanceEntity, configuration);
    }
}

