/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryConfigurationSettings;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmmnHistoryConfigurationSettings
implements CmmnHistoryConfigurationSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DefaultCmmnHistoryConfigurationSettings.class.getName());
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCmmnHistoryConfigurationSettings(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE;
    }

    protected boolean isEnableCaseDefinitionHistoryLevel() {
        return this.cmmnEngineConfiguration.isEnableCaseDefinitionHistoryLevel();
    }

    @Override
    public boolean isHistoryEnabled(String caseDefinitionId) {
        HistoryLevel engineHistoryLevel = this.cmmnEngineConfiguration.getHistoryLevel();
        if (this.isEnableCaseDefinitionHistoryLevel() && caseDefinitionId != null) {
            HistoryLevel caseDefinitionLevel = this.getCaseDefinitionHistoryLevel(caseDefinitionId);
            if (caseDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}", (Object)caseDefinitionLevel);
                }
                return !caseDefinitionLevel.equals((Object)HistoryLevel.NONE);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}", (Object)engineHistoryLevel);
            }
            return !engineHistoryLevel.equals((Object)HistoryLevel.NONE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}", (Object)engineHistoryLevel);
        }
        return !engineHistoryLevel.equals((Object)HistoryLevel.NONE);
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level, String caseDefinitionId) {
        HistoryLevel engineHistoryLevel = this.cmmnEngineConfiguration.getHistoryLevel();
        if (this.isEnableCaseDefinitionHistoryLevel() && caseDefinitionId != null) {
            HistoryLevel caseDefinitionLevel = this.getCaseDefinitionHistoryLevel(caseDefinitionId);
            if (caseDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)caseDefinitionLevel, (Object)level);
                }
                return caseDefinitionLevel.isAtLeast(level);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)level);
            }
            return engineHistoryLevel.isAtLeast(level);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)level);
        }
        return engineHistoryLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabledForCaseInstance(CaseInstanceEntity caseInstanceEntity) {
        String caseDefinitionId = caseInstanceEntity.getCaseDefinitionId();
        return this.isHistoryLevelAtLeast(HistoryLevel.INSTANCE, caseDefinitionId);
    }

    protected boolean isHistoryEnabledForActivity(String caseDefinitionId, String activityId) {
        HistoryLevel engineHistoryLevel = this.cmmnEngineConfiguration.getHistoryLevel();
        if (this.isEnableCaseDefinitionHistoryLevel() && caseDefinitionId != null) {
            HistoryLevel caseDefinitionLevel = this.getCaseDefinitionHistoryLevel(caseDefinitionId);
            if (caseDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)caseDefinitionLevel, (Object)HistoryLevel.ACTIVITY);
                }
                if (caseDefinitionLevel.isAtLeast(HistoryLevel.ACTIVITY)) {
                    return true;
                }
                if (!HistoryLevel.NONE.equals((Object)caseDefinitionLevel) && StringUtils.isNotEmpty((CharSequence)activityId)) {
                    return this.includePlanItemDefinitionInHistory(caseDefinitionId, activityId);
                }
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.ACTIVITY);
            }
            return engineHistoryLevel.isAtLeast(HistoryLevel.ACTIVITY);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.ACTIVITY);
        }
        if (engineHistoryLevel.isAtLeast(HistoryLevel.ACTIVITY)) {
            return true;
        }
        if (!HistoryLevel.NONE.equals((Object)engineHistoryLevel) && StringUtils.isNotEmpty((CharSequence)activityId)) {
            return this.includePlanItemDefinitionInHistory(caseDefinitionId, activityId);
        }
        return false;
    }

    @Override
    public boolean isHistoryEnabledForMilestone(MilestoneInstanceEntity milestoneInstanceEntity) {
        return this.isHistoryEnabledForActivity(milestoneInstanceEntity.getCaseDefinitionId(), milestoneInstanceEntity.getElementId());
    }

    @Override
    public boolean isHistoryEnabledForPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        return this.isHistoryEnabledForActivity(planItemInstanceEntity.getCaseDefinitionId(), planItemInstanceEntity.getPlanItemDefinitionId());
    }

    @Override
    public boolean isHistoryEnabledForUserTask(TaskInfo taskInfo) {
        String scopeDefinitionId = taskInfo.getScopeDefinitionId();
        HistoryLevel engineHistoryLevel = this.cmmnEngineConfiguration.getHistoryLevel();
        if (this.isEnableCaseDefinitionHistoryLevel() && scopeDefinitionId != null) {
            HistoryLevel caseDefinitionLevel = this.getCaseDefinitionHistoryLevel(scopeDefinitionId);
            if (caseDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)caseDefinitionLevel, (Object)HistoryLevel.TASK);
                }
                return this.hasTaskHistoryLevel(caseDefinitionLevel);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.TASK);
            }
            return this.hasTaskHistoryLevel(engineHistoryLevel);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.TASK);
        }
        return this.hasTaskHistoryLevel(engineHistoryLevel);
    }

    protected boolean hasTaskHistoryLevel(HistoryLevel historyLevel) {
        boolean taskHistoryLevel = false;
        if (HistoryLevel.TASK.equals((Object)historyLevel)) {
            taskHistoryLevel = true;
        } else if (historyLevel.isAtLeast(HistoryLevel.AUDIT)) {
            taskHistoryLevel = true;
        }
        return taskHistoryLevel;
    }

    @Override
    public boolean isHistoryEnabledForVariableInstance(VariableInstanceEntity variableInstanceEntity) {
        String caseDefinitionId = null;
        if (this.isEnableCaseDefinitionHistoryLevel() && variableInstanceEntity.getScopeId() != null) {
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(variableInstanceEntity.getScopeId());
            caseDefinitionId = caseInstance.getCaseDefinitionId();
        }
        return this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, caseDefinitionId);
    }

    @Override
    public boolean isHistoryEnabledForIdentityLink(IdentityLinkEntity identityLinkEntity) {
        String caseDefinitionId = this.getCaseDefinitionId(identityLinkEntity);
        return this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, caseDefinitionId);
    }

    protected String getCaseDefinitionId(IdentityLinkEntity identityLink) {
        TaskEntity task;
        String caseDefinitionId = null;
        if (identityLink.getScopeDefinitionId() != null) {
            return identityLink.getScopeDefinitionId();
        }
        if (identityLink.getScopeId() != null) {
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(identityLink.getScopeId());
            if (caseInstance != null) {
                caseDefinitionId = caseInstance.getCaseDefinitionId();
            }
        } else if (identityLink.getTaskId() != null && (task = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(identityLink.getTaskId())) != null) {
            caseDefinitionId = task.getScopeDefinitionId();
        }
        return caseDefinitionId;
    }

    @Override
    public boolean isHistoryEnabledForEntityLink(EntityLinkEntity entityLink) {
        String caseDefinitionId = this.getCaseDefinitionId(entityLink);
        return this.isHistoryEnabled(caseDefinitionId);
    }

    @Override
    public boolean isHistoryEnabledForVariables(HistoricTaskInstance historicTaskInstance) {
        return this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY);
    }

    protected String getCaseDefinitionId(EntityLinkEntity entityLink) {
        TaskEntity task;
        String caseDefinitionId = null;
        if ("cmmn".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null) {
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(entityLink.getScopeId());
            if (caseInstance != null) {
                caseDefinitionId = caseInstance.getCaseDefinitionId();
            }
        } else if ("task".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null && (task = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(entityLink.getScopeId())) != null) {
            caseDefinitionId = task.getScopeDefinitionId();
        }
        return caseDefinitionId;
    }

    protected HistoryLevel getCaseDefinitionHistoryLevel(String caseDefinitionId) {
        HistoryLevel caseDefinitionHistoryLevel = null;
        try {
            ExtensionElement historyLevelElement;
            String historyLevelValue;
            CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseDefinitionId);
            CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinitionId);
            Case caze = cmmnModel.getCaseById(caseDefinition.getKey());
            if (caze.getPlanModel().getExtensionElements().containsKey("historyLevel") && StringUtils.isNotEmpty((CharSequence)(historyLevelValue = (historyLevelElement = (ExtensionElement)((List)caze.getPlanModel().getExtensionElements().get("historyLevel")).iterator().next()).getElementText()))) {
                try {
                    caseDefinitionHistoryLevel = HistoryLevel.getHistoryLevelForKey((String)historyLevelValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (caseDefinitionHistoryLevel == null) {
                caseDefinitionHistoryLevel = this.cmmnEngineConfiguration.getHistoryLevel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return caseDefinitionHistoryLevel;
    }

    protected boolean includePlanItemDefinitionInHistory(String caseDefinitionId, String activityId) {
        boolean includeInHistory = false;
        if (caseDefinitionId != null) {
            CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinitionId);
            PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(activityId);
            if (planItemDefinition == null) {
                PlanItem planItem = cmmnModel.findPlanItem(activityId);
                planItemDefinition = planItem.getPlanItemDefinition();
            }
            if (planItemDefinition.getExtensionElements().containsKey("includeInHistory")) {
                ExtensionElement historyElement = (ExtensionElement)((List)planItemDefinition.getExtensionElements().get("includeInHistory")).iterator().next();
                String historyLevelValue = historyElement.getElementText();
                includeInHistory = Boolean.valueOf(historyLevelValue);
            }
        }
        return includeInHistory;
    }
}

