/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractSetVariableAsyncCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetLocalVariablesAsyncCmd
extends AbstractSetVariableAsyncCmd
implements Command<Void> {
    protected String planItemInstanceId;
    protected Map<String, Object> variables;

    public SetLocalVariablesAsyncCmd(String planItemInstanceId, Map<String, Object> variables) {
        this.planItemInstanceId = planItemInstanceId;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("planItemInstanceId is null");
        }
        if (this.variables == null) {
            throw new FlowableIllegalArgumentException("variables is null");
        }
        if (this.variables.isEmpty()) {
            throw new FlowableIllegalArgumentException("variables is empty");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No plan item instance found for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        for (String variableName : this.variables.keySet()) {
            this.addVariable(true, planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId(), variableName, this.variables.get(variableName), planItemInstanceEntity.getTenantId(), cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService());
        }
        this.createSetAsyncVariablesJob(planItemInstanceEntity, cmmnEngineConfiguration);
        return null;
    }
}

