/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractSetVariableAsyncCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetLocalVariableAsyncCmd
extends AbstractSetVariableAsyncCmd
implements Command<Void> {
    protected String planItemInstanceId;
    protected String variableName;
    protected Object variableValue;

    public SetLocalVariableAsyncCmd(String planItemInstanceId, String variableName, Object variableValue) {
        this.planItemInstanceId = planItemInstanceId;
        this.variableName = variableName;
        this.variableValue = variableValue;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("planItemInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variable name is null");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No plan item instance found for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        this.addVariable(true, planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId(), this.variableName, this.variableValue, planItemInstanceEntity.getTenantId(), cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService());
        this.createSetAsyncVariablesJob(planItemInstanceEntity, cmmnEngineConfiguration);
        return null;
    }
}

