/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.StageResponse;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstanceQuery;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.history.HistoricPlanItemInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class GetHistoricStageOverviewCmd
implements Command<List<StageResponse>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;

    public GetHistoricStageOverviewCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public List<StageResponse> execute(CommandContext commandContext) {
        Optional<HistoricPlanItemInstance> planItemInstance2;
        OverviewElement overviewElement22;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        HistoricCaseInstanceEntity caseInstance = (HistoricCaseInstanceEntity)cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager().findById(this.caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, HistoricCaseInstanceEntity.class);
        }
        HistoricPlanItemInstanceEntityManager planItemInstanceEntityManager = cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
        List<HistoricPlanItemInstance> planItemInstances = planItemInstanceEntityManager.findByCriteria((HistoricPlanItemInstanceQuery)new HistoricPlanItemInstanceQueryImpl().planItemInstanceCaseInstanceId(this.caseInstanceId).planItemInstanceDefinitionTypes(Arrays.asList(PlanItemDefinitionType.STAGE, PlanItemDefinitionType.MILESTONE)).orderByEndedTime().asc());
        planItemInstances.removeIf(planItemInstance -> PlanItemInstanceState.INTERMEDIARY_STATES.contains(planItemInstance.getState()));
        CmmnDeploymentManager deploymentManager = cmmnEngineConfiguration.getDeploymentManager();
        CaseDefinition caseDefinition = deploymentManager.findDeployedCaseDefinitionById(caseInstance.getCaseDefinitionId());
        CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
        List stages = cmmnModel.getPrimaryCase().getPlanModel().findPlanItemDefinitionsOfType(Stage.class, true);
        List milestones = cmmnModel.getPrimaryCase().getPlanModel().findPlanItemDefinitionsOfType(Milestone.class, true);
        ArrayList<OverviewElement> overviewElements = new ArrayList<OverviewElement>();
        for (Stage stage : stages) {
            overviewElement22 = new OverviewElement(stage.getId(), stage.getName(), stage.getDisplayOrder(), stage.getIncludeInStageOverview(), (PlanItemDefinition)stage);
            planItemInstance2 = this.getPlanItemInstance(planItemInstances, (PlanItemDefinition)stage);
            if (planItemInstance2.isPresent() && StringUtils.isNotEmpty((CharSequence)planItemInstance2.get().getName())) {
                overviewElement22.setName(planItemInstance2.get().getName());
            }
            overviewElements.add(overviewElement22);
        }
        for (Milestone milestone : milestones) {
            overviewElement22 = new OverviewElement(milestone.getId(), milestone.getName(), milestone.getDisplayOrder(), milestone.getIncludeInStageOverview(), (PlanItemDefinition)milestone);
            planItemInstance2 = this.getPlanItemInstance(planItemInstances, (PlanItemDefinition)milestone);
            if (planItemInstance2.isPresent() && StringUtils.isNotEmpty((CharSequence)planItemInstance2.get().getName())) {
                overviewElement22.setName(planItemInstance2.get().getName());
            }
            overviewElements.add(overviewElement22);
        }
        overviewElements.sort(Comparator.comparing(OverviewElement::getDisplayOrder, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(overviewElement -> this.getPlanItemInstanceEndTime(planItemInstances, overviewElement.getPlanItemDefinition()), Comparator.nullsLast(Comparator.naturalOrder())));
        ArrayList<StageResponse> stageResponses = new ArrayList<StageResponse>(stages.size());
        for (OverviewElement overviewElement22 : overviewElements) {
            planItemInstance2 = this.getPlanItemInstance(planItemInstances, overviewElement22.getPlanItemDefinition());
            boolean showInOverview = false;
            if (planItemInstance2.isPresent()) {
                if (planItemInstance2.get().isShowInOverview()) {
                    showInOverview = true;
                }
            } else if (caseInstance.getEndTime() == null && !"false".equalsIgnoreCase(overviewElement22.getIncludeInStageOverview())) {
                showInOverview = true;
            }
            if (!showInOverview) continue;
            StageResponse stageResponse = new StageResponse(overviewElement22.getId(), overviewElement22.getName());
            if (planItemInstance2.isPresent()) {
                stageResponse.setEndTime(planItemInstance2.get().getEndedTime());
                stageResponse.setEnded(stageResponse.getEndTime() != null);
                stageResponse.setCurrent("active".equals(planItemInstance2.get().getState()));
            }
            stageResponses.add(stageResponse);
        }
        return stageResponses;
    }

    protected Date getPlanItemInstanceEndTime(List<HistoricPlanItemInstance> planItemInstances, PlanItemDefinition planItemDefinition) {
        return this.getPlanItemInstance(planItemInstances, planItemDefinition).map(HistoricPlanItemInstance::getEndedTime).orElse(null);
    }

    protected Optional<HistoricPlanItemInstance> getPlanItemInstance(List<HistoricPlanItemInstance> planItemInstances, PlanItemDefinition planItemDefinition) {
        HistoricPlanItemInstance planItemInstance = null;
        for (HistoricPlanItemInstance p : planItemInstances) {
            if (!p.getPlanItemDefinitionId().equals(planItemDefinition.getId())) continue;
            if (p.getEndedTime() == null) {
                planItemInstance = p;
                continue;
            }
            if (planItemInstance != null) continue;
            planItemInstance = p;
        }
        return Optional.ofNullable(planItemInstance);
    }

    protected class OverviewElement {
        protected String id;
        protected String name;
        protected Integer displayOrder;
        protected String includeInStageOverview;
        protected PlanItemDefinition planItemDefinition;

        public OverviewElement(String id, String name, Integer displayOrder, String includeInStageOverview, PlanItemDefinition planItemDefinition) {
            this.id = id;
            this.name = name;
            this.displayOrder = displayOrder;
            this.includeInStageOverview = includeInStageOverview;
            this.planItemDefinition = planItemDefinition;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        public String getIncludeInStageOverview() {
            return this.includeInStageOverview;
        }

        public void setIncludeInStageOverview(String includeInStageOverview) {
            this.includeInStageOverview = includeInStageOverview;
        }

        public PlanItemDefinition getPlanItemDefinition() {
            return this.planItemDefinition;
        }

        public void setPlanItemDefinition(PlanItemDefinition planItemDefinition) {
            this.planItemDefinition = planItemDefinition;
        }
    }
}

