/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public abstract class AbstractSetVariableAsyncCmd {
    protected void addVariable(boolean isLocal, String scopeId, String subScopeId, String varName, Object varValue, String tenantId, VariableService variableService) {
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
        variableInstance.setScopeId(scopeId);
        variableInstance.setSubScopeId(subScopeId);
        variableInstance.setScopeType("cmmnAsyncVariables");
        variableInstance.setMetaInfo(String.valueOf(isLocal));
        variableService.insertVariableInstanceWithValue(variableInstance, varValue, tenantId);
    }

    protected void createSetAsyncVariablesJob(CaseInstanceEntity caseInstanceEntity, CmmnEngineConfiguration cmmnEngineConfiguration) {
        JobServiceConfiguration jobServiceConfiguration = cmmnEngineConfiguration.getJobServiceConfiguration();
        JobService jobService = jobServiceConfiguration.getJobService();
        JobEntity job = jobService.createJob();
        job.setScopeId(caseInstanceEntity.getId());
        job.setScopeDefinitionId(caseInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setJobHandlerType("cmmn-set-async-variables");
        if (caseInstanceEntity.getTenantId() != null) {
            job.setTenantId(caseInstanceEntity.getTenantId());
        }
        jobService.createAsyncJob(job, true);
        jobService.scheduleAsyncJob(job);
    }

    protected void createSetAsyncVariablesJob(PlanItemInstanceEntity planItemInstanceEntity, CmmnEngineConfiguration cmmnEngineConfiguration) {
        JobServiceConfiguration jobServiceConfiguration = cmmnEngineConfiguration.getJobServiceConfiguration();
        JobService jobService = jobServiceConfiguration.getJobService();
        JobEntity job = jobService.createJob();
        job.setScopeId(planItemInstanceEntity.getCaseInstanceId());
        job.setSubScopeId(planItemInstanceEntity.getId());
        job.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setJobHandlerType("cmmn-set-async-variables");
        if (planItemInstanceEntity.getTenantId() != null) {
            job.setTenantId(planItemInstanceEntity.getTenantId());
        }
        jobService.createAsyncJob(job, true);
        jobService.scheduleAsyncJob(job);
    }
}

