/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EventInstanceCmmnUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;

public class SendEventActivityBehavior
extends TaskActivityBehavior {
    protected SendEventServiceTask serviceTask;

    public SendEventActivityBehavior(SendEventServiceTask serviceTask) {
        super(serviceTask.isBlocking(), serviceTask.getBlockingExpression());
        this.serviceTask = serviceTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        String key = this.getEventKey(planItemInstanceEntity);
        EventRegistry eventRegistry = CommandContextUtil.getEventRegistry();
        EventModel eventModel = this.getEventModel(planItemInstanceEntity, key);
        boolean sendOnSystemChannel = this.isSendOnSystemChannel(planItemInstanceEntity);
        List<ChannelModel> channelModels = this.getChannelModels(commandContext, planItemInstanceEntity, sendOnSystemChannel);
        Collection<EventPayloadInstance> eventPayloadInstances = EventInstanceCmmnUtil.createEventPayloadInstances(planItemInstanceEntity, CommandContextUtil.getExpressionManager(commandContext), (BaseElement)this.serviceTask, eventModel);
        EventInstanceImpl eventInstance = new EventInstanceImpl(eventModel.getKey(), eventPayloadInstances, planItemInstanceEntity.getTenantId());
        if (!channelModels.isEmpty()) {
            eventRegistry.sendEventOutbound((EventInstance)eventInstance, channelModels);
        }
        if (sendOnSystemChannel) {
            eventRegistry.sendSystemEventOutbound((EventInstance)eventInstance);
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected EventModel getEventModel(PlanItemInstanceEntity planItemInstanceEntity, String key) {
        EventModel eventModel = null;
        eventModel = Objects.equals("", planItemInstanceEntity.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(key) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(key, planItemInstanceEntity.getTenantId());
        if (eventModel == null) {
            throw new FlowableException("No event model found for event key " + key + " for " + String.valueOf(planItemInstanceEntity));
        }
        return eventModel;
    }

    protected boolean isSendOnSystemChannel(PlanItemInstanceEntity planItemInstanceEntity) {
        List systemChannels = planItemInstanceEntity.getPlanItemDefinition().getExtensionElements().getOrDefault("systemChannel", Collections.emptyList());
        return !systemChannels.isEmpty();
    }

    protected List<ChannelModel> getChannelModels(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, boolean sendOnSystemChannel) {
        String channelKey;
        List channelKeyElements;
        ArrayList<String> channelKeys = new ArrayList<String>();
        Map extensionElements = planItemInstanceEntity.getPlanItem().getPlanItemDefinition().getExtensionElements();
        if (extensionElements != null && (channelKeyElements = (List)extensionElements.get("channelKey")) != null && !channelKeyElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(channelKey = ((ExtensionElement)channelKeyElements.get(0)).getElementText()))) {
            ExpressionManager expressionManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager();
            Expression expression = expressionManager.createExpression(channelKey);
            Object resolvedChannelKey = expression.getValue((VariableContainer)planItemInstanceEntity);
            if (resolvedChannelKey instanceof Collection) {
                for (Object next : (Collection)resolvedChannelKey) {
                    if (next instanceof String) {
                        String[] keys = ((String)next).split(",");
                        channelKeys.addAll(Arrays.asList(keys));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Can only use a collection of String elements for referencing channel model key");
                }
            } else if (resolvedChannelKey instanceof String) {
                String[] keys = ((String)resolvedChannelKey).split(",");
                channelKeys.addAll(Arrays.asList(keys));
            }
        }
        if (channelKeys.isEmpty()) {
            if (!sendOnSystemChannel) {
                throw new FlowableException("No channel keys configured for " + String.valueOf(planItemInstanceEntity));
            }
            return Collections.emptyList();
        }
        EventRepositoryService eventRepositoryService = CommandContextUtil.getEventRegistryEngineConfiguration(commandContext).getEventRepositoryService();
        ArrayList<ChannelModel> channelModels = new ArrayList<ChannelModel>(channelKeys.size());
        for (String channelKey2 : channelKeys) {
            if (Objects.equals("", planItemInstanceEntity.getTenantId())) {
                channelModels.add(eventRepositoryService.getChannelModelByKey(channelKey2));
                continue;
            }
            channelModels.add(eventRepositoryService.getChannelModelByKey(channelKey2, planItemInstanceEntity.getTenantId()));
        }
        return channelModels;
    }

    protected String getEventKey(PlanItemInstanceEntity planItemInstanceEntity) {
        if (StringUtils.isNotEmpty((CharSequence)this.serviceTask.getEventType())) {
            return this.serviceTask.getEventType();
        }
        throw new FlowableException("No event key configured for " + this.serviceTask.getId() + " for " + String.valueOf(planItemInstanceEntity));
    }
}

