/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.flowable.cmmn.api.delegate.PlanItemFutureJavaDelegate;
import org.flowable.cmmn.api.delegate.PlanItemJavaDelegate;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemFutureJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemDelegateExpressionActivityBehavior
extends CoreCmmnTriggerableActivityBehavior {
    protected String expression;
    protected List<FieldExtension> fieldExtensions;

    public PlanItemDelegateExpressionActivityBehavior(String expression, List<FieldExtension> fieldExtensions) {
        this.expression = expression;
        this.fieldExtensions = fieldExtensions;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Expression expressionObject = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.expression);
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(expressionObject, (VariableContainer)planItemInstanceEntity, this.fieldExtensions);
        if (delegate instanceof PlanItemActivityBehavior) {
            ((PlanItemActivityBehavior)delegate).execute(planItemInstanceEntity);
        } else if (delegate instanceof CmmnActivityBehavior) {
            ((CmmnActivityBehavior)delegate).execute(planItemInstanceEntity);
        } else if (delegate instanceof PlanItemJavaDelegate) {
            PlanItemJavaDelegateActivityBehavior behavior = new PlanItemJavaDelegateActivityBehavior((PlanItemJavaDelegate)delegate);
            behavior.execute(planItemInstanceEntity);
        } else if (delegate instanceof PlanItemFutureJavaDelegate) {
            PlanItemFutureJavaDelegateActivityBehavior behavior = new PlanItemFutureJavaDelegateActivityBehavior((PlanItemFutureJavaDelegate)delegate);
            behavior.execute(planItemInstanceEntity);
        } else {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + String.valueOf(PlanItemActivityBehavior.class) + ", " + String.valueOf(CmmnActivityBehavior.class) + ", " + String.valueOf(PlanItemJavaDelegate.class) + " nor " + String.valueOf(PlanItemFutureJavaDelegate.class));
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Expression expressionObject = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.expression);
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(expressionObject, (VariableContainer)planItemInstanceEntity, this.fieldExtensions);
        if (!(delegate instanceof CmmnTriggerableActivityBehavior)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + String.valueOf(CmmnTriggerableActivityBehavior.class));
        }
        ((CmmnTriggerableActivityBehavior)delegate).trigger(planItemInstanceEntity);
    }
}

