/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.interceptor.CreateCmmnExternalWorkerJobAfterContext;
import org.flowable.cmmn.engine.interceptor.CreateCmmnExternalWorkerJobBeforeContext;
import org.flowable.cmmn.engine.interceptor.CreateCmmnExternalWorkerJobInterceptor;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.ExternalWorkerServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;

public class ExternalWorkerTaskActivityBehavior
extends TaskActivityBehavior {
    protected ExternalWorkerServiceTask serviceTask;

    public ExternalWorkerTaskActivityBehavior(ExternalWorkerServiceTask serviceTask) {
        super(serviceTask.isBlocking(), serviceTask.getBlockingExpression());
        this.serviceTask = serviceTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Expression expression;
        Object expressionValue;
        Expression categoryExpression;
        Object categoryValue;
        String jobTopicExpression;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CreateCmmnExternalWorkerJobInterceptor interceptor = cmmnEngineConfiguration.getCreateCmmnExternalWorkerJobInterceptor();
        CreateCmmnExternalWorkerJobBeforeContext beforeContext = new CreateCmmnExternalWorkerJobBeforeContext(this.serviceTask, planItemInstanceEntity, this.getJobCategory((BaseElement)this.serviceTask), this.serviceTask.getTopic());
        if (interceptor != null) {
            interceptor.beforeCreateExternalWorkerJob(beforeContext);
        }
        if (StringUtils.isEmpty((CharSequence)(jobTopicExpression = beforeContext.getJobTopicExpression()))) {
            throw new FlowableException("no topic expression configured for " + String.valueOf(planItemInstanceEntity));
        }
        JobServiceConfiguration jobServiceConfiguration = cmmnEngineConfiguration.getJobServiceConfiguration();
        JobService jobService = jobServiceConfiguration.getJobService();
        ExternalWorkerJobEntity job = jobService.createExternalWorkerJob();
        job.setSubScopeId(planItemInstanceEntity.getId());
        job.setScopeId(planItemInstanceEntity.getCaseInstanceId());
        job.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setElementId(this.serviceTask.getId());
        job.setElementName(this.serviceTask.getName());
        job.setJobHandlerType("cmmn-external-worker-complete");
        job.setExclusive(this.serviceTask.isExclusive());
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getJobCategory()) && (categoryValue = (categoryExpression = CommandContextUtil.getExpressionManager(commandContext).createExpression(beforeContext.getJobCategory())).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            job.setCategory(categoryValue.toString());
        }
        job.setJobType("externalWorker");
        job.setRetries(jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
        if (planItemInstanceEntity.getTenantId() != null) {
            job.setTenantId(planItemInstanceEntity.getTenantId());
        }
        if ((expressionValue = (expression = CommandContextUtil.getExpressionManager(commandContext).createExpression(jobTopicExpression)).getValue((VariableContainer)planItemInstanceEntity)) == null || expressionValue.toString().isEmpty()) {
            throw new FlowableException("Expression " + jobTopicExpression + " did not evaluate to a valid value (non empty String). Was: " + String.valueOf(expressionValue) + ". For " + String.valueOf(planItemInstanceEntity));
        }
        job.setJobHandlerConfiguration(expressionValue.toString());
        jobService.insertExternalWorkerJob(job);
        if (interceptor != null) {
            interceptor.afterCreateExternalWorkerJob(new CreateCmmnExternalWorkerJobAfterContext(this.serviceTask, job, planItemInstanceEntity));
        }
    }

    protected String getJobCategory(BaseElement baseElement) {
        List jobCategoryElements = (List)baseElement.getExtensionElements().get("jobCategory");
        if (jobCategoryElements != null && jobCategoryElements.size() > 0) {
            return ((ExtensionElement)jobCategoryElements.get(0)).getElementText();
        }
        return null;
    }
}

