/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.task.Comment;
import org.flowable.rest.service.api.engine.CommentRequest;
import org.flowable.rest.service.api.engine.CommentResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Task Comments"}, description="Manage Tasks Comments", authorizations={@Authorization(value="basicAuth")})
public class TaskCommentCollectionResource
extends TaskBaseResource {
    @ApiOperation(value="List comments on a task", tags={"Task Comments"}, nickname="listTaskComments")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the comments are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @GetMapping(value={"/runtime/tasks/{taskId}/comments"}, produces={"application/json"})
    public List<CommentResponse> getComments(@ApiParam(name="taskId") @PathVariable String taskId) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        return this.restResponseFactory.createRestCommentList(this.taskService.getTaskComments(task.getId()));
    }

    @ApiOperation(value="Create a new comment on a task", tags={"Task Comments"}, nickname="createTaskComments", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the comment was created and the result is returned."), @ApiResponse(code=400, message="Indicates the comment is missing from the request."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @PostMapping(value={"/runtime/tasks/{taskId}/comments"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public CommentResponse createComment(@ApiParam(name="taskId") @PathVariable String taskId, @RequestBody CommentRequest comment) {
        Task task = this.getTaskFromRequestWithoutAccessCheck(taskId);
        if (comment.getMessage() == null) {
            throw new FlowableIllegalArgumentException("Comment text is required.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.createTaskComment(task, comment);
        }
        String processInstanceId = null;
        if (comment.isSaveProcessInstanceId()) {
            Task taskEntity = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult();
            processInstanceId = taskEntity.getProcessInstanceId();
        }
        Comment createdComment = this.taskService.addComment(task.getId(), processInstanceId, comment.getMessage());
        return this.restResponseFactory.createRestComment(createdComment);
    }
}

