/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseExecutionVariableResource
implements InitializingBean {
    @Autowired
    protected Environment env;
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;
    protected boolean isSerializableVariableAllowed;
    protected final int variableType;

    public BaseExecutionVariableResource(int variableType) {
        this.variableType = variableType;
    }

    public void afterPropertiesSet() {
        this.isSerializableVariableAllowed = (Boolean)this.env.getProperty("rest.variables.allow.serializable", Boolean.class, (Object)true);
    }

    protected byte[] getVariableDataByteArray(Execution execution, String variableName, String scope, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(execution, variableName, scope, true);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Error getting variable " + variableName, (Throwable)ioe);
        }
    }

    protected RestVariable setBinaryVariable(MultipartHttpServletRequest request, Execution execution, boolean isNew, boolean async) {
        if (request.getFileMap().size() == 0) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        MultipartFile file = request.getFile((String)request.getFileMap().keySet().iterator().next());
        if (file == null) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        String variableScope = null;
        String variableName = null;
        String variableType = null;
        Map paramMap = request.getParameterMap();
        for (String parameterName : paramMap.keySet()) {
            if (((String[])paramMap.get(parameterName)).length <= 0) continue;
            if ("scope".equalsIgnoreCase(parameterName)) {
                variableScope = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if ("name".equalsIgnoreCase(parameterName)) {
                variableName = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (!"type".equalsIgnoreCase(parameterName)) continue;
            variableType = ((String[])paramMap.get(parameterName))[0];
        }
        try {
            if (variableName == null) {
                throw new FlowableIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new FlowableIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                byte[] variableBytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                this.setVariable(execution, variableName, variableBytes, scope, isNew, async);
            } else if (this.isSerializableVariableAllowed) {
                ObjectInputStream stream = new ObjectInputStream(file.getInputStream());
                Object value = stream.readObject();
                this.setVariable(execution, variableName, value, scope, isNew, async);
                stream.close();
            } else {
                throw new FlowableContentNotSupportedException("Serialized objects are not allowed");
            }
            RestVariable variable = null;
            if (!async) {
                variable = this.getVariableFromRequestWithoutAccessCheck(execution, variableName, scope, false);
                variable.setVariableScope(scope);
            }
            return variable;
        }
        catch (IOException ioe) {
            throw new FlowableIllegalArgumentException("Could not process multipart content", (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new FlowableContentNotSupportedException("The provided body contains a serialized object for which the class was not found: " + ioe.getMessage());
        }
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, Execution execution, boolean isNew, boolean async) {
        if (restVariable.getName() == null) {
            throw new FlowableIllegalArgumentException("Variable name is required");
        }
        RestVariable.RestVariableScope scope = restVariable.getVariableScope();
        if (scope == null) {
            scope = RestVariable.RestVariableScope.LOCAL;
        }
        Object actualVariableValue = this.restResponseFactory.getVariableValue(restVariable);
        this.setVariable(execution, restVariable.getName(), actualVariableValue, scope, isNew, async);
        RestVariable newRestVariable = null;
        if (!async) {
            newRestVariable = this.getVariableFromRequestWithoutAccessCheck(execution, restVariable.getName(), scope, false);
        }
        return newRestVariable;
    }

    protected void setVariable(Execution execution, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew, boolean async) {
        boolean hasVariable = this.hasVariableOnScope(execution, name, scope);
        if (isNew && hasVariable) {
            throw new FlowableException("Variable '" + name + "' is already present on execution '" + execution.getId() + "'.");
        }
        if (!isNew && !hasVariable) {
            throw new FlowableObjectNotFoundException("Execution '" + execution.getId() + "' does not have a variable with name: '" + name + "'.", null);
        }
        if (this.restApiInterceptor != null) {
            if (isNew) {
                this.restApiInterceptor.createExecutionVariables(execution, Collections.singletonMap(name, value), scope);
            } else {
                this.restApiInterceptor.updateExecutionVariables(execution, Collections.singletonMap(name, value), scope);
            }
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            if (async) {
                this.runtimeService.setVariableLocalAsync(execution.getId(), name, value);
            } else {
                this.runtimeService.setVariableLocal(execution.getId(), name, value);
            }
        } else {
            String executionId = null;
            executionId = execution.getParentId() != null ? execution.getParentId() : execution.getId();
            if (async) {
                this.runtimeService.setVariableAsync(executionId, name, value);
            } else {
                this.runtimeService.setVariable(executionId, name, value);
            }
        }
    }

    protected boolean hasVariableOnScope(Execution execution, String variableName, RestVariable.RestVariableScope scope) {
        boolean variableFound = false;
        if (scope == RestVariable.RestVariableScope.GLOBAL) {
            if (execution.getParentId() != null && this.runtimeService.hasVariable(execution.getParentId(), variableName)) {
                variableFound = true;
            }
        } else if (scope == RestVariable.RestVariableScope.LOCAL && this.runtimeService.hasVariableLocal(execution.getId(), variableName)) {
            variableFound = true;
        }
        return variableFound;
    }

    public RestVariable getVariableFromRequest(Execution execution, String variableName, String scope, boolean includeBinary) {
        if (execution == null) {
            throw new FlowableObjectNotFoundException("Could not find an execution", Execution.class);
        }
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessExecutionVariable(execution, variableName, scope);
        }
        return this.getVariableFromRequestWithoutAccessCheck(execution, variableName, variableScope, includeBinary);
    }

    public RestVariable getVariableFromRequestWithoutAccessCheck(Execution execution, String variableName, RestVariable.RestVariableScope variableScope, boolean includeBinary) {
        boolean variableFound = false;
        Object value = null;
        if (variableScope == null) {
            if (this.runtimeService.hasVariableLocal(execution.getId(), variableName)) {
                value = this.runtimeService.getVariableLocal(execution.getId(), variableName);
                variableScope = RestVariable.RestVariableScope.LOCAL;
                variableFound = true;
            } else if (execution.getParentId() != null) {
                value = this.runtimeService.getVariable(execution.getParentId(), variableName);
                variableScope = RestVariable.RestVariableScope.GLOBAL;
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            if (execution.getParentId() != null) {
                value = this.runtimeService.getVariable(execution.getParentId(), variableName);
                variableScope = RestVariable.RestVariableScope.GLOBAL;
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            value = this.runtimeService.getVariableLocal(execution.getId(), variableName);
            variableScope = RestVariable.RestVariableScope.LOCAL;
            variableFound = true;
        }
        if (!variableFound) {
            throw new FlowableObjectNotFoundException("Execution '" + execution.getId() + "' does not have a variable with name: '" + variableName + "'.", VariableInstanceEntity.class);
        }
        return this.constructRestVariable(variableName, value, variableScope, execution.getId(), includeBinary);
    }

    protected RestVariable constructRestVariable(String variableName, Object value, RestVariable.RestVariableScope variableScope, String executionId, boolean includeBinary) {
        return this.restResponseFactory.createRestVariable(variableName, value, variableScope, executionId, this.variableType, includeBinary);
    }

    protected Execution getExecutionFromRequestWithoutAccessCheck(String executionId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            throw new FlowableObjectNotFoundException("Could not find an execution with id '" + executionId + "'.", Execution.class);
        }
        return execution;
    }

    protected String getExecutionIdParameter() {
        return "executionId";
    }

    protected boolean allowProcessInstanceUrl() {
        return false;
    }
}

