/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.ActivityInstanceQueryProperty;
import org.flowable.engine.runtime.ActivityInstanceQuery;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceQueryRequest;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<ActivityInstanceResponse> getQueryResponse(ActivityInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        ActivityInstanceQuery query = this.runtimeService.createActivityInstanceQuery();
        if (queryRequest.getActivityId() != null) {
            query.activityId(queryRequest.getActivityId());
        }
        if (queryRequest.getActivityInstanceId() != null) {
            query.activityInstanceId(queryRequest.getActivityInstanceId());
        }
        if (queryRequest.getActivityName() != null) {
            query.activityName(queryRequest.getActivityName());
        }
        if (queryRequest.getActivityType() != null) {
            query.activityType(queryRequest.getActivityType());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getFinished() != null) {
            Boolean finished = queryRequest.getFinished();
            if (finished.booleanValue()) {
                query.finished();
            } else {
                query.unfinished();
            }
        }
        if (queryRequest.getTaskAssignee() != null) {
            query.taskAssignee(queryRequest.getTaskAssignee());
        }
        if (queryRequest.getTaskCompletedBy() != null) {
            query.taskCompletedBy(queryRequest.getTaskCompletedBy());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getTenantId() != null) {
            query.activityTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.activityTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.activityWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessActivityInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (PaginateRequest)queryRequest, (Query)query, (String)"startTime", allowedSortProperties, this.restResponseFactory::createActivityInstanceResponseList);
    }

    static {
        allowedSortProperties.put("activityId", (QueryProperty)ActivityInstanceQueryProperty.ACTIVITY_ID);
        allowedSortProperties.put("activityName", (QueryProperty)ActivityInstanceQueryProperty.ACTIVITY_NAME);
        allowedSortProperties.put("activityType", (QueryProperty)ActivityInstanceQueryProperty.ACTIVITY_TYPE);
        allowedSortProperties.put("duration", (QueryProperty)ActivityInstanceQueryProperty.DURATION);
        allowedSortProperties.put("endTime", (QueryProperty)ActivityInstanceQueryProperty.END);
        allowedSortProperties.put("executionId", (QueryProperty)ActivityInstanceQueryProperty.EXECUTION_ID);
        allowedSortProperties.put("activityInstanceId", (QueryProperty)ActivityInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        allowedSortProperties.put("processDefinitionId", (QueryProperty)ActivityInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processInstanceId", (QueryProperty)ActivityInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("startTime", (QueryProperty)ActivityInstanceQueryProperty.START);
        allowedSortProperties.put("tenantId", (QueryProperty)ActivityInstanceQueryProperty.TENANT_ID);
    }
}

