/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.RuntimeService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Runtime"}, description="Manage Runtime", authorizations={@Authorization(value="basicAuth")})
public class VariableInstanceDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    @GetMapping(value={"/runtime/variable-instances/{varInstanceId}/data"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the variable instance was found and the requested variable data is returned."), @ApiResponse(code=404, message="Indicates the requested variable instance was not found or the variable instance does not have a variable with the given name or the variable does not have a binary stream available. Status message provides additional information.")})
    @ApiOperation(value="Get the binary data for a variable instance", tags={"Runtime"}, nickname="getVariableInstanceData", notes="The response body contains the binary value of the variable. When the variable is of type binary, the content-type of the response is set to application/octet-stream, regardless of the content of the variable or the request accept-type header. In case of serializable, application/x-java-serialized-object is used as content-type.")
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="varInstanceId") @PathVariable(value="varInstanceId") String varInstanceId, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(true, varInstanceId);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String varInstanceId) {
        VariableInstance varObject = (VariableInstance)this.runtimeService.createVariableInstanceQuery().id(varInstanceId).singleResult();
        if (varObject == null) {
            throw new FlowableObjectNotFoundException("Historic variable instance '" + varInstanceId + "' could not be found.", VariableInstanceEntity.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessVariableInfoById(varObject);
        }
        return this.restResponseFactory.createRestVariable(varObject.getName(), varObject.getValue(), null, varInstanceId, 4, includeBinary);
    }
}

