/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.RuntimeService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.runtime.VariableInstanceQueryRequest;
import org.flowable.rest.service.api.runtime.VariableInstanceResponse;
import org.flowable.variable.api.runtime.VariableInstanceQuery;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class VariableInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<VariableInstanceResponse> getQueryResponse(VariableInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        if (Boolean.TRUE.equals(queryRequest.getExcludeTaskVariables())) {
            query.excludeTaskVariables();
        }
        if (Boolean.TRUE.equals(queryRequest.getExcludeLocalVariables())) {
            query.excludeLocalVariables();
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getVariableName() != null) {
            query.variableName(queryRequest.getVariableName());
        }
        if (queryRequest.getVariableNameLike() != null) {
            query.variableNameLike(queryRequest.getVariableNameLike());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessVariableInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (PaginateRequest)queryRequest, (Query)query, (String)"variableName", allowedSortProperties, this.restResponseFactory::createVariableInstanceResponseList);
    }

    protected void addVariables(VariableInstanceQuery variableInstanceQuery, List<QueryVariable> variables) {
        block3: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is not supported");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    variableInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block3;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + String.valueOf((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("variableName", (QueryProperty)HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
    }
}

