/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskResponse;
import org.flowable.task.api.Task;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskSubTaskCollectionResource
extends TaskBaseResource {
    @ApiOperation(value="List of sub tasks for a task", nickname="listTaskSubtasks", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the  sub tasks are returned"), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @GetMapping(value={"/cmmn-runtime/tasks/{taskId}/subtasks"}, produces={"application/json"})
    public List<TaskResponse> getSubTasks(@ApiParam(name="taskId") @PathVariable String taskId) {
        Task task = this.getTaskFromRequest(taskId);
        return this.restResponseFactory.createTaskResponseList(this.taskService.getSubTasks(task.getId()));
    }
}

