/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryProperty;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.engine.variable.QueryVariable;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCaseInstanceResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnRuntimeService runtimeService;
    @Autowired
    protected CmmnRepositoryService repositoryService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<CaseInstanceResponse> getQueryResponse(CaseInstanceQueryRequest queryRequest, Map<String, String> requestParams) {
        CaseInstanceQuery query = this.runtimeService.createCaseInstanceQuery();
        if (queryRequest.getCaseInstanceId() != null) {
            query.caseInstanceId(queryRequest.getCaseInstanceId());
        }
        if (queryRequest.getCaseDefinitionKey() != null) {
            query.caseDefinitionKey(queryRequest.getCaseDefinitionKey());
        }
        if (queryRequest.getCaseDefinitionKeyLike() != null) {
            query.caseDefinitionKeyLike(queryRequest.getCaseDefinitionKeyLike());
        }
        if (queryRequest.getCaseDefinitionKeyLikeIgnoreCase() != null) {
            query.caseDefinitionKeyLikeIgnoreCase(queryRequest.getCaseDefinitionKeyLikeIgnoreCase());
        }
        if (queryRequest.getCaseDefinitionKeys() != null && !queryRequest.getCaseDefinitionKeys().isEmpty()) {
            query.caseDefinitionKeys(queryRequest.getCaseDefinitionKeys());
        }
        if (queryRequest.getExcludeCaseDefinitionKeys() != null && !queryRequest.getExcludeCaseDefinitionKeys().isEmpty()) {
            query.excludeCaseDefinitionKeys(queryRequest.getExcludeCaseDefinitionKeys());
        }
        if (queryRequest.getCaseDefinitionId() != null) {
            query.caseDefinitionId(queryRequest.getCaseDefinitionId());
        }
        if (queryRequest.getCaseDefinitionCategory() != null) {
            query.caseDefinitionCategory(queryRequest.getCaseDefinitionCategory());
        }
        if (queryRequest.getCaseDefinitionCategoryLike() != null) {
            query.caseDefinitionCategoryLike(queryRequest.getCaseDefinitionCategoryLike());
        }
        if (queryRequest.getCaseDefinitionCategoryLikeIgnoreCase() != null) {
            query.caseDefinitionCategoryLikeIgnoreCase(queryRequest.getCaseDefinitionCategoryLikeIgnoreCase());
        }
        if (queryRequest.getCaseDefinitionName() != null) {
            query.caseDefinitionName(queryRequest.getCaseDefinitionName());
        }
        if (queryRequest.getCaseDefinitionNameLike() != null) {
            query.caseDefinitionNameLike(queryRequest.getCaseDefinitionNameLike());
        }
        if (queryRequest.getCaseDefinitionNameLikeIgnoreCase() != null) {
            query.caseDefinitionNameLikeIgnoreCase(queryRequest.getCaseDefinitionNameLikeIgnoreCase());
        }
        if (queryRequest.getCaseBusinessKey() != null) {
            query.caseInstanceBusinessKey(queryRequest.getCaseBusinessKey());
        }
        if (queryRequest.getCaseInstanceName() != null) {
            query.caseInstanceName(queryRequest.getCaseInstanceName());
        }
        if (queryRequest.getCaseInstanceNameLike() != null) {
            query.caseInstanceNameLike(queryRequest.getCaseInstanceNameLike());
        }
        if (queryRequest.getCaseInstanceNameLikeIgnoreCase() != null) {
            query.caseInstanceNameLikeIgnoreCase(queryRequest.getCaseInstanceNameLikeIgnoreCase());
        }
        if (queryRequest.getCaseInstanceRootScopeId() != null) {
            query.caseInstanceRootScopeId(queryRequest.getCaseInstanceRootScopeId());
        }
        if (queryRequest.getCaseInstanceParentScopeId() != null) {
            query.caseInstanceParentScopeId(queryRequest.getCaseInstanceParentScopeId());
        }
        if (queryRequest.getCaseInstanceBusinessKey() != null) {
            query.caseInstanceBusinessKey(queryRequest.getCaseInstanceBusinessKey());
        }
        if (queryRequest.getCaseInstanceBusinessKeyLike() != null) {
            query.caseInstanceBusinessKeyLike(queryRequest.getCaseInstanceBusinessKeyLike());
        }
        if (queryRequest.getCaseInstanceBusinessKeyLikeIgnoreCase() != null) {
            query.caseInstanceBusinessKeyLikeIgnoreCase(queryRequest.getCaseInstanceBusinessKeyLikeIgnoreCase());
        }
        if (queryRequest.getCaseInstanceBusinessStatus() != null) {
            query.caseInstanceBusinessStatus(queryRequest.getCaseInstanceBusinessStatus());
        }
        if (queryRequest.getCaseInstanceBusinessStatusLike() != null) {
            query.caseInstanceBusinessStatusLike(queryRequest.getCaseInstanceBusinessStatusLike());
        }
        if (queryRequest.getCaseInstanceBusinessStatusLikeIgnoreCase() != null) {
            query.caseInstanceBusinessStatusLikeIgnoreCase(queryRequest.getCaseInstanceBusinessStatusLikeIgnoreCase());
        }
        if (queryRequest.getInvolvedUser() != null) {
            query.involvedUser(queryRequest.getInvolvedUser());
        }
        if (queryRequest.getCaseInstanceParentId() != null) {
            query.caseInstanceParentId(queryRequest.getCaseInstanceParentId());
        }
        if (queryRequest.getCaseInstanceState() != null) {
            query.caseInstanceState(queryRequest.getCaseInstanceState());
        }
        if (queryRequest.getCaseInstanceStartedBy() != null) {
            query.caseInstanceStartedBy(queryRequest.getCaseInstanceStartedBy());
        }
        if (queryRequest.getCaseInstanceStartedBefore() != null) {
            query.caseInstanceStartedBefore(queryRequest.getCaseInstanceStartedBefore());
        }
        if (queryRequest.getCaseInstanceStartedAfter() != null) {
            query.caseInstanceStartedAfter(queryRequest.getCaseInstanceStartedAfter());
        }
        if (queryRequest.getCaseInstanceCallbackId() != null) {
            query.caseInstanceCallbackId(queryRequest.getCaseInstanceCallbackId());
        }
        if (queryRequest.getCaseInstanceCallbackType() != null) {
            query.caseInstanceCallbackType(queryRequest.getCaseInstanceCallbackType());
        }
        if (queryRequest.getParentCaseInstanceId() != null) {
            query.parentCaseInstanceId(queryRequest.getParentCaseInstanceId());
        }
        if (queryRequest.getCaseInstanceReferenceId() != null) {
            query.caseInstanceReferenceId(queryRequest.getCaseInstanceReferenceId());
        }
        if (queryRequest.getCaseInstanceReferenceType() != null) {
            query.caseInstanceReferenceType(queryRequest.getCaseInstanceReferenceType());
        }
        if (queryRequest.getCaseInstanceLastReactivatedBy() != null) {
            query.caseInstanceLastReactivatedBy(queryRequest.getCaseInstanceLastReactivatedBy());
        }
        if (queryRequest.getCaseInstanceLastReactivatedBefore() != null) {
            query.caseInstanceLastReactivatedBefore(queryRequest.getCaseInstanceLastReactivatedBefore());
        }
        if (queryRequest.getCaseInstanceLastReactivatedAfter() != null) {
            query.caseInstanceLastReactivatedAfter(queryRequest.getCaseInstanceLastReactivatedAfter());
        }
        if (queryRequest.getIncludeCaseVariables() != null && queryRequest.getIncludeCaseVariables().booleanValue()) {
            query.includeCaseVariables();
        }
        if (queryRequest.getIncludeCaseVariablesNames() != null) {
            query.includeCaseVariables(queryRequest.getIncludeCaseVariablesNames());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (queryRequest.getActivePlanItemDefinitionId() != null) {
            query.activePlanItemDefinitionId(queryRequest.getActivePlanItemDefinitionId());
        }
        if (queryRequest.getActivePlanItemDefinitionIds() != null) {
            query.activePlanItemDefinitionIds(queryRequest.getActivePlanItemDefinitionIds());
        }
        if (queryRequest.getTenantId() != null) {
            query.caseInstanceTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.caseInstanceTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (queryRequest.getTenantIdLikeIgnoreCase() != null) {
            query.caseInstanceTenantIdLikeIgnoreCase(queryRequest.getTenantIdLikeIgnoreCase());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.caseInstanceWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseInstanceInfoWithQuery(query, queryRequest);
        }
        DataResponse responseList = PaginateListUtil.paginateList(requestParams, (PaginateRequest)queryRequest, (Query)query, (String)"id", allowedSortProperties, this.restResponseFactory::createCaseInstanceResponseList);
        HashSet<String> caseDefinitionIds = new HashSet<String>();
        List caseInstanceList = responseList.getData();
        for (CaseInstanceResponse caseInstanceResponse : caseInstanceList) {
            if (caseDefinitionIds.contains(caseInstanceResponse.getCaseDefinitionId())) continue;
            caseDefinitionIds.add(caseInstanceResponse.getCaseDefinitionId());
        }
        if (caseDefinitionIds.size() > 0) {
            List caseDefinitionList = this.repositoryService.createCaseDefinitionQuery().caseDefinitionIds(caseDefinitionIds).list();
            HashMap<String, CaseDefinition> caseDefinitionMap = new HashMap<String, CaseDefinition>();
            for (CaseDefinition caseDefinition : caseDefinitionList) {
                caseDefinitionMap.put(caseDefinition.getId(), caseDefinition);
            }
            for (CaseInstanceResponse caseInstanceResponse : caseInstanceList) {
                if (!caseDefinitionMap.containsKey(caseInstanceResponse.getCaseDefinitionId())) continue;
                CaseDefinition caseDefinition = (CaseDefinition)caseDefinitionMap.get(caseInstanceResponse.getCaseDefinitionId());
                caseInstanceResponse.setCaseDefinitionName(caseDefinition.getName());
                caseInstanceResponse.setCaseDefinitionDescription(caseDefinition.getDescription());
            }
        }
        return responseList;
    }

    protected CaseInstance getCaseInstanceFromRequest(String caseInstanceId) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseInstanceInfoById(caseInstance);
        }
        return caseInstance;
    }

    protected CaseInstance getCaseInstanceFromRequestWithoutAccessCheck(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a case instance with id '" + caseInstanceId + "'.");
        }
        return caseInstance;
    }

    protected void addVariables(CaseInstanceQuery caseInstanceQuery, List<QueryVariable> variables) {
        block12: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        caseInstanceQuery.variableValueEquals(actualValue);
                        continue block12;
                    }
                    caseInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    caseInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block12;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueLike(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case LIKE_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueLikeIgnoreCase(variable.getName(), (String)actualValue);
                        continue block12;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    caseInstanceQuery.variableValueGreaterThan(variable.getName(), actualValue);
                    continue block12;
                }
                case GREATER_THAN_OR_EQUALS: {
                    caseInstanceQuery.variableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN: {
                    caseInstanceQuery.variableValueLessThan(variable.getName(), actualValue);
                    continue block12;
                }
                case LESS_THAN_OR_EQUALS: {
                    caseInstanceQuery.variableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block12;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + String.valueOf((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("caseDefinitionId", (QueryProperty)CaseInstanceQueryProperty.CASE_DEFINITION_ID);
        allowedSortProperties.put("caseDefinitionKey", (QueryProperty)CaseInstanceQueryProperty.CASE_DEFINITION_KEY);
        allowedSortProperties.put("id", (QueryProperty)CaseInstanceQueryProperty.CASE_INSTANCE_ID);
        allowedSortProperties.put("startTime", (QueryProperty)CaseInstanceQueryProperty.CASE_START_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)CaseInstanceQueryProperty.TENANT_ID);
        allowedSortProperties.put("businessKey", (QueryProperty)CaseInstanceQueryProperty.BUSINESS_KEY);
    }
}

