/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.repository.BaseDeploymentResource;
import org.flowable.cmmn.rest.service.api.repository.CmmnDeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"CMMN Deployment"}, description="Manage CMMN Deployment", authorizations={@Authorization(value="basicAuth")})
public class DeploymentResource
extends BaseDeploymentResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;

    @ApiOperation(value="Get a deployment", tags={"Deployment"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the deployment was found and returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @GetMapping(value={"/cmmn-repository/deployments/{deploymentId}"}, produces={"application/json"})
    public CmmnDeploymentResponse getDeployment(@ApiParam(name="deploymentId", value="The id of the deployment to get.") @PathVariable String deploymentId) {
        CmmnDeployment deployment = this.getCmmnDeployment(deploymentId);
        return this.restResponseFactory.createDeploymentResponse(deployment);
    }

    @ApiOperation(value="Delete a deployment", tags={"Deployment"}, code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the deployment was found and has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @DeleteMapping(value={"/cmmn-repository/deployments/{deploymentId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDeployment(@ApiParam(name="deploymentId") @PathVariable String deploymentId, @RequestParam(value="cascade", required=false, defaultValue="false") Boolean cascade) {
        CmmnDeployment deployment = this.getCmmnDeployment(deploymentId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteDeployment(deployment);
        }
        if (cascade.booleanValue()) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        } else {
            this.repositoryService.deleteDeployment(deploymentId, false);
        }
    }
}

