/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionImageResource
extends BaseCaseDefinitionResource {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="Get a case definition image", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the case definitions are returned"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/image"}, produces={"image/png"})
    public ResponseEntity<byte[]> getImageResource(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        try (InputStream imageStream = this.repositoryService.getCaseDiagram(caseDefinition.getId());){
            if (imageStream == null) throw new FlowableObjectNotFoundException("Case definition with id '" + caseDefinition.getId() + "' has no image.");
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)imageStream), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
                return responseEntity;
            }
            catch (Exception e) {
                throw new FlowableException("Error reading image stream", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new FlowableException("Error reading image stream", (Throwable)e);
        }
    }
}

