/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.engine.RestIdentityLink;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.identitylink.api.IdentityLink;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionIdentityLinkResource
extends BaseCaseDefinitionResource {
    @ApiOperation(value="Get a candidate starter from a case definition", tags={"Case Definitions"}, nickname="getIdentityLink")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case definition was found and the identity link was returned."), @ApiResponse(code=404, message="Indicates the requested case definition was not found or the case definition does not have an identity-link that matches the url.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/identitylinks/{family}/{identityId}"}, produces={"application/json"})
    public RestIdentityLink getIdentityLinkRequest(@ApiParam(name="caseDefinitionId") @PathVariable(value="caseDefinitionId") String caseDefinitionId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, caseDefinition.getId());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseDefinitionIdentityLink(caseDefinition, link);
        }
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @ApiOperation(value="Delete a candidate starter from a case definition", tags={"Case Definitions"}, code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the case definition was found and the identity link was removed. The response body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested case definition was not found or the case definition does not have an identity-link that matches the url.")})
    @DeleteMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/identitylinks/{family}/{identityId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteIdentityLink(@ApiParam(name="caseDefinitionId") @PathVariable(value="caseDefinitionId") String caseDefinitionId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, caseDefinition.getId());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteCaseDefinitionIdentityLink(caseDefinition, link);
        }
        if (link.getUserId() != null) {
            this.repositoryService.deleteCandidateStarterUser(caseDefinition.getId(), link.getUserId());
        } else {
            this.repositoryService.deleteCandidateStarterGroup(caseDefinition.getId(), link.getGroupId());
        }
    }

    protected void validateIdentityLinkArguments(String family, String identityId) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new FlowableIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("IdentityId is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String caseDefinitionId) {
        boolean isUser = family.equals("users");
        List allLinks = this.repositoryService.getIdentityLinksForCaseDefinition(caseDefinitionId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals("candidate")) continue;
            return link;
        }
        throw new FlowableObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

