/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.common.rest.api.EngineInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Cmmn Engine"}, description="Manage Cmmn Engine", authorizations={@Authorization(value="basicAuth")})
public class CmmnEngineResource {
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get engine info", tags={"Cmmn Engine"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/cmmn-management/engine"}, produces={"application/json"})
    public EngineInfoResponse getEngineInfo() {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessManagementInfo();
        }
        CmmnEngine cmmnEngine = CmmnEngines.getDefaultCmmnEngine();
        EngineInfoResponse response = new EngineInfoResponse();
        response.setName(cmmnEngine.getName());
        response.setVersion(CmmnEngine.class.getPackage().getImplementationVersion());
        return response;
    }
}

