/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceResponse;
import org.flowable.common.rest.api.DataResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Case"}, description="Manage History Case Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricCaseInstanceQueryResource
extends HistoricCaseInstanceBaseResource {
    @ApiOperation(value="Query for historic case instances", tags={"History Case", "Query"}, nickname="queryHistoricCaseInstance", notes="All supported JSON parameter fields allowed are exactly the same as the parameters found for getting a collection of historic case instances, but passed in as JSON-body arguments rather than URL-parameters to allow for more advanced querying and preventing errors with request-uri\u2019s that are too long. On top of that, the query allows for filtering based on process variables. The variables property is a JSON-array containing objects with the format as described here.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sort", dataType="string", value="The field to sort by. Defaults to 'caseInstanceId'.", allowableValues="caseInstanceId,caseDefinitionId,startTime,endTime,tenantId", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the case instances are returned"), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @PostMapping(value={"/cmmn-query/historic-case-instances"}, produces={"application/json"})
    public DataResponse<HistoricCaseInstanceResponse> queryCasesInstances(@RequestBody HistoricCaseInstanceQueryRequest queryRequest, @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        return this.getQueryResponse(queryRequest, allRequestParams);
    }
}

