/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi.blueprint;

import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintELResolver
extends ELResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintELResolver.class);
    private Map<String, JavaDelegate> delegateMap = new HashMap<String, JavaDelegate>();
    private Map<String, ActivityBehavior> activityBehaviourMap = new HashMap<String, ActivityBehavior>();

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String key = (String)property;
            for (String name : this.delegateMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.delegateMap.get(name);
            }
            for (String name : this.activityBehaviourMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.activityBehaviourMap.get(name);
            }
        }
        return null;
    }

    public void bindService(JavaDelegate delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.delegateMap.put(name, delegate);
        LOGGER.info("added Flowable service to delegate cache {}", (Object)name);
    }

    public void unbindService(JavaDelegate delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.delegateMap.containsKey(name)) {
            this.delegateMap.remove(name);
        }
        LOGGER.info("removed Flowable service from delegate cache {}", (Object)name);
    }

    public void bindActivityBehaviourService(ActivityBehavior delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.activityBehaviourMap.put(name, delegate);
        LOGGER.info("added Flowable service to activity behaviour cache {}", (Object)name);
    }

    public void unbindActivityBehaviourService(ActivityBehavior delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.activityBehaviourMap.containsKey(name)) {
            this.activityBehaviourMap.remove(name);
        }
        LOGGER.info("removed Flowable service from activity behaviour cache {}", (Object)name);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public Class<?> getCommonPropertyType(ELContext context, Object arg) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object arg) {
        return null;
    }

    public Class<?> getType(ELContext context, Object arg1, Object arg2) {
        return Object.class;
    }
}

