/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarDeploymentListener
implements ArtifactUrlTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BarDeploymentListener.class);

    public URL transform(URL artifact) throws Exception {
        try {
            return new URL("bar", null, artifact.toString());
        }
        catch (Exception e) {
            LOGGER.error("Unable to build bar bundle", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        ZipFile jar = null;
        try {
            if (!artifact.getName().endsWith(".bar")) {
                boolean bl = false;
                return bl;
            }
            jar = new JarFile(artifact);
            Manifest m = ((JarFile)jar).getManifest();
            if (m != null && m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) != null && m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) != null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close jar", (Throwable)e);
                }
            }
        }
    }
}

