/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.management.jmx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static String getHostName() {
        String DEFAULT_HOST = "localhost";
        String hostName = null;
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                LOGGER.info("Cannot determine localhost name. Fallback to: localhost", (Throwable)uhe);
                hostName = "localhost";
            }
        } else {
            hostName = "localhost";
        }
        return hostName;
    }
}

