/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.management.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;
import org.flowable.management.jmx.DefaultManagementMBeanAssembler;
import org.flowable.management.jmx.JMXConfigurator;
import org.flowable.management.jmx.ManagementAgent;
import org.flowable.management.jmx.ManagementMBeanAssembler;
import org.flowable.management.jmx.Utils;
import org.flowable.management.jmx.mbeans.JobExecutorMBean;
import org.flowable.management.jmx.mbeans.ProcessDefinitionsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementAgent
implements ManagementAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultManagementAgent.class);
    protected MBeanServer server;
    protected final ConcurrentMap<ObjectName, ObjectName> mbeansRegistered = new ConcurrentHashMap<ObjectName, ObjectName>();
    protected JMXConfigurator jmxConfigurator;
    protected Registry registry;
    protected JMXConnectorServer cs;
    protected ManagementMBeanAssembler assembler;

    public DefaultManagementAgent(JMXConfigurator jmxConfigurator) {
        this.jmxConfigurator = jmxConfigurator;
        this.assembler = new DefaultManagementMBeanAssembler();
    }

    @Override
    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    @Override
    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            ModelMBean mbean = this.assembler.assemble(obj, name);
            if (mbean != null) {
                this.registerMBeanWithServer(mbean, name, forceRegistration);
            } else {
                this.registerMBeanWithServer(obj, name, forceRegistration);
            }
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Mbean {} is not compliant MBean.", (Object)name, (Object)e);
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOGGER.info("ForceRegistration enabled, unregistering existing MBean with ObjectName: {}", (Object)name);
                this.server.unregisterMBean(name);
            } else {
                LOGGER.debug("MBean already registered with ObjectName: {}", (Object)name);
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            LOGGER.trace("Registering MBean with ObjectName: {}", (Object)name);
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            LOGGER.debug("Registered MBean with ObjectName: {}", (Object)registeredName);
            this.mbeansRegistered.put(name, registeredName);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
        return on != null && this.server.isRegistered(on) || this.server.isRegistered(name);
    }

    @Override
    public void unregister(ObjectName name) throws JMException {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.remove(name);
            this.server.unregisterMBean(on);
            LOGGER.debug("Unregistered MBean with ObjectName: {}", (Object)name);
        } else {
            this.mbeansRegistered.remove(name);
        }
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    @Override
    public void doStart() {
        this.createMBeanServer();
    }

    protected void createMBeanServer() {
        this.server = this.findOrCreateMBeanServer();
        try {
            if (this.jmxConfigurator.getCreateConnector().booleanValue()) {
                this.createJmxConnector(Utils.getHostName());
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not create and start JMX connector.", (Throwable)ioe);
        }
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.jmxConfigurator.getMbeanDomain().equals("DefaultDomain")) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            LOGGER.debug("Found MBeanServer with default domain {}", (Object)server.getDefaultDomain());
            if (!this.jmxConfigurator.getMbeanDomain().equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.jmxConfigurator.getMbeanDomain());
    }

    @Override
    public void findAndRegisterMbeans() throws Exception {
        this.register(new ProcessDefinitionsMBean(this.jmxConfigurator.getProcessEngineConfig()), new ObjectName(this.jmxConfigurator.getDomain(), "type", "Deployments"));
        this.register(new JobExecutorMBean(this.jmxConfigurator.getProcessEngineConfig()), new ObjectName(this.jmxConfigurator.getDomain(), "type", "JobExecutor"));
    }

    public void createJmxConnector(String host) throws IOException {
        String serviceUrlPath = this.jmxConfigurator.getServiceUrlPath();
        Integer registryPort = this.jmxConfigurator.getRegistryPort();
        Integer connectorPort = this.jmxConfigurator.getConnectorPort();
        if (serviceUrlPath == null) {
            LOGGER.warn("Service url path is null. JMX connector creation skipped");
            return;
        }
        if (registryPort == null) {
            LOGGER.warn("Registry port is null. JMX connector creation skipped.");
            return;
        }
        try {
            this.registry = LocateRegistry.createRegistry(registryPort);
            LOGGER.debug("Created JMXConnector RMI registry on port {}", (Object)registryPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object path = serviceUrlPath.startsWith("/") ? serviceUrlPath : "/" + serviceUrlPath;
        final JMXServiceURL url = connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + connectorPort + "/jndi/rmi://" + host + ":" + registryPort + (String)path) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + registryPort + (String)path);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Staring JMX Connector thread to listen at: {}", (Object)url);
                    DefaultManagementAgent.this.cs.start();
                    LOGGER.info("JMX Connector thread started and listening at: {}", (Object)url);
                }
                catch (IOException ioe) {
                    if (ioe.getCause() instanceof NameAlreadyBoundException) {
                        LOGGER.warn("JMX connection:{} already exists.", (Object)url);
                    }
                    LOGGER.warn("Could not start JMXConnector thread at: {}. JMX Connector not in use.", (Object)url, (Object)ioe);
                }
            }
        }, "jmxConnectorStarterThread");
        thread.start();
    }
}

