/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationTransitionCreateScope
implements AtomicOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicOperationTransitionCreateScope.class);

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        return activity.isAsync();
    }

    @Override
    public void execute(InterpretableExecution execution) {
        InterpretableExecution propagatingExecution = null;
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity.isScope()) {
            propagatingExecution = (InterpretableExecution)execution.createExecution();
            propagatingExecution.setActivity(activity);
            propagatingExecution.setTransition(execution.getTransition());
            execution.setTransition(null);
            execution.setActivity(null);
            execution.setActive(false);
            LOGGER.debug("create scope: parent {} continues as execution {}", (Object)execution, (Object)propagatingExecution);
            propagatingExecution.initialize();
        } else {
            propagatingExecution = execution;
        }
        propagatingExecution.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_START);
    }
}

