/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.form.StartFormHandler;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.repository.ProcessDefinition;

public class ProcessDefinitionEntity
extends ProcessDefinitionImpl
implements ProcessDefinition,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String key;
    protected int revision = 1;
    protected int version;
    protected String category;
    protected String deploymentId;
    protected String resourceName;
    protected String tenantId = "";
    protected Integer historyLevel;
    protected StartFormHandler startFormHandler;
    protected String diagramResourceName;
    protected boolean isGraphicalNotationDefined;
    protected Map<String, TaskDefinition> taskDefinitions;
    protected Map<String, Object> variables;
    protected boolean hasStartFormKey;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected boolean isIdentityLinksInitialized;
    protected List<IdentityLinkEntity> definitionIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected Set<Expression> candidateStarterUserIdExpressions = new HashSet<Expression>();
    protected Set<Expression> candidateStarterGroupIdExpressions = new HashSet<Expression>();
    protected String engineVersion;

    public ProcessDefinitionEntity() {
        super(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public ExecutionEntity createProcessInstance(String businessKey, ActivityImpl initial) {
        ExecutionEntity processInstance = null;
        processInstance = initial == null ? (ExecutionEntity)super.createProcessInstance() : (ExecutionEntity)super.createProcessInstanceForInitial(initial);
        processInstance.setExecutions(new ArrayList<ExecutionEntity>());
        processInstance.setProcessDefinition(this.processDefinition);
        if (businessKey != null) {
            processInstance.setBusinessKey(businessKey);
        }
        if (this.getTenantId() != null) {
            processInstance.setTenantId(this.getTenantId());
        }
        processInstance.setProcessInstance(processInstance);
        Map<String, Object> dataObjectVars = this.getVariables();
        if (dataObjectVars != null) {
            processInstance.setVariables(dataObjectVars);
        }
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        String initiatorVariableName = (String)this.getProperty("initiatorVariableName");
        if (initiatorVariableName != null) {
            processInstance.setVariable(initiatorVariableName, authenticatedUserId);
        }
        if (authenticatedUserId != null) {
            processInstance.addIdentityLink(authenticatedUserId, null, "starter");
        }
        Context.getCommandContext().getHistoryManager().recordProcessInstanceStart(processInstance);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, processInstance), "cfg.processEngine");
        }
        return processInstance;
    }

    public ExecutionEntity createProcessInstance(String businessKey) {
        return this.createProcessInstance(businessKey, null);
    }

    @Override
    public ExecutionEntity createProcessInstance() {
        return this.createProcessInstance(null);
    }

    @Override
    protected InterpretableExecution newProcessInstance(ActivityImpl activityImpl) {
        ExecutionEntity processInstance = new ExecutionEntity(activityImpl);
        processInstance.insert();
        return processInstance;
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        identityLinkEntity.insert();
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinkByProcessDefinitionUserAndGroup(this.id, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLink, false);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.definitionIdentityLinkEntities = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByProcessDefinitionId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.definitionIdentityLinkEntities;
    }

    @Override
    public String toString() {
        return "ProcessDefinitionEntity[" + this.id + "]";
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("category", this.category);
        return persistentState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getDerivedFrom() {
        return null;
    }

    public String getDerivedFromRoot() {
        return null;
    }

    public int getDerivedVersion() {
        return 0;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(Integer historyLevel) {
        this.historyLevel = historyLevel;
    }

    public StartFormHandler getStartFormHandler() {
        return this.startFormHandler;
    }

    public void setStartFormHandler(StartFormHandler startFormHandler) {
        this.startFormHandler = startFormHandler;
    }

    public Map<String, TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(Map<String, TaskDefinition> taskDefinitions) {
        this.taskDefinitions = taskDefinitions;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    public boolean hasStartFormKey() {
        return this.hasStartFormKey;
    }

    public boolean getHasStartFormKey() {
        return this.hasStartFormKey;
    }

    public void setStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public void setHasStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public boolean isGraphicalNotationDefined() {
        return this.isGraphicalNotationDefined;
    }

    public boolean hasGraphicalNotation() {
        return this.isGraphicalNotationDefined;
    }

    public void setGraphicalNotationDefined(boolean isGraphicalNotationDefined) {
        this.isGraphicalNotationDefined = isGraphicalNotationDefined;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    public Set<Expression> getCandidateStarterUserIdExpressions() {
        return this.candidateStarterUserIdExpressions;
    }

    public void addCandidateStarterUserIdExpression(Expression userId) {
        this.candidateStarterUserIdExpressions.add(userId);
    }

    public Set<Expression> getCandidateStarterGroupIdExpressions() {
        return this.candidateStarterGroupIdExpressions;
    }

    public void addCandidateStarterGroupIdExpression(Expression groupId) {
        this.candidateStarterGroupIdExpressions.add(groupId);
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }
}

