/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.job.api.Job;

public class TimerSuspendProcessDefinitionHandler
extends TimerChangeProcessDefinitionSuspensionStateJobHandler {
    public static final String TYPE = "suspend-processdefinition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(Job job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        boolean suspendProcessInstances = false;
        try {
            JsonNode configNode = processEngineConfiguration.getObjectMapper().readTree(configuration);
            suspendProcessInstances = TimerSuspendProcessDefinitionHandler.getIncludeProcessInstances(configNode);
        }
        catch (Exception e) {
            throw new FlowableException("Error reading json value " + configuration, (Throwable)e);
        }
        String processDefinitionId = job.getProcessDefinitionId();
        SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionId, null, suspendProcessInstances, null, job.getTenantId());
        suspendProcessDefinitionCmd.execute(commandContext);
    }
}

